/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.Arrays;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.unit.DistanceUnit;
import org.goplanit.utils.unit.GroupUnit;
import org.goplanit.utils.unit.NoneUnit;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.SrsUnit;
import org.goplanit.utils.unit.TimeUnit;
import org.goplanit.utils.unit.UnitType;
import org.goplanit.utils.unit.VehiclesUnit;

public interface Unit {
    public static final Unit NONE = Unit.of(UnitType.NONE);
    public static final TimeUnit HOUR = (TimeUnit)Unit.of(UnitType.HOUR);
    public static final TimeUnit MINUTE = (TimeUnit)Unit.of(UnitType.MINUTE);
    public static final TimeUnit SECOND = (TimeUnit)Unit.of(UnitType.SECOND);
    public static final DistanceUnit KM = (DistanceUnit)Unit.of(UnitType.KM);
    public static final DistanceUnit METER = (DistanceUnit)Unit.of(UnitType.METER);
    public static final VehiclesUnit PCU = (VehiclesUnit)Unit.of(UnitType.PCU);
    public static final VehiclesUnit VEH = (VehiclesUnit)Unit.of(UnitType.VEH);
    public static final Unit SRS = Unit.of(UnitType.SRS);
    public static final Unit KM_HOUR = new GroupUnit(KM).per(HOUR);
    public static final Unit METER_SECOND = new GroupUnit(METER).per(SECOND);
    public static final Unit PCU_HOUR = new GroupUnit(PCU).per(HOUR);
    public static final Unit PCU_KM = new GroupUnit(PCU).per(KM);
    public static final Unit VEH_HOUR = new GroupUnit(VEH).per(HOUR);
    public static final Unit VEH_KM = new GroupUnit(VEH).per(KM);

    public boolean isCombinedUnit();

    public double convertTo(Unit var1, double var2) throws PlanItException;

    public boolean canConvertTo(Unit var1);

    public static SimpleUnit of(UnitType type) {
        switch (type.getGroup()) {
            case DISTANCE: {
                return new DistanceUnit(type);
            }
            case TIME: {
                return new TimeUnit(type);
            }
            case VEHICLES: {
                return new VehiclesUnit(type);
            }
            case NONE: {
                return new NoneUnit();
            }
            case SRS: {
                return new SrsUnit();
            }
        }
        return null;
    }

    public static GroupUnit of(UnitType[] numeratorUnits, UnitType[] denominatorUnits) {
        SimpleUnit[] numeratorUnitTypes = (SimpleUnit[])Arrays.stream(numeratorUnits).map(unit -> Unit.of(unit)).toArray(SimpleUnit[]::new);
        SimpleUnit[] denominatorUnitTypes = (SimpleUnit[])Arrays.stream(denominatorUnits).map(unit -> Unit.of(unit)).toArray(SimpleUnit[]::new);
        return new GroupUnit(numeratorUnitTypes).per(denominatorUnitTypes);
    }
}

