/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.wrapper;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface MapWrapper<K, V>
extends Iterable<V>,
Cloneable {
    public V register(V var1);

    public V remove(V var1);

    public void clear();

    public V get(K var1);

    public int size();

    public boolean isEmpty();

    public boolean contains(V var1);

    public Collection<V> toCollection();

    public Set<V> valuesAsNewSet();

    public V findFirst(Predicate<V> var1);

    public MapWrapper<K, V> clone();

    public K getKeyByValue(V var1);

    default public V getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (V)this.iterator().next();
    }

    default public void addAll(Iterable<? extends V> iterable) {
        iterable.forEach(v -> this.register(v));
    }

    default public <T extends V> void forEachIn(Collection<T> values, Consumer<T> consumer) {
        values.forEach(v -> {
            if (this.contains(v)) {
                consumer.accept(v);
            }
        });
    }
}

