/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PlanitZipFileInputStream
extends InputStream {
    private final ZipFile zipFile;
    private final InputStream wrappedInputStream;

    protected PlanitZipFileInputStream(ZipFile zipFile, ZipEntry entry) throws IOException {
        this.zipFile = zipFile;
        this.wrappedInputStream = zipFile.getInputStream(entry);
    }

    public static PlanitZipFileInputStream of(ZipFile zipFile, ZipEntry entry) throws IOException {
        return new PlanitZipFileInputStream(zipFile, entry);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.wrappedInputStream.close();
        this.zipFile.close();
    }

    @Override
    public int read() throws IOException {
        return this.wrappedInputStream.read();
    }
}

