/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.Zone;

public abstract class ConnectoidImpl
extends ExternalIdAbleImpl
implements Connectoid {
    private static final long serialVersionUID = 373775073620741347L;
    private static final Logger LOGGER = Logger.getLogger(ConnectoidImpl.class.getCanonicalName());
    protected String name = null;
    protected ConnectoidType type = DEFAULT_CONNECTOID_TYPE;
    protected TreeMap<Long, AccessZoneProperties> accessZones = new TreeMap();

    protected static long generateId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Connectoid.class);
    }

    public void recreateAccessZoneIdMapping() {
        Collection<AccessZoneProperties> accessZoneValues = this.accessZones.values();
        this.accessZones = new TreeMap();
        accessZoneValues.forEach(accessZoneValue -> this.accessZones.put(accessZoneValue.accessZone.getId(), (AccessZoneProperties)accessZoneValue));
    }

    @Override
    protected void setId(long id) {
        super.setId(id);
    }

    protected ConnectoidImpl(IdGroupingToken idToken) {
        super(ConnectoidImpl.generateId(idToken));
    }

    protected ConnectoidImpl(IdGroupingToken idToken, Zone accessZone, double length) {
        this(idToken);
        this.addAccessZone(accessZone);
        this.setLength(accessZone, length);
    }

    protected ConnectoidImpl(IdGroupingToken idToken, Zone accessZone) {
        this(idToken);
        this.addAccessZone(accessZone);
    }

    protected ConnectoidImpl(ConnectoidImpl connectoidImpl) {
        super(connectoidImpl);
        for (AccessZoneProperties entry : connectoidImpl.accessZones.values()) {
            this.accessZones.put(entry.accessZone.getId(), new AccessZoneProperties(entry));
        }
        this.name = connectoidImpl.name;
        this.type = connectoidImpl.type;
    }

    @Override
    public void setType(ConnectoidType type) {
        this.type = type;
    }

    @Override
    public ConnectoidType getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Zone> getAccessZones() {
        return this.accessZones.values().stream().map(amp -> amp.accessZone).collect(Collectors.toList());
    }

    @Override
    public Zone getFirstAccessZone() {
        return this.iterator().next();
    }

    @Override
    public long getNumberOfAccessZones() {
        return this.accessZones.size();
    }

    @Override
    public Optional<Double> getLengthKm(Zone accessZone) {
        if (!this.hasAccessZone(accessZone)) {
            LOGGER.warning(String.format("unknown access zone %s (id:%d) for connectoid %s (id:%d) when collecting length", accessZone.getXmlId(), accessZone.getId(), this.getXmlId(), this.getId()));
            return Optional.empty();
        }
        return Optional.of(this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).lengthKm);
    }

    @Override
    public Zone addAccessZone(Zone accessZone) {
        AccessZoneProperties duplicate;
        if (accessZone == null) {
            LOGGER.warning(String.format("unable to add access zone to connectoid %s, it is null", this.getXmlId()));
        }
        return (duplicate = this.accessZones.put(accessZone.getId(), new AccessZoneProperties(accessZone))) != null ? duplicate.accessZone : null;
    }

    @Override
    public boolean isModeAllowed(Zone accessZone, Mode mode) throws PlanItException {
        if (!this.hasAccessZone(accessZone)) {
            LOGGER.warning(String.format("unknown access zone %s (id:%d) for connectoid %s (id:%d) when checking if mode is allowed", accessZone.getXmlId(), accessZone.getId(), this.getXmlId(), this.getId()));
            return false;
        }
        TreeMap<Long, Mode> allowedModes = this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).allowedModes;
        return allowedModes != null ? allowedModes.containsKey(mode.getId()) : true;
    }

    @Override
    public boolean hasAccessZone(Zone accessZone) {
        if (accessZone == null) {
            return false;
        }
        return this.accessZones.containsKey(accessZone.getId());
    }

    @Override
    public void setLength(Zone accessZone, double length) {
        if (this.hasAccessZone(accessZone)) {
            this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).lengthKm = length;
        } else {
            LOGGER.warning(String.format("unknown access zone %s (id:%d) for connectoid %s (id:%d) when setting length", accessZone.getXmlId(), accessZone.getId(), this.getXmlId(), this.getId()));
        }
    }

    @Override
    public void addAllowedMode(Zone accessZone, Mode allowedMode) {
        if (this.hasAccessZone(accessZone)) {
            AccessZoneProperties accessZoneProperties = this.accessZones.get(accessZone.getId());
            accessZoneProperties.addAllowedMode(allowedMode);
        } else {
            LOGGER.warning(String.format("unknown access zone %s (id:%d) for connectoid %s (id:%d) when adding allowed mode %s (id: %d)", accessZone.getXmlId(), accessZone.getId(), this.getXmlId(), this.getId(), allowedMode.getXmlId(), allowedMode.getId()));
        }
    }

    @Override
    public Collection<Mode> getExplicitlyAllowedModes(Zone accessZone) {
        if (this.hasAccessZone(accessZone)) {
            AccessZoneProperties accessZoneProperties = this.accessZones.get(accessZone.getId());
            if (accessZoneProperties.allowedModes != null && !accessZoneProperties.allowedModes.isEmpty()) {
                return Collections.unmodifiableCollection(accessZoneProperties.allowedModes.values());
            }
        }
        return null;
    }

    @Override
    public Iterator<Zone> iterator() {
        Iterator<Zone> it = new Iterator<Zone>(){
            private Iterator<AccessZoneProperties> iterator;
            {
                this.iterator = ConnectoidImpl.this.accessZones.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Zone next() {
                return this.iterator.next().accessZone;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = ConnectoidImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public abstract ConnectoidImpl clone();

    protected class AccessZoneProperties {
        public final Zone accessZone;
        public Double lengthKm = 0.0;
        public TreeMap<Long, Mode> allowedModes = null;

        protected AccessZoneProperties(Zone accessZone) {
            this.accessZone = accessZone;
        }

        public AccessZoneProperties(AccessZoneProperties other) {
            this.accessZone = other.accessZone;
            this.lengthKm = other.lengthKm;
            if (other.allowedModes != null) {
                this.allowedModes = (TreeMap)other.allowedModes.clone();
            }
        }

        void addAllowedMode(Mode mode) {
            if (this.allowedModes == null) {
                this.allowedModes = new TreeMap();
            }
            this.allowedModes.put(mode.getId(), mode);
        }
    }
}

