/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;

public class TransferZoneGroupImpl
extends ExternalIdAbleImpl
implements TransferZoneGroup {
    protected Map<Long, TransferZone> transferZoneMap = new TreeMap<Long, TransferZone>();
    protected String name = null;

    protected void recreateTransferZoneIdMapping() {
        if (!this.transferZoneMap.isEmpty()) {
            TreeMap<Long, TransferZone> updatedMap = new TreeMap<Long, TransferZone>();
            this.transferZoneMap.forEach((? super K oldId, ? super V transferzone) -> updatedMap.put(transferzone.getId(), (TransferZone)transferzone));
            this.transferZoneMap.clear();
            this.transferZoneMap = updatedMap;
        }
    }

    protected static long generateTransferZoneGroupId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, TransferZoneGroup.class);
    }

    protected TransferZoneGroupImpl(IdGroupingToken tokenId) {
        super(TransferZoneGroupImpl.generateTransferZoneGroupId(tokenId));
    }

    public TransferZoneGroupImpl(TransferZoneGroupImpl transferZoneGroupImpl) {
        super(transferZoneGroupImpl);
        this.name = transferZoneGroupImpl.name;
        this.transferZoneMap.putAll(transferZoneGroupImpl.transferZoneMap);
    }

    @Override
    public Iterator<TransferZone> iterator() {
        return this.transferZoneMap.values().iterator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TransferZone addTransferZone(TransferZone transferZone) {
        TransferZone prevTransferZone = this.transferZoneMap.put(transferZone.getId(), transferZone);
        transferZone.addToTransferZoneGroup(this);
        return prevTransferZone;
    }

    @Override
    public TransferZone removeTransferZone(TransferZone transferZone) {
        TransferZone removedZone = this.transferZoneMap.remove(transferZone.getId());
        if (transferZone.isInTransferZoneGroup(this)) {
            transferZone.removeFromTransferZoneGroup(this);
        }
        return removedZone;
    }

    @Override
    public boolean hasTransferZone(TransferZone transferZone) {
        return this.transferZoneMap.containsKey(transferZone.getId());
    }

    @Override
    public int size() {
        return this.transferZoneMap.size();
    }

    @Override
    public Collection<TransferZone> getTransferZones() {
        return this.transferZoneMap.values();
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = TransferZoneGroupImpl.generateTransferZoneGroupId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public TransferZoneGroupImpl clone() {
        return new TransferZoneGroupImpl(this);
    }
}

