/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.ZoneImpl;

public class TransferZoneImpl
extends ZoneImpl
implements TransferZone {
    private long transferZoneId;
    private TransferZoneType type = DEFAULT_TYPE;
    Set<TransferZoneGroup> transferZoneGroups = null;

    protected static long generateTransferZoneId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, TransferZone.TRANSFER_ZONE_ID_CLASS);
    }

    protected void setTransferZoneId(long transferZoneId) {
        this.transferZoneId = transferZoneId;
    }

    public TransferZoneImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.setTransferZoneId(TransferZoneImpl.generateTransferZoneId(tokenId));
    }

    public TransferZoneImpl(TransferZoneImpl transferZoneImpl) {
        super(transferZoneImpl);
        this.transferZoneId = transferZoneImpl.transferZoneId;
        this.type = transferZoneImpl.type;
        if (transferZoneImpl.hasTransferZoneGroup()) {
            this.transferZoneGroups = new HashSet<TransferZoneGroup>(transferZoneImpl.getTransferZoneGroups());
        }
    }

    @Override
    public long getTransferZoneId() {
        return this.transferZoneId;
    }

    @Override
    public void setType(TransferZoneType type) {
        this.type = type;
    }

    @Override
    public TransferZoneType getTransferZoneType() {
        return this.type;
    }

    @Override
    public boolean hasTransferZoneGroup() {
        return this.transferZoneGroups != null && !this.transferZoneGroups.isEmpty();
    }

    @Override
    public boolean isInTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        if (transferZoneGroup == null || !this.hasTransferZoneGroup()) {
            return false;
        }
        return this.transferZoneGroups.contains(transferZoneGroup);
    }

    @Override
    public void addToTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        if (transferZoneGroup == null) {
            LOGGER.warning(String.format("transfer zone group null, unable to register on transfer zone %s", this.getXmlId()));
            return;
        }
        if (!this.hasTransferZoneGroup()) {
            this.transferZoneGroups = new HashSet<TransferZoneGroup>();
        }
        this.transferZoneGroups.add(transferZoneGroup);
    }

    @Override
    public boolean removeFromTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        boolean success = false;
        if (this.isInTransferZoneGroup(transferZoneGroup)) {
            success = this.transferZoneGroups.remove(transferZoneGroup);
            if (this.transferZoneGroups.isEmpty()) {
                this.transferZoneGroups = null;
            }
            if (transferZoneGroup.hasTransferZone(this)) {
                transferZoneGroup.removeTransferZone(this);
            }
        }
        return success;
    }

    @Override
    public void removeFromAllTransferZoneGroups() {
        if (this.hasTransferZoneGroup()) {
            Iterator<TransferZoneGroup> iterator = this.transferZoneGroups.iterator();
            while (iterator.hasNext()) {
                TransferZoneGroup group = iterator.next();
                iterator.remove();
                group.removeTransferZone(this);
            }
        }
    }

    @Override
    public final Set<TransferZoneGroup> getTransferZoneGroups() {
        if (this.hasTransferZoneGroup()) {
            return Collections.unmodifiableSet(this.transferZoneGroups);
        }
        return null;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.setTransferZoneId(TransferZoneImpl.generateTransferZoneId(tokenId));
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public TransferZoneImpl clone() {
        return new TransferZoneImpl(this);
    }
}

