/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.ConnectoidImpl;

public class UndirectedConnectoidImpl
extends ConnectoidImpl
implements UndirectedConnectoid {
    private static final long serialVersionUID = 373775073620741347L;
    private static final Logger LOGGER = Logger.getLogger(UndirectedConnectoidImpl.class.getCanonicalName());
    protected long undirectedConnectoidId;
    protected DirectedVertex accessVertex;

    protected static long generateUndirectedConnectoidId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, UndirectedConnectoid.UNDIRECTED_CONNECTOID_ID_CLASS);
    }

    protected void setUndirectedConnectoidId(long undirectedConnectoidId) {
        this.undirectedConnectoidId = undirectedConnectoidId;
    }

    protected void setAccessVertex(DirectedVertex accessVertex) {
        this.accessVertex = accessVertex;
    }

    protected UndirectedConnectoidImpl(IdGroupingToken idToken, DirectedVertex accessVertex, Zone accessZone, double length) {
        super(idToken, accessZone, length);
        this.setUndirectedConnectoidId(UndirectedConnectoidImpl.generateUndirectedConnectoidId(idToken));
        this.setAccessVertex(accessVertex);
    }

    public UndirectedConnectoidImpl(IdGroupingToken idToken, DirectedVertex accessVertex, Zone accessZone) {
        super(idToken, accessZone);
        this.setUndirectedConnectoidId(UndirectedConnectoidImpl.generateUndirectedConnectoidId(idToken));
        this.setAccessVertex(accessVertex);
    }

    public UndirectedConnectoidImpl(IdGroupingToken idToken, DirectedVertex accessVertex) {
        super(idToken);
        this.setUndirectedConnectoidId(UndirectedConnectoidImpl.generateUndirectedConnectoidId(idToken));
        this.setAccessVertex(accessVertex);
    }

    protected UndirectedConnectoidImpl(UndirectedConnectoidImpl connectoidImpl) {
        super(connectoidImpl);
        this.setAccessVertex(connectoidImpl.getAccessVertex());
        this.setUndirectedConnectoidId(connectoidImpl.getUndirectedConnectoidId());
    }

    @Override
    public long getUndirectedConnectoidId() {
        return this.undirectedConnectoidId;
    }

    @Override
    public DirectedVertex getAccessVertex() {
        return this.accessVertex;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.setUndirectedConnectoidId(UndirectedConnectoidImpl.generateUndirectedConnectoidId(tokenId));
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public UndirectedConnectoidImpl clone() {
        return new UndirectedConnectoidImpl(this);
    }
}

