/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.io.Serializable;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.demands.Demands;
import org.goplanit.network.virtual.VirtualNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.DirectedConnectoids;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.TransferZoneGroups;
import org.goplanit.utils.zoning.TransferZones;
import org.goplanit.utils.zoning.UndirectedConnectoids;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.modifier.ZoningModifier;
import org.goplanit.zoning.DirectedConnectoidsImpl;
import org.goplanit.zoning.OdZonesImpl;
import org.goplanit.zoning.TransferZoneGroupsImpl;
import org.goplanit.zoning.TransferZonesImpl;
import org.goplanit.zoning.UndirectedConnectoidsImpl;
import org.goplanit.zoning.modifier.ZoningModifierImpl;

public class Zoning
extends PlanitComponent<Zoning>
implements Serializable {
    private static final long serialVersionUID = -2986366471146628179L;
    private static final Logger LOGGER = Logger.getLogger(Zoning.class.getCanonicalName());
    protected final VirtualNetwork virtualNetwork;
    protected final ZoningModifier zoningModifier;
    public final UndirectedConnectoids odConnectoids;
    public final DirectedConnectoids transferConnectoids;
    public final OdZones odZones;
    public final TransferZones transferZones;
    public final TransferZoneGroups transferZoneGroups;

    public Zoning(IdGroupingToken groupId, IdGroupingToken networkGroupId) {
        super(groupId, Zoning.class);
        this.virtualNetwork = new VirtualNetwork(networkGroupId);
        this.odConnectoids = new UndirectedConnectoidsImpl(networkGroupId);
        this.transferConnectoids = new DirectedConnectoidsImpl(networkGroupId);
        this.odZones = new OdZonesImpl(networkGroupId);
        this.transferZones = new TransferZonesImpl(networkGroupId);
        this.transferZoneGroups = new TransferZoneGroupsImpl(networkGroupId);
        this.zoningModifier = new ZoningModifierImpl(this);
    }

    public Zoning(Zoning other) {
        super(other);
        this.virtualNetwork = other.virtualNetwork;
        this.odConnectoids = other.odConnectoids.clone();
        this.transferConnectoids = other.transferConnectoids.clone();
        this.odZones = other.odZones.clone();
        this.transferZones = other.transferZones.clone();
        this.transferZoneGroups = other.transferZoneGroups.clone();
        this.zoningModifier = new ZoningModifierImpl(this);
    }

    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s#od zones: %d (#centroids: %d)", prefix, this.odZones.size(), this.odZones.getNumberOfCentroids()));
        LOGGER.info(String.format("%s#od connectoids: %d", prefix, this.odConnectoids.size()));
        if (!this.transferZones.isEmpty()) {
            LOGGER.info(String.format("%s#transfer connectoids: %d", prefix, this.transferConnectoids.size()));
            LOGGER.info(String.format("%s#transfer zones: %d (#centroids:", prefix, this.transferZones.size(), this.transferZones.getNumberOfCentroids()));
            LOGGER.info(String.format("%s#transfer zone groups: %d", prefix, this.transferZoneGroups.size()));
        }
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public boolean isCompatibleWithDemands(Demands demands, Modes modes) {
        int nofZones = this.odZones.size();
        for (Mode mode : modes) {
            for (TimePeriod timePeriod : demands.timePeriods) {
                OdDemands odDemandsForModeTime = demands.get(mode, timePeriod);
                if (odDemandsForModeTime == null || nofZones == odDemandsForModeTime.getNumberOfOdZones()) continue;
                return false;
            }
        }
        return true;
    }

    public Zone getZone(long id) {
        Zone zone = (Zone)this.odZones.get(id);
        if (zone == null) {
            zone = (Zone)this.transferZones.get(id);
        }
        return zone;
    }

    public OdZones getOdZones() {
        return this.odZones;
    }

    public TransferZones getTransferZones() {
        return this.transferZones;
    }

    public long getNumberOfCentroids() {
        return this.odZones.getNumberOfCentroids() + this.transferZones.getNumberOfCentroids();
    }

    public long getNumberOfConnectoids() {
        return this.odConnectoids.size() + this.transferConnectoids.size();
    }

    public ZoningModifier getZoningModifier() {
        return this.zoningModifier;
    }

    @Override
    public Zoning clone() {
        return new Zoning(this);
    }

    @Override
    public void reset() {
        this.virtualNetwork.reset();
        this.odConnectoids.reset();
        this.odZones.reset();
        this.transferConnectoids.reset();
        this.odConnectoids.reset();
        this.transferZoneGroups.reset();
        this.transferZones.reset();
    }
}

