/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.Raw1D;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.machine.JavaType;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;

public class Primitive32Array
extends PrimitiveArray {
    public static final DenseArray.Factory<Double> FACTORY = new DenseArray.Factory<Double>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<Double> make(long size) {
            return Primitive32Array.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = JavaType.FLOAT.memory();
    public final float[] data;

    public static final Primitive32Array make(int size) {
        return new Primitive32Array(size);
    }

    public static final Primitive32Array wrap(float ... data) {
        return new Primitive32Array(data);
    }

    private static void add(float[] data, int first, int limit, int step, float left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left + right[i];
        }
    }

    private static void add(float[] data, int first, int limit, int step, float[] left, float right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right;
        }
    }

    private static void add(float[] data, int first, int limit, int step, float[] left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] + right[i];
        }
    }

    private static void divide(float[] data, int first, int limit, int step, float left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left / right[i];
        }
    }

    private static void divide(float[] data, int first, int limit, int step, float[] left, float right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right;
        }
    }

    private static void divide(float[] data, int first, int limit, int step, float[] left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] / right[i];
        }
    }

    private static void multiply(float[] data, int first, int limit, int step, float left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left * right[i];
        }
    }

    private static void multiply(float[] data, int first, int limit, int step, float[] left, float right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right;
        }
    }

    private static void multiply(float[] data, int first, int limit, int step, float[] left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] * right[i];
        }
    }

    private static void negate(float[] data, int first, int limit, int step, float[] values) {
        for (int i = first; i < limit; i += step) {
            data[i] = -values[i];
        }
    }

    private static void subtract(float[] data, int first, int limit, int step, float left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left - right[i];
        }
    }

    private static void subtract(float[] data, int first, int limit, int step, float[] left, float right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right;
        }
    }

    private static void subtract(float[] data, int first, int limit, int step, float[] left, float[] right) {
        for (int i = first; i < limit; i += step) {
            data[i] = left[i] - right[i];
        }
    }

    protected static void exchange(float[] data, int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            float tmpVal = data[tmpIndexA];
            data[tmpIndexA] = data[tmpIndexB];
            data[tmpIndexB] = tmpVal;
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    protected static void fill(float[] data, Access1D<?> values) {
        int tmpLimit = (int)Math.min((long)data.length, values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            data[i] = (float)values.doubleValue(i);
        }
    }

    protected static void fill(float[] data, int first, int limit, int step, float value) {
        for (int i = first; i < limit; i += step) {
            data[i] = value;
        }
    }

    protected static void fill(float[] data, int first, int limit, int step, NullaryFunction<Double> supplier) {
        for (int i = first; i < limit; i += step) {
            data[i] = (float)supplier.doubleValue();
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof Primitive32Array && right instanceof Primitive32Array) {
            Primitive32Array.invoke(data, first, limit, step, ((Primitive32Array)left).data, function, ((Primitive32Array)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left.doubleValue(i), right.doubleValue(i));
            }
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        if (left instanceof Primitive32Array) {
            Primitive32Array.invoke(data, first, limit, step, ((Primitive32Array)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left.doubleValue(i), right);
            }
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, Access1D<Double> values, ParameterFunction<Double> function, int aParam) {
        if (values instanceof Primitive32Array) {
            Primitive32Array.invoke(data, first, limit, step, ((Primitive32Array)values).data, function, aParam);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(values.doubleValue(i), aParam);
            }
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, Access1D<Double> values, UnaryFunction<Double> function) {
        if (values instanceof Primitive32Array) {
            Primitive32Array.invoke(data, first, limit, step, ((Primitive32Array)values).data, function);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(values.doubleValue(i));
            }
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof Primitive32Array) {
            Primitive32Array.invoke(data, first, limit, step, left, function, ((Primitive32Array)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left, right.doubleValue(i));
            }
        }
    }

    protected static void invoke(float[] data, int first, int limit, int step, VoidFunction<Double> aVisitor) {
        for (int i = first; i < limit; i += step) {
            aVisitor.invoke(data[i]);
        }
    }

    static void invoke(float[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, float[] right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive32Array.add(data, first, limit, step, (float)left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive32Array.divide(data, first, limit, step, (float)left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive32Array.multiply(data, first, limit, step, (float)left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive32Array.subtract(data, first, limit, step, (float)left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left, right[i]);
            }
        }
    }

    static void invoke(float[] data, int first, int limit, int step, float[] left, BinaryFunction<Double> function, double right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive32Array.add(data, first, limit, step, left, (float)right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive32Array.divide(data, first, limit, step, left, (float)right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive32Array.multiply(data, first, limit, step, left, (float)right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive32Array.subtract(data, first, limit, step, left, (float)right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left[i], right);
            }
        }
    }

    static void invoke(float[] data, int first, int limit, int step, float[] left, BinaryFunction<Double> function, float[] right) {
        if (function == PrimitiveFunction.ADD) {
            Primitive32Array.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.DIVIDE) {
            Primitive32Array.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.MULTIPLY) {
            Primitive32Array.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveFunction.SUBTRACT) {
            Primitive32Array.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(left[i], right[i]);
            }
        }
    }

    static void invoke(float[] data, int first, int limit, int step, float[] values, ParameterFunction<Double> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data[i] = (float)function.invoke(values[i], aParam);
        }
    }

    static void invoke(float[] data, int first, int limit, int step, float[] values, UnaryFunction<Double> function) {
        if (function == PrimitiveFunction.NEGATE) {
            Primitive32Array.negate(data, first, limit, step, values);
        } else if (function instanceof BinaryFunction.FixedFirst) {
            BinaryFunction.FixedFirst tmpFunc = (BinaryFunction.FixedFirst)function;
            Primitive32Array.invoke(data, first, limit, step, tmpFunc.doubleValue(), tmpFunc.getFunction(), values);
        } else if (function instanceof BinaryFunction.FixedSecond) {
            BinaryFunction.FixedSecond tmpFunc = (BinaryFunction.FixedSecond)function;
            Primitive32Array.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.doubleValue());
        } else if (function instanceof ParameterFunction.FixedParameter) {
            ParameterFunction.FixedParameter tmpFunc = (ParameterFunction.FixedParameter)function;
            Primitive32Array.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.getParameter());
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = (float)function.invoke(values[i]);
            }
        }
    }

    protected Primitive32Array(float[] data) {
        super(FACTORY, data.length);
        this.data = data;
    }

    protected Primitive32Array(int size) {
        super(FACTORY, size);
        this.data = new float[size];
    }

    @Override
    public void axpy(double a, Mutate1D y) {
        AXPY.invoke(y, a, this.data);
    }

    @Override
    public double dot(Access1D<?> vector) {
        double retVal = PrimitiveMath.ZERO;
        int limit = Math.min(this.data.length, (int)vector.count());
        for (int i = 0; i < limit; ++i) {
            retVal += (double)this.data[i] * vector.doubleValue(i);
        }
        return retVal;
    }

    public boolean equals(Object anObj) {
        if (anObj instanceof Primitive32Array) {
            return Arrays.equals(this.data, ((Primitive32Array)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        Primitive32Array.fill(this.data, values);
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        Primitive32Array.invoke(this.data, 0, tmpLimit, 1, left, function, right);
    }

    @Override
    public void fillMatching(UnaryFunction<Double> function, Access1D<Double> arguments) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), arguments.count());
        Primitive32Array.invoke(this.data, 0, tmpLimit, 1, arguments, function);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort(this.data);
    }

    @Override
    public void sortDescending() {
        Primitive32Array.negate(this.data, 0, this.data.length, 1, this.data);
        Arrays.parallelSort(this.data);
        Primitive32Array.negate(this.data, 0, this.data.length, 1, this.data);
    }

    @Override
    protected void add(int index, double addend) {
        int n = index;
        this.data[n] = (float)((double)this.data[n] + addend);
    }

    @Override
    protected void add(int index, Number addend) {
        int n = index;
        this.data[n] = (float)((double)this.data[n] + addend.doubleValue());
    }

    protected final float[] copyOfData() {
        return Raw1D.copyOf(this.data);
    }

    @Override
    protected final double doubleValue(int index) {
        return this.data[index];
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        Primitive32Array.exchange(this.data, firstA, firstB, step, count);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive32Array.invoke(this.data, first, limit, 1, left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        Primitive32Array.invoke(this.data, first, limit, 1, left, function, (double)right);
    }

    @Override
    protected final void fill(int first, int limit, Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive32Array.invoke(this.data, first, limit, 1, (double)left, function, right);
    }

    @Override
    protected final void fill(int first, int limit, int step, Double value) {
        Primitive32Array.fill(this.data, first, limit, step, value.floatValue());
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<Double> supplier) {
        Primitive32Array.fill(this.data, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        this.data[index] = (float)values.doubleValue(valueIndex);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.data[index] = value.floatValue();
    }

    @Override
    protected void fillOne(int index, NullaryFunction<Double> supplier) {
        this.data[index] = (float)supplier.doubleValue();
    }

    @Override
    protected final Double get(int index) {
        return this.data[index];
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke(this.data, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.data[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.data[index]);
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        Primitive32Array.invoke(this.data, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        Primitive32Array.invoke(this.data, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<Double> function, Double right) {
        Primitive32Array.invoke(this.data, first, limit, step, this.data, function, (double)right);
    }

    @Override
    protected final void modify(int first, int limit, int step, Double left, BinaryFunction<Double> function) {
        Primitive32Array.invoke(this.data, first, limit, step, (double)left, function, this.data);
    }

    @Override
    protected final void modify(int first, int limit, int step, ParameterFunction<Double> function, int parameter) {
        Primitive32Array.invoke(this.data, first, limit, step, this.data, function, parameter);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        Primitive32Array.invoke(this.data, first, limit, step, this, function);
    }

    @Override
    protected final void modifyOne(int index, UnaryFunction<Double> modifier) {
        this.data[index] = (float)modifier.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(Double number) {
        return Arrays.binarySearch(this.data, number.floatValue());
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = (float)value;
    }

    @Override
    protected final void set(int index, Number value) {
        this.data[index] = value.floatValue();
    }

    @Override
    protected int size() {
        return this.data.length;
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        Primitive32Array.invoke(this.data, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    void modify(long extIndex, int intIndex, Access1D<Double> left, BinaryFunction<Double> function) {
        this.data[intIndex] = (float)function.invoke(left.doubleValue(extIndex), this.data[intIndex]);
    }

    @Override
    void modify(long extIndex, int intIndex, BinaryFunction<Double> function, Access1D<Double> right) {
        this.data[intIndex] = (float)function.invoke(this.data[intIndex], right.doubleValue(extIndex));
    }

    @Override
    void modify(long extIndex, int intIndex, UnaryFunction<Double> function) {
        this.data[intIndex] = (float)function.invoke(this.data[intIndex]);
    }
}

