/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Mutate1D;

public abstract class ScalarArray<N extends Number>
extends ReferenceTypeArray<N> {
    protected ScalarArray(DenseArray.Factory<N> factory, int length) {
        super(factory, length);
    }

    protected ScalarArray(DenseArray.Factory<N> factory, N[] data) {
        super(factory, data);
    }

    @Override
    public final void axpy(double a, Mutate1D y) {
        AXPY.invoke((Mutate1D)y, (double)a, (Number[])this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Comparable[])this.data));
    }

    @Override
    public final void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((Scalar)((ScalarOperation.Addition)this.get(index)).add(this.valueOf(addend))).get());
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((Scalar)((ScalarOperation.Addition)this.get(index)).add(this.valueOf(addend))).get());
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((Number[])this.data, (int)first, (int)limit, (int)step);
    }

    @Override
    protected final boolean isAbsolute(int index) {
        return ((Scalar)((Object)this.data[index])).isAbsolute();
    }

    @Override
    protected final boolean isSmall(int index, double comparedTo) {
        return ((NormedVectorSpace)((Object)this.data[index])).isSmall(comparedTo);
    }
}

