/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveFunction
extends FunctionSet<Double> {
    public static final Unary ABS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.abs(arg);
        }
    };
    public static final Unary ACOS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.acos(arg);
        }
    };
    public static final Unary ACOSH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return LOG.invoke(arg + SQRT.invoke(arg * arg - PrimitiveMath.ONE));
        }
    };
    public static final Binary ADD = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 + arg2;
        }
    };
    public static final Unary ASIN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.asin(arg);
        }
    };
    public static final Unary ASINH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return LOG.invoke(arg + SQRT.invoke(arg * arg + PrimitiveMath.ONE));
        }
    };
    public static final Unary ATAN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.atan(arg);
        }
    };
    public static final Binary ATAN2 = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.atan2(arg1, arg2);
        }
    };
    public static final Unary ATANH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return LOG.invoke((PrimitiveMath.ONE + arg) / (PrimitiveMath.ONE - arg)) / PrimitiveMath.TWO;
        }
    };
    public static final Unary CARDINALITY = new Unary(){

        @Override
        public final double invoke(double arg) {
            return PrimitiveScalar.isSmall(PrimitiveMath.ONE, arg) ? PrimitiveMath.ZERO : PrimitiveMath.ONE;
        }
    };
    public static final Unary CBRT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.cbrt(arg);
        }
    };
    public static final Unary CEIL = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.ceil(arg);
        }
    };
    public static final Unary CONJUGATE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return arg;
        }
    };
    public static final Unary COS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.cos(arg);
        }
    };
    public static final Unary COSH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.cosh(arg);
        }
    };
    public static final Binary DIVIDE = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 / arg2;
        }
    };
    public static final Unary EXP = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.exp(arg);
        }
    };
    public static final Unary EXPM1 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.expm1(arg);
        }
    };
    public static final Unary FLOOR = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.floor(arg);
        }
    };
    public static final Binary HYPOT = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            if (Double.isNaN(arg1) || Double.isNaN(arg2)) {
                return Double.NaN;
            }
            double abs1 = ABS.invoke(arg1);
            double abs2 = ABS.invoke(arg2);
            double retVal = PrimitiveMath.ZERO;
            if (abs1 > abs2) {
                retVal = abs1 * SQRT1PX2.invoke(abs2 / abs1);
            } else if (abs2 > PrimitiveMath.ZERO) {
                retVal = abs2 * SQRT1PX2.invoke(abs1 / abs2);
            }
            return retVal;
        }
    };
    public static final Unary INVERT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return PrimitiveMath.ONE / arg;
        }
    };
    public static final Unary LOG = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log(arg);
        }
    };
    public static final Unary LOG10 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log10(arg);
        }
    };
    public static final Unary LOG1P = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log1p(arg);
        }
    };
    public static final Unary LOGISTIC = new Unary(){

        @Override
        public final double invoke(double arg) {
            return PrimitiveMath.ONE / (PrimitiveMath.ONE + Math.exp(-arg));
        }
    };
    public static final Unary LOGIT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log(PrimitiveMath.ONE / (PrimitiveMath.ONE - arg));
        }
    };
    public static final Binary MAX = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.max(arg1, arg2);
        }
    };
    public static final Binary MIN = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.min(arg1, arg2);
        }
    };
    public static final Binary MULTIPLY = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 * arg2;
        }
    };
    public static final Unary NEGATE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return -arg;
        }
    };
    public static final Binary POW = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.pow(arg1, arg2);
        }
    };
    public static final Parameter POWER = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param < 0) {
                return INVERT.invoke(POWER.invoke(arg, -param));
            }
            double retVal = PrimitiveMath.ONE;
            while (param > 0) {
                retVal *= arg;
                --param;
            }
            return retVal;
        }
    };
    public static final Unary RINT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.rint(arg);
        }
    };
    public static final Parameter ROOT = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param != 0) {
                return POW.invoke(arg, PrimitiveMath.ONE / (double)param);
            }
            throw new IllegalArgumentException();
        }
    };
    public static final Parameter SCALE = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param < 0) {
                throw new ProgrammingError("Cannot have exponents smaller than zero.");
            }
            long tmpFactor = 1L;
            long tmp10 = (long)PrimitiveMath.TEN;
            while (param > 0) {
                tmpFactor *= tmp10;
                --param;
            }
            return RINT.invoke((double)tmpFactor * arg) / (double)tmpFactor;
        }
    };
    public static final Unary SIGNUM = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.signum(arg);
        }
    };
    public static final Unary SIN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sin(arg);
        }
    };
    public static final Unary SINH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sinh(arg);
        }
    };
    public static final Unary SQRT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sqrt(arg);
        }
    };
    public static final Unary SQRT1PX2 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return SQRT.invoke(PrimitiveMath.ONE + arg * arg);
        }
    };
    public static final Binary SUBTRACT = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 - arg2;
        }
    };
    public static final Unary TAN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.tan(arg);
        }
    };
    public static final Unary TANH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.tanh(arg);
        }
    };
    public static final Unary VALUE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return arg;
        }
    };
    private static final PrimitiveFunction SET = new PrimitiveFunction();

    public static PrimitiveFunction getSet() {
        return SET;
    }

    private PrimitiveFunction() {
    }

    @Override
    public UnaryFunction<Double> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<Double> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<Double> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<Double> add() {
        return ADD;
    }

    @Override
    public AggregatorSet<Double> aggregator() {
        return PrimitiveAggregator.getSet();
    }

    @Override
    public UnaryFunction<Double> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<Double> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<Double> atan() {
        return ATAN;
    }

    @Override
    public BinaryFunction<Double> atan2() {
        return ATAN2;
    }

    @Override
    public UnaryFunction<Double> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<Double> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<Double> cbrt() {
        return CBRT;
    }

    @Override
    public UnaryFunction<Double> ceil() {
        return CEIL;
    }

    @Override
    public UnaryFunction<Double> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<Double> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<Double> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<Double> divide() {
        return DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> context.enforce(t);
    }

    @Override
    public UnaryFunction<Double> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<Double> expm1() {
        return EXPM1;
    }

    @Override
    public UnaryFunction<Double> floor() {
        return FLOOR;
    }

    @Override
    public BinaryFunction<Double> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<Double> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<Double> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<Double> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<Double> log1p() {
        return LOG1P;
    }

    @Override
    public UnaryFunction<Double> logistic() {
        return LOGISTIC;
    }

    @Override
    public UnaryFunction<Double> logit() {
        return LOGIT;
    }

    @Override
    public BinaryFunction<Double> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<Double> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<Double> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<Double> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<Double> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<Double> power() {
        return POWER;
    }

    @Override
    public UnaryFunction<Double> rint() {
        return RINT;
    }

    @Override
    public ParameterFunction<Double> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<Double> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<Double> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<Double> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<Double> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<Double> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<Double> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<Double> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<Double> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<Double> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<Double> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Double> {
        @Override
        default public Double invoke(Double arg) {
            return this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<Double> {
        @Override
        default public boolean invoke(Double arg) {
            return this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Double> {
        @Override
        default public Double invoke(Double arg, int param) {
            return this.invoke((double)arg, param);
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<Double> {
        @Override
        default public void invoke(Double arg) {
            this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Double> {
        @Override
        default public Double invoke(Double arg1, Double arg2) {
            return this.invoke((double)arg1, (double)arg2);
        }
    }
}

