/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;

public final class MatrixFactory<N extends Number, I extends BasicMatrix>
implements Factory2D<I> {
    private final Constructor<I> myConstructor;
    private final PhysicalStore.Factory<N, ?> myPhysicalFactory;

    private static Constructor<? extends BasicMatrix> getConstructor(Class<? extends BasicMatrix> aTemplate) {
        try {
            Constructor<? extends BasicMatrix> retVal = aTemplate.getDeclaredConstructor(MatrixStore.class);
            retVal.setAccessible(true);
            return retVal;
        }
        catch (SecurityException anException) {
            return null;
        }
        catch (NoSuchMethodException anException) {
            return null;
        }
    }

    MatrixFactory(Class<I> template, PhysicalStore.Factory<N, ?> factory) {
        this.myPhysicalFactory = factory;
        this.myConstructor = MatrixFactory.getConstructor(template);
    }

    @Override
    public I columns(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I copy(Access2D<?> source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.copy(source));
    }

    public FunctionSet<N> function() {
        return this.myPhysicalFactory.function();
    }

    public BasicMatrix.PhysicalBuilder<N, I> getBuilder(int count) {
        return this.getBuilder(count, 1);
    }

    public BasicMatrix.PhysicalBuilder<N, I> getBuilder(int rows, int columns) {
        return new MatrixBuilder(this.myPhysicalFactory, rows, columns);
    }

    @Override
    public I makeEye(long rows, long columns) {
        int tmpMinDim = (int)Math.min(rows, columns);
        MatrixStore.LogicalBuilder<N> retVal = this.myPhysicalFactory.builder().makeIdentity(tmpMinDim);
        if (rows > (long)tmpMinDim) {
            retVal = retVal.below((int)rows - tmpMinDim);
        } else if (columns > (long)tmpMinDim) {
            retVal = retVal.right((int)columns - tmpMinDim);
        }
        return this.instantiate((MatrixStore<N>)retVal.get());
    }

    @Override
    public I makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.makeFilled(rows, columns, supplier));
    }

    @Override
    public I makeZero(long rows, long columns) {
        return this.instantiate((MatrixStore<N>)this.myPhysicalFactory.builder().makeZero((int)rows, (int)columns).get());
    }

    @Override
    public I rows(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    public Scalar.Factory<N> scalar() {
        return this.myPhysicalFactory.scalar();
    }

    I instantiate(MatrixStore<N> store) {
        try {
            return (I)((BasicMatrix)this.myConstructor.newInstance(store));
        }
        catch (IllegalArgumentException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InstantiationException anException) {
            throw new ProgrammingError(anException);
        }
        catch (IllegalAccessException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InvocationTargetException anException) {
            throw new ProgrammingError(anException);
        }
    }

    MatrixBuilder wrap(PhysicalStore<N> store) {
        return new MatrixBuilder(store);
    }

    final class MatrixBuilder
    implements BasicMatrix.PhysicalBuilder<N, I> {
        private boolean mySafe = true;
        private final PhysicalStore<N> myStore;

        protected MatrixBuilder(PhysicalStore.Factory<N, ?> factory, int rowDim, int colDim) {
            this.myStore = (PhysicalStore)factory.makeZero(rowDim, colDim);
        }

        MatrixBuilder(PhysicalStore<N> physicalStore) {
            this.myStore = physicalStore;
        }

        @Override
        public void accept(Access2D<?> supplied) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.accept(supplied);
        }

        @Override
        public void add(long index, double addend) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(index, addend);
        }

        @Override
        public void add(long row, long col, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(row, col, value);
        }

        @Override
        public void add(long row, long col, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(row, col, value);
        }

        @Override
        public void add(long index, Number addend) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(index, addend);
        }

        @Override
        public long count() {
            return this.myStore.count();
        }

        @Override
        public long countColumns() {
            return this.myStore.countColumns();
        }

        @Override
        public long countRows() {
            return this.myStore.countRows();
        }

        @Override
        public void exchangeColumns(long colA, long colB) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.exchangeColumns(colA, colB);
        }

        @Override
        public void exchangeRows(long rowA, long rowB) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.exchangeRows(rowA, rowB);
        }

        @Override
        public void fillAll(NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillAll(supplier);
        }

        @Override
        public void fillAll(Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillAll(this.myStore.physical().scalar().cast(value));
        }

        @Override
        public void fillColumn(long col, Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn(col, values);
        }

        @Override
        public void fillColumn(long row, long col, Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn(row, col, values);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn(row, col, supplier);
        }

        @Override
        public void fillColumn(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
        }

        @Override
        public void fillColumn(long col, N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn(col, value);
        }

        @Override
        public void fillColumn(long col, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn(col, supplier);
        }

        @Override
        public void fillDiagonal(Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal(values);
        }

        @Override
        public void fillDiagonal(long row, long col, Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal(row, col, values);
        }

        @Override
        public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal(row, col, supplier);
        }

        @Override
        public void fillDiagonal(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
        }

        @Override
        public void fillDiagonal(N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal(value);
        }

        @Override
        public void fillDiagonal(NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal(supplier);
        }

        @Override
        public void fillMatching(Access1D<?> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillMatching(values);
        }

        @Override
        public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillMatching(left, function, right);
        }

        @Override
        public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillMatching(function, arguments);
        }

        @Override
        public void fillOne(long index, Access1D<?> values, long valueIndex) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(index, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(row, col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(row, col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(row, col, supplier);
        }

        @Override
        public void fillOne(long index, N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(index, value);
        }

        @Override
        public void fillOne(long index, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillOne(index, supplier);
        }

        @Override
        public void fillRange(long first, long limit, N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRange(first, limit, value);
        }

        @Override
        public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRange(first, limit, supplier);
        }

        @Override
        public void fillRow(long row, Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow(row, values);
        }

        @Override
        public void fillRow(long row, long col, Access1D<N> values) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow(row, col, values);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow(row, col, supplier);
        }

        @Override
        public void fillRow(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
        }

        @Override
        public void fillRow(long row, N value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow(row, value);
        }

        @Override
        public void fillRow(long row, NullaryFunction<N> supplier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow(row, supplier);
        }

        @Override
        public I get() {
            this.mySafe = false;
            return MatrixFactory.this.instantiate(this.myStore);
        }

        @Override
        public void modifyAll(UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyAll(modifier);
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyColumn(row, col, modifier);
        }

        @Override
        public void modifyColumn(long col, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyColumn(col, modifier);
        }

        @Override
        public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyDiagonal(row, col, modifier);
        }

        @Override
        public void modifyDiagonal(UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyDiagonal(modifier);
        }

        @Override
        public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatching(left, function);
        }

        @Override
        public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatching(function, right);
        }

        @Override
        public void modifyMatchingInColumns(Access1D<N> left, BinaryFunction<N> function) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatchingInColumns(left, function);
        }

        @Override
        public void modifyMatchingInColumns(BinaryFunction<N> function, Access1D<N> right) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatchingInColumns(function, right);
        }

        @Override
        public void modifyMatchingInRows(Access1D<N> left, BinaryFunction<N> function) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatchingInRows(left, function);
        }

        @Override
        public void modifyMatchingInRows(BinaryFunction<N> function, Access1D<N> right) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyMatchingInRows(function, right);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyOne(row, col, modifier);
        }

        @Override
        public void modifyOne(long index, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyOne(index, modifier);
        }

        @Override
        public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyRange(first, limit, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyRow(row, col, modifier);
        }

        @Override
        public void modifyRow(long row, UnaryFunction<N> modifier) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.modifyRow(row, modifier);
        }

        @Override
        public void reset() {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.reset();
        }

        @Override
        public void set(long index, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(index, value);
        }

        @Override
        public void set(long row, long col, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(row, col, value);
        }

        @Override
        public void set(long row, long col, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(row, col, value);
        }

        @Override
        public void set(long index, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(index, (Number)this.myStore.physical().scalar().cast(value));
        }

        @Override
        public void supplyTo(PhysicalStore<N> receiver) {
            this.myStore.supplyTo(receiver);
        }
    }
}

