/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.random.Uniform;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public abstract class MatrixUtils {
    public static void copy(Access2D<?> source, int rows, int columns, double[][] destination) {
        for (int i = 0; i < rows; ++i) {
            double[] tmpRow = destination[i];
            for (int j = 0; j < columns; ++j) {
                tmpRow[j] = source.doubleValue(i, j);
            }
        }
    }

    public static void copyComplexArgument(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getArgument());
        }
    }

    public static void copyComplexImaginary(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getImaginary());
        }
    }

    public static void copyComplexModulus(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getModulus());
        }
    }

    public static void copyComplexModulusAndArgument(Access2D<ComplexNumber> source, ElementsConsumer<?> modDest, ElementsConsumer<?> argDest) {
        long tmpCount = FunctionUtils.min(source.count(), modDest.count(), argDest.count());
        for (long i = 0L; i < tmpCount; ++i) {
            ComplexNumber tmpComplexNumber = source.get(i);
            modDest.set(i, tmpComplexNumber.getModulus());
            argDest.set(i, tmpComplexNumber.getArgument());
        }
    }

    public static void copyComplexReal(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getReal());
        }
    }

    public static void copyComplexRealAndImaginary(Access2D<ComplexNumber> source, ElementsConsumer<?> realDest, ElementsConsumer<?> imagDest) {
        long tmpCount = FunctionUtils.min(source.count(), realDest.count(), imagDest.count());
        for (long i = 0L; i < tmpCount; ++i) {
            ComplexNumber tmpComplexNumber = source.get(i);
            realDest.set(i, tmpComplexNumber.getReal());
            imagDest.set(i, tmpComplexNumber.getImaginary());
        }
    }

    public static final int firstInColumn(Access1D<?> matrix, int col, int defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max(((MatrixStore)matrix).firstInColumn(col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final long firstInColumn(Access1D<?> matrix, long col, long defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max((long)((MatrixStore)matrix).firstInColumn((int)col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final int firstInRow(Access1D<?> matrix, int row, int defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max(((MatrixStore)matrix).firstInRow(row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final long firstInRow(Access1D<?> matrix, long row, long defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max((long)((MatrixStore)matrix).firstInRow((int)row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static PrimitiveDenseStore getComplexArgument(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexArgument(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexImaginary(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexImaginary(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexModulus(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexModulus(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexReal(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexReal(arg, retVal);
        return retVal;
    }

    public static <N extends Number> int hashCode(BasicMatrix matrix) {
        return Access1D.hashCode(matrix);
    }

    public static <N extends Number> int hashCode(MatrixStore<N> matrix) {
        return Access1D.hashCode(matrix);
    }

    public static boolean isHermitian(Access2D<?> matrix) {
        boolean retVal;
        long tmpRowDim = matrix.countRows();
        long tmpColDim = matrix.countColumns();
        Object tmpElement = matrix.get(0L);
        boolean bl = retVal = tmpRowDim == tmpColDim;
        if (tmpElement instanceof ComplexNumber) {
            int j = 0;
            while (retVal && (long)j < tmpColDim) {
                retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, ComplexNumber.valueOf(matrix.get((long)((long)j), (long)((long)j))).i);
                int i = j + 1;
                while (retVal && (long)i < tmpRowDim) {
                    ComplexNumber tmpLowerLeft = ComplexNumber.valueOf(matrix.get(i, j)).conjugate();
                    ComplexNumber tmpUpperRight = ComplexNumber.valueOf(matrix.get(j, i));
                    retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpLowerLeft.subtract(tmpUpperRight).norm());
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (retVal && (long)j < tmpColDim) {
                int i = j + 1;
                while (retVal && (long)i < tmpRowDim) {
                    retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, matrix.doubleValue(i, j) - matrix.doubleValue(j, i));
                    ++i;
                }
                ++j;
            }
        }
        return retVal;
    }

    public static <N extends Number> boolean isNormal(MatrixStore<N> matrix) {
        Object tmpConjugate = matrix.conjugate();
        return tmpConjugate.multiply(matrix).equals(matrix.multiply(tmpConjugate));
    }

    public static final int limitOfColumn(Access1D<?> matrix, int col, int defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min(((MatrixStore)matrix).limitOfColumn(col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final long limitOfColumn(Access1D<?> matrix, long col, long defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min((long)((MatrixStore)matrix).limitOfColumn((int)col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final int limitOfRow(Access1D<?> matrix, int row, int defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min(((MatrixStore)matrix).limitOfRow(row), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final long limitOfRow(Access1D<?> matrix, long row, long defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min((long)((MatrixStore)matrix).limitOfRow((int)row), defaultAndMaximum) : defaultAndMaximum;
    }

    public static PhysicalStore<ComplexNumber> makeRandomComplexStore(int numberOfRows, int numberOfColumns) {
        PhysicalStore retVal = (PhysicalStore)GenericDenseStore.COMPLEX.makeZero(numberOfRows, numberOfColumns);
        Uniform tmpArgGen = new Uniform(PrimitiveMath.ZERO, PrimitiveMath.TWO_PI);
        for (int j = 0; j < numberOfColumns; ++j) {
            for (int i = 0; i < numberOfRows; ++i) {
                retVal.set((long)i, (long)j, ComplexNumber.makePolar(PrimitiveMath.E, tmpArgGen.doubleValue()).add(PrimitiveMath.PI));
            }
        }
        return retVal;
    }

    public static PrimitiveDenseStore makeSPD(int dim) {
        double[] tmpRandom = new double[dim];
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(dim, dim);
        for (int i = 0; i < dim; ++i) {
            tmpRandom[i] = Math.random();
            for (int j = 0; j < i; ++j) {
                retVal.set((long)i, (long)j, tmpRandom[i] * tmpRandom[j]);
                retVal.set((long)j, (long)i, tmpRandom[j] * tmpRandom[i]);
            }
            retVal.set((long)i, (long)i, tmpRandom[i] + 1.0);
        }
        return retVal;
    }

    @Deprecated
    public static String toString(Access2D<?> matrix) {
        return Access2D.toString(matrix);
    }

    public static Access2D<BigDecimal> wrapBigAccess2D(final BasicMatrix matrix) {
        return new Access2D<BigDecimal>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public BigDecimal get(long row, long col) {
                return TypeUtils.toBigDecimal(matrix.get((int)row, (int)col));
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    public static Access2D<ComplexNumber> wrapComplexAccess2D(final BasicMatrix matrix) {
        return new Access2D<ComplexNumber>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public ComplexNumber get(long row, long col) {
                return ComplexNumber.valueOf(matrix.get((int)row, (int)col));
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    public static Access2D<Double> wrapPrimitiveAccess2D(final BasicMatrix matrix) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public Double get(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    private MatrixUtils() {
    }
}

