/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

final class RawCholesky
extends RawDecomposition
implements Cholesky<Double> {
    private double myMaxDiag = PrimitiveMath.ONE;
    private double myMinDiag = PrimitiveMath.ZERO;
    private boolean mySPD = false;

    RawCholesky() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, false);
        this.doDecompose(retVal, matrix);
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndCompute(MatrixStore<Double> matrix) {
        this.mySPD = MatrixUtils.isHermitian(matrix);
        if (this.mySPD) {
            double[][] retVal = this.reset(matrix, false);
            return this.doDecompose(retVal, matrix);
        }
        return this.computed(false);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] retVal = this.reset(matrix, false);
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        matrix.supplyTo(tmpRawInPlaceStore);
        return this.doDecompose(retVal, tmpRawInPlaceStore);
    }

    @Override
    public Double getDeterminant() {
        double[][] tmpData = this.getRawInPlaceData();
        int tmpMinDim = this.getMinDim();
        double retVal = PrimitiveMath.ONE;
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            double tmpVal = tmpData[ij][ij];
            retVal *= tmpVal * tmpVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse(preallocated);
    }

    @Override
    public MatrixStore<Double> getL() {
        return this.getRawInPlaceStore().logical().triangular(false, false).get();
    }

    @Override
    public int getRank() {
        double tolerance = PrimitiveFunction.SQRT.invoke(this.getAlgorithmEpsilon());
        int rank = 0;
        RawStore inPlaceStore = this.getRawInPlaceStore();
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(inPlaceStore.doubleValue(ij, ij) > tolerance)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        PrimitiveDenseStore tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(original, false);
        this.doDecompose(retVal, original);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.isSolvable();
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(body, false);
        this.doDecompose(retVal, body);
        if (this.isSolvable()) {
            preallocated.fillMatching(rhs);
            return this.doSolve(preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data, Access2D<?> input) {
        int tmpDiagDim = this.getRowDim();
        this.mySPD = this.getColDim() == tmpDiagDim;
        this.myMaxDiag = PrimitiveMath.ZERO;
        this.myMinDiag = Double.POSITIVE_INFINITY;
        for (int ij = 0; this.mySPD && ij < tmpDiagDim; ++ij) {
            double[] tmpRowIJ = data[ij];
            double tmpVal = PrimitiveFunction.MAX.invoke(input.doubleValue(ij, ij) - DOT.invoke(tmpRowIJ, 0, tmpRowIJ, 0, 0, ij), PrimitiveMath.ZERO);
            this.myMaxDiag = PrimitiveFunction.MAX.invoke(this.myMaxDiag, tmpVal);
            this.myMinDiag = PrimitiveFunction.MIN.invoke(this.myMinDiag, tmpVal);
            tmpVal = tmpRowIJ[ij] = PrimitiveFunction.SQRT.invoke(tmpVal);
            this.mySPD = this.mySPD && tmpVal > PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                double[] tmpRowI = data[i];
                tmpRowI[ij] = (input.doubleValue(i, ij) - DOT.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij)) / tmpVal;
            }
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(PhysicalStore<Double> preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, false, false, true);
        preallocated.substituteBackwards(tmpBody, false, true, true);
        return preallocated.logical().hermitian(false).get();
    }

    private MatrixStore<Double> doSolve(PhysicalStore<Double> preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, false, false, false);
        preallocated.substituteBackwards(tmpBody, false, true, false);
        return preallocated;
    }

    @Override
    protected boolean checkSolvability() {
        return this.mySPD && this.myMinDiag > this.getAlgorithmEpsilon();
    }

    double getAlgorithmEpsilon() {
        return this.myMaxDiag * PrimitiveMath.TEN * this.getDimensionalEpsilon();
    }
}

