/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.DeferredTridiagonal;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface Tridiagonal<N extends Number>
extends MatrixDecomposition<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new DeferredTridiagonal.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new DeferredTridiagonal.Primitive();
    public static final Factory<Quaternion> QUATERNION = typical -> new DeferredTridiagonal.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new DeferredTridiagonal.Rational();

    public static <N extends Number> Tridiagonal<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof RationalNumber) {
            return (Tridiagonal)RATIONAL.make(typical);
        }
        if (tmpNumber instanceof Quaternion) {
            return (Tridiagonal)QUATERNION.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (Tridiagonal)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (Tridiagonal)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Tridiagonal<N> decomposition, NumberContext context) {
        boolean retVal = true;
        retVal &= Access2D.equals(matrix, Tridiagonal.reconstruct(decomposition), context);
        MatrixStore<Object> mtrxQ = decomposition.getQ();
        MatrixStore identity = (MatrixStore)mtrxQ.physical().makeEye(mtrxQ.countRows(), mtrxQ.countColumns());
        MatrixStore<Object> qqh = mtrxQ.multiply(mtrxQ.conjugate());
        retVal &= qqh.equals(identity, context);
        MatrixStore<MatrixStore<N>> qhq = mtrxQ.conjugate().multiply(mtrxQ);
        return retVal &= qhq.equals(identity, context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(Tridiagonal<N> decomposition) {
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        return tmpQ.multiply(decomposition.getD()).multiply((MatrixStore<Object>)tmpQ.conjugate());
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ();

    @Override
    default public MatrixStore<N> reconstruct() {
        return Tridiagonal.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<Tridiagonal<N>> {
    }
}

