/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.Operation;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.store.AboveBelowStore;
import org.ojalgo.matrix.store.ColumnsStore;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.IdentityStore;
import org.ojalgo.matrix.store.LeftRightStore;
import org.ojalgo.matrix.store.LimitStore;
import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.LowerHermitianStore;
import org.ojalgo.matrix.store.LowerHessenbergStore;
import org.ojalgo.matrix.store.LowerTriangularStore;
import org.ojalgo.matrix.store.MatrixPipeline;
import org.ojalgo.matrix.store.OffsetStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RowsStore;
import org.ojalgo.matrix.store.SingleStore;
import org.ojalgo.matrix.store.SuperimposedStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.UnaryOperatoStore;
import org.ojalgo.matrix.store.UpperHermitianStore;
import org.ojalgo.matrix.store.UpperHessenbergStore;
import org.ojalgo.matrix.store.UpperTriangularStore;
import org.ojalgo.matrix.store.WrapperStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public interface MatrixStore<N extends Number>
extends ElementsSupplier<N>,
Access2D<N>,
Access2D.Elements,
Access2D.Visitable<N>,
Access2D.Aggregatable<N>,
Structure2D.ReducibleTo1D<ElementsSupplier<N>>,
Access2D.Sliceable<N>,
NormedVectorSpace<MatrixStore<N>, N>,
Operation.Multiplication<MatrixStore<N>> {
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public LogicalBuilder<ComplexNumber> makeIdentity(int dimension) {
            return new LogicalBuilder<ComplexNumber>(new IdentityStore<ComplexNumber>(GenericDenseStore.COMPLEX, dimension));
        }

        @Override
        public LogicalBuilder<ComplexNumber> makeSingle(ComplexNumber element) {
            return new LogicalBuilder<ComplexNumber>(new SingleStore<ComplexNumber>(GenericDenseStore.COMPLEX, element));
        }

        @Override
        public LogicalBuilder<ComplexNumber> makeWrapper(Access2D<?> access) {
            return new LogicalBuilder<ComplexNumber>(new WrapperStore<ComplexNumber>(GenericDenseStore.COMPLEX, access));
        }

        @Override
        public LogicalBuilder<ComplexNumber> makeZero(int rowsCount, int columnsCount) {
            return new LogicalBuilder<ComplexNumber>(new ZeroStore<ComplexNumber>(GenericDenseStore.COMPLEX, rowsCount, columnsCount));
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public LogicalBuilder<Double> makeIdentity(int dimension) {
            return new LogicalBuilder<Double>(new IdentityStore<Double>(PrimitiveDenseStore.FACTORY, dimension));
        }

        @Override
        public LogicalBuilder<Double> makeSingle(Double element) {
            return new LogicalBuilder<Double>(new SingleStore<Double>(PrimitiveDenseStore.FACTORY, element));
        }

        @Override
        public LogicalBuilder<Double> makeWrapper(Access2D<?> access) {
            return new LogicalBuilder<Double>(new WrapperStore<Double>(PrimitiveDenseStore.FACTORY, access));
        }

        @Override
        public LogicalBuilder<Double> makeZero(int rowsCount, int columnsCount) {
            return new LogicalBuilder<Double>(new ZeroStore<Double>(PrimitiveDenseStore.FACTORY, rowsCount, columnsCount));
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        public LogicalBuilder<Quaternion> makeIdentity(int dimension) {
            return new LogicalBuilder<Quaternion>(new IdentityStore<Quaternion>(GenericDenseStore.QUATERNION, dimension));
        }

        @Override
        public LogicalBuilder<Quaternion> makeSingle(Quaternion element) {
            return new LogicalBuilder<Quaternion>(new SingleStore<Quaternion>(GenericDenseStore.QUATERNION, element));
        }

        @Override
        public LogicalBuilder<Quaternion> makeWrapper(Access2D<?> access) {
            return new LogicalBuilder<Quaternion>(new WrapperStore<Quaternion>(GenericDenseStore.QUATERNION, access));
        }

        @Override
        public LogicalBuilder<Quaternion> makeZero(int rowsCount, int columnsCount) {
            return new LogicalBuilder<Quaternion>(new ZeroStore<Quaternion>(GenericDenseStore.QUATERNION, rowsCount, columnsCount));
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        public LogicalBuilder<RationalNumber> makeIdentity(int dimension) {
            return new LogicalBuilder<RationalNumber>(new IdentityStore<RationalNumber>(GenericDenseStore.RATIONAL, dimension));
        }

        @Override
        public LogicalBuilder<RationalNumber> makeSingle(RationalNumber element) {
            return new LogicalBuilder<RationalNumber>(new SingleStore<RationalNumber>(GenericDenseStore.RATIONAL, element));
        }

        @Override
        public LogicalBuilder<RationalNumber> makeWrapper(Access2D<?> access) {
            return new LogicalBuilder<RationalNumber>(new WrapperStore<RationalNumber>(GenericDenseStore.RATIONAL, access));
        }

        @Override
        public LogicalBuilder<RationalNumber> makeZero(int rowsCount, int columnsCount) {
            return new LogicalBuilder<RationalNumber>(new ZeroStore<RationalNumber>(GenericDenseStore.RATIONAL, rowsCount, columnsCount));
        }
    };

    @Override
    default public MatrixStore<N> add(MatrixStore<N> addend) {
        return this.operateOnMatching(this.physical().function().add(), addend).get();
    }

    @Override
    default public N aggregateAll(Aggregator aggregator) {
        AggregatorFunction tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitAll(tmpVisitor);
        return tmpVisitor.get();
    }

    @Override
    default public N aggregateColumn(long row, long col, Aggregator aggregator) {
        AggregatorFunction tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitColumn(row, col, tmpVisitor);
        return tmpVisitor.get();
    }

    @Override
    default public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        AggregatorFunction tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitDiagonal(row, col, tmpVisitor);
        return tmpVisitor.get();
    }

    @Override
    default public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitRange(first, limit, tmpVisitor);
        return tmpVisitor.get();
    }

    @Override
    default public N aggregateRow(long row, long col, Aggregator aggregator) {
        AggregatorFunction tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitRow(row, col, tmpVisitor);
        return tmpVisitor.get();
    }

    @Override
    default public MatrixStore<N> conjugate() {
        return new ConjugatedStore(this);
    }

    default public PhysicalStore<N> copy() {
        PhysicalStore retVal = (PhysicalStore)this.physical().makeZero(this);
        this.supplyTo(retVal);
        return retVal;
    }

    @Override
    default public double doubleValue(long row, long col) {
        return ((Number)this.get(row, col)).doubleValue();
    }

    default public boolean equals(MatrixStore<N> other, NumberContext context) {
        return Access2D.equals(this, other, context);
    }

    default public int firstInColumn(int col) {
        return 0;
    }

    default public int firstInRow(int row) {
        return 0;
    }

    @Override
    default public MatrixStore<N> get() {
        return this;
    }

    @Override
    default public boolean isAbsolute(long row, long col) {
        return this.toScalar(row, col).isAbsolute();
    }

    @Override
    default public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.norm());
    }

    @Override
    default public boolean isSmall(long row, long col, double comparedTo) {
        return this.toScalar(row, col).isSmall(comparedTo);
    }

    default public int limitOfColumn(int col) {
        return (int)this.countRows();
    }

    default public int limitOfRow(int row) {
        return (int)this.countColumns();
    }

    default public LogicalBuilder<N> logical() {
        return new LogicalBuilder(this);
    }

    default public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        target.fillByMultiplying(this, right);
    }

    @Override
    default public MatrixStore<N> multiply(double scalar) {
        return this.multiply((Number)this.physical().scalar().cast(scalar));
    }

    @Override
    default public MatrixStore<N> multiply(MatrixStore<N> right) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = right.count() / this.countColumns();
        PhysicalStore retVal = (PhysicalStore)this.physical().makeZero(tmpCountRows, tmpCountColumns);
        this.multiply(right, retVal);
        return retVal;
    }

    @Override
    default public MatrixStore<N> multiply(N scalar) {
        return this.operateOnAll(this.physical().function().multiply().second(scalar)).get();
    }

    default public N multiplyBoth(Access1D<N> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)this.physical().makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)this.physical().makeZero(1L, 1L);
        PhysicalStore tmpLeft = (PhysicalStore)this.physical().rows(leftAndRight);
        tmpLeft.modifyAll(this.physical().function().conjugate());
        tmpStep1.fillByMultiplying(tmpLeft.conjugate(), this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return tmpStep2.get(0L);
    }

    @Override
    default public MatrixStore<N> negate() {
        return this.operateOnAll(this.physical().function().negate()).get();
    }

    @Override
    default public double norm() {
        double frobeniusNorm = ((Number)this.aggregateAll(Aggregator.NORM2)).doubleValue();
        if (this.isVector()) {
            return frobeniusNorm;
        }
        return frobeniusNorm / PrimitiveFunction.SQRT.invoke(Math.min(this.countRows(), this.countColumns()));
    }

    @Override
    default public MatrixStore<N> operateOnAll(UnaryFunction<N> operator) {
        return new UnaryOperatoStore<N>(this, operator);
    }

    default public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return new MatrixPipeline.Multiplication<N>(left, this);
    }

    @Override
    default public ElementsSupplier<N> reduceColumns(Aggregator aggregator) {
        return new MatrixPipeline.ColumnsReducer(this, aggregator);
    }

    @Override
    default public ElementsSupplier<N> reduceRows(Aggregator aggregator) {
        return new MatrixPipeline.RowsReducer(this, aggregator);
    }

    @Override
    default public MatrixStore<N> signum() {
        return this.multiply(PrimitiveMath.ONE / this.norm());
    }

    @Override
    default public Access1D<N> sliceColumn(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countRows() - row;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, col);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, col);
            }
        };
    }

    @Override
    default public Access1D<N> sliceDiagonal(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return Math.min(MatrixStore.this.countRows() - row, MatrixStore.this.countColumns() - col);
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, col + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, col + index);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRange(final long first, final long limit) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return limit - first;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(first + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(first + index);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRow(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countColumns() - col;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row, col + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row, col + index);
            }
        };
    }

    default public MatrixStore<N> subtract(MatrixStore<N> subtrahend) {
        return this.operateOnMatching(this.physical().function().subtract(), subtrahend).get();
    }

    @Override
    default public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.fillMatching(this);
    }

    default public Scalar<N> toScalar(long row, long column) {
        return this.physical().scalar().convert((Number)this.get(row, column));
    }

    @Override
    default public MatrixStore<N> transpose() {
        return new TransposedStore(this);
    }

    @Override
    default public void visitOne(long row, long col, VoidFunction<N> visitor) {
        visitor.invoke(this.get(row, col));
    }

    public static final class LogicalBuilder<N extends Number>
    implements ElementsSupplier<N>,
    Structure2D.Logical<MatrixStore<N>, LogicalBuilder<N>> {
        private MatrixStore<N> myStore;

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildColumn(int minRowDim, MatrixStore<N> ... columnStores) {
            MatrixStore<N> retVal = columnStores[0];
            for (int i = 1; i < columnStores.length; ++i) {
                retVal = new AboveBelowStore<N>(retVal, columnStores[i]);
            }
            int tmpRowDim = (int)retVal.countRows();
            if (tmpRowDim < minRowDim) {
                retVal = new AboveBelowStore<N>(retVal, new ZeroStore(retVal.physical(), minRowDim - tmpRowDim, (int)retVal.countColumns()));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildColumn(PhysicalStore.Factory<N, ?> factory, int minRowDim, N ... columnElements) {
            AboveBelowStore<N> retVal = (AboveBelowStore<N>)factory.columns(new Number[][]{columnElements});
            int tmpRowDim = (int)retVal.countRows();
            if (tmpRowDim < minRowDim) {
                retVal = new AboveBelowStore<N>(retVal, new ZeroStore<N>(factory, minRowDim - tmpRowDim, (int)retVal.countColumns()));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildRow(int minColDim, MatrixStore<N> ... rowStores) {
            MatrixStore<N> retVal = rowStores[0];
            for (int j = 1; j < rowStores.length; ++j) {
                retVal = new LeftRightStore<N>(retVal, rowStores[j]);
            }
            int tmpColDim = (int)retVal.countColumns();
            if (tmpColDim < minColDim) {
                retVal = new LeftRightStore<N>(retVal, new ZeroStore(retVal.physical(), (int)retVal.countRows(), minColDim - tmpColDim));
            }
            return retVal;
        }

        @SafeVarargs
        static <N extends Number> MatrixStore<N> buildRow(PhysicalStore.Factory<N, ?> factory, int minColDim, N ... rowElements) {
            LogicalStore retVal = new TransposedStore((MatrixStore)factory.columns(new Number[][]{rowElements}));
            int tmpColDim = (int)retVal.countColumns();
            if (tmpColDim < minColDim) {
                retVal = new LeftRightStore(retVal, new ZeroStore<N>(factory, (int)retVal.countRows(), minColDim - tmpColDim));
            }
            return retVal;
        }

        private LogicalBuilder() {
            this(null);
            ProgrammingError.throwForIllegalInvocation();
        }

        LogicalBuilder(MatrixStore<N> matrixStore) {
            this.myStore = matrixStore;
        }

        public final LogicalBuilder<N> above(int numberOfRows) {
            ZeroStore tmpUpperStore = new ZeroStore(this.myStore.physical(), numberOfRows, (int)this.myStore.countColumns());
            this.myStore = new AboveBelowStore(tmpUpperStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final LogicalBuilder<N> above(MatrixStore<N> ... upperStore) {
            MatrixStore<N> tmpUpperStore = LogicalBuilder.buildRow((int)this.myStore.countColumns(), upperStore);
            this.myStore = new AboveBelowStore<N>(tmpUpperStore, this.myStore);
            return this;
        }

        @Override
        @SafeVarargs
        public final LogicalBuilder<N> above(N ... elements) {
            MatrixStore tmpUpperStore = LogicalBuilder.buildRow(this.myStore.physical(), (int)((int)this.myStore.countColumns()), elements);
            this.myStore = new AboveBelowStore<N>(tmpUpperStore, this.myStore);
            return this;
        }

        public final LogicalBuilder<N> below(int numberOfRows) {
            ZeroStore tmpLowerStore = new ZeroStore(this.myStore.physical(), numberOfRows, (int)this.myStore.countColumns());
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        @SafeVarargs
        public final LogicalBuilder<N> below(MatrixStore<N> ... lowerStore) {
            MatrixStore<N> tmpLowerStore = LogicalBuilder.buildRow((int)this.myStore.countColumns(), lowerStore);
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        @Override
        @SafeVarargs
        public final LogicalBuilder<N> below(N ... elements) {
            MatrixStore tmpLowerStore = LogicalBuilder.buildRow(this.myStore.physical(), (int)((int)this.myStore.countColumns()), elements);
            this.myStore = new AboveBelowStore<N>(this.myStore, tmpLowerStore);
            return this;
        }

        public final LogicalBuilder<N> bidiagonal(boolean upper, boolean assumeOne) {
            this.myStore = upper ? new UpperTriangularStore<N>(new LowerHessenbergStore<N>(this.myStore), assumeOne) : new LowerTriangularStore<N>(new UpperHessenbergStore<N>(this.myStore), assumeOne);
            return this;
        }

        public final LogicalBuilder<N> column(int ... columns) {
            this.myStore = new ColumnsStore<N>(this.myStore, columns);
            return this;
        }

        public final LogicalBuilder<N> conjugate() {
            this.myStore = this.myStore instanceof ConjugatedStore ? ((ConjugatedStore)this.myStore).getOriginal() : new ConjugatedStore<N>(this.myStore);
            return this;
        }

        public final PhysicalStore<N> copy() {
            return this.myStore.copy();
        }

        @Override
        public final long count() {
            return this.myStore.count();
        }

        @Override
        public final long countColumns() {
            return this.myStore.countColumns();
        }

        @Override
        public final long countRows() {
            return this.myStore.countRows();
        }

        public final LogicalBuilder<N> diagonal() {
            this.myStore = new UpperTriangularStore<N>(new LowerTriangularStore<N>(this.myStore, false), false);
            return this;
        }

        public final LogicalBuilder<N> diagonal(boolean assumeOne) {
            this.myStore = new UpperTriangularStore<N>(new LowerTriangularStore<N>(this.myStore, assumeOne), assumeOne);
            return this;
        }

        @SafeVarargs
        public final LogicalBuilder<N> diagonally(MatrixStore<N> ... diagonally) {
            PhysicalStore.Factory tmpFactory = this.myStore.physical();
            for (int ij = 0; ij < diagonally.length; ++ij) {
                MatrixStore<N> tmpDiagonalStore = diagonally[ij];
                int tmpBaseRowDim = (int)this.myStore.countRows();
                int tmpBaseColDim = (int)this.myStore.countColumns();
                int tmpDiagRowDim = (int)tmpDiagonalStore.countRows();
                int tmpDiagColDim = (int)tmpDiagonalStore.countColumns();
                ZeroStore tmpRightStore = new ZeroStore(tmpFactory, tmpBaseRowDim, tmpDiagColDim);
                LeftRightStore<N> tmpAboveStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
                ZeroStore tmpLeftStore = new ZeroStore(tmpFactory, tmpDiagRowDim, tmpBaseColDim);
                LeftRightStore tmpBelowStore = new LeftRightStore(tmpLeftStore, tmpDiagonalStore);
                this.myStore = new AboveBelowStore<N>(tmpAboveStore, tmpBelowStore);
            }
            return this;
        }

        @Override
        public final MatrixStore<N> get() {
            return this.myStore;
        }

        public final LogicalBuilder<N> hermitian(boolean upper) {
            this.myStore = upper ? new UpperHermitianStore<N>(this.myStore) : new LowerHermitianStore<N>(this.myStore);
            return this;
        }

        public final LogicalBuilder<N> hessenberg(boolean upper) {
            this.myStore = upper ? new UpperHessenbergStore<N>(this.myStore) : new LowerHessenbergStore<N>(this.myStore);
            return this;
        }

        public final LogicalBuilder<N> left(int numberOfColumns) {
            ZeroStore tmpLeftStore = new ZeroStore(this.myStore.physical(), (int)this.myStore.countRows(), numberOfColumns);
            this.myStore = new LeftRightStore(tmpLeftStore, this.myStore);
            return this;
        }

        @SafeVarargs
        public final LogicalBuilder<N> left(MatrixStore<N> ... left) {
            MatrixStore<N> tmpLeftStore = LogicalBuilder.buildColumn((int)this.myStore.countRows(), left);
            this.myStore = new LeftRightStore<N>(tmpLeftStore, this.myStore);
            return this;
        }

        @Override
        @SafeVarargs
        public final LogicalBuilder<N> left(N ... elements) {
            MatrixStore tmpLeftStore = LogicalBuilder.buildColumn(this.myStore.physical(), (int)((int)this.myStore.countRows()), elements);
            this.myStore = new LeftRightStore<N>(tmpLeftStore, this.myStore);
            return this;
        }

        public final LogicalBuilder<N> limits(int rowLimit, int columnLimit) {
            this.myStore = new LimitStore<N>(rowLimit < 0 ? (int)this.myStore.countRows() : rowLimit, columnLimit < 0 ? (int)this.myStore.countColumns() : columnLimit, this.myStore);
            return this;
        }

        public final LogicalBuilder<N> offsets(int rowOffset, int columnOffset) {
            this.myStore = new OffsetStore<N>(this.myStore, rowOffset < 0 ? 0 : rowOffset, columnOffset < 0 ? 0 : columnOffset);
            return this;
        }

        @Override
        public final PhysicalStore.Factory<N, ?> physical() {
            return this.myStore.physical();
        }

        public final LogicalBuilder<N> right(int numberOfColumns) {
            ZeroStore tmpRightStore = new ZeroStore(this.myStore.physical(), (int)this.myStore.countRows(), numberOfColumns);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        @SafeVarargs
        public final LogicalBuilder<N> right(MatrixStore<N> ... right) {
            MatrixStore<N> tmpRightStore = LogicalBuilder.buildColumn((int)this.myStore.countRows(), right);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        @Override
        @SafeVarargs
        public final LogicalBuilder<N> right(N ... elements) {
            MatrixStore tmpRightStore = LogicalBuilder.buildColumn(this.myStore.physical(), (int)((int)this.myStore.countRows()), elements);
            this.myStore = new LeftRightStore<N>(this.myStore, tmpRightStore);
            return this;
        }

        public final LogicalBuilder<N> row(int ... rows) {
            this.myStore = new RowsStore<N>(this.myStore, rows);
            return this;
        }

        public final LogicalBuilder<N> superimpose(int row, int col, MatrixStore<N> matrix) {
            this.myStore = new SuperimposedStore<N>(this.myStore, row, col, matrix);
            return this;
        }

        public final LogicalBuilder<N> superimpose(int row, int col, Number matrix) {
            this.myStore = new SuperimposedStore<N>(this.myStore, row, col, new SingleStore(this.myStore.physical(), matrix));
            return this;
        }

        public final LogicalBuilder<N> superimpose(MatrixStore<N> matrix) {
            this.myStore = new SuperimposedStore<N>(this.myStore, 0, 0, matrix);
            return this;
        }

        @Override
        public final void supplyTo(ElementsConsumer<N> receiver) {
            if (!receiver.isAcceptable(this)) {
                throw new ProgrammingError("Not acceptable!");
            }
            receiver.accept((Access2D<?>)this.get());
        }

        public String toString() {
            return this.myStore.toString();
        }

        @Override
        public final LogicalBuilder<N> transpose() {
            this.myStore = this.myStore instanceof TransposedStore ? ((TransposedStore)this.myStore).getOriginal() : new TransposedStore<N>(this.myStore);
            return this;
        }

        public final LogicalBuilder<N> triangular(boolean upper, boolean assumeOne) {
            this.myStore = upper ? new UpperTriangularStore<N>(this.myStore, assumeOne) : new LowerTriangularStore<N>(this.myStore, assumeOne);
            return this;
        }

        public final LogicalBuilder<N> tridiagonal() {
            this.myStore = new UpperHessenbergStore<N>(new LowerHessenbergStore<N>(this.myStore));
            return this;
        }
    }

    public static interface Factory<N extends Number> {
        public LogicalBuilder<N> makeIdentity(int var1);

        public LogicalBuilder<N> makeSingle(N var1);

        public LogicalBuilder<N> makeWrapper(Access2D<?> var1);

        public LogicalBuilder<N> makeZero(int var1, int var2);
    }
}

