/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.MatrixStore;

abstract class ShadingStore<N extends Number>
extends LogicalStore<N> {
    protected ShadingStore(MatrixStore<N> base, int rowsCount, int columnsCount) {
        super(base, rowsCount, columnsCount);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.reset();
        int tmpColDim = this.getColDim();
        if (this.isPrimitive()) {
            for (int j = 0; j < tmpColDim; ++j) {
                int tmpFirst = this.firstInColumn(j);
                int tmpLimit = this.limitOfColumn(j);
                for (int i = tmpFirst; i < tmpLimit; ++i) {
                    consumer.set((long)i, (long)j, this.doubleValue(i, j));
                }
            }
        } else {
            for (int j = 0; j < tmpColDim; ++j) {
                int tmpFirst = this.firstInColumn(j);
                int tmpLimit = this.limitOfColumn(j);
                for (int i = tmpFirst; i < tmpLimit; ++i) {
                    consumer.fillOne((long)i, (long)j, this.get(i, j));
                }
            }
        }
    }
}

