/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.Scalar;

public final class HouseholderRight
extends MatrixOperation {
    public static final HouseholderRight SETUP = new HouseholderRight();
    public static int THRESHOLD = 512;

    public static void invoke(double[] data, int structure, int firstRow, int rowLimit, int numberOfColumns, Householder.Primitive householder, double[] work) {
        int j;
        double[] vector = householder.vector;
        int firstNonZero = householder.first;
        double beta = householder.beta;
        for (j = firstNonZero; j < numberOfColumns; ++j) {
            AXPY.invoke(work, 0, beta * vector[j], data, j * structure, firstRow, rowLimit);
        }
        for (j = firstNonZero; j < numberOfColumns; ++j) {
            AXPY.invoke(data, j * structure, -vector[j], work, 0, firstRow, rowLimit);
        }
    }

    public static <N extends Number> void invoke(N[] data, int first, int limit, int tmpColDim, Householder.Generic<N> householder, Scalar.Factory<N> scalar) {
        N[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        Object tmpBeta = householder.beta;
        int tmpRowDim = data.length / tmpColDim;
        for (int i = first; i < limit; ++i) {
            int j;
            Scalar tmpScale = scalar.zero();
            int tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                tmpScale = tmpScale.add(((Scalar)((VectorSpace)tmpHouseholderVector[j]).conjugate()).multiply((Scalar)((VectorSpace)data[tmpIndex]).conjugate()));
                tmpIndex += tmpRowDim;
            }
            tmpScale = (Scalar)tmpScale.multiply(tmpBeta);
            tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                data[tmpIndex] = ((Scalar)((Scalar)((VectorSpace)data[tmpIndex]).conjugate()).subtract((Scalar)tmpScale.multiply(tmpHouseholderVector[j])).conjugate()).get();
                tmpIndex += tmpRowDim;
            }
        }
    }

    private static void invoke2old(double[] data, int first, int limit, int tmpColDim, Householder.Primitive householder) {
        double[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        double tmpBeta = householder.beta;
        int tmpRowDim = data.length / tmpColDim;
        for (int i = first; i < limit; ++i) {
            int j;
            double tmpScale = PrimitiveMath.ZERO;
            int tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                tmpScale += tmpHouseholderVector[j] * data[tmpIndex];
                tmpIndex += tmpRowDim;
            }
            tmpScale *= tmpBeta;
            tmpIndex = i + tmpFirstNonZero * tmpRowDim;
            for (j = tmpFirstNonZero; j < tmpColDim; ++j) {
                int n = tmpIndex;
                data[n] = data[n] - tmpScale * tmpHouseholderVector[j];
                tmpIndex += tmpRowDim;
            }
        }
    }

    private HouseholderRight() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

