# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty
from retro_data_structures.properties.corruption.archetypes.WeaponVulnerability import WeaponVulnerability


@dataclasses.dataclass()
class DamageVulnerability(BaseProperty):
    power: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    plasma: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    nova: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    power_charge: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    plasma_charge: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    nova_charge: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon_charge: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    missile: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    ice_missile: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon_missile: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    bomb: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    grapple_upgrade: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon_grapple: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    boost_ball: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon_ball: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    screw_attack: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    poison_water: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    ai: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    friendly_ai: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    weapon_vulnerability: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    electrical: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)

    @classmethod
    def game(cls) -> Game:
        return Game.CORRUPTION

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_count = struct.unpack(">H", data.read(2))[0]
        present_fields = default_override or {}
        for _ in range(property_count):
            property_id, property_size = struct.unpack(">LH", data.read(6))
            start = data.tell()
            try:
                property_name, decoder = _property_decoder[property_id]
                present_fields[property_name] = decoder(data, property_size)
            except KeyError:
                data.read(property_size)  # skip unknown property
            assert data.tell() - start == property_size

        return cls(**present_fields)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        data.write(b'\x00\x16')  # 22 properties

        data.write(b'\xac\x8b\xb2\xa7')  # 0xac8bb2a7
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.power.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xe4F\xa4\xfc')  # 0xe446a4fc
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.plasma.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xd2\xea%\xa6')  # 0xd2ea25a6
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.nova.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xbbp\t?')  # 0xbb70093f
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xa4B\xb4\xa3')  # 0xa442b4a3
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.power_charge.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xd7\x05\xc4\x16')  # 0xd705c416
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.plasma_charge.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xd1\xcdI:')  # 0xd1cd493a
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.nova_charge.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'zn=\xdb')  # 0x7a6e3ddb
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon_charge.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x00\xef\xe8\xcb')  # 0xefe8cb
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.missile.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'W\xa4\xdf\xf2')  # 0x57a4dff2
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.ice_missile.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x18Z\x88\xad')  # 0x185a88ad
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon_missile.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'h\xae\x13\xa0')  # 0x68ae13a0
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.bomb.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'9DK\xdd')  # 0x39444bdd
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.grapple_upgrade.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xce\xe1nz')  # 0xcee16e7a
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon_grapple.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xd9\x9c\x04\x00')  # 0xd99c0400
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.boost_ball.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'xF%\xbd')  # 0x784625bd
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon_ball.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x86o\x91\xbf')  # 0x866f91bf
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.screw_attack.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'P\xdd\xe8\x91')  # 0x50dde891
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.poison_water.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xbf\xac"\x9f')  # 0xbfac229f
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.ai.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xdaB*\xe5')  # 0xda422ae5
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.friendly_ai.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x89\xd2]\xf4')  # 0x89d25df4
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.weapon_vulnerability.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xc2\xbe\xb2)')  # 0xc2beb229
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.electrical.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            power=WeaponVulnerability.from_json(data['power']),
            plasma=WeaponVulnerability.from_json(data['plasma']),
            nova=WeaponVulnerability.from_json(data['nova']),
            phazon=WeaponVulnerability.from_json(data['phazon']),
            power_charge=WeaponVulnerability.from_json(data['power_charge']),
            plasma_charge=WeaponVulnerability.from_json(data['plasma_charge']),
            nova_charge=WeaponVulnerability.from_json(data['nova_charge']),
            phazon_charge=WeaponVulnerability.from_json(data['phazon_charge']),
            missile=WeaponVulnerability.from_json(data['missile']),
            ice_missile=WeaponVulnerability.from_json(data['ice_missile']),
            phazon_missile=WeaponVulnerability.from_json(data['phazon_missile']),
            bomb=WeaponVulnerability.from_json(data['bomb']),
            grapple_upgrade=WeaponVulnerability.from_json(data['grapple_upgrade']),
            phazon_grapple=WeaponVulnerability.from_json(data['phazon_grapple']),
            boost_ball=WeaponVulnerability.from_json(data['boost_ball']),
            phazon_ball=WeaponVulnerability.from_json(data['phazon_ball']),
            screw_attack=WeaponVulnerability.from_json(data['screw_attack']),
            poison_water=WeaponVulnerability.from_json(data['poison_water']),
            ai=WeaponVulnerability.from_json(data['ai']),
            friendly_ai=WeaponVulnerability.from_json(data['friendly_ai']),
            weapon_vulnerability=WeaponVulnerability.from_json(data['weapon_vulnerability']),
            electrical=WeaponVulnerability.from_json(data['electrical']),
        )

    def to_json(self) -> dict:
        return {
            'power': self.power.to_json(),
            'plasma': self.plasma.to_json(),
            'nova': self.nova.to_json(),
            'phazon': self.phazon.to_json(),
            'power_charge': self.power_charge.to_json(),
            'plasma_charge': self.plasma_charge.to_json(),
            'nova_charge': self.nova_charge.to_json(),
            'phazon_charge': self.phazon_charge.to_json(),
            'missile': self.missile.to_json(),
            'ice_missile': self.ice_missile.to_json(),
            'phazon_missile': self.phazon_missile.to_json(),
            'bomb': self.bomb.to_json(),
            'grapple_upgrade': self.grapple_upgrade.to_json(),
            'phazon_grapple': self.phazon_grapple.to_json(),
            'boost_ball': self.boost_ball.to_json(),
            'phazon_ball': self.phazon_ball.to_json(),
            'screw_attack': self.screw_attack.to_json(),
            'poison_water': self.poison_water.to_json(),
            'ai': self.ai.to_json(),
            'friendly_ai': self.friendly_ai.to_json(),
            'weapon_vulnerability': self.weapon_vulnerability.to_json(),
            'electrical': self.electrical.to_json(),
        }


def _decode_power(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_plasma(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_nova(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_power_charge(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_plasma_charge(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_nova_charge(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon_charge(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_missile(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_ice_missile(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon_missile(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_bomb(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_grapple_upgrade(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon_grapple(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_boost_ball(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon_ball(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_screw_attack(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_poison_water(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_ai(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_friendly_ai(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_weapon_vulnerability(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_electrical(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


_property_decoder: typing.Dict[int, typing.Tuple[str, typing.Callable[[typing.BinaryIO, int], typing.Any]]] = {
    0xac8bb2a7: ('power', _decode_power),
    0xe446a4fc: ('plasma', _decode_plasma),
    0xd2ea25a6: ('nova', _decode_nova),
    0xbb70093f: ('phazon', _decode_phazon),
    0xa442b4a3: ('power_charge', _decode_power_charge),
    0xd705c416: ('plasma_charge', _decode_plasma_charge),
    0xd1cd493a: ('nova_charge', _decode_nova_charge),
    0x7a6e3ddb: ('phazon_charge', _decode_phazon_charge),
    0xefe8cb: ('missile', _decode_missile),
    0x57a4dff2: ('ice_missile', _decode_ice_missile),
    0x185a88ad: ('phazon_missile', _decode_phazon_missile),
    0x68ae13a0: ('bomb', _decode_bomb),
    0x39444bdd: ('grapple_upgrade', _decode_grapple_upgrade),
    0xcee16e7a: ('phazon_grapple', _decode_phazon_grapple),
    0xd99c0400: ('boost_ball', _decode_boost_ball),
    0x784625bd: ('phazon_ball', _decode_phazon_ball),
    0x866f91bf: ('screw_attack', _decode_screw_attack),
    0x50dde891: ('poison_water', _decode_poison_water),
    0xbfac229f: ('ai', _decode_ai),
    0xda422ae5: ('friendly_ai', _decode_friendly_ai),
    0x89d25df4: ('weapon_vulnerability', _decode_weapon_vulnerability),
    0xc2beb229: ('electrical', _decode_electrical),
}
