# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty


@dataclasses.dataclass()
class WeaponVulnerability(BaseProperty):
    damage_multiplier: float = dataclasses.field(default=100.0)
    effect: int = dataclasses.field(default=0)  # Choice
    ignore_radius: bool = dataclasses.field(default=False)

    @classmethod
    def game(cls) -> Game:
        return Game.CORRUPTION

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_count = struct.unpack(">H", data.read(2))[0]
        if default_override is None and (result := _fast_decode(data, property_count)) is not None:
            return result

        present_fields = default_override or {}
        for _ in range(property_count):
            property_id, property_size = struct.unpack(">LH", data.read(6))
            start = data.tell()
            try:
                property_name, decoder = _property_decoder[property_id]
                present_fields[property_name] = decoder(data, property_size)
            except KeyError:
                data.read(property_size)  # skip unknown property
            assert data.tell() - start == property_size

        return cls(**present_fields)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        data.write(b'\x00\x03')  # 3 properties

        data.write(b'\x85-8q')  # 0x852d3871
        data.write(b'\x00\x04')  # size
        data.write(struct.pack('>f', self.damage_multiplier))

        data.write(b'h\xac\xbd\x86')  # 0x68acbd86
        data.write(b'\x00\x04')  # size
        data.write(struct.pack(">L", self.effect))

        data.write(b'\x93g}\xa2')  # 0x93677da2
        data.write(b'\x00\x01')  # size
        data.write(struct.pack('>?', self.ignore_radius))

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            damage_multiplier=data['damage_multiplier'],
            effect=data['effect'],
            ignore_radius=data['ignore_radius'],
        )

    def to_json(self) -> dict:
        return {
            'damage_multiplier': self.damage_multiplier,
            'effect': self.effect,
            'ignore_radius': self.ignore_radius,
        }


_FAST_FORMAT = None
_FAST_IDS = (0x852d3871, 0x68acbd86, 0x93677da2)


def _fast_decode(data: typing.BinaryIO, property_count: int) -> typing.Optional[WeaponVulnerability]:
    if property_count != 3:
        return None

    global _FAST_FORMAT
    if _FAST_FORMAT is None:
        _FAST_FORMAT = struct.Struct('>LHfLHLLH?')

    dec = _FAST_FORMAT.unpack(data.read(27))
    if (dec[0], dec[3], dec[6]) != _FAST_IDS:
        return None

    return WeaponVulnerability(
        dec[2],
        dec[5],
        dec[8],
    )


def _decode_damage_multiplier(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>f', data.read(4))[0]


def _decode_effect(data: typing.BinaryIO, property_size: int):
    return struct.unpack(">L", data.read(4))[0]


def _decode_ignore_radius(data: typing.BinaryIO, property_size: int):
    return struct.unpack('>?', data.read(1))[0]


_property_decoder: typing.Dict[int, typing.Tuple[str, typing.Callable[[typing.BinaryIO, int], typing.Any]]] = {
    0x852d3871: ('damage_multiplier', _decode_damage_multiplier),
    0x68acbd86: ('effect', _decode_effect),
    0x93677da2: ('ignore_radius', _decode_ignore_radius),
}
