# Generated File
import functools
import importlib
import typing

from retro_data_structures.properties.base_property import BaseObjectType

_FOUR_CC_MAPPING = {
    'ACHI': 'Achievement',
    'ACKF': 'ActorKeyframe',
    'ACTR': 'Actor',
    'ADMG': 'AreaDamage',
    'AIFZ': 'AIFuse',
    'AIHT': 'AIHint',
    'AIKF': 'AIKeyframe',
    'AITP': 'AITaskPoint',
    'AIWP': 'AIWaypoint',
    'ALRM': 'AlarmController',
    'AMIA': 'AmbientAI',
    'AMOR': 'ActorMorph',
    'AOCL': 'AudioOccluder',
    'ASAS': 'AreaStreamedAudioState',
    'ATMA': 'AtomicAlpha',
    'ATRN': 'ActorTransform',
    'AUR1': 'AuroraUnit1',
    'AUR2': 'AuroraUnit2',
    'AVIS': 'AVIS',
    'AVMC': 'AVMC',
    'BALS': 'SpiderBallAttractionSurface',
    'BALT': 'BallTrigger',
    'BALW': 'SpiderBallWaypoint',
    'BEAM': 'Beam',
    'BLUR': 'CameraBlurKeyframe',
    'BLWF': 'BlinkWolf',
    'BOS3': 'SeedBoss3',
    'BSKR': 'Berserker',
    'BSTR': 'BeastRider',
    'CABL': 'Cable',
    'CABP': 'ContextActionButtonPressing',
    'CACL': 'ContextActionCombinationLock',
    'CAIF': 'ContextActionImageFocus',
    'CAMH': 'CameraHint',
    'CAMP': 'CameraPitch',
    'CAMS': 'CameraShaker',
    'CANB': 'CannonBall',
    'CAWL': 'ContextActionWelding',
    'CINE': 'CinematicCamera',
    'CLRM': 'ColorModulate',
    'CMBT': 'CombatTrooper',
    'CNTA': 'ControllerAction',
    'CNTR': 'Counter',
    'COVR': 'CoverPoint',
    'CRAR': 'CrossAreaRelay',
    'CRLY': 'ConditionalRelay',
    'CSAC': 'ContextSensitiveAction',
    'CSAT': 'ContextSensitiveActivator',
    'CTLH': 'ControlHint',
    'DEBR': 'Debris',
    'DEFM': 'DefenseMechanoid',
    'DFOG': 'DistanceFog',
    'DGMN': 'DialogueMenu',
    'DKSE': 'DarkSamusEcho',
    'DLHT': 'DynamicLight',
    'DMGA': 'DamageActor',
    'DOCK': 'Dock',
    'DOOR': 'Door',
    'DRKS': 'DarkSamus',
    'DTRG': 'DamageableTrigger',
    'DTRO': 'DamageableTriggerOrientated',
    'EFCT': 'Effect',
    'EFTR': 'EffectRepulsor',
    'EMPU': 'ElectroMagneticPulse',
    'EYEP': 'EyePod',
    'FGHS': 'FargullHatcherSwarm',
    'FGHT': 'FargullHatcher',
    'FILT': 'CameraFilterKeyframe',
    'FISH': 'FishCloud',
    'FLAR': 'VisorFlare',
    'FLPS': 'FalsePerspective',
    'FLYP': 'FlyingPirate',
    'FOGO': 'FogOverlay',
    'FOGV': 'FogVolume',
    'FRND': 'Friendly',
    'FSHM': 'FishCloudModifier',
    'FSWM': 'FlyerSwarm',
    'FXDC': 'EnvFxDensityController',
    'GAND': 'Gandrayda',
    'GENR': 'Generator',
    'GHOR': 'GhorLowerBody',
    'GHRU': 'GhorUpperBody',
    'GMNU': 'GuiMenu',
    'GNTB': 'GunTurretBase',
    'GNTT': 'GunTurretTop',
    'GOBD': 'GeneratedObjectDeleter',
    'GRAP': 'GrapplePoint',
    'GRFL': 'GragnolFlyer',
    'GSAC': 'GellSac',
    'GSCR': 'GuiScreen',
    'GSLD': 'GuiSlider',
    'GWIG': 'GuiWidget',
    'HHNT': 'HUDHint',
    'HINT': 'PlayerHint',
    'IFTC': 'IFT',
    'KRAK': 'Korakk',
    'KRBA': 'KorbaSnatcherSwarm',
    'KRBM': 'KorbaMaw',
    'LODC': 'LODController',
    'LUAX': 'LUAScript',
    'LVOL': 'LightVolume',
    'MEMO': 'HUDMemo',
    'MHAT': 'MetroidHatcher',
    'MHOP': 'MetroidHopper',
    'MIIA': 'MiiAccessory',
    'MINI': 'MinorIng',
    'MMDL': 'MultiModelActor',
    'MOVI': 'StreamedMovie',
    'MPHZ': 'MetroidPhazeoid',
    'MREE': 'Metaree',
    'MRLY': 'MemoryRelay',
    'MYSF': 'MysteryFlyer',
    'NBAR': 'Nightbarb',
    'NOTU': 'NoseTurret',
    'OPAA': 'OptionalAreaAsset',
    'PARA': 'Parasite',
    'PCKP': 'Pickup',
    'PCTL': 'PathControl',
    'PDBR': 'PhysicsDebris',
    'PDRN': 'PirateDrone',
    'PGVS': 'PlayerGravityScalar',
    'PHHR': 'PhazonHarvester',
    'PHPF': 'PhazonPuffer',
    'PHZD': 'Phaazoid',
    'PHZS': 'PhazonFlyerSwarm',
    'PILL': 'PillBug',
    'PIRT': 'SpacePirate',
    'PLAC': 'PlayerActor',
    'PLAT': 'Platform',
    'PLCH': 'PhazonLeech',
    'PLPX': 'PlayerProxy',
    'PMCT': 'PathMeshCtrl',
    'POIN': 'PointOfInterest',
    'PPDL': 'PhazonPuddle',
    'PSSM': 'PlantScarabSwarm',
    'PTNT': 'PhazonTentacle',
    'PUAP': 'PlayerUserAnimPoint',
    'PUFR': 'Puffer',
    'RADD': 'RadialDamage',
    'REAA': 'AreaAttributes',
    'REPH': 'ReptilicusHunter',
    'REPL': 'Repulsor',
    'RID1': 'Ridley1',
    'RIPL': 'Ripple',
    'RMAC': 'RoomAcoustics',
    'RRLY': 'RandomRelay',
    'RSPL': 'RSPL',
    'RUMB': 'RumbleEffect',
    'RUND': 'Rundas',
    'SAMD': 'StreamedAudioModifier',
    'SAMF': 'SamusForm',
    'SB2G': 'SeedBoss2GiantForm',
    'SB2P': 'SeedBoss2PrimeBot',
    'SB2X': 'SeedBoss2BotSwarm',
    'SBEM': 'ScanBeam',
    'SBMI': 'SkyboxModInca',
    'SBO1': 'SeedBoss1Orb',
    'SCIC': 'ScanIncoming',
    'SCTL': 'SurfaceControl',
    'SDB1': 'SeedBoss1',
    'SDRN': 'SteamDrone',
    'SHBG': 'ShellBug',
    'SHBR': 'ShipBombingRun',
    'SHCI': 'ShipCommandIcon',
    'SHCP': 'ShipCommandPath',
    'SHDW': 'ShadowProjector',
    'SHHC': 'ShipHudControl',
    'SHIP': 'Ship',
    'SHPX': 'ShipProxy',
    'SKRP': 'SkyRipple',
    'SLCT': 'ScriptLayerController',
    'SNAG': 'SnagVineHelper',
    'SNDM': 'SoundModifier',
    'SOND': 'Sound',
    'SPDC': 'ShipDecalController',
    'SPFN': 'SpecialFunction',
    'SPIN': 'Spinner',
    'SPRL': 'PositionRelay',
    'SPRT': 'Sprite',
    'SPWN': 'SpawnPoint',
    'SQTR': 'SequenceTimer',
    'SRLY': 'Relay',
    'STAU': 'StreamedAudio',
    'STEM': 'Steam',
    'STMB': 'SteamBot',
    'STML': 'SteamLord',
    'SUBT': 'Subtitles',
    'SWBT': 'SwarmBot',
    'SWJT': 'ScrewAttackWallJumpTarget',
    'SWRM': 'WallCrawlerSwarm',
    'SWTC': 'Switch',
    'TEL1': 'WorldTeleporter',
    'TGPT': 'TargetingPoint',
    'TIMR': 'Timer',
    'TKEY': 'TimeKeyframe',
    'TMAI': 'TeamAI',
    'TRGR': 'Trigger',
    'TXPN': 'TextPane',
    'VGOO': 'VisorGoo',
    'VOLG': 'VolGroup',
    'WATR': 'Water',
    'WAYP': 'Waypoint',
    'WEED': 'VenomWeed',
    'WLDA': 'WorldAttributes',
    'WLIT': 'WorldLightFader',
    'WPNG': 'WeaponGenerator',
    'WTAT': 'WorldTeleporterAttributes',
    'WTCR': 'WorldTransitionChoiceRelay',
}


@functools.lru_cache(maxsize=None)
def get_object(four_cc: str) -> typing.Type[BaseObjectType]:
    stem = _FOUR_CC_MAPPING[four_cc]
    module = importlib.import_module(f"retro_data_structures.properties.corruption.objects.{stem}")
    return getattr(module, stem)
