# Generated File
import functools
import importlib
import typing

from retro_data_structures.properties.base_property import BaseObjectType

_FOUR_CC_MAPPING = {
    'AAGM': 'ActorAnimGridModifier',
    'ACKF': 'ActorKeyframe',
    'ACOU': 'Acoustics',
    'ACTR': 'Actor',
    'ADMG': 'AreaDamage',
    'AIHT': 'AIHint',
    'AIKF': 'AIKeyframe',
    'AIWP': 'AIWaypoint',
    'AMKF': 'ActorMultiKeyFrame',
    'AOCL': 'AudioOccluder',
    'ARNO': 'AreaNode',
    'ARPA': 'AreaPath',
    'ASAS': 'AreaStreamedAudioState',
    'ATRN': 'ActorTransform',
    'AVIS': 'AVIS',
    'BABL': 'BarrelBalloon',
    'BARL': 'BarrelCannon',
    'BIRD': 'BirdBoss',
    'BLME': 'BloomEffect',
    'BLMV': 'BloomVolume',
    'BLUR': 'CameraBlurKeyframe',
    'BONU': 'BonusRoom',
    'BTYR': 'BouncyTire',
    'BUHA': 'BeatUpHandler',
    'CABL': 'Cable',
    'CAMH': 'CameraHint',
    'CAMS': 'CameraShaker',
    'CART': 'MineCart',
    'CINE': 'CinematicCamera',
    'CKPT': 'Checkpoint',
    'CLPC': 'ClingPathControl',
    'CLRM': 'ColorModulate',
    'CMAN': 'CameraManager',
    'CMGR': 'PirateCrabManager',
    'CMOD': 'CameraModifier',
    'CNTA': 'ControllerAction',
    'CNTR': 'Counter',
    'CRAB': 'PirateCrab',
    'CRED': 'CreditsScreen',
    'CRLY': 'ConditionalRelay',
    'CSGO': 'GameOverDisplay',
    'CSTI': 'CustomInterpolation',
    'DEBR': 'Debris',
    'DFOG': 'DistanceFog',
    'DLHT': 'DynamicLight',
    'DMGA': 'DamageArea',
    'DMGE': 'DamageEffect',
    'DOFT': 'DepthOfFieldTuner',
    'DTRG': 'DamageableTrigger',
    'DTRO': 'DamageableTriggerOrientated',
    'EFCT': 'Effect',
    'EOLD': 'EOLDisplay',
    'FILT': 'CameraFilterKeyframe',
    'FLPS': 'FalsePerspective',
    'FOBS': 'ForestBoss',
    'FOGO': 'FogOverlay',
    'FOGV': 'FogVolume',
    'FSWC': 'FactorySwitch',
    'FXDC': 'EnvFxDensityController',
    'GCGP': 'GenericCreatureGroup',
    'GCTR': 'GenericCreature',
    'GENR': 'Generator',
    'GMGR': 'GameManager',
    'GMNU': 'GuiMenu',
    'GOBD': 'GeneratedObjectDeleter',
    'GPDT': 'GroundPoundDetector',
    'GPTR': 'GPTR',
    'GSLD': 'GuiSlider',
    'GUCH': 'GuiCharacter',
    'GWIG': 'GuiWidget',
    'HINT': 'PlayerActionHint',
    'HUDD': 'HUD',
    'HUDP': 'HUDProxy',
    'IHUD': 'IslandHUD',
    'ISAR': 'IslandArea',
    'JB01': 'JungleBoss1',
    'KNGP': 'KongProxy',
    'KONG': 'Kong',
    'LODC': 'LODController',
    'LVLD': 'LevelDarkener',
    'LVOL': 'LightVolume',
    'MEAT': 'MEAT',
    'MMDL': 'MultiModelActor',
    'MNPL': 'MotionPlatform',
    'MOLC': 'MoleCart',
    'MOLE': 'Mole',
    'MOLM': 'MoleTrainManager',
    'MOVI': 'StreamedMovie',
    'MPSR': 'MultiplayerSyncRelay',
    'MRLY': 'MemoryRelay',
    'MUMA': 'MusicMaster',
    'MUTR': 'MusicTrack',
    'OBRG': 'OceanBridge',
    'OPAA': 'OptionalAreaAsset',
    'PCHK': 'PilotChicken',
    'PCKP': 'Pickup',
    'PCTL': 'PathControl',
    'PLAC': 'PlayerActor',
    'PLAT': 'Platform',
    'PNUT': 'Peanut',
    'POIO': 'PoiObject',
    'PRLA': 'ProbabilityRelay',
    'PROJ': 'Projectile',
    'PRSP': 'PlayerRespawn',
    'PTOK': 'PlayerToken',
    'RACR': 'RambiCrate',
    'RADD': 'RadialDamage',
    'RBRL': 'RocketBarrel',
    'RCHK': 'RobotChicken',
    'RCKF': 'RobotChickenFlyer',
    'RCTL': 'ReviewControl',
    'REAA': 'AreaAttributes',
    'REAC': 'ReactiveActor',
    'RMBI': 'Rambi',
    'ROPE': 'SwingRope',
    'RRLY': 'RelayRandom',
    'RSBL': 'RespawnBalloon',
    'RSCL': 'ReactiveScale',
    'RTNM': 'Retronome',
    'RUMB': 'RumbleEffect',
    'SAMD': 'MusicModifier',
    'SBMI': 'SkyboxModInca',
    'SCTL': 'SurfaceControl',
    'SHDW': 'ShadowProjector',
    'SLCT': 'ScriptLayerController',
    'SNDM': 'SoundModifier',
    'SNMD': 'SoundModifierData',
    'SOND': 'Sound',
    'SPFN': 'SpecialFunction',
    'SPIN': 'Spinner',
    'SPNW': 'SplinePathNetwork',
    'SPPA': 'SplinePath',
    'SPRL': 'PositionRelay',
    'SPWN': 'SpawnPoint',
    'SQTR': 'SequenceTimer',
    'SRLY': 'Relay',
    'STAU': 'StreamedAudio',
    'SUBT': 'Subtitles',
    'SUSP': 'SuspensionBridge',
    'SVOL': 'SplineModifierVolume',
    'SWKP': 'SquawkProxy',
    'SWTC': 'Switch',
    'TARP': 'TarPit',
    'TEOL': 'TimeAttackEOLDisplay',
    'TIDE': 'TidalWave',
    'TIMR': 'Timer',
    'TIPI': 'TippyPlatform',
    'TKEY': 'TimeKeyframe',
    'TMGR': 'TrainTrackManager',
    'TPND': 'TPND',
    'TRGR': 'Trigger',
    'TRSC': 'TransitionScreen',
    'TSEQ': 'TrainSequence',
    'TUTR': 'Tutorial',
    'TXPN': 'TextPane',
    'VBPT': 'VolcanoBossBodyPart',
    'VOLG': 'VolumeGroup',
    'VRBR': 'VerticalRocketBarrel',
    'WAVE': 'OceanWave',
    'WAYP': 'Waypoint',
    'WLDA': 'WorldAttributes',
    'WLIT': 'WorldLightFader',
}


@functools.lru_cache(maxsize=None)
def get_object(four_cc: str) -> typing.Type[BaseObjectType]:
    stem = _FOUR_CC_MAPPING[four_cc]
    module = importlib.import_module(f"retro_data_structures.properties.dkc_returns.objects.{stem}")
    return getattr(module, stem)
