# Generated File
import dataclasses
import struct
import typing

from retro_data_structures.game_check import Game
from retro_data_structures.properties.base_property import BaseProperty
from retro_data_structures.properties.echoes.archetypes.WeaponVulnerability import WeaponVulnerability


@dataclasses.dataclass()
class DamageVulnerability(BaseProperty):
    power: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    dark: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    light: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    annihilator: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    boost_ball: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    cannon_ball: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    screw_attack: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    bomb: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    power_bomb: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    missile: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    phazon: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    ai: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    poison_water: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    dark_water: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    lava: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    area_damage_hot: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    area_damage_cold: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    area_damage_dark: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    area_damage_light: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    power_charge: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    entangler: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    light_blast: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    sonic_boom: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    super_missle: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    black_hole: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    sunburst: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    imploder: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    weapon_vulnerability: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)
    normal_safe_zone: WeaponVulnerability = dataclasses.field(default_factory=WeaponVulnerability)

    @classmethod
    def game(cls) -> Game:
        return Game.ECHOES

    @classmethod
    def from_stream(cls, data: typing.BinaryIO, size: typing.Optional[int] = None, default_override: typing.Optional[dict] = None):
        property_count = struct.unpack(">H", data.read(2))[0]
        present_fields = default_override or {}
        for _ in range(property_count):
            property_id, property_size = struct.unpack(">LH", data.read(6))
            start = data.tell()
            try:
                property_name, decoder = _property_decoder[property_id]
                present_fields[property_name] = decoder(data, property_size)
            except KeyError:
                data.read(property_size)  # skip unknown property
            assert data.tell() - start == property_size

        return cls(**present_fields)

    def to_stream(self, data: typing.BinaryIO, default_override: typing.Optional[dict] = None):
        default_override = default_override or {}
        data.write(b'\x00\x1d')  # 29 properties

        data.write(b'\xac\x8b\xb2\xa7')  # 0xac8bb2a7
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.power.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xb1\x9bml')  # 0xb19b6d6c
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.dark.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x00$D\xc6')  # 0x2444c6
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.light.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xe6\xba\xcd\xe5')  # 0xe6bacde5
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.annihilator.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xd9\x9c\x04\x00')  # 0xd99c0400
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.boost_ball.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xc7\r\x8b\x8b')  # 0xc70d8b8b
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.cannon_ball.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x86o\x91\xbf')  # 0x866f91bf
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.screw_attack.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'h\xae\x13\xa0')  # 0x68ae13a0
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.bomb.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xf0\xb2\xf4\xcf')  # 0xf0b2f4cf
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.power_bomb.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x00\xef\xe8\xcb')  # 0xefe8cb
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.missile.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xbbp\t?')  # 0xbb70093f
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.phazon.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xbf\xac"\x9f')  # 0xbfac229f
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.ai.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'P\xdd\xe8\x91')  # 0x50dde891
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.poison_water.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x97\xb5\xc6\x8b')  # 0x97b5c68b
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.dark_water.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xf4\xce\x8a\xcf')  # 0xf4ce8acf
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.lava.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x1dRX\x8d')  # 0x1d52588d
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.area_damage_hot.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'd\xdd\xd5C')  # 0x64ddd543
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.area_damage_cold.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'=b_\x10')  # 0x3d625f10
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.area_damage_dark.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'Y\x1b\x80\xe3')  # 0x591b80e3
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.area_damage_light.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xa4B\xb4\xa3')  # 0xa442b4a3
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.power_charge.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'*\x0f\x05$')  # 0x2a0f0524
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.entangler.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x94\x9e<\x86')  # 0x949e3c86
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.light_blast.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'[\xa9\x91\xb1')  # 0x5ba991b1
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.sonic_boom.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'i$\xb8\xc1')  # 0x6924b8c1
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.super_missle.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x1a\xb7\x8b\xef')  # 0x1ab78bef
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.black_hole.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\xfc\xdc\xb7\xd4')  # 0xfcdcb7d4
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.sunburst.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'1\x1f\xb0a')  # 0x311fb061
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.imploder.to_stream(data)
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'\x89\xd2]\xf4')  # 0x89d25df4
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.weapon_vulnerability.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

        data.write(b'3V\xd3~')  # 0x3356d37e
        before = data.tell()
        data.write(b'\x00\x00')  # size placeholder
        self.normal_safe_zone.to_stream(data, default_override={'damage_multiplier': 0.0})
        after = data.tell()
        data.seek(before)
        data.write(struct.pack(">H", after - before - 2))
        data.seek(after)

    @classmethod
    def from_json(cls, data: dict):
        return cls(
            power=WeaponVulnerability.from_json(data['power']),
            dark=WeaponVulnerability.from_json(data['dark']),
            light=WeaponVulnerability.from_json(data['light']),
            annihilator=WeaponVulnerability.from_json(data['annihilator']),
            boost_ball=WeaponVulnerability.from_json(data['boost_ball']),
            cannon_ball=WeaponVulnerability.from_json(data['cannon_ball']),
            screw_attack=WeaponVulnerability.from_json(data['screw_attack']),
            bomb=WeaponVulnerability.from_json(data['bomb']),
            power_bomb=WeaponVulnerability.from_json(data['power_bomb']),
            missile=WeaponVulnerability.from_json(data['missile']),
            phazon=WeaponVulnerability.from_json(data['phazon']),
            ai=WeaponVulnerability.from_json(data['ai']),
            poison_water=WeaponVulnerability.from_json(data['poison_water']),
            dark_water=WeaponVulnerability.from_json(data['dark_water']),
            lava=WeaponVulnerability.from_json(data['lava']),
            area_damage_hot=WeaponVulnerability.from_json(data['area_damage_hot']),
            area_damage_cold=WeaponVulnerability.from_json(data['area_damage_cold']),
            area_damage_dark=WeaponVulnerability.from_json(data['area_damage_dark']),
            area_damage_light=WeaponVulnerability.from_json(data['area_damage_light']),
            power_charge=WeaponVulnerability.from_json(data['power_charge']),
            entangler=WeaponVulnerability.from_json(data['entangler']),
            light_blast=WeaponVulnerability.from_json(data['light_blast']),
            sonic_boom=WeaponVulnerability.from_json(data['sonic_boom']),
            super_missle=WeaponVulnerability.from_json(data['super_missle']),
            black_hole=WeaponVulnerability.from_json(data['black_hole']),
            sunburst=WeaponVulnerability.from_json(data['sunburst']),
            imploder=WeaponVulnerability.from_json(data['imploder']),
            weapon_vulnerability=WeaponVulnerability.from_json(data['weapon_vulnerability']),
            normal_safe_zone=WeaponVulnerability.from_json(data['normal_safe_zone']),
        )

    def to_json(self) -> dict:
        return {
            'power': self.power.to_json(),
            'dark': self.dark.to_json(),
            'light': self.light.to_json(),
            'annihilator': self.annihilator.to_json(),
            'boost_ball': self.boost_ball.to_json(),
            'cannon_ball': self.cannon_ball.to_json(),
            'screw_attack': self.screw_attack.to_json(),
            'bomb': self.bomb.to_json(),
            'power_bomb': self.power_bomb.to_json(),
            'missile': self.missile.to_json(),
            'phazon': self.phazon.to_json(),
            'ai': self.ai.to_json(),
            'poison_water': self.poison_water.to_json(),
            'dark_water': self.dark_water.to_json(),
            'lava': self.lava.to_json(),
            'area_damage_hot': self.area_damage_hot.to_json(),
            'area_damage_cold': self.area_damage_cold.to_json(),
            'area_damage_dark': self.area_damage_dark.to_json(),
            'area_damage_light': self.area_damage_light.to_json(),
            'power_charge': self.power_charge.to_json(),
            'entangler': self.entangler.to_json(),
            'light_blast': self.light_blast.to_json(),
            'sonic_boom': self.sonic_boom.to_json(),
            'super_missle': self.super_missle.to_json(),
            'black_hole': self.black_hole.to_json(),
            'sunburst': self.sunburst.to_json(),
            'imploder': self.imploder.to_json(),
            'weapon_vulnerability': self.weapon_vulnerability.to_json(),
            'normal_safe_zone': self.normal_safe_zone.to_json(),
        }


def _decode_power(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_dark(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_light(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_annihilator(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_boost_ball(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_cannon_ball(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_screw_attack(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_bomb(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_power_bomb(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_missile(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_phazon(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_ai(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_poison_water(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_dark_water(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_lava(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_area_damage_hot(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_area_damage_cold(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_area_damage_dark(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_area_damage_light(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_power_charge(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_entangler(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_light_blast(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_sonic_boom(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_super_missle(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_black_hole(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_sunburst(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_imploder(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size)


def _decode_weapon_vulnerability(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


def _decode_normal_safe_zone(data: typing.BinaryIO, property_size: int):
    return WeaponVulnerability.from_stream(data, property_size, default_override={'damage_multiplier': 0.0})


_property_decoder: typing.Dict[int, typing.Tuple[str, typing.Callable[[typing.BinaryIO, int], typing.Any]]] = {
    0xac8bb2a7: ('power', _decode_power),
    0xb19b6d6c: ('dark', _decode_dark),
    0x2444c6: ('light', _decode_light),
    0xe6bacde5: ('annihilator', _decode_annihilator),
    0xd99c0400: ('boost_ball', _decode_boost_ball),
    0xc70d8b8b: ('cannon_ball', _decode_cannon_ball),
    0x866f91bf: ('screw_attack', _decode_screw_attack),
    0x68ae13a0: ('bomb', _decode_bomb),
    0xf0b2f4cf: ('power_bomb', _decode_power_bomb),
    0xefe8cb: ('missile', _decode_missile),
    0xbb70093f: ('phazon', _decode_phazon),
    0xbfac229f: ('ai', _decode_ai),
    0x50dde891: ('poison_water', _decode_poison_water),
    0x97b5c68b: ('dark_water', _decode_dark_water),
    0xf4ce8acf: ('lava', _decode_lava),
    0x1d52588d: ('area_damage_hot', _decode_area_damage_hot),
    0x64ddd543: ('area_damage_cold', _decode_area_damage_cold),
    0x3d625f10: ('area_damage_dark', _decode_area_damage_dark),
    0x591b80e3: ('area_damage_light', _decode_area_damage_light),
    0xa442b4a3: ('power_charge', _decode_power_charge),
    0x2a0f0524: ('entangler', _decode_entangler),
    0x949e3c86: ('light_blast', _decode_light_blast),
    0x5ba991b1: ('sonic_boom', _decode_sonic_boom),
    0x6924b8c1: ('super_missle', _decode_super_missle),
    0x1ab78bef: ('black_hole', _decode_black_hole),
    0xfcdcb7d4: ('sunburst', _decode_sunburst),
    0x311fb061: ('imploder', _decode_imploder),
    0x89d25df4: ('weapon_vulnerability', _decode_weapon_vulnerability),
    0x3356d37e: ('normal_safe_zone', _decode_normal_safe_zone),
}
