# Generated File
import functools
import importlib
import typing

from retro_data_structures.properties.base_property import BaseObjectType

_FOUR_CC_MAPPING = {
    'ACKF': 'ActorKeyframe',
    'ACNT': 'AdvancedCounter',
    'ACTR': 'Actor',
    'ADMG': 'AreaDamage',
    'AIHT': 'AIHint',
    'AIKF': 'AIKeyframe',
    'AIMT': 'AIMannedTurret',
    'AIWP': 'AIWaypoint',
    'AJMP': 'AIJumpPoint',
    'AMIA': 'AmbientAI',
    'AROT': 'ActorRotate',
    'ATMA': 'AtomicAlpha',
    'ATMB': 'AtomicBeta',
    'BALS': 'SpiderBallAttractionSurface',
    'BALT': 'BallTrigger',
    'BALW': 'SpiderBallWaypoint',
    'BLOG': 'Blogg',
    'BLUR': 'CameraBlurKeyframe',
    'BRZG': 'Brizgee',
    'BSWM': 'BacteriaSwarm',
    'CAMH': 'CameraHint',
    'CAMP': 'CameraPitch',
    'CAMR': 'Camera',
    'CAMS': 'CameraShaker',
    'CAMW': 'CameraWaypoint',
    'CANB': 'CannonBall',
    'CHOG': 'ChozoGhost',
    'CLRM': 'ColorModulate',
    'CMDO': 'CommandoPirate',
    'CNTA': 'ControllerAction',
    'CNTR': 'Counter',
    'COIN': 'Coin',
    'COVR': 'CoverPoint',
    'CRLT': 'Crystallite',
    'CRLY': 'ConditionalRelay',
    'CTLH': 'ControlHint',
    'DBAR': 'DestructibleBarrier',
    'DBR1': 'Debris',
    'DBR2': 'DebrisExtended',
    'DFOG': 'DistanceFog',
    'DGHD': 'DigitalGuardianHead',
    'DGRD': 'DigitalGuardian',
    'DKTR': 'DarkTrooper',
    'DLHT': 'DynamicLight',
    'DMGA': 'DamageActor',
    'DOCK': 'Dock',
    'DOOR': 'Door',
    'DRKC': 'DarkCommando',
    'DRKS': 'DarkSamus',
    'DSBS': 'DarkSamusBattleStage',
    'DTRG': 'DamageableTrigger',
    'DTRO': 'DamageableTriggerOrientated',
    'EFCT': 'Effect',
    'EM2T': 'EmperorIngStage2Tentacle',
    'EMPU': 'EMPulse',
    'EMS1': 'EmperorIngStage1',
    'EMS3': 'EmperorIngStage3',
    'EPRT': 'ElitePirate',
    'EYEB': 'EyeBall',
    'FGTO': 'ForgottenObject',
    'FILT': 'CameraFilterKeyframe',
    'FISH': 'FishCloud',
    'FLAR': 'VisorFlare',
    'FNWK': 'FrontEndDataNetwork',
    'FOGO': 'FogOverlay',
    'FOGV': 'FogVolume',
    'FPRT': 'FlyingPirate',
    'FSHM': 'FishCloudModifier',
    'FSWM': 'FlyerSwarm',
    'FXDC': 'EnvFxDensityController',
    'GBUG': 'Glowbug',
    'GENR': 'Generator',
    'GMNU': 'GuiMenu',
    'GNTB': 'GunTurretBase',
    'GNTT': 'GunTurretTop',
    'GPJN': 'GuiPlayerJoinManager',
    'GRAP': 'GrapplePoint',
    'GRCH': 'Grenchler',
    'GSCR': 'GuiScreen',
    'GSLD': 'GuiSlider',
    'GWIG': 'GuiWidget',
    'HHNT': 'HUDHint',
    'HINT': 'PlayerHint',
    'IBBG': 'IngBoostBallGuardian',
    'IBSM': 'IngBlobSwarm',
    'INGS': 'Ing',
    'IPUD': 'IngPuddle',
    'ISBG': 'IngSpiderballGuardian',
    'ISJG': 'IngSpaceJumpGuardian',
    'ISSW': 'IngSnatchingSwarm',
    'KRAL': 'Kralee',
    'KROC': 'Krocuss',
    'LUMI': 'Lumite',
    'MEMO': 'HUDMemo',
    'MIDI': 'Midi',
    'MING': 'MediumIng',
    'MNNG': 'MinorIng',
    'MOVI': 'StreamedMovie',
    'MREE': 'Metaree',
    'MRLY': 'MemoryRelay',
    'MSWM': 'MetareeSwarm',
    'MTDA': 'MetroidAlpha',
    'MYSF': 'MysteryFlyer',
    'OCTS': 'OctapedeSegment',
    'PARA': 'Parasite',
    'PCAM': 'PathCamera',
    'PCKP': 'Pickup',
    'PILB': 'PillBug',
    'PIRT': 'SpacePirate',
    'PKGN': 'PickupGenerator',
    'PLAC': 'PlayerActor',
    'PLAT': 'Platform',
    'PLCT': 'PlayerController',
    'PLRT': 'PlayerTurret',
    'PMCT': 'PathMeshCtrl',
    'POIN': 'PointOfInterest',
    'PRTT': 'PortalTransition',
    'PSCH': 'PlayerStateChange',
    'PSSM': 'PlantScarabSwarm',
    'PUFR': 'Puffer',
    'RADD': 'RadialDamage',
    'RBPZ': 'RubiksPuzzle',
    'REAA': 'AreaAttributes',
    'REPL': 'Repulsor',
    'REZB': 'Rezbit',
    'RIPL': 'Ripple',
    'RIPR': 'Ripper',
    'RMAC': 'RoomAcoustics',
    'RPTL': 'RiftPortal',
    'RRLY': 'RandomRelay',
    'RSFA': 'RsfAudio',
    'RUMB': 'RumbleEffect',
    'SAFE': 'SafeZone',
    'SBS1': 'SwampBossStage1',
    'SBS2': 'SwampBossStage2',
    'SCIN': 'ScanTreeInventory',
    'SCMN': 'ScanTreeMenu',
    'SCND': 'ScanTreeCategory',
    'SCSL': 'ScanTreeSlider',
    'SCSN': 'ScanTreeScan',
    'SFZC': 'SafeZoneCrystal',
    'SHDW': 'ShadowProjector',
    'SHRD': 'Shredder',
    'SHRK': 'Shrieker',
    'SILH': 'Silhouette',
    'SKRP': 'SkyRipple',
    'SLCT': 'ScriptLayerController',
    'SNAK': 'SnakeWeedSwarm',
    'SNDB': 'SandBoss',
    'SNDM': 'SoundModifier',
    'SNFO': 'ScannableObjectInfo',
    'SOND': 'Sound',
    'SPBB': 'SporbBase',
    'SPBN': 'SporbNeedle',
    'SPBP': 'SporbProjectile',
    'SPBT': 'SporbTop',
    'SPFN': 'SpecialFunction',
    'SPIN': 'Spinner',
    'SPLL': 'SplitterMainChassis',
    'SPLU': 'SplitterCommandModule',
    'SPND': 'SpindleCamera',
    'SPNK': 'SpankWeed',
    'SPOR': 'PuddleSpore',
    'SPTR': 'Splinter',
    'SPWN': 'SpawnPoint',
    'SQTR': 'SequenceTimer',
    'SRLY': 'Relay',
    'STAU': 'StreamedAudio',
    'STEM': 'Steam',
    'STOD': 'StoneToad',
    'SUBT': 'Subtitle',
    'SURC': 'SurfaceCamera',
    'SWTC': 'Switch',
    'TEL1': 'WorldTeleporter',
    'TGPT': 'TargetingPoint',
    'TIMR': 'Timer',
    'TKEY': 'TimeKeyframe',
    'TMAI': 'TeamAI',
    'TRGE': 'TriggerEllipsoid',
    'TRGO': 'TriggerOrientated',
    'TRGR': 'Trigger',
    'TRYC': 'Tryclops',
    'TXPN': 'TextPane',
    'VGOO': 'VisorGoo',
    'WATR': 'Water',
    'WAYP': 'Waypoint',
    'WISP': 'WispTentacle',
    'WLIT': 'WorldLightFader',
    'WLWK': 'WallWalker',
    'WORM': 'Sandworm',
}


@functools.lru_cache(maxsize=None)
def get_object(four_cc: str) -> typing.Type[BaseObjectType]:
    stem = _FOUR_CC_MAPPING[four_cc]
    module = importlib.import_module(f"retro_data_structures.properties.echoes.objects.{stem}")
    return getattr(module, stem)
