# Generated File
import functools
import importlib
import typing

from retro_data_structures.properties.base_property import BaseObjectType

_FOUR_CC_MAPPING = {
    0x0: 'Actor',
    0x2: 'Waypoint',
    0x3: 'Door',
    0x4: 'Trigger',
    0x5: 'Timer',
    0x6: 'Counter',
    0x7: 'Effect',
    0x8: 'Platform',
    0x9: 'Sound',
    0xA: 'Generator',
    0xB: 'Dock',
    0xC: 'Camera',
    0xD: 'CameraWaypoint',
    0xE: 'NewIntroBoss',
    0xF: 'SpawnPoint',
    0x10: 'CameraHint',
    0x11: 'Pickup',
    0x13: 'MemoryRelay',
    0x14: 'RandomRelay',
    0x15: 'Relay',
    0x16: 'Beetle',
    0x17: 'HUDMemo',
    0x18: 'CameraFilterKeyframe',
    0x19: 'CameraBlurKeyframe',
    0x1A: 'DamageableTrigger',
    0x1B: 'Debris',
    0x1C: 'CameraShaker',
    0x1D: 'ActorKeyframe',
    0x20: 'Water',
    0x21: 'WarWasp',
    0x24: 'SpacePirate',
    0x25: 'FlyingPirate',
    0x26: 'ElitePirate',
    0x27: 'MetroidBeta',
    0x28: 'ChozoGhost',
    0x2A: 'CoverPoint',
    0x2C: 'SpiderBallWaypoint',
    0x2D: 'BloodFlower',
    0x2E: 'FlickerBat',
    0x2F: 'PathCamera',
    0x30: 'GrapplePoint',
    0x31: 'PuddleSpore',
    0x32: 'DebugCameraWaypoint',
    0x33: 'SpiderBallAttractionSurface',
    0x34: 'PuddleToadGamma',
    0x35: 'DistanceFog',
    0x36: 'FireFlea',
    0x37: 'MetareeAlpha',
    0x38: 'DockAreaChange',
    0x39: 'ActorRotate',
    0x3A: 'SpecialFunction',
    0x3B: 'SpankWeed',
    0x3D: 'Parasite',
    0x3E: 'PlayerHint',
    0x3F: 'Ripper',
    0x40: 'PickupGenerator',
    0x41: 'AIKeyframe',
    0x42: 'PointOfInterest',
    0x43: 'Drone',
    0x44: 'MetroidAlpha',
    0x45: 'DebrisExtended',
    0x46: 'Steam',
    0x47: 'Ripple',
    0x48: 'BallTrigger',
    0x49: 'TargetingPoint',
    0x4A: 'ElectroMagneticPulse',
    0x4B: 'IceSheegoth',
    0x4C: 'PlayerActor',
    0x4D: 'Flaahgra',
    0x4E: 'AreaAttributes',
    0x4F: 'FishCloud',
    0x50: 'FishCloudModifier',
    0x51: 'VisorFlare',
    0x52: 'WorldTeleporter',
    0x53: 'VisorGoo',
    0x54: 'JellyZap',
    0x55: 'ControllerAction',
    0x56: 'Switch',
    0x57: 'PlayerStateChange',
    0x58: 'Thardus',
    0x5A: 'WallCrawlerSwarm',
    0x5B: 'AIJumpPoint',
    0x5C: 'FlaahgraTentacle',
    0x5D: 'RoomAcoustics',
    0x5E: 'ColorModulate',
    0x5F: 'ThardusRockProjectile',
    0x60: 'Midi',
    0x61: 'StreamedAudio',
    0x62: 'WorldTeleporter',
    0x63: 'Repulsor',
    0x64: 'GunTurret',
    0x65: 'FogVolume',
    0x66: 'Babygoth',
    0x67: 'Eyeball',
    0x68: 'RadialDamage',
    0x69: 'CameraPitchVolume',
    0x6A: 'EnvFxDensityController',
    0x6B: 'Magdolite',
    0x6C: 'TeamAIMgr',
    0x6D: 'SnakeWeedSwarm',
    0x6E: 'ActorContraption',
    0x6F: 'Oculus',
    0x70: 'Geemer',
    0x71: 'SpindleCamera',
    0x72: 'AtomicAlpha',
    0x73: 'CameraHintTrigger',
    0x74: 'RumbleEffect',
    0x75: 'AmbientAI',
    0x77: 'AtomicBeta',
    0x78: 'IceZoomer',
    0x79: 'Puffer',
    0x7A: 'Tryclops',
    0x7B: 'Ridley',
    0x7C: 'Seedling',
    0x7D: 'ThermalHeatFader',
    0x7F: 'Burrower',
    0x81: 'ScriptBeam',
    0x82: 'WorldLightFader',
    0x83: 'MetroidPrimeStage2',
    0x84: 'MetroidPrimeStage1',
    0x85: 'MazeNode',
    0x86: 'OmegaPirate',
    0x87: 'PhazonPool',
    0x88: 'PhazonHealingNodule',
    0x89: 'NewCameraShaker',
    0x8A: 'ShadowProjector',
    0x8B: 'EnergyBall',
}


@functools.lru_cache(maxsize=None)
def get_object(four_cc: int) -> typing.Type[BaseObjectType]:
    stem = _FOUR_CC_MAPPING[four_cc]
    module = importlib.import_module(f"retro_data_structures.properties.prime.objects.{stem}")
    return getattr(module, stem)
