# delphix-api-gateway
Delphix API Gateway API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import api_keys_api
from delphix.api.gateway.model.api_key import ApiKey
from delphix.api.gateway.model.api_key_token import ApiKeyToken
# Defining the host is optional and defaults to http://localhost/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_keys_api.ApiKeysApi(api_client)
    api_key = ApiKey(
        id=1,
        name="name_example",
    ) # ApiKey | 

    try:
        # Create a new API key. If no API key exists yet, or all tokens for existing API keys have been lost, the application container container can be TEMPORARILY started with the API_KEY_CREATE environment variable set to string \"true\" and the application will create a new API key when starting and print the corresponding token to the logs. API keys created using the environment variable mechanism should only be used to boostrap the creation of other - more secure - API keys and be discarded. 
        api_response = api_instance.create_api_key(api_key)
        pprint(api_response)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling ApiKeysApi->create_api_key: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeysApi* | [**create_api_key**](docs/ApiKeysApi.md#create_api_key) | **POST** /management/api-keys | Create a new API key. If no API key exists yet, or all tokens for existing API keys have been lost, the application container container can be TEMPORARILY started with the API_KEY_CREATE environment variable set to string \&quot;true\&quot; and the application will create a new API key when starting and print the corresponding token to the logs. API keys created using the environment variable mechanism should only be used to boostrap the creation of other - more secure - API keys and be discarded. 
*ApiKeysApi* | [**delete_api_key**](docs/ApiKeysApi.md#delete_api_key) | **DELETE** /management/api-keys/{apiKeyId} | Delete an API key
*ApiKeysApi* | [**get_api_key**](docs/ApiKeysApi.md#get_api_key) | **GET** /management/api-keys/{apiKeyId} | Get an API key by id
*ApiKeysApi* | [**list_api_keys**](docs/ApiKeysApi.md#list_api_keys) | **GET** /management/api-keys | Returns a list of API keys.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*EnginesApi* | [**get_engine_by_id**](docs/EnginesApi.md#get_engine_by_id) | **GET** /engines/{engineId} | Returns an engine by ID.
*EnginesApi* | [**get_engines**](docs/EnginesApi.md#get_engines) | **GET** /engines | List all engines.
*EnvironmentsApi* | [**get_environment**](docs/EnvironmentsApi.md#get_environment) | **GET** /environments/{environmentId} | Get an environment by id.
*EnvironmentsApi* | [**list_environments**](docs/EnvironmentsApi.md#list_environments) | **GET** /environments | List all environments.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**list_hashicorp_vaults**](docs/ManagementApi.md#list_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**list_registered_engines**](docs/ManagementApi.md#list_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [ApiKeyToken](docs/ApiKeyToken.md)
 - [DSource](docs/DSource.md)
 - [Engine](docs/Engine.md)
 - [Environment](docs/Environment.md)
 - [Error](docs/Error.md)
 - [Errors](docs/Errors.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [Host](docs/Host.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListEnginesResponse](docs/ListEnginesResponse.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [Source](docs/Source.md)
 - [VDB](docs/VDB.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

