# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['atcodertools',
 'atcodertools.client',
 'atcodertools.client.models',
 'atcodertools.codegen',
 'atcodertools.codegen.code_generators',
 'atcodertools.codegen.models',
 'atcodertools.common',
 'atcodertools.config',
 'atcodertools.constprediction',
 'atcodertools.constprediction.models',
 'atcodertools.executils',
 'atcodertools.fileutils',
 'atcodertools.fmtprediction',
 'atcodertools.fmtprediction.models',
 'atcodertools.release_management',
 'atcodertools.tools',
 'atcodertools.tools.models',
 'atcodertools.tools.templates']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=2.11.3,<3.0.0',
 'beautifulsoup4>=4.9.3,<5.0.0',
 'colorama>=0.4.4,<0.5.0',
 'requests>=2.25.1,<3.0.0',
 'toml>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['atcoder-tools = atcodertools.atcoder_tools:main']}

setup_kwargs = {
    'name': 'atcoder-tools',
    'version': '2.2.0',
    'description': 'Convenient modules & tools for AtCoder users, written in Python 3.6',
    'long_description': '[![Build Status](https://api.travis-ci.org/kyuridenamida/atcoder-tools.svg?branch=stable)](https://travis-ci.org/kyuridenamida/atcoder-tools)\n[![codecov](https://codecov.io/gh/kyuridenamida/atcoder-tools/branch/master/graph/badge.svg)](https://codecov.io/gh/kyuridenamida/atcoder-tools)\n[![PyPI](https://img.shields.io/pypi/v/atcoder-tools.svg)](https://pypi.python.org/pypi/atcoder-tools)\n\n\n重要!\n===\n2020-05-17 02:57 に デフォルトのブランチがmasterからstableに変わりました。\nこの変更の背景には、1.1.6以降の変更のverificationが終わっておわず、また完了するにも時間がかかることが見込まれるため、一時的なロールバックをしたかったというものがあります。\n現状masterは1.1.6以降のマージの一時退避場所になっていますが、それらの検証が終わった後のmasterの運用は未定です。デフォルトブランチについては今後もstableを使っていく予定です。つきましては、今後のマージリクエストはstable branchから派生し、stableブランチへのPull Requestを送って頂くようお願い申し上げます。\n送っていただいている既存のマージリクエストについては個別に対応いたします。\n\nAtCoder Tools\n====\nPython 3.6 以降で動作する [AtCoder](http://atcoder.jp/) からサンプル入力をダウンロードしたりする際に便利なツールです。\n\nこのツールには次のような機能があります。\n- AtCoderへのログイン，入出力例データなどの抽出\n- 枝刈り探索による高精度・高速な入力フォーマット解析 (ARC、ABC、AGCについては約9割ほど)\n- 問題文中に含まれるMOD値、YES/NO文字列、誤差ジャッジのための誤差値等の定数値抽出\n- サンプルのローカルテスト機能\n    - 誤差ジャッジに対応 by [@chaemon](https://github.com/chaemon/)\n- コード提出機能\n- 入力フォーマット解析結果や抽出した定数値を用いたテンプレートからのコード自動生成(以下の表に記載されている言語をサポートしています)\n    - カスタムテンプレートに対応\n    - 他言語対応のためのコントリビューション(≒中間形式からコードに変換する部分のPR)を募集中です!\n\n|対応言語  |Contributor 1|Contributor 2|\n|---:|:---:|:---:|\n|C++|[@kyuridenamida](https://github.com/kyuridenamida/) (generator, template)|[@asi1024](https://github.com/asi1024/) (template)|\n|Java|[@kyuridenamida](https://github.com/kyuridenamida/) (generator, template)||\n|Rust|[@fukatani](https://github.com/fukatani/) (generator, template)|[@koba-e964](https://github.com/koba-e964/) (template, CR)|\n|Python3|[@kmyk](https://github.com/kmyk/) (generator, template)|[@penpenpng](https://github.com/penpenpng/) (generator)|\n|D|[@penpenpng](https://github.com/penpenpng/) (generator, template)||\n|Nim|[@chaemon](https://github.com/chaemon/) (generator, template)||\n|C#|[@chaemon](https://github.com/chaemon/) (generator, template)||\n\n## Demo\n<img src="https://user-images.githubusercontent.com/233559/52807100-f6e2d300-30cd-11e9-8906-82b9f9b2dff7.gif" width=70%>\n\n## How to install\n`pip3 install atcoder-tools` \n\nただの`pip`だとPython 2系を使ってインストールされる可能性があるためうまくいかないかもしれません。\n\n## Userscript by [@kmyk](https://github.com/kmyk/) (NEW! 2019/03/06)\nTampermonkey(各種ブラウザで動作)でインストールすることが可能なUserscriptです。公開されている過去問を対象として、atcoder-toolsで自動生成されたコードをそのままAtCoderのスニペット上で利用できます。\n1. Tampermonkey をインストールする ([Chrome](https://chrome.google.com/webstore/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo), [FireFox](https://addons.mozilla.org/en-US/firefox/addon/tampermonkey/))\n2. https://kyuridenamida.github.io/atcoder-tools/index.user.js にアクセスしてUserscriptをインストール\n3. ログインした状態で適当な問題ページに行く(e.g. https://atcoder.jp/contests/abc120/tasks/abc120_d)\n4. 正しくインストールされている場合、ページ下部のコードスニペットにコードが標準で埋め込まれている (atcoder-toolsの対応言語のみ)\n<img src="https://user-images.githubusercontent.com/233559/53821542-56d3e780-3fb1-11e9-89d9-24a3d0e9af5c.png" width=50%>\n\n## Analysis\nhttps://kyuridenamida.github.io/atcoder-tools/\n\n各問題ごとの解析結果などが載っています。\n\n## Usage\n\n\n*重要: かつてパスワード入力なしでログインを実現するために`AccountInformation.py`にログイン情報を書き込むことを要求していましたが、セキュリティリスクが高すぎるため、セッション情報のみを保持する方針に切り替えました。\n今後はできるだけ保持されているセッション情報を利用してAtCoderにアクセスし、必要に応じて再入力を要求します。\n過去のユーザーの皆様には`AccountInformation.py`を削除して頂くようお願い申し上げます。*\n\n\n- `atcoder-tools gen {contest_id}` コンテスト環境を用意します。\n- `atcoder-tools test` カレント・ディレクトリ上に実行ファイルと入出力(in_\\*.txt, out_\\*.txt)がある状態で実行するとローカルテストを行います。\n- `atcoder-tools submit` カレント・ディレクトリ上で実行すると対応する問題がサンプルに通る場合ソースコードを提出します。既にAtCoder上にその問題に対する提出がある場合、`-u`を指定しないと提出できないようになっています。\n- `atcoder-tools version` 現在の atcoder-tools のバージョンを出力します。\n\n`atcoder-tools gen --help`で`atcoder-tools gen`の引数の詳細について確認することができます。\n\n例: \n```console\natcoder-tools gen agc001\ncd ~/atcoder-workspace/agc001/A\ng++ main.cpp\natcoder-tools test\n```\n\n`--without-login` 引数を指定するとログインなしでデータをダウンロードできます(一般公開されているコンテストのみ)。\n\n```console\n$ atcoder-tools gen  [contest_id] --without-login\n```\n\n### gen の詳細\n```\nusage: atcoder-tools gen\n       [-h] [--without-login] [--workspace WORKSPACE] [--lang LANG]\n       [--template TEMPLATE] [--parallel] [--save-no-session-cache]\n       [--skip-existing-problems] [--config CONFIG]\n       contest_id\n\npositional arguments:\n  contest_id            Contest ID (e.g. arc001)\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --without-login       Download data without login\n  --workspace WORKSPACE\n                        Path to workspace\'s root directory. This script will create files in {WORKSPACE}/{contest_name}/{alphabet}/ e.g. ./your-workspace/arc001/A/\n                        [Default] /home/kyuridenamida/atcoder-workspace\n  --lang LANG           Programming language of your template code, cpp or java or rust or python or nim or d or cs.\n                        [Default] cpp\n  --template TEMPLATE   File path to your template code\n                        [Default (C++)] /atcodertools/tools/templates/default_template.cpp\n                        [Default (Java)] /atcodertools/tools/templates/default_template.java\n                        [Default (Rust)] /atcodertools/tools/templates/default_template.rs\n                        [Default (Python3)] /atcodertools/tools/templates/default_template.py\n                        [Default (NIM)] /atcodertools/tools/templates/default_template.nim\n                        [Default (D)] /atcodertools/tools/templates/default_template.d\n                        [Default (C#)] /atcodertools/tools/templates/default_template.cs\n  --parallel            Prepare problem directories asynchronously using multi processors.\n  --save-no-session-cache\n                        Save no session cache to avoid security risk\n  --skip-existing-problems\n                        Skip processing every problem for which a directory already exists\n  --config CONFIG       File path to your config file\n                        [Default (Primary)] /home/kyuridenamida/.atcodertools.toml\n                        [Default (Secondary)] /atcoder-tools/atcodertools/tools/atcodertools-default.toml\n```\n\n### test の詳細\n\n```\nusage: atcoder-tools test [-h] [--exec EXEC] [--num NUM]\n                                         [--dir DIR] [--timeout TIMEOUT]\n                                         [--knock-out]\n                                         [--skip-almost-ac-feedback]\n                                         [--judge-type JUDGE_TYPE]\n                                         [--error-value ERROR_VALUE]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --exec EXEC, -e EXEC  File path to the execution target. [Default] Automatically detected exec file\n  --num NUM, -n NUM     The case number to test (1-origin). All cases are tested if not specified.\n  --dir DIR, -d DIR     Target directory to test. [Default] Current directory\n  --timeout TIMEOUT, -t TIMEOUT\n                        Timeout for each test cases (sec) [Default] 1\n  --knock-out, -k       Stop execution immediately after any example\'s failure [Default] False\n  --skip-almost-ac-feedback, -s\n                        Hide inputs and expected/actual outputs if result is correct and there are error outputs [Default] False,\n  --judge-type JUDGE_TYPE, -j JUDGE_TYPE\n                        error type must be one of [normal, absolute, relative, absolute_or_relative]\n  --error-value ERROR_VALUE, -v ERROR_VALUE\n                        error value for decimal number judge: [Default] 0.000000001\n```\n\n\n### submit の詳細\n\n```\nusage: atcoder-tools submit [-h] [--exec EXEC] [--dir DIR]\n                                           [--timeout TIMEOUT] [--code CODE]\n                                           [--force] [--save-no-session-cache]\n                                           [--unlock-safety]\n                                           [--judge-type JUDGE_TYPE]\n                                           [--error-value ERROR_VALUE]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --exec EXEC, -e EXEC  File path to the execution target. [Default] Automatically detected exec file\n  --dir DIR, -d DIR     Target directory to test. [Default] Current directory\n  --timeout TIMEOUT, -t TIMEOUT\n                        Timeout for each test cases (sec) [Default] 1\n  --code CODE, -c CODE  Path to the source code to submit [Default] Code path written in metadata.json\n  --force, -f           Submit the code regardless of the local test result [Default] False\n  --save-no-session-cache\n                        Save no session cache to avoid security risk\n  --unlock-safety, -u   By default, this script only submits the first code per problem. However, you can remove the safety by this option in order to submit codes twice or more.\n  --judge-type JUDGE_TYPE, -j JUDGE_TYPE\n                        error type must be one of [normal, absolute, relative, absolute_or_relative]\n  --error-value ERROR_VALUE, -v ERROR_VALUE\n                        error value for decimal number judge: [Default] 1e-09\n```\n\n### codegen の詳細\n\n```\nusage: ./atcoder-tools codegen [-h] [--without-login] [--lang LANG]\n                               [--template TEMPLATE] [--save-no-session-cache]\n                               [--config CONFIG]\n                               url\n\npositional arguments:\n  url                   URL (e.g. https://atcoder.jp/contests/abc012/tasks/abc012_3)\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --without-login       Download data without login\n  --lang LANG           Programming language of your template code, cpp or java or rust.\n                        [Default] cpp\n  --template TEMPLATE   File path to your template code\n                        [Default (C++)] /home/user/GitHub/atcoder-tools/atcodertools/tools/templates/default_template.cpp\n                        [Default (Java)] /home/user/GitHub/atcoder-tools/atcodertools/tools/templates/default_template.java\n                        [Default (Rust)] /home/user/GitHub/atcoder-tools/atcodertools/tools/templates/default_template.rs\n  --save-no-session-cache\n                        Save no session cache to avoid security risk\n  --config CONFIG       File path to your config file\n                        [Default (Primary)] /home/user/.atcodertools.toml\n                        [Default (Secondary)] /home/user/GitHub/atcoder-tools/atcodertools/tools/atcodertools-default.toml\n```\n\n\n## 設定ファイルの例\n`~/.atcodertools.toml`に以下の設定を保存すると、コードスタイルや、コード生成後に実行するコマンドを指定できます。\n\n以下は、次の挙動を期待する場合の`~/.atcodertools.toml`の例です。\n\n- `indent_type=\'space\'` スペースがインデントに使われる(`\'tab\'`を指定した場合はタブが使われる)\n- `indent_width=4` インデント幅は4である (`indent_width`が無指定の場合`4`(nim言語以外), `2`(nim言語)が規定値として使われます。)\n- `template_file=\'~/my_template.cpp\'` コード生成テンプレートとして`~/my_template.cpp`を使う\n- `workspace_dir=\'~/atcoder-workspace/\'` ワークスペースのルートは `~/atcoder-workspace/`\n- `lang=\'cpp\'` 言語設定は `cpp` (提出時もしくはデフォルトのコードジェネレーター生成時に使われます)\n- `code_generator_file="~/custom_code_generator.py"` カスタムコードジェネレーター `~/custom_code_generator.py`を指定する\n- `exec_on_each_problem_dir=\'clang-format -i ./*.cpp\'` `exec_on_contest_dir=\'touch CMakeLists.txt\'`\n    - 問題用ディレクトリ内で毎回`clang-format`を実行して、最後に`CMakeLists.txt`(空)をコンテスト用ディレクトリに生成する\n- `download_without_login=false` AtCoderにログインせずにダウンロードを行う機能を使わない (公開コンテストに対してのみ可能)\n- `parallel_download=false` データの並列ダウンロードを無効にする\n- `save_no_session_cache=false` ログイン情報のクッキーを保存する\n- `skip_existing_problems=false` ディレクトリが既に存在する問題の処理をスキップする\n- `in_example_format="in_{}.txt"` テストケース(input)のフォーマットを`in_1.txt, in_2.txt, ...`とする\n- `out_example_format="out_{}.txt"` テストケース(output)のフォーマットを`out_1.txt, out_2.txt, ...`とする\n\n```toml\n[codestyle]\nindent_type=\'space\' # \'tab\' or \'space\'\nindent_width=4\ntemplate_file=\'~/my_template.cpp\'\nworkspace_dir=\'~/atcoder-workspace/\'\nlang=\'cpp\' # Check README.md for the supported languages.\ncode_generator_file="~/custom_code_generator.py"\n[postprocess]\nexec_on_each_problem_dir=\'clang-format -i ./*.cpp\'\nexec_on_contest_dir=\'touch CMakeLists.txt\'\n\n[etc]\ndownload_without_login=false\nparallel_download=false\nsave_no_session_cache=false\nskip_existing_problems=false\nin_example_format="in_{}.txt"\nout_example_format="out_{}.txt"\n\n```\n\n### カスタムコードジェネレーター\n[標準のC++コードジェネレーター](https://github.com/kyuridenamida/atcoder-tools/blob/master/atcodertools/codegen/code_generators/cpp.py)に倣って、\n`(CogeGenArgs) -> str(ソースコード)`が型であるような`main`関数を定義した.pyファイルを`code_generator_file`で指定すると、コード生成時にカスタムコードジェネレーターを利用できます。\n \n## テンプレートの例\n`atcoder-tools gen`コマンドに対し`--template`でテンプレートソースコードを指定できます。\nテンプレートエンジンの仕様については[jinja2](http://jinja.pocoo.org/docs/2.10/) の公式ドキュメントを参照してください。\n\nテンプレートに渡される変数は以下の通りです。\n\n\n- **prediction_success** 入力形式の推論に成功したとき `True`、 失敗したとき `False`が格納されている。この値が`True`のとき次の3種類の変数も存在することが保証される。\n    - **input_part** input用のコード\n    - **formal_arguments** 型つき引数列\n    - **actual_arguments** 型なし引数列\n\n- **mod** 問題文中に存在するmodの整数値\n- **yes_str** 問題文中に存在する yes や possible などの真を表しそうな文字列値\n- **no_str** 問題文中に存在する no や impossible などの偽を表しそうな文字列値\n\n```c++\n#include <bits/stdc++.h>\nusing namespace std;\n\n{% if mod %}\nconst long long MOD = {{ mod }};\n{% endif %}\n{% if yes_str %}\nconst string YES = "{{ yes_str }}";\n{% endif %}\n{% if no_str %}\nconst string NO = "{{ no_str }}";\n{% endif %}\n\n{% if prediction_success %}\nvoid solve({{ formal_arguments }}){\n\n}\n{% endif %}\n\nint main(){\n    {% if prediction_success %}\n    {{input_part}}\n    solve({{ actual_arguments }});\n    {% else %}\n    // Failed to predict input format\n    {% endif %}\n    return 0;\n}\n```\n\n\n## Contribution\n気軽にPRを送ってください。\n\n## Licence\n\n[MIT](https://github.com/kyuridenamida/ToolsForAtCoder/blob/master/LICENCE)\n\n## Author\n\n[kyuridenamida](https://github.com/kyuridenamida) ([@kyuridenamida](https://twitter.com/kyuridenamida))\n',
    'author': 'kyuridenamida',
    'author_email': 'tyotyo3@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kyuridenamida/atcoder-tools',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
