"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
const path = require("path");
const fs = require("fs-extra");
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the typescript client
        utils_1.generateClientCode({
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            language: languages_1.ClientLanguage.TYPESCRIPT,
            additionalProperties: {
                npmName: this.project.package.packageName,
                typescriptThreePlus: "true",
                useSingleParameter: "true",
                supportsES6: "true",
            },
        });
        // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
        // and other generated code used by the construct.
        fs.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
            "/* tslint:disable */",
            "/* eslint-disable */",
            "export * from './runtime';",
            "export * from './apis';",
            "export * from './models';",
            "export * from './apis/DefaultApi/OperationConfig';",
        ].join("\n"));
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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