"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResilienceLambdaChecker = void 0;
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
const ResilientLambdaTask_1 = require("../construct/ResilientLambdaTask");
class ResilienceLambdaChecker {
    constructor(props) {
        this._fail = props === null || props === void 0 ? void 0 : props.fail;
    }
    visit(construct) {
        if (construct instanceof tasks.LambdaInvoke) {
            const reporter = this._fail ? construct.node.addError : construct.node.addWarning;
            const retries = this.getRetryConfiguration(construct);
            if (retries.length > 0) {
                const unhandledErrors = this.getUnhandledTransientErrors(retries);
                if (unhandledErrors.length > 0) {
                    reporter.apply(construct.node, [`Missing retry for transient errors: ${unhandledErrors}.`]);
                }
            }
            else {
                reporter.apply(construct.node, ['No retry for AWS Lambda transient errors defined - consider using ResilientLambdaTask construct.']);
                //ResilientLambdaTask.addDefaultRetry(construct);
            }
        }
    }
    getUnhandledTransientErrors(retries) {
        return ResilientLambdaTask_1.ResilientLambdaTask.TransientErrors.filter(transientError => retries.every(config => { var _a; return !((_a = config.errors) === null || _a === void 0 ? void 0 : _a.includes(transientError)); }));
    }
    getRetryConfiguration(construct) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return construct.retries || [];
    }
}
exports.ResilienceLambdaChecker = ResilienceLambdaChecker;
//# sourceMappingURL=data:application/json;base64,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