"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResilientLambdaTask = void 0;
const cdk = require("@aws-cdk/core");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
class ResilientLambdaTask extends tasks.LambdaInvoke {
    constructor(scope, id, props) {
        super(scope, id, props);
        ResilientLambdaTask.addDefaultRetry(this);
    }
    static addDefaultRetry(task) {
        // https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html
        task.addRetry({
            errors: ResilientLambdaTask.TransientErrors,
            backoffRate: 2,
            maxAttempts: 6,
            interval: cdk.Duration.seconds(2)
        });
    }
}
exports.ResilientLambdaTask = ResilientLambdaTask;
ResilientLambdaTask.TransientErrors = [
    "Lambda.ServiceException",
    "Lambda.AWSLambdaException",
    "Lambda.SdkClientException",
    "Lambda.TooManyRequestsException"
];
//# sourceMappingURL=data:application/json;base64,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