"""
    Splitit.OnBoarding.Api.V2

    Splitit's Onboarding API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""


import re  # noqa: F401
import sys  # noqa: F401

from splitit_client.api_client import ApiClient, Endpoint as _Endpoint
from splitit_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from splitit_client.model.create_merchant_request import CreateMerchantRequest
from splitit_client.model.create_merchant_response import CreateMerchantResponse
from splitit_client.model.get_merchant_details_response import GetMerchantDetailsResponse
from splitit_client.model.get_merchants_response import GetMerchantsResponse
from splitit_client.model.self_on_boarding_error_response import SelfOnBoardingErrorResponse


class MerchantsApi(object):
    """NOTE: This class is auto generated by Konfig
    Ref: https://konfigthis.com

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_merchant_endpoint = _Endpoint(
            settings={
                'response_type': (CreateMerchantResponse,),
                'auth': [
                    'oauth2'
                ],
                'endpoint_path': '/api/merchants/create',
                'operation_id': 'create_merchant',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_merchant_request',
                ],
                'required': [
                    'create_merchant_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_merchant_request':
                        (CreateMerchantRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_merchant_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_merchant_details_endpoint = _Endpoint(
            settings={
                'response_type': (GetMerchantDetailsResponse,),
                'auth': [
                    'oauth2'
                ],
                'endpoint_path': '/api/merchants/get-details',
                'operation_id': 'get_merchant_details',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_temp_id',
                ],
                'required': [
                    'merchant_temp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_temp_id':
                        (str,),
                },
                'attribute_map': {
                    'merchant_temp_id': 'merchantTempId',
                },
                'location_map': {
                    'merchant_temp_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_merchants_endpoint = _Endpoint(
            settings={
                'response_type': (GetMerchantsResponse,),
                'auth': [
                    'oauth2'
                ],
                'endpoint_path': '/api/merchants/get',
                'operation_id': 'get_merchants',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'number_of_rows_in_page',
                    'page_number',
                    'name',
                    'legal_name',
                    'status',
                ],
                'required': [
                    'number_of_rows_in_page',
                    'page_number',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'number_of_rows_in_page':
                        (int,),
                    'page_number':
                        (int,),
                    'name':
                        (str,),
                    'legal_name':
                        (str,),
                    'status':
                        (int,),
                },
                'attribute_map': {
                    'number_of_rows_in_page': 'NumberOfRowsInPage',
                    'page_number': 'PageNumber',
                    'name': 'Name',
                    'legal_name': 'LegalName',
                    'status': 'Status',
                },
                'location_map': {
                    'number_of_rows_in_page': 'query',
                    'page_number': 'query',
                    'name': 'query',
                    'legal_name': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_merchant(
        self,
        create_merchant_request,
        **kwargs
    ):
        """create_merchant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_merchant(create_merchant_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_merchant_request (CreateMerchantRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateMerchantResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_merchant_request'] = \
            create_merchant_request
        return self.create_merchant_endpoint.call_with_http_info(**kwargs)

    def get_merchant_details(
        self,
        merchant_temp_id,
        **kwargs
    ):
        """get_merchant_details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_merchant_details(merchant_temp_id, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_temp_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetMerchantDetailsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['merchant_temp_id'] = \
            merchant_temp_id
        return self.get_merchant_details_endpoint.call_with_http_info(**kwargs)

    def get_merchants(
        self,
        number_of_rows_in_page,
        page_number,
        **kwargs
    ):
        """get_merchants  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_merchants(number_of_rows_in_page, page_number, async_req=True)
        >>> result = thread.get()

        Args:
            number_of_rows_in_page (int):
            page_number (int):

        Keyword Args:
            name (str): [optional]
            legal_name (str): [optional]
            status (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetMerchantsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['number_of_rows_in_page'] = \
            number_of_rows_in_page
        kwargs['page_number'] = \
            page_number
        return self.get_merchants_endpoint.call_with_http_info(**kwargs)

