"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/time-windows/change-controller/change-controller.lambda.ts
var change_controller_lambda_exports = {};
__export(change_controller_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(change_controller_lambda_exports);

// src/common/alarm-state.ts
var import_aws_sdk = require("aws-sdk");
var getCloudwatchAlarms = async (params) => {
  var _a, _b;
  const cloudwatch = new import_aws_sdk.CloudWatch();
  let nextToken;
  let results = [];
  do {
    const result = await cloudwatch.describeAlarms({
      AlarmTypes: ["CompositeAlarm", "MetricAlarm"],
      ...params,
      NextToken: nextToken
    }).promise();
    results = result.CompositeAlarms ? results.concat(
      (_a = result.CompositeAlarms) == null ? void 0 : _a.map((alarm) => {
        return {
          alarmArn: alarm.AlarmArn,
          state: alarm.StateValue,
          reason: alarm.StateReason,
          alarmDescription: alarm.AlarmDescription
        };
      })
    ) : results;
    results = result.MetricAlarms ? results.concat(
      (_b = result.MetricAlarms) == null ? void 0 : _b.map((alarm) => {
        return {
          alarmArn: alarm.AlarmArn,
          state: alarm.StateValue,
          reason: alarm.StateReason,
          alarmDescription: alarm.AlarmDescription
        };
      })
    ) : results;
    nextToken = result.NextToken;
  } while (nextToken);
  return results;
};
var getAlarms = async (searchTerms) => {
  const states = [];
  try {
    const alarmsForAccountAndRegion = await getCloudwatchAlarms();
    states.push(
      ...hasAlarmMatching(alarmsForAccountAndRegion, searchTerms).map(
        (alarm) => {
          alarm.reason = `${alarm.alarmArn} in ${alarm.state} due to ${alarm.reason}`;
          return alarm;
        }
      )
    );
    if (states.length === 0) {
      states.push({
        state: "ALARM" /* ALARM */,
        reason: `No alarms were found for the provided search terms: ${searchTerms.join(
          ", "
        )}.`
      });
    }
  } catch (e) {
    const message = "Unable to retrieve alarms.";
    states.push({ reason: message, state: "ALARM" /* ALARM */ });
    console.error(message, e);
  }
  return states;
};
var getAggregateAlarmState = async (searchTerms) => {
  var _a;
  const alarmDetails = await getAlarms(searchTerms);
  return {
    alarmDetails,
    state: ((_a = alarmDetails.find((a) => a.state === "ALARM" /* ALARM */)) == null ? void 0 : _a.state) ?? "OK" /* OK */,
    summary: `${alarmDetails.filter((a) => a.state === "ALARM" /* ALARM */).map((a) => a.reason).join(", ")}`
  };
};
var hasAlarmMatching = (alarms, searchTerms) => {
  return [
    ...new Set(
      alarms.flatMap(
        (alarm) => searchTerms.map((searchTerm) => {
          var _a;
          return ((_a = alarm.alarmDescription) == null ? void 0 : _a.includes(searchTerm)) ? alarm : void 0;
        }).filter((sameAlarm) => sameAlarm)
      )
    )
  ];
};

// src/time-windows/change-controller/calendar-state.ts
var import_aws_sdk2 = require("aws-sdk");
var getCalendarState = async (calendarName) => {
  const fallbackNextTransitionTime = "2999-01-01T00:00:00Z";
  const ssm = new import_aws_sdk2.SSM();
  try {
    const result = await ssm.getCalendarState({ CalendarNames: [calendarName] }).promise();
    if (!result.State)
      throw new Error("getCalendarState returned an undefined state.");
    return {
      state: result.State,
      nextTransitionTime: result.NextTransitionTime ?? fallbackNextTransitionTime,
      summary: `Calendar is ${result.State} until ${result.NextTransitionTime ?? fallbackNextTransitionTime}.`
    };
  } catch (error) {
    const summary = `Unable to retrieve calendar state for ${calendarName}.`;
    console.error(summary, error);
    return {
      state: "CLOSED",
      nextTransitionTime: fallbackNextTransitionTime,
      summary
    };
  }
};

// src/time-windows/change-controller/pipeline-state.ts
var import_aws_sdk3 = require("aws-sdk");
var codepipeline = new import_aws_sdk3.CodePipeline();
var getStageState = async (pipelineName, stageName) => {
  var _a;
  const pipelineState = await codepipeline.getPipelineState({ name: pipelineName }).promise();
  return (_a = pipelineState.stageStates) == null ? void 0 : _a.find(
    (stage) => stage.stageName === stageName
  );
};
var disableStageTransition = async (params, lastChangedByMustInclude, stageState) => {
  var _a, _b, _c, _d;
  if (((_a = stageState == null ? void 0 : stageState.inboundTransitionState) == null ? void 0 : _a.enabled) === true || ((_b = stageState == null ? void 0 : stageState.inboundTransitionState) == null ? void 0 : _b.enabled) === false && ((_d = (_c = stageState.inboundTransitionState) == null ? void 0 : _c.lastChangedBy) == null ? void 0 : _d.includes(
    lastChangedByMustInclude
  ))) {
    params.reason = params.reason.replace(/[^a-zA-Z0-9!@ \(\)\.\*\?\-]/g, "-").slice(0, 300);
    await codepipeline.disableStageTransition(params).promise();
  }
};
var enableStageTransition = async (params, lastChangedByMustInclude, stageState) => {
  var _a, _b, _c;
  if (((_a = stageState == null ? void 0 : stageState.inboundTransitionState) == null ? void 0 : _a.enabled) === false && ((_c = (_b = stageState.inboundTransitionState) == null ? void 0 : _b.lastChangedBy) == null ? void 0 : _c.includes(
    lastChangedByMustInclude
  ))) {
    await codepipeline.enableStageTransition(params).promise();
  }
};

// src/time-windows/change-controller/change-controller.lambda.ts
var handler = async (event, context) => {
  const pipelineName = event.pipelineName;
  const stageName = event.stageName;
  const calendarState = await getCalendarState(event.calendar.calendarName);
  const stageState = await getStageState(pipelineName, stageName);
  const alarmState = await getAggregateAlarmState(event.searchTerms);
  const input = {
    pipelineName,
    stageName,
    transitionType: "Inbound"
  };
  if (calendarState.state === "OPEN" && alarmState.state === "OK") {
    console.log(`Enabling transition: ${JSON.stringify(input, null, 2)}`);
    await enableStageTransition(input, context.functionName, stageState);
  } else {
    const reason = alarmState.state === "ALARM" ? alarmState.summary : calendarState.summary;
    const disableInput = { ...input, reason };
    console.log(
      `Disabling transition: ${JSON.stringify(disableInput, null, 2)}`
    );
    await disableStageTransition(
      disableInput,
      context.functionName,
      stageState
    );
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
