# coding: utf-8

"""
    Selling Partner API for Sellers

    The Selling Partner API for Sellers lets you retrieve information on behalf of sellers about their seller account, such as the marketplaces they participate in. Along with listing the marketplaces that a seller can sell in, the API also provides additional information about the marketplace such as the default language and the default currency. The API also provides seller-specific information such as whether the seller has suspended listings in that marketplace.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class MarketplaceParticipation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'marketplace': 'Marketplace',
        'participation': 'Participation'
    }

    attribute_map = {
        'marketplace': 'marketplace',
        'participation': 'participation'
    }

    def __init__(self, marketplace=None, participation=None):  # noqa: E501
        """MarketplaceParticipation - a model defined in Swagger"""  # noqa: E501
        self._marketplace = None
        self._participation = None
        self.discriminator = None
        self.marketplace = marketplace
        self.participation = participation

    @property
    def marketplace(self):
        """Gets the marketplace of this MarketplaceParticipation.  # noqa: E501


        :return: The marketplace of this MarketplaceParticipation.  # noqa: E501
        :rtype: Marketplace
        """
        return self._marketplace

    @marketplace.setter
    def marketplace(self, marketplace):
        """Sets the marketplace of this MarketplaceParticipation.


        :param marketplace: The marketplace of this MarketplaceParticipation.  # noqa: E501
        :type: Marketplace
        """
        if marketplace is None:
            raise ValueError("Invalid value for `marketplace`, must not be `None`")  # noqa: E501

        self._marketplace = marketplace

    @property
    def participation(self):
        """Gets the participation of this MarketplaceParticipation.  # noqa: E501


        :return: The participation of this MarketplaceParticipation.  # noqa: E501
        :rtype: Participation
        """
        return self._participation

    @participation.setter
    def participation(self, participation):
        """Sets the participation of this MarketplaceParticipation.


        :param participation: The participation of this MarketplaceParticipation.  # noqa: E501
        :type: Participation
        """
        if participation is None:
            raise ValueError("Invalid value for `participation`, must not be `None`")  # noqa: E501

        self._participation = participation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MarketplaceParticipation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketplaceParticipation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
