/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util.web;

import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.DataOutputStream;
import com.datapps.linkoopdb.jdbc.result.Result;
import com.datapps.linkoopdb.jdbc.rowio.RowInputBinary;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputBinary;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.net.Socket;
import java.util.List;

public class ClusterStateUtils {
    public static final int NETWORK_COMPATIBILITY_VERSION_INT = -2030400;
    static final int BUFFER_SIZE = 4096;

    public static String queryMainServerUrl(List<String> clusterNodes) throws Exception {
        for (String addr : clusterNodes) {
            String[] addrs = addr.split(":");
            try {
                String url = ClusterStateUtils.query(addrs[0], Integer.valueOf(addrs[1]));
                if (url == null || url.startsWith("queryerror")) {
                    throw new Exception("server state is abnormal!");
                }
                return url;
            }
            catch (Exception e) {
                System.out.println("---------\u67e5\u8be2\u8282\u70b9\u4e0d\u53ef\u7528\uff1a" + addr + ":" + e.getMessage());
            }
        }
        throw new Exception("\u96c6\u7fa4\u72b6\u6001\u4e0d\u53ef\u7528\uff01");
    }

    public static String query(String host, int port) throws Exception {
        Result queryInfo = Result.queryInfoRequest();
        queryInfo.setValueObject("main_server_url");
        Result queryInfoResult = ClusterStateUtils.execute(queryInfo, host, port);
        return queryInfoResult.getValueObject().toString();
    }

    public static Result execute(Result r, String host, int port) throws Exception {
        RowOutputBinary rowOutTemp;
        byte[] mainBuffer = new byte[4096];
        RowOutputBinary rowOut = rowOutTemp = new RowOutputBinary(mainBuffer);
        RowInputBinary rowIn = new RowInputBinary(rowOutTemp);
        Socket socket = null;
        FilterOutputStream dataOutput = null;
        FilterInputStream dataInput = null;
        try {
            socket = new Socket(host, port);
            dataOutput = new DataOutputStream(socket.getOutputStream());
            dataInput = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            socket.setTcpNoDelay(true);
            ((DataOutputStream)dataOutput).writeInt(-2030400);
            ((BufferedOutputStream)dataOutput).flush();
            r.write(null, (DataOutputStream)dataOutput, rowOut);
            Result result = Result.newResult((DataInput)((Object)dataInput), rowIn);
            result.readAdditionalResults(null, (DataInputStream)dataInput, rowIn);
            rowOut.reset(mainBuffer);
            rowIn.resetRow(mainBuffer.length);
            Result result2 = result;
            return result2;
        }
        catch (Throwable e) {
            throw Error.error(e, 1305, e.toString());
        }
        finally {
            if (dataInput != null) {
                try {
                    dataInput.close();
                }
                catch (Exception exception) {}
            }
            if (dataOutput != null) {
                try {
                    dataOutput.close();
                }
                catch (Exception exception) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

