csphinxtools.librarydescription
Library
q )q}q(X   nameqX   wx.lib-4.1.0qX   kindqK X   docsqX    qX   commentsqhX   is_redundantq	X   childrenq
]q(csphinxtools.librarydescription
Module
q)q
}q(hX
   wx.lib.agwqhKhX  This is the Advanced Generic Widgets package (AGW). It provides many
custom-drawn wxPython controls: some of them can be used as a replacement
of the platform native controls, others are simply an addition to the
already rich wxPython widgets set.


Description:

AGW contains many different modules, listed below. Items labelled with
an asterisk were already present in :mod:`lib` before:

- AdvancedSplash: reproduces the behaviour of :class:`~adv.SplashScreen`, with more
  advanced features like custom shapes and text animations;
- AquaButton: this is another custom-drawn button class which
  *approximatively* mimics the behaviour of Aqua buttons on the Mac;
- AUI: a pure-Python implementation of :mod:`~wx.lib.agw.aui`, with many bug fixes and
  new features like HUD docking and :class:`~wx.lib.agw.aui.auibook.AuiNotebook` tab arts;
- BalloonTip: allows you to display tooltips in a balloon style window
  (actually a frame), similarly to the Windows XP balloon help;
- ButtonPanel (*): a panel with gradient background shading with the
  possibility to add buttons and controls still respecting the gradient
  background;
- CubeColourDialog: an alternative implementation of :class:`wx.ColourDialog`, it
  offers different functionalities like colour wheel and RGB cube;
- CustomTreeCtrl (*): mimics the behaviour of :class:`TreeCtrl`, with almost the
  same base functionalities plus a bunch of enhancements and goodies;
- FlatMenu: as the name implies, it is a generic menu implementation,
  offering the same :class:`wx.MenuBar` / :class:`wx.Menu` / :class:`ToolBar` capabilities and much more;
- FlatNotebook (*): a full implementation of the :class:`Notebook`, and designed
  to be a drop-in replacement for :class:`Notebook` with enhanced capabilities;
- FloatSpin: this class implements a floating point spinctrl, cabable (in
  theory) of handling infinite-precision floating point numbers;
- FoldPanelBar (*): a control that contains multiple panels that can be
  expanded or collapsed a la Windows Explorer/Outlook command bars;
- FourWaySplitter: this is a layout manager which manages four children like
  four panes in a window, similar to many CAD software interfaces;
- GenericMessageDialog: it is a possible replacement for the standard
  :class:`MessageDialog`, with a fancier look and extended functionalities;
- GradientButton: another custom-drawn button class which mimics Windows CE
  mobile gradient buttons, using a tri-vertex blended gradient background;
- HyperLinkCtrl (*): this widget acts line an hyper link in a typical browser;
- HyperTreeList: a class that mimics the behaviour of :class:`wx.adv.TreeListCtrl`,
  with almost the same base functionalities plus some more enhancements;
- InfoBar: a transient window shown at top or bottom of its parent window to display
  non-critical information to the user;
- KnobCtrl: a widget which lets the user select a numerical value by
  rotating it, like a slider with a wheel shape;
- LabelBook and FlatImageBook: these are a quasi-full implementations of
  :class:`Listbook`, with additional features;
- MultiDirDialog: it represents a possible replacement for :class:`DirDialog`,
  with the additional ability of selecting multiple folders at once and a
  fancier look;
- PeakMeter: this widget mimics the behaviour of LED equalizers that are
  usually found in stereos and MP3 players;
- PersistentControls: widgets which automatically save their state
  when they are destroyed and restore it when they are recreated, even during
  another program invocation;
- PieCtrl and ProgressPie: these are simple classes that reproduce the
  behavior of a pie chart, in a static or progress-gauge-like way;
- PyBusyInfo: constructs a busy info window and displays a message in it:
  it is similar to :class:`BusyInfo`;
- PyCollapsiblePane: a pure Python implementation of the original wxWidgets
  C++ code of :class:`CollapsiblePane`, with customizable buttons;
- PyGauge: a generic :class:`Gauge` implementation, it supports the determinate
  mode functions as :class:`Gauge`;
- PyProgress: it is similar to :class:`ProgressDialog` in indeterminated mode, but
  with a different gauge appearance and a different spinning behavior;
- RibbonBar: the RibbonBar library is a set of classes for writing a ribbon
  user interface, similar to the user interface present in recent versions
  of Microsoft Office;
- RulerCtrl: it implements a ruler window that can be placed on top, bottom,
  left or right to any wxPython widget. It is somewhat similar to the rulers
  you can find in text editors software;
- ShapedButton: this class tries to fill the lack of "custom shaped" controls
  in wxPython. It can be used to build round buttons or elliptic buttons;
- ShortcutEditor: a widget that allows the user to customize and change
  keyboard shortcuts via a dialog;
- SpeedMeter: this widget tries to reproduce the behavior of some car
  controls (but not only), by creating an "angular" control;
- SuperToolTip: a class that mimics the behaviour of :class:`TipWindow` and
  generic tooltips, with many features and highly customizable;
- ThumbnailCtrl: a widget that can be used to display a series of images
  in a "thumbnail" format; it mimics, for example, the Windows Explorer
  behavior when you select the "view thumbnails" option;
- ToasterBox: a cross-platform widget to make the creation of MSN-style
  "toaster" popups easier;
- UltimateListCtrl: mimics the behaviour of :class:`ListCtrl`, with almost the same
  base functionalities plus some more enhancements;
- XLSGrid: a class based on :class:`grid.Grid` that can be used to faithfully
  reproduce the appearance of a Microsoft Excel spreadsheets;
- ZoomBar: a class that *appoximatively* mimics the behaviour of the Mac Dock,
  inside a :class:`Panel`.


Bugs and Limitations: many, patches and fixes welcome :-D

See the demos for an example of what AGW can do, and on how to use it.

Copyright: Andrea Gavana

License: Same as the version of wxPython you are using it with.

SVN for latest code:
http://svn.wxwidgets.org/viewvc/wx/wxPython/3rdParty/AGW/

Mailing List:
wxpython-users@lists.wxwidgets.org

My personal web page:
http://xoomer.alice.it/infinity77

Please let me know if you are using AGW!

You can contact me at:

andrea.gavana@gmail.com
andrea.gavana@maerskoil.com

AGW version: 0.9.7

Last updated: 09 January 2014, 23.00 GMTqhhh	h
]q(h)q}q(hX   wx.lib.agw.auiqhKhX	>  AUI is an Advanced User Interface library that aims to implement "cutting-edge"
interface usability and design features so developers can quickly and easily create
beautiful and usable application interfaces.


Vision and Design Principles
============================

AUI attempts to encapsulate the following aspects of the user interface:

* **Frame Management**: Frame management provides the means to open, move and hide common
  controls that are needed to interact with the document, and allow these configurations
  to be saved into different perspectives and loaded at a later time.

* **Toolbars**: Toolbars are a specialized subset of the frame management system and should
  behave similarly to other docked components. However, they also require additional
  functionality, such as "spring-loaded" rebar support, "chevron" buttons and end-user
  customizability.

* **Modeless Controls**: Modeless controls expose a tool palette or set of options that
  float above the application content while allowing it to be accessed. Usually accessed
  by the toolbar, these controls disappear when an option is selected, but may also be
  "torn off" the toolbar into a floating frame of their own.

* **Look and Feel**: Look and feel encompasses the way controls are drawn, both when shown
  statically as well as when they are being moved. This aspect of user interface design
  incorporates "special effects" such as transparent window dragging as well as frame animation.

AUI adheres to the following principles:

- Use native floating frames to obtain a native look and feel for all platforms;
- Use existing wxPython code where possible, such as sizer implementation for frame management;
- Use standard wxPython coding conventions.


Usage
=====

The following example shows a simple implementation that uses :class:`framemanager.AuiManager` to manage
three text controls in a frame window::

    import wx
    import wx.lib.agw.aui as aui

    class MyFrame(wx.Frame):

        def __init__(self, parent, id=-1, title="AUI Test", pos=wx.DefaultPosition,
                     size=(800, 600), style=wx.DEFAULT_FRAME_STYLE):

            wx.Frame.__init__(self, parent, id, title, pos, size, style)

            self._mgr = aui.AuiManager()

            # notify AUI which frame to use
            self._mgr.SetManagedWindow(self)

            # create several text controls
            text1 = wx.TextCtrl(self, -1, "Pane 1 - sample text",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            text2 = wx.TextCtrl(self, -1, "Pane 2 - sample text",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            text3 = wx.TextCtrl(self, -1, "Main content window",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            # add the panes to the manager
            self._mgr.AddPane(text1, aui.AuiPaneInfo().Left().Caption("Pane Number One"))
            self._mgr.AddPane(text2, aui.AuiPaneInfo().Bottom().Caption("Pane Number Two"))
            self._mgr.AddPane(text3, aui.AuiPaneInfo().CenterPane())

            # tell the manager to "commit" all the changes just made
            self._mgr.Update()

            self.Bind(wx.EVT_CLOSE, self.OnClose)


        def OnClose(self, event):
            # deinitialize the frame manager
            self._mgr.UnInit()
            event.Skip()


    # our normal wxApp-derived class, as usual

    app = wx.App(0)

    frame = MyFrame(None)
    app.SetTopWindow(frame)
    frame.Show()

    app.MainLoop()


What's New
==========

Current wxAUI Version Tracked: wxWidgets 2.9.5 (SVN HEAD)

The wxPython AUI version fixes the following bugs or implement the following
missing features (the list is not exhaustive):

- Visual Studio 2005 style docking: http://www.kirix.com/forums/viewtopic.php?f=16&t=596
- Dock and Pane Resizing: http://www.kirix.com/forums/viewtopic.php?f=16&t=582
- Patch concerning dock resizing: http://www.kirix.com/forums/viewtopic.php?f=16&t=610
- Patch to effect wxAuiToolBar orientation switch: http://www.kirix.com/forums/viewtopic.php?f=16&t=641
- AUI: Core dump when loading a perspective in wxGTK (MSW OK): http://www.kirix.com/forums/viewtopic.php?f=15&t=627
- wxAuiNotebook reordered AdvanceSelection(): http://www.kirix.com/forums/viewtopic.php?f=16&t=617
- Vertical Toolbar Docking Issue: http://www.kirix.com/forums/viewtopic.php?f=16&t=181
- Patch to show the resize hint on mouse-down in aui: http://trac.wxwidgets.org/ticket/9612
- The Left/Right and Top/Bottom Docks over draw each other: http://trac.wxwidgets.org/ticket/3516
- MinSize() not honoured: http://trac.wxwidgets.org/ticket/3562
- Layout problem with wxAUI: http://trac.wxwidgets.org/ticket/3597
- Resizing children ignores current window size: http://trac.wxwidgets.org/ticket/3908
- Resizing panes under Vista does not repaint background: http://trac.wxwidgets.org/ticket/4325
- Resize sash resizes in response to click: http://trac.wxwidgets.org/ticket/4547
- "Illegal" resizing of the AuiPane? (wxPython): http://trac.wxwidgets.org/ticket/4599
- Floating wxAUIPane Resize Event doesn't update its position: http://trac.wxwidgets.org/ticket/9773
- Don't hide floating panels when we maximize some other panel: http://trac.wxwidgets.org/ticket/4066
- wxAUINotebook incorrect ALLOW_ACTIVE_PANE handling: http://trac.wxwidgets.org/ticket/4361
- Page changing veto doesn't work, (patch supplied): http://trac.wxwidgets.org/ticket/4518
- Show and DoShow are mixed around in wxAuiMDIChildFrame: http://trac.wxwidgets.org/ticket/4567
- wxAuiManager & wxToolBar - ToolBar Of Size Zero: http://trac.wxwidgets.org/ticket/9724
- wxAuiNotebook doesn't behave properly like a container as far as...: http://trac.wxwidgets.org/ticket/9911
- Serious layout bugs in wxAUI: http://trac.wxwidgets.org/ticket/10620
- wAuiDefaultTabArt::Clone() should just use copy contructor: http://trac.wxwidgets.org/ticket/11388
- Drop down button for check tool on wxAuiToolbar: http://trac.wxwidgets.org/ticket/11139

Plus the following features:

- AuiManager:

  (a) Implementation of a simple minimize pane system: Clicking on this minimize button causes a new
      AuiToolBar to be created and added to the frame manager, (currently the implementation is such
      that panes at West will have a toolbar at the right, panes at South will have toolbars at the
      bottom etc...) and the pane is hidden in the manager.
      Clicking on the restore button on the newly created toolbar will result in the toolbar being
      removed and the original pane being restored;
  (b) Panes can be docked on top of each other to form `AuiNotebooks`; `AuiNotebooks` tabs can be torn
      off to create floating panes;
  (c) On Windows XP, use the nice sash drawing provided by XP while dragging the sash;
  (d) Possibility to set an icon on docked panes;
  (e) Possibility to draw a sash visual grip, for enhanced visualization of sashes;
  (f) Implementation of a native docking art (`ModernDockArt`). Windows XP only, **requires** Mark Hammond's
      pywin32 package (winxptheme);
  (g) Possibility to set a transparency for floating panes (a la Paint .NET);
  (h) Snapping the main frame to the screen in any positin specified by horizontal and vertical
      alignments;
  (i) Snapping floating panes on left/right/top/bottom or any combination of directions, a la Winamp;
  (j) "Fly-out" floating panes, i.e. panes which show themselves only when the mouse hover them;
  (k) Ability to set custom bitmaps for pane buttons (close, maximize, etc...);
  (l) Implementation of the style ``AUI_MGR_ANIMATE_FRAMES``, which fade-out floating panes when
      they are closed (all platforms which support frames transparency) and show a moving rectangle
      when they are docked and minimized (Windows < Vista and GTK only);
  (m) A pane switcher dialog is available to cycle through existing AUI panes;
  (n) Some flags which allow to choose the orientation and the position of the minimized panes;
  (o) The functions [Get]MinimizeMode() in `AuiPaneInfo` which allow to set/get the flags described above;
  (p) Events like ``EVT_AUI_PANE_DOCKING``, ``EVT_AUI_PANE_DOCKED``, ``EVT_AUI_PANE_FLOATING`` and ``EVT_AUI_PANE_FLOATED`` are
      available for all panes *except* toolbar panes;
  (q) Implementation of the RequestUserAttention method for panes;
  (r) Ability to show the caption bar of docked panes on the left instead of on the top (with caption
      text rotated by 90 degrees then). This is similar to what `wxDockIt` did. To enable this feature on any
      given pane, simply call `CaptionVisible(True, left=True)`;
  (s) New Aero-style docking guides: you can enable them by using the `AuiManager` style ``AUI_MGR_AERO_DOCKING_GUIDES``;
  (t) A slide-in/slide-out preview of minimized panes can be seen by enabling the `AuiManager` style
      ``AUI_MGR_PREVIEW_MINIMIZED_PANES`` and by hovering with the mouse on the minimized pane toolbar tool;
  (u) New Whidbey-style docking guides: you can enable them by using the `AuiManager` style ``AUI_MGR_WHIDBEY_DOCKING_GUIDES``;
  (v) Native of custom-drawn mini frames can be used as floating panes, depending on the ``AUI_MGR_USE_NATIVE_MINIFRAMES`` style;
  (w) A "smooth docking effect" can be obtained by using the ``AUI_MGR_SMOOTH_DOCKING`` style (similar to PyQT docking style);
  (x) Implementation of "Movable" panes, i.e. a pane that is set as `Movable()` but not `Floatable()` can be dragged and docked
      into a new location but will not form a floating window in between.


- AuiNotebook:

  (a) Implementation of the style ``AUI_NB_HIDE_ON_SINGLE_TAB``, a la :mod:`lib.agw.flatnotebook`;
  (b) Implementation of the style ``AUI_NB_SMART_TABS``, a la :mod:`lib.agw.flatnotebook`;
  (c) Implementation of the style ``AUI_NB_USE_IMAGES_DROPDOWN``, which allows to show tab images
      on the tab dropdown menu instead of bare check menu items (a la :mod:`lib.agw.flatnotebook`);
  (d) 6 different tab arts are available, namely:

      (1) Default "glossy" theme (as in :class:`~auibook.AuiNotebook`)
      (2) Simple theme (as in :class:`~auibook.AuiNotebook`)
      (3) Firefox 2 theme
      (4) Visual Studio 2003 theme (VC71)
      (5) Visual Studio 2005 theme (VC81)
      (6) Google Chrome theme

  (e) Enabling/disabling tabs;
  (f) Setting the colour of the tab's text;
  (g) Implementation of the style ``AUI_NB_CLOSE_ON_TAB_LEFT``, which draws the tab close button on
      the left instead of on the right (a la Camino browser);
  (h) Ability to save and load perspectives in `AuiNotebook` (experimental);
  (i) Possibility to add custom buttons in the `AuiNotebook` tab area;
  (j) Implementation of the style ``AUI_NB_TAB_FLOAT``, which allows the floating of single tabs.
      Known limitation: when the notebook is more or less full screen, tabs cannot be dragged far
      enough outside of the notebook to become floating pages;
  (k) Implementation of the style ``AUI_NB_DRAW_DND_TAB`` (on by default), which draws an image
      representation of a tab while dragging;
  (l) Implementation of the `AuiNotebook` unsplit functionality, which unsplit a splitted AuiNotebook
      when double-clicking on a sash;
  (m) Possibility to hide all the tabs by calling `HideAllTAbs`;
  (n) wxPython controls can now be added inside page tabs by calling `AddControlToPage`, and they can be
      removed by calling `RemoveControlFromPage`;
  (o) Possibility to preview all the pages in a `AuiNotebook` (as thumbnails) by using the `NotebookPreview`
      method of `AuiNotebook`;
  (p) Tab labels can be edited by calling the `SetRenamable` method on a `AuiNotebook` page;
  (q) Support for multi-lines tab labels in `AuiNotebook`;
  (r) Support for setting minimum and maximum tab widths for fixed width tabs;
  (s) Implementation of the style ``AUI_NB_ORDER_BY_ACCESS``, which orders the tabs by last access time
      inside the Tab Navigator dialog;
  (t) Implementation of the style ``AUI_NB_NO_TAB_FOCUS``, allowing the developer not to draw the tab
      focus rectangle on tne `AuiNotebook` tabs.

|

- AuiToolBar:

  (a) ``AUI_TB_PLAIN_BACKGROUND`` style that allows to easy setup a plain background to the AUI toolbar,
      without the need to override drawing methods. This style contrasts with the default behaviour
      of the :class:`~auibar.AuiToolBar` that draws a background gradient and this break the window design when
      putting it within a control that has margin between the borders and the toolbar (example: put
      :class:`~auibar.AuiToolBar` within a :class:`StaticBoxSizer` that has a plain background);
  (b) `AuiToolBar` allow item alignment: http://trac.wxwidgets.org/ticket/10174;
  (c) `AUIToolBar` `DrawButton()` improvement: http://trac.wxwidgets.org/ticket/10303;
  (d) `AuiToolBar` automatically assign new id for tools: http://trac.wxwidgets.org/ticket/10173;
  (e) `AuiToolBar` Allow right-click on any kind of button: http://trac.wxwidgets.org/ticket/10079;
  (f) `AuiToolBar` idle update only when visible: http://trac.wxwidgets.org/ticket/10075;
  (g) Ability of creating `AuiToolBar` tools with [counter]clockwise rotation. This allows to propose a
      variant of the minimizing functionality with a rotated button which keeps the caption of the pane
      as label;
  (h) Allow setting the alignment of all tools in a toolbar that is expanded;
  (i) Implementation of the ``AUI_MINIMIZE_POS_TOOLBAR`` flag, which allows to minimize a pane inside
      an existing toolbar. Limitation: if the minimized icon in the toolbar ends up in the overflowing
      items (i.e., a menu is needed to show the icon), this style will not work.



TODOs
=====

- Documentation, documentation and documentation;
- Fix `tabmdi.AuiMDIParentFrame` and friends, they do not work correctly at present;
- Allow specification of `CaptionLeft()` to `AuiPaneInfo` to show the caption bar of docked panes
  on the left instead of on the top (with caption text rotated by 90 degrees then). This is
  similar to what `wxDockIt` did - DONE;
- Make developer-created `AuiNotebooks` and automatic (framemanager-created) `AuiNotebooks` behave
  the same way (undocking of tabs) - DONE, to some extent;
- Find a way to dock panes in already floating panes (`AuiFloatingFrames`), as they already have
  their own `AuiManager`;
- Add more gripper styles (see, i.e., PlusDock 4.0);
- Add an "AutoHide" feature to docked panes, similar to fly-out floating panes (see, i.e., PlusDock 4.0);
- Add events for panes when they are about to float or to be docked (something like
  ``EVT_AUI_PANE_FLOATING/ED`` and ``EVT_AUI_PANE_DOCKING/ED``) - DONE, to some extent;
- Implement the 4-ways splitter behaviour for horizontal and vertical sashes if they intersect;
- Extend `tabart.py` with more aui tab arts;
- Implement ``AUI_NB_LEFT`` and ``AUI_NB_RIGHT`` tab locations in `AuiNotebook`;
- Move `AuiDefaultToolBarArt` into a separate module (as with `tabart.py` and `dockart.py`) and
  provide more arts for toolbars (maybe from :mod:`lib.agw.flatmenu`?)
- Support multiple-rows/multiple columns toolbars;
- Integrate as much as possible with :mod:`lib.agw.flatmenu`, from dropdown menus in `AuiNotebook` to
  toolbars and menu positioning;
- Possibly handle minimization of panes in a different way (or provide an option to switch to
  another way of minimizing panes);
- Clean up/speed up the code, especially time-consuming for-loops;
- Possibly integrate `wxPyRibbon` (still on development), at least on Windows.


License And Version
===================

AUI library is distributed under the wxPython license.

Latest Revision: Andrea Gavana @ 09 Jan 2014, 22.00 GMT

Version 1.3.qhhh	h
]q(h)q}q(hX   wx.lib.agw.aui.aui_constantsqhKhX   This module contains all the constants used by wxPython-AUI.

Especially important and meaningful are constants for AuiManager, AuiDockArt and
AuiNotebook.qhX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_constants.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
qh	h
]q(csphinxtools.librarydescription
Class
q)q}q(hX,   wx.lib.agw.aui.aui_constants.PyEmbeddedImageq hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.q!hhh	h
]q"(csphinxtools.librarydescription
Method
q#)q$}q%(hX5   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.__init__q&hKX   orderq'KhX>   Initialize self.  See help(type(self)) for accurate signature.q(hhh	X	   argumentsq)]q*(X   dataq+hhq,X   isBase64q-X   Trueq.X   Trueq/q0eX	   signatureq1X#   __init__(self, data, isBase64=True)q2X   obj_typeq3X   Method/Functionq4X   number_linesq5X   4q6X   parentq7hubh#)q8}q9(hX6   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetBitmapq:hKh'Khhhhh	h)]q;h1X   GetBitmap(self)q<h3h4h5X   3q=h7hubh#)q>}q?(hX4   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetDataq@hKh'Khhhhh	h)]qAh1X
   GetData(self)qBh3h4h5X   6qCh7hubh#)qD}qE(hX4   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetIconqFhKh'Khhhhh	h)]qGh1X
   GetIcon(self)qHh3h4h5X   5qIh7hubh#)qJ}qK(hX5   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetImageqLhKh'Khhhhh	h)]qMh1X   GetImage(self)qNh3h4h5h6h7hubcsphinxtools.librarydescription
Property
qO)qP}qQ(hX3   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.BitmapqRhKh'Khhhhh	X   getterqSX	   GetBitmapqTX   setterqUhX   deleterqVhh3X   PropertyqWh7hubhO)qX}qY(hX1   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.DataqZhKh'Khhhhh	hSX   GetDataq[hUhhVhh3hWh7hubhO)q\}q](hX1   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.Iconq^hKh'Khhhhh	hSX   GetIconq_hUhhVhh3hWh7hubhO)q`}qa(hX2   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.ImageqbhKh'Khhhhh	hSX   GetImageqchUhhVhh3hWh7hubeX
   class_treeqd]qe(]qfX   objectqga]qh]qiX   PyEmbeddedImageqjaaeX
   subClassesqk]qlX   superClassesqm]qnh1X   PyEmbeddedImage(object)qoX   inheritance_diagramqpNh'Kh3X   ClassqqX   sphinx_fileqrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_constants.PyEmbeddedImage.txtqsh7hh5X   52qtubcsphinxtools.librarydescription
Attribute
qu)qv}qw(hX'   wx.lib.agw.aui.aui_constants.__author__qxhKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.qyhhh	X   valueqzX)   'Andrea Gavana <andrea.gavana@gmail.com>'q{X   specsq|X   strq}h3X	   Attributeq~h7hubhu)q}q(hX%   wx.lib.agw.aui.aui_constants.__date__qhKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.qhhh	hzX   '31 March 2009'qh|X   strqh3h~h7hubhu)q}q(hX.   wx.lib.agw.aui.aui_constants.actionClickButtonqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   2qh|X   intqh3h~h7hubhu)q}q(hX/   wx.lib.agw.aui.aui_constants.actionClickCaptionqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   3qh|X   intqh3h~h7hubhu)q}q(hX3   wx.lib.agw.aui.aui_constants.actionDragFloatingPaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   5qh|X   intqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.actionDragMovablePaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   6qh|X   intqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.actionDragToolbarPaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   4qh|X   intqh3h~h7hubhu)q}q(hX'   wx.lib.agw.aui.aui_constants.actionNoneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   0qh|X   intqh3h~h7hubhu)q}q(hX)   wx.lib.agw.aui.aui_constants.actionResizeqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   1qh|X   intqh3h~h7hubhu)q}q(hX(   wx.lib.agw.aui.aui_constants.aero_deniedqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX+   wx.lib.agw.aui.aui_constants.aero_dock_paneqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ed0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_bottomqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f50>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_centerqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f90>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_deniedqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f10>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX0   wx.lib.agw.aui.aui_constants.aero_dock_pane_leftqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9fd0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX1   wx.lib.agw.aui.aui_constants.aero_dock_pane_rightqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5050>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX/   wx.lib.agw.aui.aui_constants.aero_dock_pane_topqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5090>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX&   wx.lib.agw.aui.aui_constants.aero_downqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd50d0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX,   wx.lib.agw.aui.aui_constants.aero_down_focusqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX3   wx.lib.agw.aui.aui_constants.aero_down_focus_singleqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX-   wx.lib.agw.aui.aui_constants.aero_down_singleqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5150>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX&   wx.lib.agw.aui.aui_constants.aero_leftqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5190>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX,   wx.lib.agw.aui.aui_constants.aero_left_focusqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.aero_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r	  }r
  (hX-   wx.lib.agw.aui.aui_constants.aero_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5210>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.aero_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5250>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.aero_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.aero_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7hubhu)r!  }r"  (hX.   wx.lib.agw.aui.aui_constants.aero_right_singler#  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r$  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd52d0>r%  h|X$   wx.lib.embeddedimage.PyEmbeddedImager&  h3h~h7hubhu)r'  }r(  (hX%   wx.lib.agw.aui.aui_constants.aero_tabr)  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r*  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5310>r+  h|X$   wx.lib.embeddedimage.PyEmbeddedImager,  h3h~h7hubhu)r-  }r.  (hX+   wx.lib.agw.aui.aui_constants.aero_tab_focusr/  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager2  h3h~h7hubhu)r3  }r4  (hX2   wx.lib.agw.aui.aui_constants.aero_tab_focus_singler5  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r6  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r7  h|X$   wx.lib.embeddedimage.PyEmbeddedImager8  h3h~h7hubhu)r9  }r:  (hX,   wx.lib.agw.aui.aui_constants.aero_tab_singler;  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r<  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5390>r=  h|X$   wx.lib.embeddedimage.PyEmbeddedImager>  h3h~h7hubhu)r?  }r@  (hX$   wx.lib.agw.aui.aui_constants.aero_uprA  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rB  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd53d0>rC  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerD  h3h~h7hubhu)rE  }rF  (hX*   wx.lib.agw.aui.aui_constants.aero_up_focusrG  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rH  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>rI  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerJ  h3h~h7hubhu)rK  }rL  (hX1   wx.lib.agw.aui.aui_constants.aero_up_focus_singlerM  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rN  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>rO  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerP  h3h~h7hubhu)rQ  }rR  (hX+   wx.lib.agw.aui.aui_constants.aero_up_singlerS  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rT  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5450>rU  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerV  h3h~h7hubhu)rW  }rX  (hX+   wx.lib.agw.aui.aui_constants.aeroguideSizeXrY  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rZ  hhh	hzX   31r[  h|X   intr\  h3h~h7hubhu)r]  }r^  (hX+   wx.lib.agw.aui.aui_constants.aeroguideSizeYr_  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r`  hhh	hzX   32ra  h|X   intrb  h3h~h7hubhu)rc  }rd  (hX-   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CLOSEre  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rf  hhh	hzX   101rg  h|X   intrh  h3h~h7hubhu)ri  }rj  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM1rk  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rl  hhh	hzX   201rm  h|X   intrn  h3h~h7hubhu)ro  }rp  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM2rq  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rr  hhh	hzX   202rs  h|X   intrt  h3h~h7hubhu)ru  }rv  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM3rw  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rx  hhh	hzX   203ry  h|X   intrz  h3h~h7hubhu)r{  }r|  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM4r}  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r~  hhh	hzX   204r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM5r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   205r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM6r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   206r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM7r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   207r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM8r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   208r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM9r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   209r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_BUTTON_DOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   110r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_BUTTON_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   107r  h|X   intr  h3h~h7hubhu)r  }r  (hX8   wx.lib.agw.aui.aui_constants.AUI_BUTTON_MAXIMIZE_RESTOREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   102r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_BUTTON_MINIMIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   103r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_OPTIONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   105r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_BUTTON_PINr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   104r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_BUTTON_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   108r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_CHECKEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_NORMALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_PRESSEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_BUTTON_UPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   109r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_BUTTON_WINDOWLISTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   106r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7hubhu)r  }r   (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_CENTERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_CENTREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r	  h|X   intr
  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_DOCK_LEFTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_DOCK_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_DOCK_NOTEBOOK_PAGEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_DOCK_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   2r!  h|X   intr"  h3h~h7hubhu)r#  }r$  (hX)   wx.lib.agw.aui.aui_constants.AUI_DOCK_TOPr%  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r&  hhh	hzX   1r'  h|X   intr(  h3h~h7hubhu)r)  }r*  (hX>   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_COLOURr+  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r,  hhh	hzX   8r-  h|X   intr.  h3h~h7hubhu)r/  }r0  (hXG   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r2  hhh	hzX   9r3  h|X   intr4  h3h~h7hubhu)r5  }r6  (hXC   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURr7  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r8  hhh	hzX   12r9  h|X   intr:  h3h~h7hubhu)r;  }r<  (hX:   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BACKGROUND_COLOURr=  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r>  hhh	hzX   5r?  h|X   intr@  h3h~h7hubhu)rA  }rB  (hXC   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURrC  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rD  hhh	hzX   6rE  h|X   intrF  h3h~h7hubhu)rG  }rH  (hX6   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BORDER_COLOURrI  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rJ  hhh	hzX   14rK  h|X   intrL  h3h~h7hubhu)rM  }rN  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_CAPTION_FONTrO  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rP  hhh	hzX   16rQ  h|X   intrR  h3h~h7hubhu)rS  }rT  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_CAPTION_SIZErU  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rV  hhh	hzX   1rW  h|X   intrX  h3h~h7hubhu)rY  }rZ  (hX7   wx.lib.agw.aui.aui_constants.AUI_DOCKART_DRAW_SASH_GRIPr[  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r\  hhh	hzX   18r]  h|X   intr^  h3h~h7hubhu)r_  }r`  (hX6   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRADIENT_TYPEra  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rb  hhh	hzX   17rc  h|X   intrd  h3h~h7hubhu)re  }rf  (hX7   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRIPPER_COLOURrg  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rh  hhh	hzX   15ri  h|X   intrj  h3h~h7hubhu)rk  }rl  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRIPPER_SIZErm  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rn  hhh	hzX   2ro  h|X   intrp  h3h~h7hubhu)rq  }rr  (hX;   wx.lib.agw.aui.aui_constants.AUI_DOCKART_HINT_WINDOW_COLOURrs  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rt  hhh	hzX   19ru  h|X   intrv  h3h~h7hubhu)rw  }rx  (hX@   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_COLOURry  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rz  hhh	hzX   10r{  h|X   intr|  h3h~h7hubhu)r}  }r~  (hXI   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7hubhu)r  }r  (hXE   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7hubhu)r  }r  (hX9   wx.lib.agw.aui.aui_constants.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7hubhu)r  }r  (hX9   wx.lib.agw.aui.aui_constants.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX8   wx.lib.agw.aui.aui_constants.AUI_MGR_AERO_DOCKING_GUIDESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_ANIMATE_FRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_MGR_AUTONB_NO_CAPTIONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_MGR_DEFAULTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_MGR_HINT_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_MGR_LIVE_RESIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r  }r  (hX<   wx.lib.agw.aui.aui_constants.AUI_MGR_NO_VENETIAN_BLINDS_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7hubhu)r  }r  (hX<   wx.lib.agw.aui.aui_constants.AUI_MGR_PREVIEW_MINIMIZED_PANESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr   h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_RECTANGLE_HINTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_SMOOTH_DOCKINGr	  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   8192r  h|X   intr  h3h~h7hubhu)r
  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_MGR_TRANSPARENT_DRAGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_MGR_TRANSPARENT_HINTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r  (hX:   wx.lib.agw.aui.aui_constants.AUI_MGR_USE_NATIVE_MINIFRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7hubhu)r  }r   (hX9   wx.lib.agw.aui.aui_constants.AUI_MGR_VENETIAN_BLINDS_HINTr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   16r#  h|X   intr$  h3h~h7hubhu)r%  }r&  (hX;   wx.lib.agw.aui.aui_constants.AUI_MGR_WHIDBEY_DOCKING_GUIDESr'  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r(  hhh	hzX   4096r)  h|X   intr*  h3h~h7hubhu)r+  }r,  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_HIDEr-  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r.  hhh	hzX   0r/  h|X   intr0  h3h~h7hubhu)r1  }r2  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_HORZr3  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r4  hhh	hzX   16r5  h|X   intr6  h3h~h7hubhu)r7  }r8  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_MASKr9  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r:  hhh	hzX   24r;  h|X   intr<  h3h~h7hubhu)r=  }r>  (hX4   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_SMARTr?  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r@  hhh	hzX   8rA  h|X   intrB  h3h~h7hubhu)rC  }rD  (hX4   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_BOTTOMrE  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rF  hhh	hzX   5rG  h|X   intrH  h3h~h7hubhu)rI  }rJ  (hX2   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_LEFTrK  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rL  hhh	hzX   3rM  h|X   intrN  h3h~h7hubhu)rO  }rP  (hX2   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_MASKrQ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rR  hhh	hzX   23rS  h|X   intrT  h3h~h7hubhu)rU  }rV  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_RIGHTrW  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rX  hhh	hzX   4rY  h|X   intrZ  h3h~h7hubhu)r[  }r\  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_SMARTr]  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r^  hhh	hzX   1r_  h|X   intr`  h3h~h7hubhu)ra  }rb  (hX5   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_TOOLBARrc  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rd  hhh	hzX   6re  h|X   intrf  h3h~h7hubhu)rg  }rh  (hX1   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_TOPri  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rj  hhh	hzX   2rk  h|X   intrl  h3h~h7hubhu)rm  }rn  (hX*   wx.lib.agw.aui.aui_constants.AUI_NB_BOTTOMro  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rp  hhh	hzX   8rq  h|X   intrr  h3h~h7hubhu)rs  }rt  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_BUTTONru  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rv  hhh	hzX   1024rw  h|X   intrx  h3h~h7hubhu)ry  }rz  (hX7   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_ACTIVE_TABr{  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r|  hhh	hzX   2048r}  h|X   intr~  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_NB_SCROLL_BUTTONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_EXTERNAL_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   524288r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_SPLITr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.AUI_NB_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX7   wx.lib.agw.aui.aui_constants.AUI_NB_USE_IMAGES_DROPDOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   131072r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_WINDOWLIST_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_CLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_TB_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7hubhu)r	  }r
  (hX1   wx.lib.agw.aui.aui_constants.AUI_TB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r
  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_TB_GRIPPERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_TB_HORZ_LAYOUTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_HORZ_TEXTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65r  h|X   intr   h3h~h7hubhu)r!  }r"  (hX1   wx.lib.agw.aui.aui_constants.AUI_TB_NO_AUTORESIZEr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r$  hhh	hzX   4r%  h|X   intr&  h3h~h7hubhu)r'  }r(  (hX/   wx.lib.agw.aui.aui_constants.AUI_TB_NO_TOOLTIPSr)  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r*  hhh	hzX   2r+  h|X   intr,  h3h~h7hubhu)r-  }r.  (hX,   wx.lib.agw.aui.aui_constants.AUI_TB_OVERFLOWr/  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r0  hhh	hzX   16r1  h|X   intr2  h3h~h7hubhu)r3  }r4  (hX4   wx.lib.agw.aui.aui_constants.AUI_TB_PLAIN_BACKGROUNDr5  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r6  hhh	hzX   128r7  h|X   intr8  h3h~h7hubhu)r9  }r:  (hX(   wx.lib.agw.aui.aui_constants.AUI_TB_TEXTr;  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r<  hhh	hzX   1r=  h|X   intr>  h3h~h7hubhu)r?  }r@  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_VERT_TEXTrA  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rB  hhh	hzX   289rC  h|X   intrD  h3h~h7hubhu)rE  }rF  (hX,   wx.lib.agw.aui.aui_constants.AUI_TB_VERTICALrG  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rH  hhh	hzX   32rI  h|X   intrJ  h3h~h7hubhu)rK  }rL  (hX3   wx.lib.agw.aui.aui_constants.AUI_TBART_GRIPPER_SIZErM  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rN  hhh	hzX   1rO  h|X   intrP  h3h~h7hubhu)rQ  }rR  (hX4   wx.lib.agw.aui.aui_constants.AUI_TBART_OVERFLOW_SIZErS  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rT  hhh	hzX   2rU  h|X   intrV  h3h~h7hubhu)rW  }rX  (hX5   wx.lib.agw.aui.aui_constants.AUI_TBART_SEPARATOR_SIZErY  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rZ  hhh	hzX   0r[  h|X   intr\  h3h~h7hubhu)r]  }r^  (hX2   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_HORIZONTALr_  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r`  hhh	hzX   0ra  h|X   intrb  h3h~h7hubhu)rc  }rd  (hX3   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_BOTTOMre  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rf  hhh	hzX   3rg  h|X   intrh  h3h~h7hubhu)ri  }rj  (hX1   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_LEFTrk  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rl  hhh	hzX   0rm  h|X   intrn  h3h~h7hubhu)ro  }rp  (hX2   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_RIGHTrq  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rr  hhh	hzX   1rs  h|X   intrt  h3h~h7hubhu)ru  }rv  (hX0   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_TOPrw  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rx  hhh	hzX   2ry  h|X   intrz  h3h~h7hubhu)r{  }r|  (hX6   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_VERT_CLOCKWISEr}  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r~  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX=   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AuiBaseTabCtrlIdr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5380r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.auiInsertRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.auiLayerInsertOffsetr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.auiLayerInsertPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.auiNewRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.auinotebook_previewr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd54d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.auiToolBarLayerr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.BUTTON_DROPDOWN_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.colourHintBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(0, 64, 255, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.colourIconArrowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(77, 79, 170, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.colourIconBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(255, 255, 255, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.colourIconBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(82, 65, 156, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourIconDockingPart1r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(215, 228, 243, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourIconDockingPart2r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(180, 201, 225, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.colourIconShadowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(198, 198, 198, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourTargetBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(224, 224, 224, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.colourTargetBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(180, 180, 180, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.colourTargetShader  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(206, 206, 206, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.DISABLED_TEXT_COLOURr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(153, 153, 153, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r   (hX3   wx.lib.agw.aui.aui_constants.DISABLED_TEXT_GREY_HUEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   153r  h|X   intr  h3h~h7hubhu)r  }r  (hX!   wx.lib.agw.aui.aui_constants.downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c50>r	  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.down_focusr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd99d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.down_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.guideSizeXr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   29r!  h|X   intr"  h3h~h7hubhu)r#  }r$  (hX'   wx.lib.agw.aui.aui_constants.guideSizeYr%  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r&  hhh	hzX   32r'  h|X   intr(  h3h~h7hubhu)r)  }r*  (hX-   wx.lib.agw.aui.aui_constants.ID_RESTORE_FRAMEr+  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r,  hhh	hzX   15999r-  h|X   intr.  h3h~h7hubhu)r/  }r0  (hX'   wx.lib.agw.aui.aui_constants.ITEM_CHECKr1  hKh'Khhhhh	hzX   1r2  h|X   wx._core.ItemKindr3  h3h~h7hubhu)r4  }r5  (hX)   wx.lib.agw.aui.aui_constants.ITEM_CONTROLr6  hKh'Khhhhh	hzX   4r7  h|X   wx._core.ItemKindr8  h3h~h7hubhu)r9  }r:  (hX'   wx.lib.agw.aui.aui_constants.ITEM_LABELr;  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r<  hhh	hzX   5r=  h|X   intr>  h3h~h7hubhu)r?  }r@  (hX(   wx.lib.agw.aui.aui_constants.ITEM_NORMALrA  hKh'Khhhhh	hzX   0rB  h|X   wx._core.ItemKindrC  h3h~h7hubhu)rD  }rE  (hX'   wx.lib.agw.aui.aui_constants.ITEM_RADIOrF  hKh'Khhhhh	hzX   2rG  h|X   wx._core.ItemKindrH  h3h~h7hubhu)rI  }rJ  (hX+   wx.lib.agw.aui.aui_constants.ITEM_SEPARATORrK  hKh'Khhhhh	hzX   -1rL  h|X   wx._core.ItemKindrM  h3h~h7hubhu)rN  }rO  (hX(   wx.lib.agw.aui.aui_constants.ITEM_SPACERrP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   6rR  h|X   intrS  h3h~h7hubhu)rT  }rU  (hX!   wx.lib.agw.aui.aui_constants.leftrV  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rW  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9cd0>rX  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerY  h3h~h7hubhu)rZ  }r[  (hX'   wx.lib.agw.aui.aui_constants.left_focusr\  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r]  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d10>r^  h|X$   wx.lib.embeddedimage.PyEmbeddedImager_  h3h~h7hubhu)r`  }ra  (hX.   wx.lib.agw.aui.aui_constants.left_focus_singlerb  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rc  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a50>rd  h|X$   wx.lib.embeddedimage.PyEmbeddedImagere  h3h~h7hubhu)rf  }rg  (hX(   wx.lib.agw.aui.aui_constants.left_singlerh  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ri  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a90>rj  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerk  h3h~h7hubhu)rl  }rm  (hX%   wx.lib.agw.aui.aui_constants.max_bitsrn  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerro  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'rp  h|X   bytesrq  h3h~h7hubhu)rr  }rs  (hX*   wx.lib.agw.aui.aui_constants.minimize_bitsrt  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerru  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'rv  h|X   bytesrw  h3h~h7hubhu)rx  }ry  (hX%   wx.lib.agw.aui.aui_constants.Mondrianrz  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r{  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9990>r|  h|X$   wx.lib.embeddedimage.PyEmbeddedImager}  h3h~h7hubhu)r~  }r  (hX*   wx.lib.agw.aui.aui_constants.nb_close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.nb_left_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.nb_list_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.nb_right_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX%   wx.lib.agw.aui.aui_constants.pin_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.restore_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.restore_xpmr  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r  h|X   listr  h3h~h7hubhu)r  }r  (hX"   wx.lib.agw.aui.aui_constants.rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ad0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.SWITCHER_TEXT_MARGIN_Xr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.SWITCHER_TEXT_MARGIN_Yr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX    wx.lib.agw.aui.aui_constants.tabr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9dd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.tab_active_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.tab_active_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.tab_active_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX&   wx.lib.agw.aui.aui_constants.tab_closer  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bdee90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.tab_close_hr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9850>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.tab_close_pr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9890>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX&   wx.lib.agw.aui.aui_constants.tab_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.tab_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b50>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.tab_inactive_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd98d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r	  (hX.   wx.lib.agw.aui.aui_constants.tab_inactive_leftr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9910>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.tab_inactive_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9950>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.tab_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX   wx.lib.agw.aui.aui_constants.upr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r   }r!  (hX%   wx.lib.agw.aui.aui_constants.up_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r#  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e90>r$  h|X$   wx.lib.embeddedimage.PyEmbeddedImager%  h3h~h7hubhu)r&  }r'  (hX,   wx.lib.agw.aui.aui_constants.up_focus_singler(  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r)  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9bd0>r*  h|X$   wx.lib.embeddedimage.PyEmbeddedImager+  h3h~h7hubhu)r,  }r-  (hX&   wx.lib.agw.aui.aui_constants.up_singler.  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r/  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7hubhu)r2  }r3  (hX4   wx.lib.agw.aui.aui_constants.vertical_border_paddingr4  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r5  hhh	hzX   4r6  h|X   intr7  h3h~h7hubhu)r8  }r9  (hX+   wx.lib.agw.aui.aui_constants.whidbey_deniedr:  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r;  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>r<  h|X$   wx.lib.embeddedimage.PyEmbeddedImager=  h3h~h7hubhu)r>  }r?  (hX.   wx.lib.agw.aui.aui_constants.whidbey_dock_paner@  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rA  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf610>rB  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerC  h3h~h7hubhu)rD  }rE  (hX5   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_bottomrF  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rG  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf750>rH  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerI  h3h~h7hubhu)rJ  }rK  (hX5   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_centerrL  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rM  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf790>rN  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerO  h3h~h7hubhu)rP  }rQ  (hX3   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_leftrR  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rS  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c950>rT  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerU  h3h~h7hubhu)rV  }rW  (hX4   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_rightrX  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rY  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c8d0>rZ  h|X$   wx.lib.embeddedimage.PyEmbeddedImager[  h3h~h7hubhu)r\  }r]  (hX2   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_topr^  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r_  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c9d0>r`  h|X$   wx.lib.embeddedimage.PyEmbeddedImagera  h3h~h7hubhu)rb  }rc  (hX)   wx.lib.agw.aui.aui_constants.whidbey_downrd  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.re  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>rf  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerg  h3h~h7hubhu)rh  }ri  (hX/   wx.lib.agw.aui.aui_constants.whidbey_down_focusrj  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rk  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>rl  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerm  h3h~h7hubhu)rn  }ro  (hX6   wx.lib.agw.aui.aui_constants.whidbey_down_focus_singlerp  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rq  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>rr  h|X$   wx.lib.embeddedimage.PyEmbeddedImagers  h3h~h7hubhu)rt  }ru  (hX0   wx.lib.agw.aui.aui_constants.whidbey_down_singlerv  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rw  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>rx  h|X$   wx.lib.embeddedimage.PyEmbeddedImagery  h3h~h7hubhu)rz  }r{  (hX)   wx.lib.agw.aui.aui_constants.whidbey_leftr|  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r}  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r~  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.whidbey_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.whidbey_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.whidbey_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.whidbey_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.whidbey_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX7   wx.lib.agw.aui.aui_constants.whidbey_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.whidbey_right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.whidbey_upr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.whidbey_up_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.whidbey_up_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.whidbey_up_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.whidbeySizeXr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   43r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.whidbeySizeYr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   30r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.wxWINDOWCLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4001r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.wxWINDOWCLOSEALLr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4002r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.wxWINDOWNEXTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4003r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.wxWINDOWPREVr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4004r  h|X   intr  h3h~h7hubeX   filenamer  XB   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_constants.pyr  hrXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_constants.txtr  h'Kh3X	   Py_Moduler  hpNh7hubh)r  }r  (hX!   wx.lib.agw.aui.aui_switcherdialogr  hKhX  Description
===========

The idea of `SwitcherDialog` is to make it easier to implement keyboard
navigation in AUI and other applications that have multiple panes and
tabs.

A key combination with a modifier (such as ``Ctrl`` + ``Tab``) shows the
dialog, and the user holds down the modifier whilst navigating with
``Tab`` and arrow keys before releasing the modifier to dismiss the dialog
and activate the selected pane.

The switcher dialog is a multi-column menu with no scrolling, implemented
by the :class:`MultiColumnListCtrl` class. You can have headings for your items
for logical grouping, and you can force a column break if you need to.

The modifier used for invoking and dismissing the dialog can be customised,
as can the colours, number of rows, and the key used for cycling through
the items. So you can use different keys on different platforms if
required (especially since ``Ctrl`` + ``Tab`` is reserved on some platforms).

Items are shown as names and optional 16x16 images.


Base Functionalities
====================

To use the dialog, you set up the items in a `SwitcherItems` object,
before passing this to the `SwitcherDialog` instance.

Call :meth:`SwitcherItems.AddItem` and optionally :meth:`SwitcherItems.AddGroup`
to add items and headings. These functions take a label (to be displayed to the user),
an identifying name, an integer id, and a bitmap. The name and id are purely for
application-defined identification. You may also set a description to be displayed
when each item is selected; and you can set a window pointer for convenience when
activating the desired window after the dialog returns.

Have created the dialog, you call :meth:`~Dialog.ShowModal`, and if the return value is
``wx.ID_OK``, retrieve the selection from the dialog and activate the pane.

The sample code below shows a generic method of finding panes and notebook
tabs within the current :class:`~wx.lib.agw.aui.framemanager.AuiManager`, and using the pane name or notebook
tab position to display the pane.

The only other code to add is a menu item with the desired accelerator,
whose modifier matches the one you pass to :meth:`SwitcherDialog.SetModifierKey`
(the default being ``wx.WXK_CONTROL``).


Usage
=====

Menu item::

    if wx.Platform == "__WXMAC__":
        switcherAccel = "Alt+Tab"
    elif wx.Platform == "__WXGTK__":
        switcherAccel = "Ctrl+/"
    else:
        switcherAccel = "Ctrl+Tab"

    view_menu.Append(ID_SwitchPane, _("S&witch Window...") + "  " + switcherAccel)


Event handler::

    def OnSwitchPane(self, event):

        items = SwitcherItems()
        items.SetRowCount(12)

        # Add the main windows and toolbars, in two separate columns
        # We'll use the item 'id' to store the notebook selection, or -1 if not a page

        for k in range(2):
            if k == 0:
                items.AddGroup(_("Main Windows"), "mainwindows")
            else:
                items.AddGroup(_("Toolbars"), "toolbars").BreakColumn()

            for pane in self._mgr.GetAllPanes():
                name = pane.name
                caption = pane.caption

                toolbar = isinstance(info.window, wx.ToolBar) or isinstance(info.window, aui.AuiToolBar)
                if caption and (toolBar  and k == 1) or (not toolBar and k == 0):
                    items.AddItem(caption, name, -1).SetWindow(pane.window)

        # Now add the wxAuiNotebook pages

        items.AddGroup(_("Notebook Pages"), "pages").BreakColumn()

        for pane in self._mgr.GetAllPanes():
            nb = pane.window
            if isinstance(nb, aui.AuiNotebook):
                for j in range(nb.GetPageCount()):

                    name = nb.GetPageText(j)
                    win = nb.GetPage(j)

                    items.AddItem(name, name, j, nb.GetPageBitmap(j)).SetWindow(win)

        # Select the focused window

        idx = items.GetIndexForFocus()
        if idx != wx.NOT_FOUND:
            items.SetSelection(idx)

        if wx.Platform == "__WXMAC__":
            items.SetBackgroundColour(wx.WHITE)

        # Show the switcher dialog

        dlg = SwitcherDialog(items, wx.GetApp().GetTopWindow())

        # In GTK+ we can't use Ctrl+Tab; we use Ctrl+/ instead and tell the switcher
        # to treat / in the same was as tab (i.e. cycle through the names)

        if wx.Platform == "__WXGTK__":
            dlg.SetExtraNavigationKey(wxT('/'))

        if wx.Platform == "__WXMAC__":
            dlg.SetBackgroundColour(wx.WHITE)
            dlg.SetModifierKey(wx.WXK_ALT)

        ans = dlg.ShowModal()

        if ans == wx.ID_OK and dlg.GetSelection() != -1:
            item = items.GetItem(dlg.GetSelection())

            if item.GetId() == -1:
                info = self._mgr.GetPane(item.GetName())
                info.Show()
                self._mgr.Update()
                info.window.SetFocus()

            else:
                nb = item.GetWindow().GetParent()
                win = item.GetWindow();
                if isinstance(nb, aui.AuiNotebook):
                    nb.SetSelection(item.GetId())
                    win.SetFocus()r  hXf  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_switcherdialog.py
# Purpose:
#
# Author:
#
# Created:
# Version:
# Date:
# Licence:      wxWindows license
# Tags:         phoenix-port, documented, py3-port
#----------------------------------------------------------------------------
r  h	h
]r  (h)r  }r  (hX5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  hKhX;   A control for displaying several columns (not scrollable). r  hhh	h
]r  (h#)r  }r  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.__init__r  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r  hhh	h)]r  (X   parentr  hhr  X   aui_managerr  hhr  X   idr  X	   wx.ID_ANYr  X   -1r   r  X   posr  X   wx.DefaultPositionr  X   (-1, -1)r  r  X   sizer  X   wx.DefaultSizer  X   (-1, -1)r  r	  X   styler
  X   0r  X   0r  r
  X	   validatorr  X   wx.DefaultValidatorr  X-   <wx._core.Validator object at 0x7f20f7ecc2d0>r  r  X   namer  X   "MultiColumnListCtrl"r  X   MultiColumnListCtrlr  r  eh1X   __init__(self, parent, aui_manager, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name="MultiColumnListCtrl")r  h3h4h5X   20r  h7j  ubh#)r  }r  (hXQ   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.AdvanceToNextSelectableItemr  hKh'Khhhhh	h)]r  X	   directionr  hhr  ah1X,   AdvanceToNextSelectableItem(self, direction)r  h3h4h5X   50r  h7j  ubh#)r   }r!  (hXE   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.CalculateLayoutr"  hKh'Khhhhh	h)]r#  X   dcr$  X   Noner%  X   Noner&  r'  ah1X   CalculateLayout(self, dc=None)r(  h3h4h5X   74r)  h7j  ubh#)r*  }r+  (hXC   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.DoGetBestSizer,  hKh'KhX   DoGetBestSize(self) -> Sizer-  hhh	h)]r.  h1X   DoGetBestSize(self)r/  h3h4h5h6h7j  ubh#)r0  }r1  (hXL   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GenerateSelectionEventr2  hKh'Khhhhh	h)]r3  h1X   GenerateSelectionEvent(self)r4  h3h4h5X   7r5  h7j  ubh#)r6  }r7  (hXK   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetExtraNavigationKeyr8  hKh'Khhhhh	h)]r9  h1X   GetExtraNavigationKey(self)r:  h3h4h5h6h7j  ubh#)r;  }r<  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetItemsr=  hKh'Khhhhh	h)]r>  h1X   GetItems(self)r?  h3h4h5h6h7j  ubh#)r@  }rA  (hXD   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetModifierKeyrB  hKh'Khhhhh	h)]rC  h1X   GetModifierKey(self)rD  h3h4h5h6h7j  ubh#)rE  }rF  (hX<   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnCharrG  hKh'Khhhhh	h)]rH  X   eventrI  hhrJ  ah1X   OnChar(self, event)rK  h3h4h5h6h7j  ubh#)rL  }rM  (hXG   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnEraseBackgroundrN  hKh'Khhhhh	h)]rO  X   eventrP  hhrQ  ah1X   OnEraseBackground(self, event)rR  h3h4h5h6h7j  ubh#)rS  }rT  (hX;   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnKeyrU  hKh'Khhhhh	h)]rV  X   eventrW  hhrX  ah1X   OnKey(self, event)rY  h3h4h5X   120rZ  h7j  ubh#)r[  }r\  (hXB   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnMouseEventr]  hKh'Khhhhh	h)]r^  X   eventr_  hhr`  ah1X   OnMouseEvent(self, event)ra  h3h4h5hIh7j  ubh#)rb  }rc  (hX=   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnPaintrd  hKh'Khhhhh	h)]re  X   eventrf  hhrg  ah1X   OnPaint(self, event)rh  h3h4h5X   13ri  h7j  ubh#)rj  }rk  (hXK   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetExtraNavigationKeyrl  hKh'KhXo   Set an extra key that can be used to cycle through items,
in case not using the ``Ctrl`` + ``Tab`` combination.rm  hhh	h)]rn  X   keyCodero  hhrp  ah1X$   SetExtraNavigationKey(self, keyCode)rq  h3h4h5X   8rr  h7j  ubh#)rs  }rt  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetItemsru  hKh'Khhhhh	h)]rv  X   itemsrw  hhrx  ah1X   SetItems(self, items)ry  h3h4h5h6h7j  ubh#)rz  }r{  (hXD   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetModifierKeyr|  hKh'KhXN   Set the modifier used to invoke the dialog, and therefore to test for release.r}  hhh	h)]r~  X   modifierKeyr  hhr  ah1X!   SetModifierKey(self, modifierKey)r  h3h4h5j5  h7j  ubh#)r  }r  (hXE   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetTransparencyr  hKh'Khhhhh	h)]r  X	   selectionr  X   Noner  X   Noner  r  ah1X%   SetTransparency(self, selection=None)r  h3h4h5X   14r  h7j  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  X   Objectr  a]r  (]r  X
   EvtHandlerr  a]r  (]r  X
   WindowBaser  a]r  (]r  X   Windowr  a]r  (]r  X   Controlr  a]r  ]r  j  aaeeee]r  X	   Trackabler  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeeehk]r  hm]r  X
   wx.Controlr  ah1X   MultiColumnListCtrl(wx.Control)r  hpcsphinxtools.inheritance
InheritanceDiagram
r  )r  }r  (X
   class_infor  ]r  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  ]r  X
   wx.Controlr  ar  X
   wx.Controlr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  eX   specialsr  ]r  X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  aX
   main_classr  j  ubh'Kh3hqhrXh   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.txtr  h7j  h5X   370r  X   method_listr  ]r  (X   __init__r  X   AdvanceToNextSelectableItemr  X   CalculateLayoutr  X
   DoGetBestSizer  X   GenerateSelectionEventr  X   GetExtraNavigationKeyr  X   GetItemsr  X   GetModifierKeyr  X   OnCharr  X   OnEraseBackgroundr  X   OnKeyr  X   OnMouseEventr  X   OnPaintr  X   SetExtraNavigationKeyr  X   SetItemsr  X   SetModifierKeyr  X   SetTransparencyr  eX   basesr  j  ubh)r  }r  (hX0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  hKhX   SwitcherDialog shows a :class:`Dialog` with a list of panes and tabs for the user to choose.
``Ctrl`` + ``Tab`` cycles through them.r  hhh	h
]r  (h#)r  }r  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  (X   itemsr  hhr  X   parentr  hhr  X   aui_managerr  hhr  X   idr   X	   wx.ID_ANYr  X   -1r  r  X   titler  X   _("Pane Switcher")r  X
   Pane Switcherr  r  X   posr  X   wx.DefaultPositionr	  X   (-1, -1)r
  r  X   sizer  X   wx.DefaultSizer
  X   (-1, -1)r  r  X   styler  X3   wx.STAY_ON_TOP|wx.DIALOG_NO_PARENT|wx.BORDER_SIMPLEr  X   33587232r  r  eh1X   __init__(self, items, parent, aui_manager, id=wx.ID_ANY, title=_("Pane Switcher"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.STAY_ON_TOP|wx.DIALOG_NO_PARENT|wx.BORDER_SIMPLE)r  h3h4h5X   56r  h7j  ubh#)r  }r  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.ColourToHexStringr  hKh'Khhhhh	h)]r  X   colr  hhr  ah1X   ColourToHexString(self, col)r  h3h4h5hIh7j  ubh#)r  }r  (hXF   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetExtraNavigationKeyr  hKh'Khhhhh	h)]r   h1X   GetExtraNavigationKey(self)r!  h3h4h5h6h7j  ubh#)r"  }r#  (hX?   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetModifierKeyr$  hKh'Khhhhh	h)]r%  h1X   GetModifierKey(self)r&  h3h4h5h6h7j  ubh#)r'  }r(  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetSelectionr)  hKh'Khhhhh	h)]r*  h1X   GetSelection(self)r+  h3h4h5h6h7j  ubh#)r,  }r-  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnActivater.  hKh'Khhhhh	h)]r/  X   eventr0  hhr1  ah1X   OnActivate(self, event)r2  h3h4h5j5  h7j  ubh#)r3  }r4  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnCloseWindowr5  hKh'Khhhhh	h)]r6  X   eventr7  hhr8  ah1X   OnCloseWindow(self, event)r9  h3h4h5X   15r:  h7j  ubh#)r;  }r<  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnPaintr=  hKh'Khhhhh	h)]r>  X   eventr?  hhr@  ah1X   OnPaint(self, event)rA  h3h4h5X   17rB  h7j  ubh#)rC  }rD  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnSelectItemrE  hKh'Khhhhh	h)]rF  X   eventrG  hhrH  ah1X   OnSelectItem(self, event)rI  h3h4h5h6h7j  ubh#)rJ  }rK  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetBorderColourrL  hKh'Khhhhh	h)]rM  X   colourrN  hhrO  ah1X   SetBorderColour(self, colour)rP  h3h4h5h6h7j  ubh#)rQ  }rR  (hXF   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetExtraNavigationKeyrS  hKh'Khhhhh	h)]rT  X   keyCoderU  hhrV  ah1X$   SetExtraNavigationKey(self, keyCode)rW  h3h4h5hCh7j  ubh#)rX  }rY  (hX?   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetModifierKeyrZ  hKh'Khhhhh	h)]r[  X   modifierKeyr\  hhr]  ah1X!   SetModifierKey(self, modifierKey)r^  h3h4h5hCh7j  ubh#)r_  }r`  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.ShowDescriptionra  hKh'Khhhhh	h)]rb  X   irc  hhrd  ah1X   ShowDescription(self, i)re  h3h4h5X   18rf  h7j  ubehd]rg  (]rh  X   objectri  a]rj  (]rk  X
   simplewrapperrl  a]rm  (]rn  X   wrapperro  a]rp  (]rq  j  a]rr  (]rs  j  a]rt  (]ru  j  a]rv  (]rw  j  a]rx  (]ry  X   NonOwnedWindowrz  a]r{  (]r|  X   TopLevelWindowr}  a]r~  (]r  X   Dialogr  a]r  ]r  X   SwitcherDialogr  aaeeeeee]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  jz  a]r  (]r  j}  a]r  (]r  j  a]r  ]r  j  aaeeeeeeeeeehk]r  hm]r  X	   wx.Dialogr  ah1X   SwitcherDialog(wx.Dialog)r  hpj  )r  }r  (j  ]r  (X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  ]r  X	   wx.Dialogr  ar  X	   wx.Dialogr  ]r  X   wx.TopLevelWindowr  ar  X   wx.TopLevelWindowr  ]r  X   wx.NonOwnedWindowr  ar  X   wx.NonOwnedWindowr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  ej  ]r  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  aj  j  ubh'Kh3hqhrXc   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.txtr  h7j  h5X   169r  j  ]r  (X   __init__r  X   ColourToHexStringr  X   GetExtraNavigationKeyr  X   GetModifierKeyr  X   GetSelectionr  X
   OnActivater  X
   OnCloseWindowr  X   OnPaintr  X   OnSelectItemr  X   SetBorderColourr  X   SetExtraNavigationKeyr  X   SetModifierKeyr  X   ShowDescriptionr  ej  j  ubh)r  }r  (hX.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  hKhX1   An object containing information about one item. r  hhh	h
]r  (h#)r  }r  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  X   itemr  X   Noner  X   Noner  r  ah1X   __init__(self, item=None)r  h3h4h5X   18r  h7j  ubh#)r  }r  (hX:   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.BreakColumnr  hKh'Khhhhh	h)]r  X   breakColr  X   Truer  h/r  ah1X    BreakColumn(self, breakCol=True)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.Copyr  hKh'KhXs   Copy operator between 2 :class:`SwitcherItem` instances.

:param `item`: another instance of :class:`SwitcherItem`.r  hhh	h)]r  X   itemr  hhr  ah1X   Copy(self, item)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetBitmapr  hKh'Khhhhh	h)]r  h1X   GetBitmap(self)r  h3h4h5h6h7j  ubh#)r  }r  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetBreakColumnr  hKh'Khhhhh	h)]r  h1X   GetBreakColumn(self)r  h3h4h5h6h7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetColPosr  hKh'Khhhhh	h)]r  h1X   GetColPos(self)r  h3h4h5h6h7j  ubh#)r  }r 	  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetDescriptionr	  hKh'Khhhhh	h)]r	  h1X   GetDescription(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetFontr	  hKh'Khhhhh	h)]r	  h1X
   GetFont(self)r	  h3h4h5h6h7j  ubh#)r		  }r
	  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetIdr	  hKh'Khhhhh	h)]r	  h1X   GetId(self)r
	  h3h4h5h6h7j  ubh#)r	  }r	  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetIsGroupr	  hKh'Khhhhh	h)]r	  h1X   GetIsGroup(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetNamer	  hKh'Khhhhh	h)]r	  h1X
   GetName(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetRectr	  hKh'Khhhhh	h)]r	  h1X
   GetRect(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetRowPosr	  hKh'Khhhhh	h)]r 	  h1X   GetRowPos(self)r!	  h3h4h5h6h7j  ubh#)r"	  }r#	  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetTextColourr$	  hKh'Khhhhh	h)]r%	  h1X   GetTextColour(self)r&	  h3h4h5h6h7j  ubh#)r'	  }r(	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetTitler)	  hKh'Khhhhh	h)]r*	  h1X   GetTitle(self)r+	  h3h4h5h6h7j  ubh#)r,	  }r-	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetWindowr.	  hKh'Khhhhh	h)]r/	  h1X   GetWindow(self)r0	  h3h4h5h6h7j  ubh#)r1	  }r2	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetBitmapr3	  hKh'Khhhhh	h)]r4	  X   bitmapr5	  hhr6	  ah1X   SetBitmap(self, bitmap)r7	  h3h4h5hIh7j  ubh#)r8	  }r9	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetColPosr:	  hKh'Khhhhh	h)]r;	  X   posr<	  hhr=	  ah1X   SetColPos(self, pos)r>	  h3h4h5hIh7j  ubh#)r?	  }r@	  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetDescriptionrA	  hKh'Khhhhh	h)]rB	  X   descrrC	  hhrD	  ah1X   SetDescription(self, descr)rE	  h3h4h5hIh7j  ubh#)rF	  }rG	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetFontrH	  hKh'Khhhhh	h)]rI	  X   fontrJ	  hhrK	  ah1X   SetFont(self, font)rL	  h3h4h5hIh7j  ubh#)rM	  }rN	  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetIdrO	  hKh'Khhhhh	h)]rP	  X   idrQ	  hhrR	  ah1X   SetId(self, id)rS	  h3h4h5hIh7j  ubh#)rT	  }rU	  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetIsGrouprV	  hKh'Khhhhh	h)]rW	  X   isGrouprX	  hhrY	  ah1X   SetIsGroup(self, isGroup)rZ	  h3h4h5hIh7j  ubh#)r[	  }r\	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetNamer]	  hKh'Khhhhh	h)]r^	  X   namer_	  hhr`	  ah1X   SetName(self, name)ra	  h3h4h5hIh7j  ubh#)rb	  }rc	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetRectrd	  hKh'Khhhhh	h)]re	  X   rectrf	  hhrg	  ah1X   SetRect(self, rect)rh	  h3h4h5hIh7j  ubh#)ri	  }rj	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetRowPosrk	  hKh'Khhhhh	h)]rl	  X   posrm	  hhrn	  ah1X   SetRowPos(self, pos)ro	  h3h4h5hIh7j  ubh#)rp	  }rq	  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetTextColourrr	  hKh'Khhhhh	h)]rs	  X   colourrt	  hhru	  ah1X   SetTextColour(self, colour)rv	  h3h4h5hIh7j  ubh#)rw	  }rx	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetTitlery	  hKh'Khhhhh	h)]rz	  X   titler{	  hhr|	  ah1X   SetTitle(self, title)r}	  h3h4h5hIh7j  ubh#)r~	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetWindowr	  hKh'Khhhhh	h)]r	  X   winr	  hhr	  ah1X   SetWindow(self, win)r	  h3h4h5hIh7j  ubehd]r	  (]r	  X   objectr	  a]r	  ]r	  X   SwitcherItemr	  aaehk]r	  hm]r	  h1X   SwitcherItem(object)r	  hpj  )r	  }r	  (j  ]r	  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr	  ]r	  r	  aj  ]r	  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr	  aj  j  ubh'Kh3hqhrXa   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.txtr	  h7j  h5X   186r	  j  ]r	  (X   __init__r	  X   BreakColumnr	  X   Copyr	  X	   GetBitmapr	  X   GetBreakColumnr	  X	   GetColPosr	  X   GetDescriptionr	  X   GetFontr	  X   GetIdr	  X
   GetIsGroupr	  X   GetNamer	  X   GetRectr	  X	   GetRowPosr	  X
   GetTextColourr	  X   GetTitler	  X	   GetWindowr	  X	   SetBitmapr	  X	   SetColPosr	  X   SetDescriptionr	  X   SetFontr	  X   SetIdr	  X
   SetIsGroupr	  X   SetNamer	  X   SetRectr	  X	   SetRowPosr	  X
   SetTextColourr	  X   SetTitler	  X	   SetWindowr	  ej  j	  ubh)r	  }r	  (hX/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr	  hKhX%   An object containing switcher items. r	  hhh	h
]r	  (h#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.__init__r	  hKh'KhX   Default class constructor. r	  hhh	h)]r	  X   itemsr	  X   Noner	  X   Noner	  r	  ah1X   __init__(self, items=None)r	  h3h4h5X   23r	  h7j	  ubh#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.AddGroupr	  hKh'Khhhhh	h)]r	  (X   titler	  hhr	  X   namer	  hhr	  X   idr	  j  X   0r	  r	  X   bitmapr	  X
   wx.NullBitmapr	  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r	  r	  eh1X7   AddGroup(self, title, name, id=0, bitmap=wx.NullBitmap)r	  h3h4h5j5  h7j	  ubh#)r	  }r	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.AddItemr	  hKh'Khhhhh	h)]r	  (X   titleOrItemr	  hhr	  X   namer	  X   Noner	  X   Noner	  r	  X   idr	  j  X   0r	  r	  X   bitmapr	  X
   wx.NullBitmapr	  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r	  r	  eh1XA   AddItem(self, titleOrItem, name=None, id=0, bitmap=wx.NullBitmap)r	  h3h4h5X   15r	  h7j	  ubh#)r	  }r	  (hXA   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.CalculateItemSizer	  hKh'Khhhhh	h)]r	  X   dcr	  hhr	  ah1X   CalculateItemSize(self, dc)r	  h3h4h5X   41r	  h7j	  ubh#)r	  }r	  (hX5   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.Clearr	  hKh'Khhhhh	h)]r	  h1X   Clear(self)r	  h3h4h5h6h7j	  ubh#)r	  }r	  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.Copyr	  hKh'KhXl   Copy operator between 2 :class:`SwitcherItems`.

:param `items`: another instance of :class:`SwitcherItems`.r	  hhh	h)]r	  X   itemsr	  hhr	  ah1X   Copy(self, items)r	  h3h4h5X   22r	  h7j	  ubh#)r	  }r	  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.FindItemByIdr 
  hKh'Khhhhh	h)]r
  X   idr
  hhr
  ah1X   FindItemById(self, id)r
  h3h4h5jr  h7j	  ubh#)r
  }r
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.FindItemByNamer
  hKh'Khhhhh	h)]r
  X   namer	
  hhr

  ah1X   FindItemByName(self, name)r
  h3h4h5jr  h7j	  ubh#)r
  }r
  (hXC   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetBackgroundColourr
  hKh'Khhhhh	h)]r
  h1X   GetBackgroundColour(self)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetColumnCountr
  hKh'Khhhhh	h)]r
  h1X   GetColumnCount(self)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetIndexForFocusr
  hKh'Khhhhh	h)]r
  h1X   GetIndexForFocus(self)r
  h3h4h5X   10r
  h7j	  ubh#)r
  }r
  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemr
  hKh'Khhhhh	h)]r
  jc  hhr 
  ah1X   GetItem(self, i)r!
  h3h4h5h6h7j	  ubh#)r"
  }r#
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemCountr$
  hKh'Khhhhh	h)]r%
  h1X   GetItemCount(self)r&
  h3h4h5h6h7j	  ubh#)r'
  }r(
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemFontr)
  hKh'Khhhhh	h)]r*
  h1X   GetItemFont(self)r+
  h3h4h5h6h7j	  ubh#)r,
  }r-
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetRowCountr.
  hKh'Khhhhh	h)]r/
  h1X   GetRowCount(self)r0
  h3h4h5h6h7j	  ubh#)r1
  }r2
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionr3
  hKh'Khhhhh	h)]r4
  h1X   GetSelection(self)r5
  h3h4h5h6h7j	  ubh#)r6
  }r7
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionColourr8
  hKh'Khhhhh	h)]r9
  h1X   GetSelectionColour(self)r:
  h3h4h5h6h7j	  ubh#)r;
  }r<
  (hXI   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionOutlineColourr=
  hKh'Khhhhh	h)]r>
  h1X   GetSelectionOutlineColour(self)r?
  h3h4h5h6h7j	  ubh#)r@
  }rA
  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetTextColourrB
  hKh'Khhhhh	h)]rC
  h1X   GetTextColour(self)rD
  h3h4h5h6h7j	  ubh#)rE
  }rF
  (hX:   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.PaintItemsrG
  hKh'Khhhhh	h)]rH
  (X   dcrI
  hhrJ
  X   winrK
  hhrL
  eh1X   PaintItems(self, dc, win)rM
  h3h4h5X   80rN
  h7j	  ubh#)rO
  }rP
  (hXC   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetBackgroundColourrQ
  hKh'Khhhhh	h)]rR
  X   colourrS
  hhrT
  ah1X!   SetBackgroundColour(self, colour)rU
  h3h4h5h6h7j	  ubh#)rV
  }rW
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetColumnCountrX
  hKh'Khhhhh	h)]rY
  X   colsrZ
  hhr[
  ah1X   SetColumnCount(self, cols)r\
  h3h4h5h6h7j	  ubh#)r]
  }r^
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetItemFontr_
  hKh'Khhhhh	h)]r`
  X   fontra
  hhrb
  ah1X   SetItemFont(self, font)rc
  h3h4h5h6h7j	  ubh#)rd
  }re
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetRowCountrf
  hKh'Khhhhh	h)]rg
  X   rowsrh
  hhri
  ah1X   SetRowCount(self, rows)rj
  h3h4h5h6h7j	  ubh#)rk
  }rl
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionrm
  hKh'Khhhhh	h)]rn
  X   selro
  hhrp
  ah1X   SetSelection(self, sel)rq
  h3h4h5h6h7j	  ubh#)rr
  }rs
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionByNamert
  hKh'Khhhhh	h)]ru
  X   namerv
  hhrw
  ah1X   SetSelectionByName(self, name)rx
  h3h4h5hCh7j	  ubh#)ry
  }rz
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionColourr{
  hKh'Khhhhh	h)]r|
  X   colourr}
  hhr~
  ah1X    SetSelectionColour(self, colour)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hXI   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionOutlineColourr
  hKh'Khhhhh	h)]r
  X   colourr
  hhr
  ah1X'   SetSelectionOutlineColour(self, colour)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetTextColourr
  hKh'Khhhhh	h)]r
  X   colourr
  hhr
  ah1X   SetTextColour(self, colour)r
  h3h4h5h6h7j	  ubehd]r
  (]r
  X   objectr
  a]r
  ]r
  X
   SwitcherItemsr
  aaehk]r
  hm]r
  h1X   SwitcherItems(object)r
  hpj  )r
  }r
  (j  ]r
  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr
  ]r
  r
  aj  ]r
  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr
  aj  j	  ubh'Kh3hqhrXb   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.txtr
  h7j  h5X   327r
  j  ]r
  (X   __init__r
  X   AddGroupr
  X   AddItemr
  X   CalculateItemSizer
  X   Clearr
  X   Copyr
  X   FindItemByIdr
  X   FindItemByNamer
  X   GetBackgroundColourr
  X   GetColumnCountr
  X   GetIndexForFocusr
  X   GetItemr
  X   GetItemCountr
  X   GetItemFontr
  X   GetRowCountr
  X   GetSelectionr
  X   GetSelectionColourr
  X   GetSelectionOutlineColourr
  X
   GetTextColourr
  X
   PaintItemsr
  X   SetBackgroundColourr
  X   SetColumnCountr
  X   SetItemFontr
  X   SetRowCountr
  X   SetSelectionr
  X   SetSelectionByNamer
  X   SetSelectionColourr
  X   SetSelectionOutlineColourr
  X
   SetTextColourr
  ej  j
  ubh#)r
  }r
  (hX5   wx.lib.agw.aui.aui_switcherdialog.FindFocusDescendantr
  hKh'KhX   Find a window with the focus, that is also a descendant of the given window.
This is used to determine the window to initially send commands to.

:param wx.Window `ancestor`: the window to check for ancestry.r
  hhh	h)]r
  X   ancestorr
  hhr
  ah1X   FindFocusDescendant(ancestor)r
  h3h4h5X   25r
  X   firstlinenor
  X   349r
  h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_switcherdialog.SWITCHER_TEXT_MARGIN_Xr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   4r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_switcherdialog.SWITCHER_TEXT_MARGIN_Yr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   1r
  h|X   intr
  h3h~h7j  ubej  XG   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_switcherdialog.pyr
  hrXT   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.txtr
  h'Kh3j  hpj  )r
  }r
  (j  ]r
  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr
  ]r
  X
   wx.Controlr
  ar
  X
   wx.Controlr
  ]r
  X	   wx.Windowr
  ar
  X	   wx.Windowr
  ]r
  X
   wx.WindowBaser
  ar
  X
   wx.WindowBaser
  ]r
  X
   wx.EvtHandlerr
  ar
  X
   wx.EvtHandlerr
  ]r
  (X	   wx.Objectr
  X   wx.Trackabler
  er
  X	   wx.Objectr
  ]r
  r
  X   wx.Trackabler
  ]r
  r
  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr
  ]r
  X	   wx.Dialogr
  ar
  X	   wx.Dialogr
  ]r
  X   wx.TopLevelWindowr
  ar
  X   wx.TopLevelWindowr
  ]r
  X   wx.NonOwnedWindowr   ar  X   wx.NonOwnedWindowr  ]r  X	   wx.Windowr  ar  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  ]r  r  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr	  ]r
  r  ej  ]r  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr
  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr  ej  j  ubh7hubh)r  }r  (hX   wx.lib.agw.aui.aui_utilitiesr  hKhX   This module contains some common functions used by :mod:`lib.agw.aui` to
manipulate colours, bitmaps, text, gradient shadings and custom dragging images
for :class:`~wx.lib.agw.aui.auibook.AuiNotebook` tabs.r  hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_utilities.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
r  h	h
]r  (h)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.PyEmbeddedImager  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	h
]r  (h#)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.__init__r  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r  hhh	h)]r   (X   datar!  hhr"  X   isBase64r#  X   Truer$  h/r%  eh1X#   __init__(self, data, isBase64=True)r&  h3h4h5h6h7j  ubh#)r'  }r(  (hX6   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetBitmapr)  hKh'Khhhhh	h)]r*  h1X   GetBitmap(self)r+  h3h4h5h=h7j  ubh#)r,  }r-  (hX4   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetDatar.  hKh'Khhhhh	h)]r/  h1X
   GetData(self)r0  h3h4h5hCh7j  ubh#)r1  }r2  (hX4   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetIconr3  hKh'Khhhhh	h)]r4  h1X
   GetIcon(self)r5  h3h4h5hIh7j  ubh#)r6  }r7  (hX5   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetImager8  hKh'Khhhhh	h)]r9  h1X   GetImage(self)r:  h3h4h5h6h7j  ubhO)r;  }r<  (hX3   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.Bitmapr=  hKh'Khhhhh	hShThUhhVhh3hWh7j  ubhO)r>  }r?  (hX1   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.Datar@  hKh'Khhhhh	hSh[hUhhVhh3hWh7j  ubhO)rA  }rB  (hX1   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.IconrC  hKh'Khhhhh	hSh_hUhhVhh3hWh7j  ubhO)rD  }rE  (hX2   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.ImagerF  hKh'Khhhhh	hShchUhhVhh3hWh7j  ubehd]rG  (]rH  X   objectrI  a]rJ  ]rK  hjaaehk]rL  hm]rM  h1X   PyEmbeddedImage(object)rN  hpNh'Kh3hqhrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.txtrO  h7j  h5X   52rP  ubh)rQ  }rR  (hX)   wx.lib.agw.aui.aui_utilities.TabDragImagerS  hKhX]   This class handles the creation of a custom image in case of drag and drop of a notebook tab.rT  hhh	h
]rU  (h#)rV  }rW  (hX2   wx.lib.agw.aui.aui_utilities.TabDragImage.__init__rX  hKh'KhX  Default class constructor.

For internal use: do not call it in your code!

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.rY  hhh	h)]rZ  (X   notebookr[  hhr\  X   pager]  hhr^  X   button_stater_  hhr`  X   tabArtra  hhrb  eh1X4   __init__(self, notebook, page, button_state, tabArt)rc  h3h4h5X   16rd  h7jQ  ubh#)re  }rf  (hX6   wx.lib.agw.aui.aui_utilities.TabDragImage.CreateBitmaprg  hKh'KhX  Actually creates the drag and drop bitmap.

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.rh  hhh	h)]ri  (X   notebookrj  hhrk  X   pagerl  hhrm  X   button_statern  hhro  X   tabArtrp  hhrq  eh1X8   CreateBitmap(self, notebook, page, button_state, tabArt)rr  h3h4h5X   56rs  h7jQ  ubehd]rt  (]ru  X   objectrv  a]rw  (]rx  X
   simplewrapperry  a]rz  (]r{  X   wrapperr|  a]r}  (]r~  j  a]r  (]r  X	   DragImager  a]r  ]r  X   TabDragImager  aaeeeeehk]r  hm]r  X   wx.DragImager  ah1X   TabDragImage(wx.DragImage)r  hpj  )r  }r  (j  ]r  (X)   wx.lib.agw.aui.aui_utilities.TabDragImager  ]r  X   wx.DragImager  ar  X   wx.DragImager  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X)   wx.lib.agw.aui.aui_utilities.TabDragImager  aj  jQ  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.TabDragImage.txtr  h7j  h5X   78r  j  ]r  (X   __init__r  X   CreateBitmapr  ej  j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.BitmapFromBitsr  hKh'KhX)  A utility function that creates a masked bitmap from raw bits (XBM format).

:param string `bits`: the raw bits of the bitmap;
:param integer `w`: the bitmap width;
:param integer `h`: the bitmap height;
:param wx.Colour `colour`: the colour which will replace all white pixels in the
 raw bitmap.r  hhh	h)]r  (X   bitsr  hhr  X   wr  hhr  X   hr  hhr  X   colourr  hhr  eh1X"   BitmapFromBits(bits, w, h, colour)r  h3h4h5X   17r  j
  X   147r  h7j  ubh#)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.BlendColourr  hKh'KhX
  Blends the two colour component `fg` and `bg` into one colour component, adding
an optional alpha channel.

:param wx.Colour `fg`: the first colour component;
:param wx.Colour `bg`: the second colour component;
:param integer `alpha`: an optional transparency value.r  hhh	h)]r  (X   fgr  hhr  X   bgr  hhr  X   alphar  hhr  eh1X   BlendColour(fg, bg, alpha)r  h3h4h5X   19r  j
  X   38r  h7j  ubh#)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.ChopTextr  hKh'KhX  Chops the input `text` if its size does not fit in `max_size`, by cutting the
text and adding ellipsis at the end.

:param `dc`: a :class:`wx.DC` device context;
:param string `text`: the text to chop;
:param integer `max_size`: the maximum size in which the text should fit.r  hhh	h)]r  (X   dcr  hhr  X   textr  hhr  X   max_sizer  hhr  eh1X   ChopText(dc, text, max_size)r  h3h4h5X   32r  j
  X   114r  h7j  ubh#)r  }r  (hX!   wx.lib.agw.aui.aui_utilities.Clipr  hKh'KhX   Clips the value in `a` based on the extremes `b` and `c`.

:param `a`: the value to analyze;
:param `b`: a minimum value;
:param `c`: a maximum value.r  hhh	h)]r  (X   ar  hhr  X   br  hhr  X   cr  hhr  eh1X
   Clip(a, b, c)r  h3h4h5X   11r  j
  X   220r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.CopyAttributesr  hKh'KhX   Copies pens, brushes, colours and fonts from the old tab art to the new one.

:param `newArt`: the new instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`;
:param `oldArt`: the old instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`.r  hhh	h)]r  (X   newArtr  hhr  X   oldArtr  hhr  eh1X   CopyAttributes(newArt, oldArt)r  h3h4h5X   18r  j
  X   641r  h7j  ubh#)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.DarkenBitmapr  hKh'KhX   Darkens the input bitmap on wxMAC using the input colour.

:param wx.Bitmap `bmp`: the bitmap to be manipulated;
:param wx.Colour `caption_colour`: the colour of the pane caption;
:param wx.Colour `new_colour`: the colour used to darken the bitmap.r  hhh	h)]r  (X   bmpr  hhr  X   caption_colourr  hhr  X
   new_colourr  hhr  eh1X-   DarkenBitmap(bmp, caption_colour, new_colour)r  h3h4h5X   16r  j
  X   315r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.DrawGradientRectangler  hKh'KhXg  Draws a gradient-shaded rectangle.

:param `dc`: a :class:`wx.DC` device context;
:param wx.Rect `rect`: the rectangle in which to draw the gradient;
:param wx.Colour `start_colour`: the first colour of the gradient;
:param wx.Colour `end_colour`: the second colour of the gradient;
:param integer `direction`: the gradient direction (horizontal or vertical).r  hhh	h)]r  (X   dcr  hhr  X   rectr  hhr  X   start_colourr  hhr  X
   end_colourr  hhr  X	   directionr  hhr   X   offsetr  j  X   0r  r  X   lengthr  j  X   0r  r  eh1XX   DrawGradientRectangle(dc, rect, start_colour, end_colour, direction, offset=0, length=0)r  h3h4h5X   16r  j
  X   332r	  h7j  ubh#)r
  }r  (hX/   wx.lib.agw.aui.aui_utilities.DrawMACCloseButtonr  hKh'KhX   Draws the wxMAC tab close button using :class:`GraphicsContext`.

:param wx.Colour `colour`: the colour to use to draw the circle;
:param wx.Colour `backColour`: the optional background colour for the circle.r
  hhh	h)]r  (X   colourr  hhr  X
   backColourr  X   Noner  X   Noner  r  eh1X+   DrawMACCloseButton(colour, backColour=None)r  h3h4h5X   38r  j
  X   276r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.FindFocusDescendantr  hKh'KhX   Find a window with the focus, that is also a descendant of the given window.
This is used to determine the window to initially send commands to.

:param wx.Window `ancestor`: the window to check for ancestry.r  hhh	h)]r  X   ancestorr  hhr  ah1X   FindFocusDescendant(ancestor)r  h3h4h5X   25r   j
  X   349r!  h7j  ubh#)r"  }r#  (hX*   wx.lib.agw.aui.aui_utilities.GetBaseColourr$  hKh'KhXv   Returns the face shading colour on push buttons/backgrounds,
mimicking as closely as possible the platform UI colours.r%  hhh	h)]r&  h1X   GetBaseColour()r'  h3h4h5X   29r(  j
  X   180r)  h7j  ubh#)r*  }r+  (hX,   wx.lib.agw.aui.aui_utilities.GetDockingImager,  hKh'KhX9  Returns the correct name of the docking bitmap depending on the input parameters.

:param bool `useAero`: whether :class:`~wx.lib.agw.aui.framemanager.AuiManager` is using
 Aero-style or Whidbey-style docking images or not;
:param bool `center`: whether we are looking for the center diamond-shaped bitmap or not.r-  hhh	h)]r.  (X	   directionr/  hhr0  X   useAeror1  hhr2  X   centerr3  hhr4  eh1X+   GetDockingImage(direction, useAero, center)r5  h3h4h5X   36r6  j
  X   484r7  h7j  ubh#)r8  }r9  (hX)   wx.lib.agw.aui.aui_utilities.GetLabelSizer:  hKh'KhX   Returns the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` item label size.

:param string `label`: the toolbar tool label;
:param bool `vertical`: whether the toolbar tool orientation is vertical or not.r;  hhh	h)]r<  (X   dcr=  hhr>  X   labelr?  hhr@  X   verticalrA  hhrB  eh1X!   GetLabelSize(dc, label, vertical)rC  h3h4h5X   23rD  j
  X   375rE  h7j  ubh#)rF  }rG  (hX-   wx.lib.agw.aui.aui_utilities.GetSlidingPointsrH  hKh'KhX  Returns the point at which the sliding in and out of a minimized pane begins.

:param wx.Rect `rect`: the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` tool screen rectangle;
:param wx.Size `size`: the pane window size;
:param integer `direction`: the pane docking direction.rI  hhh	h)]rJ  (X   rectrK  hhrL  X   sizerM  hhrN  X	   directionrO  hhrP  eh1X'   GetSlidingPoints(rect, size, direction)rQ  h3h4h5X   29rR  j
  X   611rS  h7j  ubh#)rT  }rU  (hX0   wx.lib.agw.aui.aui_utilities.IndentPressedBitmaprV  hKh'KhX   Indents the input rectangle `rect` based on the value of `button_state`.

:param wx.Rect `rect`: the button bitmap rectangle;
:param integer `button_state`: the button state.rW  hhh	h)]rX  (X   rectrY  hhrZ  X   button_stater[  hhr\  eh1X'   IndentPressedBitmap(rect, button_state)r]  h3h4h5X   14r^  j
  X   165r_  h7j  ubh#)r`  }ra  (hX(   wx.lib.agw.aui.aui_utilities.LightColourrb  hKh'KhX   Brighten input `colour` by `percent`.

:param wx.Colour `colour`: the colour to be brightened;
:param integer `percent`: brightening percentage.rc  hhh	h)]rd  (X   colourre  hhrf  X   percentrg  hhrh  eh1X   LightColour(colour, percent)ri  h3h4h5X   24rj  j
  X   232rk  h7j  ubh#)rl  }rm  (hX0   wx.lib.agw.aui.aui_utilities.LightContrastColourrn  hKh'KhXp   Creates a new, lighter colour based on the input colour `c`.

:param wx.Colour `c`: the input colour to analyze.ro  hhh	h)]rp  j  hhrq  ah1X   LightContrastColour(c)rr  h3h4h5X   16rs  j
  X   97rt  h7j  ubh#)ru  }rv  (hX/   wx.lib.agw.aui.aui_utilities.MakeDisabledBitmaprw  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.rx  hhh	h)]ry  X   bitmaprz  hhr{  ah1X   MakeDisabledBitmap(bitmap)r|  h3h4h5X   9r}  j
  X   210r~  h7j  ubh#)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.PaneCreateStippleBitmapr  hKh'KhXd   Creates a stipple bitmap to be used in a :class:`wx.Brush`.

This is used to draw sash resize hints.r  hhh	h)]r  h1X   PaneCreateStippleBitmap()r  h3h4h5X   18r  j
  X   257r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.RescaleScreenShotr  hKh'KhX   Rescales a bitmap to be `thumbnail_size` pixels wide (or tall) at maximum.

:param wx.Bitmap `bmp`: the bitmap to rescale;
:param integer `thumbnail_size`: the maximum size of every page thumbnail.r  hhh	h)]r  (X   bmpr  hhr  X   thumbnail_sizer  X   200r  X   200r  r  eh1X*   RescaleScreenShot(bmp, thumbnail_size=200)r  h3h4h5X   49r  j
  X   561r  h7j  ubh#)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.StepColourr  hKh'KhX   Darken/lighten the input colour `c`.

:param wx.Colour `c`: a colour to darken/lighten;
:param integer `ialpha`: a transparency value.r  hhh	h)]r  (j  hhr  X   ialphar  hhr  eh1X   StepColour(c, ialpha)r  h3h4h5X   38r  j
  X   58r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.TakeScreenShotr  hKh'KhX   Takes a screenshot of the screen at given position and size (`rect`).

:param wx.Rect `rect`: the screen rectangle for which we want to take a screenshot.r  hhh	h)]r  X   rectr  hhr  ah1X   TakeScreenShot(rect)r  h3h4h5X   39r  j
  X   521r  h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.__author__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'r  h|X   strr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.__date__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX   '31 March 2009'r  h|X   strr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.actionClickButtonr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.actionClickCaptionr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.actionDragFloatingPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.actionDragMovablePaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.actionDragToolbarPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.actionNoner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.actionResizer  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.aero_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.aero_dock_paner  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ed0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_bottomr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.aero_dock_pane_leftr 
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9fd0>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX1   wx.lib.agw.aui.aui_utilities.aero_dock_pane_rightr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5050>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager	
  h3h~h7j  ubhu)r

  }r
  (hX/   wx.lib.agw.aui.aui_utilities.aero_dock_pane_topr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r

  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5090>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX&   wx.lib.agw.aui.aui_utilities.aero_downr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd50d0>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX,   wx.lib.agw.aui.aui_utilities.aero_down_focusr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX3   wx.lib.agw.aui.aui_utilities.aero_down_focus_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r 
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!
  h3h~h7j  ubhu)r"
  }r#
  (hX-   wx.lib.agw.aui.aui_utilities.aero_down_singler$
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r%
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5150>r&
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager'
  h3h~h7j  ubhu)r(
  }r)
  (hX&   wx.lib.agw.aui.aui_utilities.aero_leftr*
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r+
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5190>r,
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager-
  h3h~h7j  ubhu)r.
  }r/
  (hX,   wx.lib.agw.aui.aui_utilities.aero_left_focusr0
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r2
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager3
  h3h~h7j  ubhu)r4
  }r5
  (hX3   wx.lib.agw.aui.aui_utilities.aero_left_focus_singler6
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r7
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r8
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager9
  h3h~h7j  ubhu)r:
  }r;
  (hX-   wx.lib.agw.aui.aui_utilities.aero_left_singler<
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r=
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5210>r>
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager?
  h3h~h7j  ubhu)r@
  }rA
  (hX'   wx.lib.agw.aui.aui_utilities.aero_rightrB
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rC
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5250>rD
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerE
  h3h~h7j  ubhu)rF
  }rG
  (hX-   wx.lib.agw.aui.aui_utilities.aero_right_focusrH
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rI
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>rJ
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerK
  h3h~h7j  ubhu)rL
  }rM
  (hX4   wx.lib.agw.aui.aui_utilities.aero_right_focus_singlerN
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rO
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>rP
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerQ
  h3h~h7j  ubhu)rR
  }rS
  (hX.   wx.lib.agw.aui.aui_utilities.aero_right_singlerT
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rU
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd52d0>rV
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerW
  h3h~h7j  ubhu)rX
  }rY
  (hX%   wx.lib.agw.aui.aui_utilities.aero_tabrZ
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r[
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5310>r\
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager]
  h3h~h7j  ubhu)r^
  }r_
  (hX+   wx.lib.agw.aui.aui_utilities.aero_tab_focusr`
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ra
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>rb
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerc
  h3h~h7j  ubhu)rd
  }re
  (hX2   wx.lib.agw.aui.aui_utilities.aero_tab_focus_singlerf
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rg
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>rh
  h|X$   wx.lib.embeddedimage.PyEmbeddedImageri
  h3h~h7j  ubhu)rj
  }rk
  (hX,   wx.lib.agw.aui.aui_utilities.aero_tab_singlerl
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rm
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5390>rn
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagero
  h3h~h7j  ubhu)rp
  }rq
  (hX$   wx.lib.agw.aui.aui_utilities.aero_uprr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rs
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd53d0>rt
  h|X$   wx.lib.embeddedimage.PyEmbeddedImageru
  h3h~h7j  ubhu)rv
  }rw
  (hX*   wx.lib.agw.aui.aui_utilities.aero_up_focusrx
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ry
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>rz
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager{
  h3h~h7j  ubhu)r|
  }r}
  (hX1   wx.lib.agw.aui.aui_utilities.aero_up_focus_singler~
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aero_up_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5450>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aeroguideSizeXr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   31r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aeroguideSizeYr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   32r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX-   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CLOSEr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   101r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM1r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   201r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM2r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   202r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM3r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   203r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM4r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   204r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM5r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   205r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM6r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   206r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM7r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   207r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM8r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   208r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM9r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   209r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX,   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_DOWNr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   110r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX,   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_LEFTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   107r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_MAXIMIZE_RESTOREr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   102r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX0   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_MINIMIZEr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   103r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_OPTIONSr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   105r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_PINr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   104r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX-   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_RIGHTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   108r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX5   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_CHECKEDr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   32r
  h|X   intr
  h3h~h7j  ubhu)r   }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r	  hhh	hzX   16r
  h|X   intr  h3h~h7j  ubhu)r  }r
  (hX3   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_NORMALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_PRESSEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_UPr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   109r"  h|X   intr#  h3h~h7j  ubhu)r$  }r%  (hX2   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_WINDOWLISTr&  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r'  hhh	hzX   106r(  h|X   intr)  h3h~h7j  ubhu)r*  }r+  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_BOTTOMr,  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r-  hhh	hzX   3r.  h|X   intr/  h3h~h7j  ubhu)r0  }r1  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_CENTERr2  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r3  hhh	hzX   5r4  h|X   intr5  h3h~h7j  ubhu)r6  }r7  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_CENTREr8  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r9  hhh	hzX   5r:  h|X   intr;  h3h~h7j  ubhu)r<  }r=  (hX*   wx.lib.agw.aui.aui_utilities.AUI_DOCK_LEFTr>  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r?  hhh	hzX   4r@  h|X   intrA  h3h~h7j  ubhu)rB  }rC  (hX*   wx.lib.agw.aui.aui_utilities.AUI_DOCK_NONErD  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rE  hhh	hzX   0rF  h|X   intrG  h3h~h7j  ubhu)rH  }rI  (hX3   wx.lib.agw.aui.aui_utilities.AUI_DOCK_NOTEBOOK_PAGErJ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rK  hhh	hzX   6rL  h|X   intrM  h3h~h7j  ubhu)rN  }rO  (hX+   wx.lib.agw.aui.aui_utilities.AUI_DOCK_RIGHTrP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   2rR  h|X   intrS  h3h~h7j  ubhu)rT  }rU  (hX)   wx.lib.agw.aui.aui_utilities.AUI_DOCK_TOPrV  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rW  hhh	hzX   1rX  h|X   intrY  h3h~h7j  ubhu)rZ  }r[  (hX>   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_COLOURr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   8r^  h|X   intr_  h3h~h7j  ubhu)r`  }ra  (hXG   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURrb  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rc  hhh	hzX   9rd  h|X   intre  h3h~h7j  ubhu)rf  }rg  (hXC   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURrh  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ri  hhh	hzX   12rj  h|X   intrk  h3h~h7j  ubhu)rl  }rm  (hX:   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BACKGROUND_COLOURrn  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ro  hhh	hzX   5rp  h|X   intrq  h3h~h7j  ubhu)rr  }rs  (hXC   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURrt  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ru  hhh	hzX   6rv  h|X   intrw  h3h~h7j  ubhu)rx  }ry  (hX6   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BORDER_COLOURrz  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r{  hhh	hzX   14r|  h|X   intr}  h3h~h7j  ubhu)r~  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_CAPTION_FONTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_CAPTION_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_DRAW_SASH_GRIPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   18r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRADIENT_TYPEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   17r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRIPPER_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   15r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRIPPER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX;   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_HINT_WINDOW_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   19r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX@   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hXI   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7j  ubhu)r  }r  (hXE   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX9   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX9   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX8   wx.lib.agw.aui.aui_utilities.AUI_MGR_AERO_DOCKING_GUIDESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r   h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r	  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_ANIMATE_FRAMESr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr
  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_MGR_AUTONB_NO_CAPTIONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_MGR_DEFAULTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.AUI_MGR_HINT_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7j  ubhu)r   }r!  (hX0   wx.lib.agw.aui.aui_utilities.AUI_MGR_LIVE_RESIZEr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   256r$  h|X   intr%  h3h~h7j  ubhu)r&  }r'  (hX<   wx.lib.agw.aui.aui_utilities.AUI_MGR_NO_VENETIAN_BLINDS_FADEr(  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r)  hhh	hzX   128r*  h|X   intr+  h3h~h7j  ubhu)r,  }r-  (hX<   wx.lib.agw.aui.aui_utilities.AUI_MGR_PREVIEW_MINIMIZED_PANESr.  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r/  hhh	hzX   2048r0  h|X   intr1  h3h~h7j  ubhu)r2  }r3  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_RECTANGLE_HINTr4  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r5  hhh	hzX   32r6  h|X   intr7  h3h~h7j  ubhu)r8  }r9  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_SMOOTH_DOCKINGr:  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r;  hhh	hzX   8192r<  h|X   intr=  h3h~h7j  ubhu)r>  }r?  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MGR_TRANSPARENT_DRAGr@  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rA  hhh	hzX   4rB  h|X   intrC  h3h~h7j  ubhu)rD  }rE  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MGR_TRANSPARENT_HINTrF  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rG  hhh	hzX   8rH  h|X   intrI  h3h~h7j  ubhu)rJ  }rK  (hX:   wx.lib.agw.aui.aui_utilities.AUI_MGR_USE_NATIVE_MINIFRAMESrL  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rM  hhh	hzX   16384rN  h|X   intrO  h3h~h7j  ubhu)rP  }rQ  (hX9   wx.lib.agw.aui.aui_utilities.AUI_MGR_VENETIAN_BLINDS_HINTrR  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rS  hhh	hzX   16rT  h|X   intrU  h3h~h7j  ubhu)rV  }rW  (hX;   wx.lib.agw.aui.aui_utilities.AUI_MGR_WHIDBEY_DOCKING_GUIDESrX  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rY  hhh	hzX   4096rZ  h|X   intr[  h3h~h7j  ubhu)r\  }r]  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_HIDEr^  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_  hhh	hzX   0r`  h|X   intra  h3h~h7j  ubhu)rb  }rc  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_HORZrd  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4re  hhh	hzX   16rf  h|X   intrg  h3h~h7j  ubhu)rh  }ri  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_MASKrj  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rk  hhh	hzX   24rl  h|X   intrm  h3h~h7j  ubhu)rn  }ro  (hX4   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_SMARTrp  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq  hhh	hzX   8rr  h|X   intrs  h3h~h7j  ubhu)rt  }ru  (hX4   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_BOTTOMrv  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw  hhh	hzX   5rx  h|X   intry  h3h~h7j  ubhu)rz  }r{  (hX2   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_LEFTr|  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}  hhh	hzX   3r~  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_MASKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   23r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_SMARTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_TOOLBARr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.AUI_NB_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_ACTIVE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_NB_SCROLL_BUTTONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_EXTERNAL_MOVEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr	  h3h~h7j  ubhu)r
  }r  (hX-   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   524288r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_SPLITr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.AUI_NB_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r   h|X   intr!  h3h~h7j  ubhu)r"  }r#  (hX7   wx.lib.agw.aui.aui_utilities.AUI_NB_USE_IMAGES_DROPDOWNr$  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r%  hhh	hzX   131072r&  h|X   intr'  h3h~h7j  ubhu)r(  }r)  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_WINDOWLIST_BUTTONr*  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r+  hhh	hzX   512r,  h|X   intr-  h3h~h7j  ubhu)r.  }r/  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_CLOCKWISEr0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   256r2  h|X   intr3  h3h~h7j  ubhu)r4  }r5  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TB_COUNTERCLOCKWISEr6  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r7  hhh	hzX   512r8  h|X   intr9  h3h~h7j  ubhu)r:  }r;  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TB_DEFAULT_STYLEr<  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r=  hhh	hzX   0r>  h|X   intr?  h3h~h7j  ubhu)r@  }rA  (hX+   wx.lib.agw.aui.aui_utilities.AUI_TB_GRIPPERrB  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rC  hhh	hzX   8rD  h|X   intrE  h3h~h7j  ubhu)rF  }rG  (hX/   wx.lib.agw.aui.aui_utilities.AUI_TB_HORZ_LAYOUTrH  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rI  hhh	hzX   64rJ  h|X   intrK  h3h~h7j  ubhu)rL  }rM  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_HORZ_TEXTrN  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rO  hhh	hzX   65rP  h|X   intrQ  h3h~h7j  ubhu)rR  }rS  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TB_NO_AUTORESIZErT  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rU  hhh	hzX   4rV  h|X   intrW  h3h~h7j  ubhu)rX  }rY  (hX/   wx.lib.agw.aui.aui_utilities.AUI_TB_NO_TOOLTIPSrZ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r[  hhh	hzX   2r\  h|X   intr]  h3h~h7j  ubhu)r^  }r_  (hX,   wx.lib.agw.aui.aui_utilities.AUI_TB_OVERFLOWr`  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ra  hhh	hzX   16rb  h|X   intrc  h3h~h7j  ubhu)rd  }re  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TB_PLAIN_BACKGROUNDrf  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rg  hhh	hzX   128rh  h|X   intri  h3h~h7j  ubhu)rj  }rk  (hX(   wx.lib.agw.aui.aui_utilities.AUI_TB_TEXTrl  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm  hhh	hzX   1rn  h|X   intro  h3h~h7j  ubhu)rp  }rq  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_VERT_TEXTrr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rs  hhh	hzX   289rt  h|X   intru  h3h~h7j  ubhu)rv  }rw  (hX,   wx.lib.agw.aui.aui_utilities.AUI_TB_VERTICALrx  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ry  hhh	hzX   32rz  h|X   intr{  h3h~h7j  ubhu)r|  }r}  (hX3   wx.lib.agw.aui.aui_utilities.AUI_TBART_GRIPPER_SIZEr~  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TBART_OVERFLOW_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_TBART_SEPARATOR_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_VERT_CLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX=   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.AuiBaseTabCtrlIdr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5380r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.auiInsertRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.auiLayerInsertOffsetr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.auiLayerInsertPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.auiNewRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.auinotebook_previewr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd54d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.auiToolBarLayerr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.BUTTON_DROPDOWN_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.colourHintBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(0, 64, 255, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.colourIconArrowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(77, 79, 170, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.colourIconBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(255, 255, 255, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r   }r  (hX-   wx.lib.agw.aui.aui_utilities.colourIconBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(82, 65, 156, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.colourIconDockingPart1r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r	  hhh	hzX   wx.Colour(215, 228, 243, 255)r
  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r
  (hX3   wx.lib.agw.aui.aui_utilities.colourIconDockingPart2r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(180, 201, 225, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.colourIconShadowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(198, 198, 198, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.colourTargetBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(224, 224, 224, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.colourTargetBorderr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(180, 180, 180, 255)r"  h|X   wx._core.Colourr#  h3h~h7j  ubhu)r$  }r%  (hX.   wx.lib.agw.aui.aui_utilities.colourTargetShader&  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r'  hhh	hzX   wx.Colour(206, 206, 206, 255)r(  h|X   wx._core.Colourr)  h3h~h7j  ubhu)r*  }r+  (hX1   wx.lib.agw.aui.aui_utilities.DISABLED_TEXT_COLOURr,  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r-  hhh	hzX   wx.Colour(153, 153, 153, 255)r.  h|X   wx._core.Colourr/  h3h~h7j  ubhu)r0  }r1  (hX3   wx.lib.agw.aui.aui_utilities.DISABLED_TEXT_GREY_HUEr2  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r3  hhh	hzX   153r4  h|X   intr5  h3h~h7j  ubhu)r6  }r7  (hX!   wx.lib.agw.aui.aui_utilities.downr8  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r9  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c50>r:  h|X$   wx.lib.embeddedimage.PyEmbeddedImager;  h3h~h7j  ubhu)r<  }r=  (hX'   wx.lib.agw.aui.aui_utilities.down_focusr>  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r?  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c90>r@  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerA  h3h~h7j  ubhu)rB  }rC  (hX.   wx.lib.agw.aui.aui_utilities.down_focus_singlerD  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rE  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd99d0>rF  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerG  h3h~h7j  ubhu)rH  }rI  (hX(   wx.lib.agw.aui.aui_utilities.down_singlerJ  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rK  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a10>rL  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerM  h3h~h7j  ubhu)rN  }rO  (hX'   wx.lib.agw.aui.aui_utilities.guideSizeXrP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   29rR  h|X   intrS  h3h~h7j  ubhu)rT  }rU  (hX'   wx.lib.agw.aui.aui_utilities.guideSizeYrV  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rW  hhh	hzX   32rX  h|X   intrY  h3h~h7j  ubhu)rZ  }r[  (hX-   wx.lib.agw.aui.aui_utilities.ID_RESTORE_FRAMEr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   15999r^  h|X   intr_  h3h~h7j  ubhu)r`  }ra  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_CHECKrb  hKh'Khhhhh	hzX   1rc  h|X   wx._core.ItemKindrd  h3h~h7j  ubhu)re  }rf  (hX)   wx.lib.agw.aui.aui_utilities.ITEM_CONTROLrg  hKh'Khhhhh	hzX   4rh  h|X   wx._core.ItemKindri  h3h~h7j  ubhu)rj  }rk  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_LABELrl  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm  hhh	hzX   5rn  h|X   intro  h3h~h7j  ubhu)rp  }rq  (hX(   wx.lib.agw.aui.aui_utilities.ITEM_NORMALrr  hKh'Khhhhh	hzX   0rs  h|X   wx._core.ItemKindrt  h3h~h7j  ubhu)ru  }rv  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_RADIOrw  hKh'Khhhhh	hzX   2rx  h|X   wx._core.ItemKindry  h3h~h7j  ubhu)rz  }r{  (hX+   wx.lib.agw.aui.aui_utilities.ITEM_SEPARATORr|  hKh'Khhhhh	hzX   -1r}  h|X   wx._core.ItemKindr~  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.ITEM_SPACERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX!   wx.lib.agw.aui.aui_utilities.leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9cd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.max_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.minimize_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.Mondrianr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9990>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.nb_close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.nb_left_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.nb_list_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.nb_right_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.pin_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.restore_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.restore_xpmr  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r  h|X   listr  h3h~h7j  ubhu)r  }r  (hX"   wx.lib.agw.aui.aui_utilities.rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ad0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.SWITCHER_TEXT_MARGIN_Xr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.SWITCHER_TEXT_MARGIN_Yr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX    wx.lib.agw.aui.aui_utilities.tabr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9dd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.tab_active_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r	  }r
  (hX,   wx.lib.agw.aui.aui_utilities.tab_active_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde150>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.tab_active_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX&   wx.lib.agw.aui.aui_utilities.tab_closer  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bdee90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.tab_close_hr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9850>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7j  ubhu)r!  }r"  (hX(   wx.lib.agw.aui.aui_utilities.tab_close_pr#  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r$  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9890>r%  h|X$   wx.lib.embeddedimage.PyEmbeddedImager&  h3h~h7j  ubhu)r'  }r(  (hX&   wx.lib.agw.aui.aui_utilities.tab_focusr)  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r*  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e10>r+  h|X$   wx.lib.embeddedimage.PyEmbeddedImager,  h3h~h7j  ubhu)r-  }r.  (hX-   wx.lib.agw.aui.aui_utilities.tab_focus_singler/  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b50>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager2  h3h~h7j  ubhu)r3  }r4  (hX0   wx.lib.agw.aui.aui_utilities.tab_inactive_centerr5  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r6  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd98d0>r7  h|X$   wx.lib.embeddedimage.PyEmbeddedImager8  h3h~h7j  ubhu)r9  }r:  (hX.   wx.lib.agw.aui.aui_utilities.tab_inactive_leftr;  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r<  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9910>r=  h|X$   wx.lib.embeddedimage.PyEmbeddedImager>  h3h~h7j  ubhu)r?  }r@  (hX/   wx.lib.agw.aui.aui_utilities.tab_inactive_rightrA  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rB  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9950>rC  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerD  h3h~h7j  ubhu)rE  }rF  (hX'   wx.lib.agw.aui.aui_utilities.tab_singlerG  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rH  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b90>rI  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerJ  h3h~h7j  ubhu)rK  }rL  (hX   wx.lib.agw.aui.aui_utilities.uprM  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rN  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e50>rO  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerP  h3h~h7j  ubhu)rQ  }rR  (hX%   wx.lib.agw.aui.aui_utilities.up_focusrS  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rT  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e90>rU  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerV  h3h~h7j  ubhu)rW  }rX  (hX,   wx.lib.agw.aui.aui_utilities.up_focus_singlerY  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rZ  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9bd0>r[  h|X$   wx.lib.embeddedimage.PyEmbeddedImager\  h3h~h7j  ubhu)r]  }r^  (hX&   wx.lib.agw.aui.aui_utilities.up_singler_  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r`  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c10>ra  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerb  h3h~h7j  ubhu)rc  }rd  (hX4   wx.lib.agw.aui.aui_utilities.vertical_border_paddingre  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rf  hhh	hzX   4rg  h|X   intrh  h3h~h7j  ubhu)ri  }rj  (hX+   wx.lib.agw.aui.aui_utilities.whidbey_deniedrk  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rl  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>rm  h|X$   wx.lib.embeddedimage.PyEmbeddedImagern  h3h~h7j  ubhu)ro  }rp  (hX.   wx.lib.agw.aui.aui_utilities.whidbey_dock_panerq  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rr  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf610>rs  h|X$   wx.lib.embeddedimage.PyEmbeddedImagert  h3h~h7j  ubhu)ru  }rv  (hX5   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_bottomrw  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rx  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf750>ry  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerz  h3h~h7j  ubhu)r{  }r|  (hX5   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_centerr}  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r~  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf790>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c950>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c8d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_topr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c9d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbey_downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.whidbey_down_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.whidbey_down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_down_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbey_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.whidbey_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.whidbey_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.whidbey_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.whidbey_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.whidbey_right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.whidbey_upr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.whidbey_up_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.whidbey_up_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.whidbey_up_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbeySizeXr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   43r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbeySizeYr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   30r  h|X   intr  h3h~h7j  ubhu)r  }r   (hX*   wx.lib.agw.aui.aui_utilities.wxWINDOWCLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4001r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.wxWINDOWCLOSEALLr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4002r	  h|X   intr
  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.wxWINDOWNEXTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4003r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.wxWINDOWPREVr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4004r  h|X   intr  h3h~h7j  ubej  XB   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_utilities.pyr  hrXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.txtr  h'Kh3j  hpj  )r  }r  (j  ]r  (X)   wx.lib.agw.aui.aui_utilities.TabDragImager  ]r  X   wx.DragImager  ar  X   wx.DragImager   ]r!  X	   wx.Objectr"  ar#  X	   wx.Objectr$  ]r%  r&  ej  ]r'  X)   wx.lib.agw.aui.aui_utilities.TabDragImager(  aj  j  ubh7hubh)r)  }r*  (hX   wx.lib.agw.aui.auibarr+  hKhX  `auibar.py` contains an implementation of
:class:`~wx.lib.agw.aui.auibar.AuiToolBar`, which is a completely owner-drawn
toolbar perfectly integrated with the AUI layout system. This allows drag and
drop of toolbars, docking/floating behaviour and the possibility to define
"overflow" items in the toolbar itself.

The default theme that is used is :class:`AuiToolBar`, which provides a modern,
glossy look and feel. The theme can be changed by calling
:meth:`AuiToolBar.SetArtProvider`.r,  hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         auibar.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
r-  h	h
]r.  (h)r/  }r0  (hX*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtr1  hKhX  Toolbar art provider code - a tab provider provides all drawing functionality to the :class:`AuiToolBar`.
This allows the :class:`AuiToolBar` to have a plugable look-and-feel.

By default, a :class:`AuiToolBar` uses an instance of this class called :class:`AuiDefaultToolBarArt`
which provides bitmap art and a colour scheme that is adapted to the major platforms'
look. You can either derive from that class to alter its behaviour or write a
completely new tab art class. Call :meth:`AuiToolBar.SetArtProvider` to make use this new tab art.r2  hhh	h
]r3  (h#)r4  }r5  (hX3   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.__init__r6  hKh'KhX   Default class constructor. r7  hhh	h)]r8  h1X   __init__(self)r9  h3h4h5X   25r:  h7j/  ubh#)r;  }r<  (hX0   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.Cloner=  hKh'KhX.   Clones the :class:`AuiDefaultToolBarArt` art. r>  hhh	h)]r?  h1X   Clone(self)r@  h3h4h5hIh7j/  ubh#)rA  }rB  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawBackgroundrC  hKh'KhX2  Draws a toolbar background with a gradient shading.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle;
:param bool `horizontal`: ``True`` if the toolbar is horizontal, ``False`` if it is vertical.rD  hhh	h)]rE  (X   dcrF  hhrG  X   wndrH  hhrI  X   _rectrJ  hhrK  X
   horizontalrL  X   TruerM  h/rN  eh1X5   DrawBackground(self, dc, wnd, _rect, horizontal=True)rO  h3h4h5X   30rP  h7j/  ubh#)rQ  }rR  (hX5   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawButtonrS  hKh'KhX   Draws a toolbar item button.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.rT  hhh	h)]rU  (X   dcrV  hhrW  X   wndrX  hhrY  X   itemrZ  hhr[  X   rectr\  hhr]  eh1X%   DrawButton(self, dc, wnd, item, rect)r^  h3h4h5X   61r_  h7j/  ubh#)r`  }ra  (hX;   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawControlLabelrb  hKh'KhX   Draws a label for a toolbar control.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.rc  hhh	h)]rd  (X   dcre  hhrf  X   wndrg  hhrh  X   itemri  hhrj  X   rectrk  hhrl  eh1X+   DrawControlLabel(self, dc, wnd, item, rect)rm  h3h4h5X   35rn  h7j/  ubh#)ro  }rp  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawDropDownButtonrq  hKh'KhX   Draws a toolbar dropdown button.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.rr  hhh	h)]rs  (X   dcrt  hhru  X   wndrv  hhrw  X   itemrx  hhry  X   rectrz  hhr{  eh1X-   DrawDropDownButton(self, dc, wnd, item, rect)r|  h3h4h5X   84r}  h7j/  ubh#)r~  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawGripperr  hKh'KhX   Draws the toolbar gripper.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   rectr  hhr  eh1X    DrawGripper(self, dc, wnd, rect)r  h3h4h5X   38r  h7j/  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawLabelr  hKh'KhX   Draws a toolbar item label.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X$   DrawLabel(self, dc, wnd, item, rect)r  h3h4h5X   41r  h7j/  ubh#)r  }r  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawOverflowButtonr  hKh'KhX	  Draws the overflow button for the :class:`AuiToolBar`.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle;
:param integer `state`: the overflow button state.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   rectr  hhr  X   stater  hhr  eh1X.   DrawOverflowButton(self, dc, wnd, rect, state)r  h3h4h5X   35r  h7j/  ubh#)r  }r  (hX>   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawPlainBackgroundr  hKh'KhX  Draws a toolbar background with a plain colour.

This method contrasts with the default behaviour of the :class:`AuiToolBar` that
draws a background gradient and this break the window design when putting
it within a control that has margin between the borders and the toolbar
(example: put :class:`AuiToolBar` within a :class:`StaticBoxSizer` that has a plain background).

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   _rectr  hhr  eh1X)   DrawPlainBackground(self, dc, wnd, _rect)r  h3h4h5X   20r  h7j/  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawSeparatorr  hKh'KhX   Draws a toolbar separator.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   _rectr  hhr  eh1X#   DrawSeparator(self, dc, wnd, _rect)r  h3h4h5X   35r  h7j/  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetAGWFlagsr  hKh'KhXs   Returns the :class:`AuiDefaultToolBarArt` flags.

:see: :meth:`~AuiDefaultToolBarArt.SetAGWFlags` for more details.r  hhh	h)]r  h1X   GetAGWFlags(self)r  h3h4h5j}  h7j/  ubh#)r  }r  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetElementSizer  hKh'KhXm  Returns the size of a UI element in the :class:`AuiToolBar`.

:param integer `element_id`: can be one of the following:

 ==================================== ==================================
 Element Identifier                   Description
 ==================================== ==================================
 ``AUI_TBART_SEPARATOR_SIZE``         Separator size in :class:`AuiToolBar`
 ``AUI_TBART_GRIPPER_SIZE``           Gripper size in :class:`AuiToolBar`
 ``AUI_TBART_OVERFLOW_SIZE``          Overflow button size in :class:`AuiToolBar`
 ==================================== ==================================r  hhh	h)]r  X
   element_idr  hhr  ah1X    GetElementSize(self, element_id)r  h3h4h5X   24r  h7j/  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetFontr  hKh'KhX0   Returns the :class:`AuiDefaultToolBarArt` font. r  hhh	h)]r  h1X
   GetFont(self)r  h3h4h5hIh7j/  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetLabelSizer  hKh'KhX   Returns the label size for a toolbar item.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  eh1X!   GetLabelSize(self, dc, wnd, item)r  h3h4h5X   14r  h7j/  ubh#)r  }r  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetOrientationr  hKh'KhX!   Returns the toolbar orientation. r  hhh	h)]r  h1X   GetOrientation(self)r  h3h4h5hIh7j/  ubh#)r  }r  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetTextOrientationr  hKh'KhX   Returns the :class:`AuiDefaultToolBarArt` text orientation.

:see: :meth:`~AuiDefaultToolBarArt.SetTextOrientation` for more details.r  hhh	h)]r  h1X   GetTextOrientation(self)r  h3h4h5j}  h7j/  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetToolSizer  hKh'KhX   Returns the toolbar item size.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  eh1X    GetToolSize(self, dc, wnd, item)r  h3h4h5X   53r  h7j/  ubh#)r  }r  (hX;   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetToolsPositionr   hKh'KhX   Returns the bitmap and text rectangles for a toolbar item.

:param `dc`: a :class:`wx.DC` device context;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the tool rectangle.r  hhh	h)]r  (X   dcr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X&   GetToolsPosition(self, dc, item, rect)r	  h3h4h5X   47r
  h7j/  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetAGWFlagsr
  hKh'KhX  Sets the toolbar art flags.

:param integer `agwFlags`: a combination of the following values:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked. This style
                                      must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================r  hhh	h)]r  X   agwFlagsr  hhr  ah1X   SetAGWFlags(self, agwFlags)r  h3h4h5X   25r  h7j/  ubh#)r  }r  (hX<   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetDefaultColoursr  hKh'KhX   Sets the default colours, which are calculated from the given base colour.

:param `base_colour`: an instance of :class:`wx.Colour`. If defaulted to ``None``, a colour
 is generated accordingly to the platform and theme.r  hhh	h)]r  X   base_colourr  X   Noner  X   Noner  r  ah1X)   SetDefaultColours(self, base_colour=None)r  h3h4h5X   20r  h7j/  ubh#)r  }r   (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetElementSizer!  hKh'KhX  Sets the size of a UI element in the :class:`AuiToolBar`.

:param integer `element_id`: can be one of the following:

 ==================================== ==================================
 Element Identifier                   Description
 ==================================== ==================================
 ``AUI_TBART_SEPARATOR_SIZE``         Separator size in :class:`AuiToolBar`
 ``AUI_TBART_GRIPPER_SIZE``           Gripper size in :class:`AuiToolBar`
 ``AUI_TBART_OVERFLOW_SIZE``          Overflow button size in :class:`AuiToolBar`
 ==================================== ==================================

:param integer `size`: the new size of the UI element.r"  hhh	h)]r#  (X
   element_idr$  hhr%  X   sizer&  hhr'  eh1X&   SetElementSize(self, element_id, size)r(  h3h4h5X   24r)  h7j/  ubh#)r*  }r+  (hX2   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetFontr,  hKh'KhXv   Sets the :class:`AuiDefaultToolBarArt` font.

:param wx.Font `font`: the font used for displaying toolbar item labels.r-  hhh	h)]r.  X   fontr/  hhr0  ah1X   SetFont(self, font)r1  h3h4h5j}  h7j/  ubh#)r2  }r3  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetOrientationr4  hKh'KhX   Sets the toolbar tool orientation.

:param integer `orientation`: one of ``AUI_TBTOOL_HORIZONTAL``, ``AUI_TBTOOL_VERT_CLOCKWISE`` or
 ``AUI_TBTOOL_VERT_COUNTERCLOCKWISE``.r5  hhh	h)]r6  X   orientationr7  hhr8  ah1X!   SetOrientation(self, orientation)r9  h3h4h5X   10r:  h7j/  ubh#)r;  }r<  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetTextOrientationr=  hKh'KhX  Sets the text orientation.

:param integer `orientation`: can be one of the following constants:

 ==================================== ==================================
 Orientation Switches                 Description
 ==================================== ==================================
 ``AUI_TBTOOL_TEXT_LEFT``             Text in :class:`AuiToolBar` items is aligned left
 ``AUI_TBTOOL_TEXT_RIGHT``            Text in :class:`AuiToolBar` items is aligned right
 ``AUI_TBTOOL_TEXT_TOP``              Text in :class:`AuiToolBar` items is aligned top
 ``AUI_TBTOOL_TEXT_BOTTOM``           Text in :class:`AuiToolBar` items is aligned bottom
 ==================================== ==================================r>  hhh	h)]r?  X   orientationr@  hhrA  ah1X%   SetTextOrientation(self, orientation)rB  h3h4h5X   19rC  h7j/  ubh#)rD  }rE  (hX7   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.ShowDropDownrF  hKh'KhX   Shows the drop down window menu for overflow items.

:param `wnd`: an instance of :class:`wx.Window`;
:param list `items`: a list of the overflow toolbar items.rG  hhh	h)]rH  (X   wndrI  hhrJ  X   itemsrK  hhrL  eh1X   ShowDropDown(self, wnd, items)rM  h3h4h5X   52rN  h7j/  ubehd]rO  (]rP  X   objectrQ  a]rR  ]rS  X   AuiDefaultToolBarArtrT  aaehk]rU  hm]rV  h1X   AuiDefaultToolBarArt(object)rW  hpj  )rX  }rY  (j  ]rZ  X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtr[  ]r\  r]  aj  ]r^  X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtr_  aj  j/  ubh'Kh3hqhrX]   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.txtr`  h7j)  h5X   770ra  j  ]rb  (X   __init__rc  X   Clonerd  X   DrawBackgroundre  X
   DrawButtonrf  X   DrawControlLabelrg  X   DrawDropDownButtonrh  X   DrawGripperri  X	   DrawLabelrj  X   DrawOverflowButtonrk  X   DrawPlainBackgroundrl  X
   DrawSeparatorrm  X   GetAGWFlagsrn  X   GetElementSizero  X   GetFontrp  X   GetLabelSizerq  X   GetOrientationrr  X   GetTextOrientationrs  X   GetToolSizert  X   GetToolsPositionru  X   SetAGWFlagsrv  X   SetDefaultColoursrw  X   SetElementSizerx  X   SetFontry  X   SetOrientationrz  X   SetTextOrientationr{  X   ShowDropDownr|  ej  jV  ubh)r}  }r~  (hX    wx.lib.agw.aui.auibar.AuiToolBarr  hKhX  AuiToolBar is a completely owner-drawn toolbar perfectly integrated with the AUI layout system.
This allows drag and drop of toolbars, docking/floating behaviour and the possibility to define
"overflow" items in the toolbar itself.

The default theme that is used is :class:`AuiDefaultToolBarArt`, which provides a modern,
glossy look and feel. The theme can be changed by calling :meth:`AuiToolBar.SetArtProvider`.r  hhh	h
]r  (h#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.__init__r  hKh'KhXh  Default class constructor.

:param wx.Window `parent`: the :class:`AuiToolBar` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the control window style;
:param integer `agwStyle`: the AGW-specific window style. This can be a combination of the
 following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked.
                                      This style must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================

 The default value for `agwStyle` is: ``AUI_TB_DEFAULT_STYLE`` = 0r  hhh	h)]r  (X   parentr  hhr  X   idr  X	   wx.ID_ANYr  X   -1r  r  X   posr  X   wx.DefaultPositionr  X   (-1, -1)r  r  X   sizer  X   wx.DefaultSizer  X   (-1, -1)r  r  X   styler  j  X   0r  r  X   agwStyler  X   AUI_TB_DEFAULT_STYLEr  X   0r  r  eh1Xy   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, agwStyle=AUI_TB_DEFAULT_STYLE)r  h3h4h5X   96r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddCheckToolr  hKh'KhX   Adds a new check (or toggle) tool to the :class:`AuiToolBar`.

:see: :meth:`AddTool` for an explanation of the input parameters.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   disabled_bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   long_help_stringr  X   ""r  hr  X   client_datar  X   Noner  X   Noner  r  eh1Xx   AddCheckTool(self, tool_id, label, bitmap, disabled_bitmap, short_help_string="", long_help_string="", client_data=None)r  h3h4h5j}  h7j}  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.AddControlr  hKh'KhX   Adds any control to the toolbar, typically e.g. a :class:`ComboBox`.

:param wx.Window `control`: the control to be added;
:param string `label`: the label which appears if the control goes into the
 overflow items in the toolbar.r  hhh	h)]r  (X   controlr  hhr  X   labelr  X   ""r  hr  eh1X#   AddControl(self, control, label="")r  h3h4h5X   30r  h7j}  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.AddLabelr  hKh'KhX   Adds a label tool to the :class:`AuiToolBar`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param integer `width`: the tool width.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  X   ""r  hr  X   widthr  j  X   0r  r  eh1X*   AddLabel(self, tool_id, label="", width=0)r  h3h4h5X   39r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddRadioToolr  hKh'KhX%  Adds a new radio tool to the toolbar.

Consecutive radio tools form a radio group such that exactly one button
in the group is pressed at any moment, in other words whenever a button
in the group is pressed the previously pressed button is automatically
released. You should avoid having the radio groups of only one element
as it would be impossible for the user to use such button.

:note: By default, the first button in the radio group is initially pressed,
 the others are not.

:see: :meth:`AddTool` for an explanation of the input parameters.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   disabled_bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   long_help_stringr  X   ""r  hr  X   client_datar  X   Noner  X   Noner  r  eh1Xx   AddRadioTool(self, tool_id, label, bitmap, disabled_bitmap, short_help_string="", long_help_string="", client_data=None)r  h3h4h5X   18r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddSeparatorr  hKh'KhX.   Adds a separator for spacing groups of tools. r  hhh	h)]r  h1X   AddSeparator(self)r  h3h4h5X   23r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.AddSimpleToolr  hKh'KhXo  Adds a tool to the toolbar. This is the simplest method you can use to
add an item to the :class:`AuiToolBar`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param string `short_help_string`: this string is used for the tools tooltip;
:param integer `kind`: the item kind. Can be one of the following:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================

:param `target`: a custom string indicating that an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`
 has been minimized into this toolbar.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   kindr  X   ITEM_NORMALr   X   0r  r  X   targetr  X   Noner  X   Noner  r  eh1X`   AddSimpleTool(self, tool_id, label, bitmap, short_help_string="", kind=ITEM_NORMAL, target=None)r  h3h4h5X   29r  h7j}  ubh#)r	  }r
  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.AddSpacerr  hKh'KhX]   Adds a spacer for spacing groups of tools.

:param integer `pixels`: the width of the spacer.r  hhh	h)]r
  X   pixelsr  hhr  ah1X   AddSpacer(self, pixels)r  h3h4h5X   28r  h7j}  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.AddStretchSpacerr  hKh'KhXw   Adds a stretchable spacer for spacing groups of tools.

:param integer `proportion`: the stretchable spacer proportion.r  hhh	h)]r  X
   proportionr  X   1r  X   1r  r  ah1X$   AddStretchSpacer(self, proportion=1)r  h3h4h5X   28r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.AddToggleToolr  hKh'KhX  Adds a toggle tool to the toolbar.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param wx.Bitmap `disabled_bitmap`: the bitmap to use when the tool is disabled. If it is equal to
 :class:`NullBitmap`, the disabled bitmap is automatically generated by greing the normal one;
:param PyObject `client_data`: whatever Python object to associate with the toolbar item;
:param string `short_help_string`: this string is used for the tools tooltip;
:param string `long_help_string`: this string is shown in the statusbar (if any) of the parent
 frame when the mouse pointer is inside the tool.r   hhh	h)]r!  (X   tool_idr"  hhr#  X   bitmapr$  hhr%  X   disabled_bitmapr&  hhr'  X   toggler(  X   Falser)  X   Falser*  r+  X   client_datar,  X   Noner-  X   Noner.  r/  X   short_help_stringr0  X   ""r1  hr2  X   long_help_stringr3  X   ""r4  hr5  eh1X   AddToggleTool(self, tool_id, bitmap, disabled_bitmap, toggle=False, client_data=None, short_help_string="", long_help_string="")r6  h3h4h5X   17r7  h7j}  ubh#)r8  }r9  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.AddToolr:  hKh'KhX  Adds a tool to the toolbar. This is the full feature version of :meth:`AddTool`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param wx.Bitmap `disabled_bitmap`: the bitmap to use when the tool is disabled. If it is equal to
 :class:`NullBitmap`, the disabled bitmap is automatically generated by greing the normal one;
:param integer `kind`: the item kind. Can be one of the following:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================

:param string `short_help_string`: this string is used for the tools tooltip;
:param string `long_help_string`: this string is shown in the statusbar (if any) of the parent
 frame when the mouse pointer is inside the tool.
:param PyObject `client_data`: whatever Python object to associate with the toolbar item.
:param `target`: a custom string indicating that an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`
 has been minimized into this toolbar.r;  hhh	h)]r<  (X   tool_idr=  hhr>  X   labelr?  hhr@  X   bitmaprA  hhrB  X   disabled_bitmaprC  hhrD  X   kindrE  hhrF  X   short_help_stringrG  X   ''rH  hrI  X   long_help_stringrJ  X   ''rK  hrL  X   client_datarM  X   NonerN  X   NonerO  rP  X   targetrQ  X   NonerR  X   NonerS  rT  eh1X   AddTool(self, tool_id, label, bitmap, disabled_bitmap, kind, short_help_string='', long_help_string='', client_data=None, target=None)rU  h3h4h5X   64rV  h7j}  ubh#)rW  }rX  (hX&   wx.lib.agw.aui.auibar.AuiToolBar.ClearrY  hKh'KhX2   Deletes all the tools in the :class:`AuiToolBar`. rZ  hhh	h)]r[  h1X   Clear(self)r\  h3h4h5hCh7j}  ubh#)r]  }r^  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.ClearToolsr_  hKh'KhX2   Deletes all the tools in the :class:`AuiToolBar`. r`  hhh	h)]ra  h1X   ClearTools(self)rb  h3h4h5hIh7j}  ubh#)rc  }rd  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.DeleteToolre  hKh'KhX7  Removes the specified tool from the toolbar and deletes it.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.

:returns: ``True`` if the tool was deleted, ``False`` otherwise.

:note: Note that it is unnecessary to call :meth:`Realize` for the change to
 take place, it will happen immediately.rf  hhh	h)]rg  X   tool_idrh  hhri  ah1X   DeleteTool(self, tool_id)rj  h3h4h5X   21rk  h7j}  ubh#)rl  }rm  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.DeleteToolByPosrn  hKh'KhX   This function behaves like :meth:`DeleteTool` but it deletes the tool at the specified position and not the one with the given id.

:param integer `pos`: the tool position.

:see: :meth:`~AuiToolBar.DeleteTool`ro  hhh	h)]rp  X   posrq  hhrr  ah1X   DeleteToolByPos(self, pos)rs  h3h4h5X   17rt  h7j}  ubh#)ru  }rv  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.DoGetBestSizerw  hKh'KhX   Gets the size which best suits the window: for a control, it would be the
minimal size which doesn't truncate the control, for a panel - the same
size as it would have after a call to `Fit()`.

:note: Overridden from :class:`wx.Control`.rx  hhh	h)]ry  h1X   DoGetBestSize(self)rz  h3h4h5X   11r{  h7j}  ubh#)r|  }r}  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.DoIdleUpdater~  hKh'KhX'   Updates the toolbar during idle times. r  hhh	h)]r  h1X   DoIdleUpdate(self)r  h3h4h5X   60r  h7j}  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.DoSetSizer  hKh'KhX  Sets the position and size of the window in pixels. The `sizeFlags`
parameter indicates the interpretation of the other params if they are
equal to -1.

:param integer `x`: the window `x` position;
:param integer `y`: the window `y` position;
:param integer `width`: the window width;
:param integer `height`: the window height;
:param integer `sizeFlags`: may have one of this bit set:

 ===================================  ======================================
 Size Flags                           Description
 ===================================  ======================================
 ``wx.SIZE_AUTO``                     A -1 indicates that a class-specific default should be used.
 ``wx.SIZE_AUTO_WIDTH``               A -1 indicates that a class-specific default should be used for the width.
 ``wx.SIZE_AUTO_HEIGHT``              A -1 indicates that a class-specific default should be used for the height.
 ``wx.SIZE_USE_EXISTING``             Existing dimensions should be used if -1 values are supplied.
 ``wx.SIZE_ALLOW_MINUS_ONE``          Allow dimensions of -1 and less to be interpreted as real dimensions, not default values.
 ``wx.SIZE_FORCE``                    Normally, if the position and the size of the window are already the same as the
                                      parameters of this function, nothing is done. but with this flag a window resize may
                                      be forced even in this case (supported in wx 2.6.2 and later and only implemented
                                      for MSW and ignored elsewhere currently)
 ===================================  ======================================

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  (X   xr  hhr  X   yr  hhr  X   widthr  hhr  X   heightr  hhr  X	   sizeFlagsr  X   wx.SIZE_AUTOr  X   3r  r  eh1X<   DoSetSize(self, x, y, width, height, sizeFlags=wx.SIZE_AUTO)r  h3h4h5X   37r  h7j}  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.EnableToolr  hKh'KhX   Enables or disables the tool.

:param integer `tool_id`: identifier for the tool to enable or disable.
:param bool `state`: if ``True``, enables the tool, otherwise disables it.r  hhh	h)]r  (X   tool_idr  hhr  X   stater  hhr  eh1X    EnableTool(self, tool_id, state)r  h3h4h5X   17r  h7j}  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.FindControlr  hKh'KhX   Returns a pointer to the control identified by `id` or ``None`` if no corresponding control is found.

:param integer `id`: the control identifier.r  hhh	h)]r  X   idr  hhr  ah1X   FindControl(self, id)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.FindToolr  hKh'KhXf   Finds a tool for the given tool id.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   FindTool(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.FindToolByIndexr  hKh'KhX   Finds a tool for the given tool position in the :class:`AuiToolBar`.

:param integer `pos`: the tool position in the toolbar.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  X   posr  hhr  ah1X   FindToolByIndex(self, pos)r  h3h4h5X   14r  h7j}  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.FindToolByLabelr  hKh'KhX\   Finds a tool for the given label.

:param string `label`: the :class:`AuiToolBarItem` label.r  hhh	h)]r  X   labelr  hhr  ah1X   FindToolByLabel(self, label)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiToolBar.FindToolForPositionr  hKh'KhX   Finds a tool for the given mouse position.

:param integer `x`: mouse `x` position;
:param integer `y`: mouse `y` position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   FindToolForPosition(self, x, y)r  h3h4h5X   25r  h7j}  ubh#)r  }r  (hX?   wx.lib.agw.aui.auibar.AuiToolBar.FindToolForPositionWithPackingr  hKh'KhX  Finds a tool for the given mouse position, taking into account also the tool packing.

:param integer `x`: mouse `x` position;
:param integer `y`: mouse `y` position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  (j  hhr  j  hhr  eh1X*   FindToolForPositionWithPacking(self, x, y)r  h3h4h5X   32r  h7j}  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.GetAGWWindowStyleFlagr  hKh'KhX   Returns the AGW-specific window style flag.

:see: :meth:`SetAGWWindowStyleFlag` for an explanation of various AGW-specific style.r  hhh	h)]r  h1X   GetAGWWindowStyleFlag(self)r  h3h4h5j}  h7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetArtProviderr  hKh'KhX-   Returns the current art provider being used. r  hhh	h)]r  h1X   GetArtProvider(self)r  h3h4h5hIh7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetAuiManagerr  hKh'KhXX   Returns the :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the toolbar. r  hhh	h)]r  h1X   GetAuiManager(self)r  h3h4h5jr  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetGripperVisibler  hKh'KhX7   Returns whether the toolbar gripper is visible or not. r  hhh	h)]r  h1X   GetGripperVisible(self)r  h3h4h5hIh7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetLabelSizer  hKh'KhXR   Returns the standard size of a toolbar item.

:param string `label`: a test label.r  hhh	h)]r  X   labelr  hhr  ah1X   GetLabelSize(self, label)r  h3h4h5X   12r  h7j}  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowRectr  hKh'KhX.   Returns the rectangle of the overflow button. r  hhh	h)]r  h1X   GetOverflowRect(self)r  h3h4h5X   23r  h7j}  ubh#)r  }r   (hX1   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowStater  hKh'KhX*   Returns the state of the overflow button. r  hhh	h)]r  h1X   GetOverflowState(self)r  h3h4h5hIh7j}  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowVisibler  hKh'KhX7   Returns whether the overflow button is visible or not. r  hhh	h)]r	  h1X   GetOverflowVisible(self)r
  h3h4h5hIh7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBarFitsr
  hKh'KhXG   Returns whether the :class:`AuiToolBar` size fits in a specified size. r  hhh	h)]r  h1X   GetToolBarFits(self)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBitmapr  hKh'KhXm   Returns the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolBitmap(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBitmapSizer  hKh'KhX;  Returns the size of bitmap that the toolbar expects to have. The default bitmap size is 16 by 15 pixels.

:note: Note that this is the size of the bitmap you pass to :meth:`AddTool`,
 and not the eventual size of the tool button.

.. todo::

   Add :class:`ToolBar` compatibility, actually implementing this method.r  hhh	h)]r  h1X   GetToolBitmapSize(self)r   h3h4h5X   16r!  h7j}  ubh#)r"  }r#  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBorderPaddingr$  hKh'KhXF   Returns the padding between the tool border and the label, in pixels. r%  hhh	h)]r&  h1X   GetToolBorderPadding(self)r'  h3h4h5hIh7j}  ubh#)r(  }r)  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolCountr*  hKh'KhX8   Returns the number of tools in the :class:`AuiToolBar`. r+  hhh	h)]r,  h1X   GetToolCount(self)r-  h3h4h5hIh7j}  ubh#)r.  }r/  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetToolDropDownr0  hKh'KhX   Returns whether the toolbar item identified by `tool_id` has an associated drop down window menu or not.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r1  hhh	h)]r2  X   tool_idr3  hhr4  ah1X   GetToolDropDown(self, tool_id)r5  h3h4h5X   13r6  h7j}  ubh#)r7  }r8  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolEnabledr9  hKh'KhXs   Returns whether the tool identified by `tool_id` is enabled or not.

:param integer `tool_id`: the tool identifier.r:  hhh	h)]r;  X   tool_idr<  hhr=  ah1X   GetToolEnabled(self, tool_id)r>  h3h4h5X   14r?  h7j}  ubh#)r@  }rA  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.GetToolFitsrB  hKh'KhX   Returns whether the tool identified by `tool_id` fits into the toolbar or not.

:param integer `tool_id`: the toolbar item identifier.rC  hhh	h)]rD  X   tool_idrE  hhrF  ah1X   GetToolFits(self, tool_id)rG  h3h4h5j}  h7j}  ubh#)rH  }rI  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetToolFitsByIndexrJ  hKh'KhX   Returns whether the tool identified by `tool_id` fits into the toolbar or not.

:param integer `tool_id`: the toolbar item identifier.rK  hhh	h)]rL  X   tool_idrM  hhrN  ah1X!   GetToolFitsByIndex(self, tool_id)rO  h3h4h5X   36rP  h7j}  ubh#)rQ  }rR  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolIndexrS  hKh'KhX}   Returns the position of the tool in the toolbar given its identifier.

:param integer `tool_id`: the toolbar item identifier.rT  hhh	h)]rU  X   tool_idrV  hhrW  ah1X   GetToolIndex(self, tool_id)rX  h3h4h5X   18rY  h7j}  ubh#)rZ  }r[  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolLabelr\  hKh'KhXl   Returns the tool label for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier.r]  hhh	h)]r^  X   tool_idr_  hhr`  ah1X   GetToolLabel(self, tool_id)ra  h3h4h5X   13rb  h7j}  ubh#)rc  }rd  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetToolLongHelpre  hKh'KhXY   Returns the long help for the given tool.

:param integer `tool_id`: the tool identifier.rf  hhh	h)]rg  X   tool_idrh  hhri  ah1X   GetToolLongHelp(self, tool_id)rj  h3h4h5X   13rk  h7j}  ubh#)rl  }rm  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetToolOrientationrn  hKh'KhX/   Returns the orientation for the toolbar items. ro  hhh	h)]rp  h1X   GetToolOrientation(self)rq  h3h4h5hIh7j}  ubh#)rr  }rs  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolPackingrt  hKh'KhXH   Returns the value used for spacing tools. The default value is 1 pixel. ru  hhh	h)]rv  h1X   GetToolPacking(self)rw  h3h4h5hIh7j}  ubh#)rx  }ry  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.GetToolPosrz  hKh'KhX}   Returns the position of the tool in the toolbar given its identifier.

:param integer `tool_id`: the toolbar item identifier.r{  hhh	h)]r|  X   tool_idr}  hhr~  ah1X   GetToolPos(self, tool_id)r  h3h4h5j}  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolProportionr  hKh'KhXn   Returns the tool proportion in the toolbar.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X    GetToolProportion(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.GetToolRectr  hKh'KhXZ   Returns the toolbar item rectangle

:param integer `tool_id`: the toolbar item identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolRect(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolSeparationr  hKh'KhX7   Returns the separator size for the toolbar, in pixels. r  hhh	h)]r  h1X   GetToolSeparation(self)r  h3h4h5jr  h7j}  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.GetToolShortHelpr  hKh'KhXZ   Returns the short help for the given tool.

:param integer `tool_id`: the tool identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolShortHelp(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetToolStickyr  hKh'KhX   Returns whether the toolbar item identified by `tool_id` has a sticky behaviour or not.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolSticky(self, tool_id)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.GetToolTextOrientationr  hKh'KhX5   Returns the label orientation for the toolbar items. r  hhh	h)]r  h1X   GetToolTextOrientation(self)r  h3h4h5hIh7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolToggledr  hKh'KhX   Returns whether a tool is toggled or not.

:param integer `tool_id`: the toolbar item identifier.

:note: This only applies to a tool that has been specified as a toggle tool.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolToggled(self, tool_id)r  h3h4h5X   19r  h7j}  ubh#)r  }r  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.HitTestr  hKh'KhXL  Finds a tool for the given mouse position.

:param integer `x`: mouse `x` screen position;
:param integer `y`: mouse `y` screen position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.

:note: This method is similar to :meth:`FindToolForPosition` but it works with absolute coordinates.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   HitTest(self, x, y)r  h3h4h5X   14r  h7j}  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.IsPaneMinimizedr  hKh'KhXI   Returns whether this :class:`AuiToolBar` contains a minimized pane tool. r  hhh	h)]r  h1X   IsPaneMinimized(self)r  h3h4h5X   19r  h7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.OnCustomRenderr  hKh'KhX  Handles custom render for single :class:`AuiToolBar` items.

:param `dc`: a :class:`wx.DC` device context;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the toolbar item rect.

:note: This method must be overridden to provide custom rendering of items.r  hhh	h)]r  (X   dcr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X$   OnCustomRender(self, dc, item, rect)r  h3h4h5X   13r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.OnEraseBackgroundr  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`AuiToolBar`.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r  hhh	h)]r  X   eventr  hhr  ah1X   OnEraseBackground(self, event)r  h3h4h5X   11r  h7j}  ubh#)r  }r  (hX'   wx.lib.agw.aui.auibar.AuiToolBar.OnIdler  hKh'KhXw   Handles the ``wx.EVT_IDLE`` event for :class:`AuiToolBar`.

:param `event`: a :class:`IdleEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnIdle(self, event)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.OnLeaveWindowr  hKh'KhX   Handles the ``wx.EVT_LEAVE_WINDOW`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnLeaveWindow(self, event)r  h3h4h5X   14r  h7j}  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.OnLeftDownr  hKh'KhX}   Handles the ``wx.EVT_LEFT_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnLeftDown(self, event)r  h3h4h5X   117r  h7j}  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.OnLeftUpr  hKh'KhX{   Handles the ``wx.EVT_LEFT_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr   ah1X   OnLeftUp(self, event)r  h3h4h5X   77r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.OnMiddleDownr  hKh'KhX   Handles the ``wx.EVT_MIDDLE_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr	  ah1X   OnMiddleDown(self, event)r
  h3h4h5X   32r  h7j}  ubh#)r  }r
  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.OnMiddleUpr  hKh'KhX}   Handles the ``wx.EVT_MIDDLE_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnMiddleUp(self, event)r  h3h4h5X   23r  h7j}  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.OnMotionr  hKh'KhXz   Handles the ``wx.EVT_MOTION`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnMotion(self, event)r  h3h4h5X   66r  h7j}  ubh#)r  }r  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.OnPaintr   hKh'KhXy   Handles the ``wx.EVT_PAINT`` event for :class:`AuiToolBar`.

:param `event`: a :class:`PaintEvent` event to be processed.r!  hhh	h)]r"  X   eventr#  hhr$  ah1X   OnPaint(self, event)r%  h3h4h5X   92r&  h7j}  ubh#)r'  }r(  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.OnRightDownr)  hKh'KhX~   Handles the ``wx.EVT_RIGHT_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r*  hhh	h)]r+  X   eventr,  hhr-  ah1X   OnRightDown(self, event)r.  h3h4h5X   31r/  h7j}  ubh#)r0  }r1  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.OnRightUpr2  hKh'KhX|   Handles the ``wx.EVT_RIGHT_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r3  hhh	h)]r4  X   eventr5  hhr6  ah1X   OnRightUp(self, event)r7  h3h4h5X   32r8  h7j}  ubh#)r9  }r:  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.OnSetCursorr;  hKh'KhX   Handles the ``wx.EVT_SET_CURSOR`` event for :class:`AuiToolBar`.

:param `event`: a :class:`SetCursorEvent` event to be processed.r<  hhh	h)]r=  X   eventr>  hhr?  ah1X   OnSetCursor(self, event)r@  h3h4h5X   17rA  h7j}  ubh#)rB  }rC  (hX'   wx.lib.agw.aui.auibar.AuiToolBar.OnSizerD  hKh'KhXz   Handles the ``wx.EVT_SIZE`` event for :class:`AuiToolBar`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.rE  hhh	h)]rF  X   eventrG  hhrH  ah1X   OnSize(self, event)rI  h3h4h5X   65rJ  h7j}  ubh#)rK  }rL  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.RealizerM  hKh'KhXQ   Realizes the toolbar. This function should be called after you have added tools. rN  hhh	h)]rO  h1X
   Realize(self)rP  h3h4h5X   214rQ  h7j}  ubh#)rR  }rS  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.RefreshOverflowStaterT  hKh'KhX   Refreshes the overflow button. rU  hhh	h)]rV  h1X   RefreshOverflowState(self)rW  h3h4h5X   34rX  h7j}  ubh#)rY  }rZ  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.SetAGWWindowStyleFlagr[  hKh'KhX  Sets the AGW-specific style of the window.

:param integer `agwStyle`: the new window style. This can be a combination of the
 following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked.
                                      This style must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.r\  hhh	h)]r]  X   agwStyler^  hhr_  ah1X%   SetAGWWindowStyleFlag(self, agwStyle)r`  h3h4h5X   53ra  h7j}  ubh#)rb  }rc  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetArtProviderrd  hKh'KhX  Instructs :class:`AuiToolBar` to use art provider specified by parameter `art`
for all drawing calls. This allows plugable look-and-feel features.

:param `art`: an art provider.

:note: The previous art provider object, if any, will be deleted by :class:`AuiToolBar`.re  hhh	h)]rf  X   artrg  hhrh  ah1X   SetArtProvider(self, art)ri  h3h4h5X   18rj  h7j}  ubh#)rk  }rl  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetAuiManagerrm  hKh'KhXU   Sets the :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the toolbar. rn  hhh	h)]ro  X
   auiManagerrp  hhrq  ah1X   SetAuiManager(self, auiManager)rr  h3h4h5hIh7j}  ubh#)rs  }rt  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.SetCustomOverflowItemsru  hKh'KhX   Sets the two lists `prepend` and `append` as custom overflow items.

:param list `prepend`: a list of :class:`AuiToolBarItem` to be prepended;
:param list `append`: a list of :class:`AuiToolBarItem` to be appended.rv  hhh	h)]rw  (X   prependrx  hhry  X   appendrz  hhr{  eh1X-   SetCustomOverflowItems(self, prepend, append)r|  h3h4h5X   11r}  h7j}  ubh#)r~  }r  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.SetFontr  hKh'KhX}   Sets the :class:`AuiToolBar` font.

:param wx.Font `font`: the new toolbar font.

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  X   fontr  hhr  ah1X   SetFont(self, font)r  h3h4h5X   16r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetGripperVisibler  hKh'KhX   Sets whether the toolbar gripper is visible or not.

:param bool `visible`: ``True`` for a visible gripper, ``False`` otherwise.r  hhh	h)]r  X   visibler  hhr  ah1X    SetGripperVisible(self, visible)r  h3h4h5X   16r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetHoverItemr  hKh'KhXr   Sets a toolbar item to be currently hovered by the mouse.

:param `pitem`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   pitemr  hhr  ah1X   SetHoverItem(self, pitem)r  h3h4h5X   23r  h7j}  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsr  hKh'KhX   Set the values to be used as margins for the toolbar.

:param integer `left`: the left toolbar margin;
:param integer `right`: the right toolbar margin;
:param integer `top`: the top toolbar margin;
:param integer `bottom`: the bottom toolbar margin.r  hhh	h)]r  (X   leftr  X   -1r  X   -1r  r  X   rightr  X   -1r  X   -1r  r  X   topr  X   -1r  X   -1r  r  X   bottomr  X   -1r  X   -1r  r  eh1X6   SetMargins(self, left=-1, right=-1, top=-1, bottom=-1)r  h3h4h5X   19r  h7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsSizer  hKh'KhX   Set the values to be used as margins for the toolbar.

:param wx.Size `size`: the margin size (an instance of :class:`wx.Size`).r  hhh	h)]r  X   sizer  hhr  ah1X   SetMarginsSize(self, size)r  h3h4h5j}  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsXYr  hKh'KhX   Set the values to be used as margins for the toolbar.

:param integer `x`: left margin, right margin and inter-tool separation value;
:param integer `y`: top margin, bottom margin and inter-tool separation value.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   SetMarginsXY(self, x, y)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetOrientationr  hKh'KhX   Sets the toolbar orientation.

:param integer `orientation`: either ``wx.VERTICAL`` or ``wx.HORIZONTAL``.

:note: This can be temporarily overridden by :class:`~wx.lib.agw.aui.framemanager.AuiManager` when floating and
 docking a :class:`AuiToolBar`.r  hhh	h)]r  X   orientationr  hhr  ah1X!   SetOrientation(self, orientation)r  h3h4h5X   12r  h7j}  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetOverflowVisibler  hKh'KhX   Sets whether the overflow button is visible or not.

:param bool `visible`: ``True`` for a visible overflow button, ``False`` otherwise.r  hhh	h)]r  X   visibler  hhr  ah1X!   SetOverflowVisible(self, visible)r  h3h4h5X   15r  h7j}  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetPressedItemr  hKh'KhXr   Sets a toolbar item to be currently in a "pressed" state.

:param `pitem`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   pitemr  hhr  ah1X   SetPressedItem(self, pitem)r  h3h4h5X   24r  h7j}  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.SetToolAlignmentr  hKh'KhX   This sets the alignment for all of the tools within the toolbar
(only has an effect when the toolbar is expanded).

:param integer `alignment`: :class:`wx.Sizer` alignment value
 (``wx.ALIGN_CENTER_HORIZONTAL`` or ``wx.ALIGN_CENTER_VERTICAL``).r  hhh	h)]r  X	   alignmentr  X	   wx.EXPANDr  X   8192r  r  ah1X+   SetToolAlignment(self, alignment=wx.EXPAND)r  h3h4h5X   11r  h7j}  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBitmapr  hKh'KhX   Sets the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new bitmap for the toolbar item.r  hhh	h)]r  (X   tool_idr  hhr  X   bitmapr  hhr  eh1X$   SetToolBitmap(self, tool_id, bitmap)r  h3h4h5X   12r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBitmapSizer  hKh'KhX  Sets the default size of each tool bitmap. The default bitmap size is 16 by 15 pixels.

:param wx.Size `size`: the size of the bitmaps in the toolbar.

:note: This should be called to tell the toolbar what the tool bitmap
 size is. Call it before you add tools.

:note: Note that this is the size of the bitmap you pass to :meth:`AddTool`,
 and not the eventual size of the tool button.

.. todo::

   Add :class:`ToolBar` compatibility, actually implementing this method.r  hhh	h)]r  X   sizer  hhr  ah1X   SetToolBitmapSize(self, size)r  h3h4h5X   21r  h7j}  ubh#)r  }r  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBorderPaddingr  hKh'KhXi   Sets the padding between the tool border and the label.

:param integer `padding`: the padding in pixels.r  hhh	h)]r  X   paddingr   hhr  ah1X#   SetToolBorderPadding(self, padding)r  h3h4h5j}  h7j}  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.SetToolDisabledBitmapr  hKh'KhX   Sets the tool disabled bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new disabled bitmap for the toolbar item.r  hhh	h)]r  (X   tool_idr  hhr	  X   bitmapr
  hhr  eh1X,   SetToolDisabledBitmap(self, tool_id, bitmap)r  h3h4h5X   12r
  h7j}  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.SetToolDropDownr  hKh'KhX   Assigns a drop down window menu to the toolbar item.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param bool `dropdown`: whether to assign a drop down menu or not.r  hhh	h)]r  (X   tool_idr  hhr  X   dropdownr  hhr  eh1X(   SetToolDropDown(self, tool_id, dropdown)r  h3h4h5X   14r  h7j}  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetToolLabelr  hKh'KhX   Sets the tool label for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param string `label`: the new toolbar item label.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr   hhr!  eh1X"   SetToolLabel(self, tool_id, label)r"  h3h4h5X   12r#  h7j}  ubh#)r$  }r%  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.SetToolLongHelpr&  hKh'KhX   Sets the long help for the given tool.

:param integer `tool_id`: the tool identifier;
:param string `help_string`: the string for the long help.r'  hhh	h)]r(  (X   tool_idr)  hhr*  X   help_stringr+  hhr,  eh1X+   SetToolLongHelp(self, tool_id, help_string)r-  h3h4h5X   12r.  h7j}  ubh#)r/  }r0  (hX4   wx.lib.agw.aui.auibar.AuiToolBar.SetToolNormalBitmapr1  hKh'KhX   Sets the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new bitmap for the toolbar item.r2  hhh	h)]r3  (X   tool_idr4  hhr5  X   bitmapr6  hhr7  eh1X*   SetToolNormalBitmap(self, tool_id, bitmap)r8  h3h4h5X   10r9  h7j}  ubh#)r:  }r;  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetToolOrientationr<  hKh'KhXx   Sets the tool orientation for the toolbar items.

:param integer `orientation`: the :class:`AuiToolBarItem` orientation.r=  hhh	h)]r>  X   orientationr?  hhr@  ah1X%   SetToolOrientation(self, orientation)rA  h3h4h5X   11rB  h7j}  ubh#)rC  }rD  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetToolPackingrE  hKh'KhXv   Sets the value used for spacing tools. The default value is 1 pixel.

:param integer `packing`: the value for packing.rF  hhh	h)]rG  X   packingrH  hhrI  ah1X   SetToolPacking(self, packing)rJ  h3h4h5j}  h7j}  ubh#)rK  }rL  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolProportionrM  hKh'KhX   Sets the tool proportion in the toolbar.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param integer `proportion`: the tool proportion in the toolbar.rN  hhh	h)]rO  (X   tool_idrP  hhrQ  X
   proportionrR  hhrS  eh1X,   SetToolProportion(self, tool_id, proportion)rT  h3h4h5X   14rU  h7j}  ubh#)rV  }rW  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolSeparationrX  hKh'KhXd   Sets the separator size for the toolbar.

:param integer `separation`: the separator size in pixels.rY  hhh	h)]rZ  X
   separationr[  hhr\  ah1X#   SetToolSeparation(self, separation)r]  h3h4h5X   10r^  h7j}  ubh#)r_  }r`  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.SetToolShortHelpra  hKh'KhX   Sets the short help for the given tool.

:param integer `tool_id`: the tool identifier;
:param string `help_string`: the string for the short help.rb  hhh	h)]rc  (X   tool_idrd  hhre  X   help_stringrf  hhrg  eh1X,   SetToolShortHelp(self, tool_id, help_string)rh  h3h4h5X   12ri  h7j}  ubh#)rj  }rk  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetToolStickyrl  hKh'KhX   Sets the toolbar item as sticky or non-sticky.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param bool `sticky`: whether the tool should be sticky or not.rm  hhh	h)]rn  (X   tool_idro  hhrp  X   stickyrq  hhrr  eh1X$   SetToolSticky(self, tool_id, sticky)rs  h3h4h5X   24rt  h7j}  ubh#)ru  }rv  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.SetToolTextOrientationrw  hKh'KhX   Sets the label orientation for the toolbar items.

:param integer `orientation`: the :class:`AuiToolBarItem` label orientation.rx  hhh	h)]ry  X   orientationrz  hhr{  ah1X)   SetToolTextOrientation(self, orientation)r|  h3h4h5X   12r}  h7j}  ubh#)r~  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetWindowStyleFlagr  hKh'KhX>  Sets the style of the window.

:param integer `style`: the new window style.

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  X   styler  hhr  ah1X   SetWindowStyleFlag(self, style)r  h3h4h5X   15r  h7j}  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.StartPreviewTimerr  hKh'KhXm   Starts a timer in :class:`~wx.lib.agw.aui.framemanager.AuiManager` to slide-in/slide-out the minimized pane. r  hhh	h)]r  h1X   StartPreviewTimer(self)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.StopPreviewTimerr  hKh'KhXl   Stops a timer in :class:`~wx.lib.agw.aui.framemanager.AuiManager` to slide-in/slide-out the minimized pane. r  hhh	h)]r  h1X   StopPreviewTimer(self)r  h3h4h5X   10r  h7j}  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.ToggleToolr  hKh'KhX  Toggles a tool on or off. This does not cause any event to get emitted.

:param integer `tool_id`: tool in question.
:param bool `state`: if ``True``, toggles the tool on, otherwise toggles it off.

:note: This only applies to a tool that has been specified as a toggle tool.r  hhh	h)]r  (X   tool_idr  hhr  X   stater  hhr  eh1X    ToggleTool(self, tool_id, state)r  h3h4h5X   39r  h7j}  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  X
   AuiToolBarr  aaeeee]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeeehk]r  hm]r  X
   wx.Controlr  ah1X   AuiToolBar(wx.Control)r  hpj  )r  }r  (j  ]r  (X    wx.lib.agw.aui.auibar.AuiToolBarr  ]r  X
   wx.Controlr  ar  X
   wx.Controlr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  ej  ]r  X    wx.lib.agw.aui.auibar.AuiToolBarr  aj  j}  ubh'Kh3hqhrXS   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBar.txtr  h7j)  h5X   2509r  j  ]r  (X   __init__r  X   AddCheckToolr  X
   AddControlr  X   AddLabelr  X   AddRadioToolr  X   AddSeparatorr  X
   AddSimpleToolr  X	   AddSpacerr  X   AddStretchSpacerr  X
   AddToggleToolr  X   AddToolr  X   Clearr  X
   ClearToolsr  X
   DeleteToolr  X   DeleteToolByPosr  X
   DoGetBestSizer  X   DoIdleUpdater  X	   DoSetSizer  X
   EnableToolr  X   FindControlr  X   FindToolr  X   FindToolByIndexr  X   FindToolByLabelr  X   FindToolForPositionr  X   FindToolForPositionWithPackingr   X   GetAGWWindowStyleFlagr  X   GetArtProviderr  X
   GetAuiManagerr  X   GetGripperVisibler  X   GetLabelSizer  X   GetOverflowRectr  X   GetOverflowStater  X   GetOverflowVisibler  X   GetToolBarFitsr	  X
   GetToolBitmapr
  X   GetToolBitmapSizer  X   GetToolBorderPaddingr  X   GetToolCountr
  X   GetToolDropDownr  X   GetToolEnabledr  X   GetToolFitsr  X   GetToolFitsByIndexr  X   GetToolIndexr  X   GetToolLabelr  X   GetToolLongHelpr  X   GetToolOrientationr  X   GetToolPackingr  X
   GetToolPosr  X   GetToolProportionr  X   GetToolRectr  X   GetToolSeparationr  X   GetToolShortHelpr  X
   GetToolStickyr  X   GetToolTextOrientationr  X   GetToolToggledr  X   HitTestr  X   IsPaneMinimizedr   X   OnCustomRenderr!  X   OnEraseBackgroundr"  X   OnIdler#  X
   OnLeaveWindowr$  X
   OnLeftDownr%  X   OnLeftUpr&  X   OnMiddleDownr'  X
   OnMiddleUpr(  X   OnMotionr)  X   OnPaintr*  X   OnRightDownr+  X	   OnRightUpr,  X   OnSetCursorr-  X   OnSizer.  X   Realizer/  X   RefreshOverflowStater0  X   SetAGWWindowStyleFlagr1  X   SetArtProviderr2  X
   SetAuiManagerr3  X   SetCustomOverflowItemsr4  X   SetFontr5  X   SetGripperVisibler6  X   SetHoverItemr7  X
   SetMarginsr8  X   SetMarginsSizer9  X   SetMarginsXYr:  X   SetOrientationr;  X   SetOverflowVisibler<  X   SetPressedItemr=  X   SetToolAlignmentr>  X
   SetToolBitmapr?  X   SetToolBitmapSizer@  X   SetToolBorderPaddingrA  X   SetToolDisabledBitmaprB  X   SetToolDropDownrC  X   SetToolLabelrD  X   SetToolLongHelprE  X   SetToolNormalBitmaprF  X   SetToolOrientationrG  X   SetToolPackingrH  X   SetToolProportionrI  X   SetToolSeparationrJ  X   SetToolShortHelprK  X
   SetToolStickyrL  X   SetToolTextOrientationrM  X   SetWindowStyleFlagrN  X   StartPreviewTimerrO  X   StopPreviewTimerrP  X
   ToggleToolrQ  ej  j  ubh)rR  }rS  (hX%   wx.lib.agw.aui.auibar.AuiToolBarEventrT  hKhXJ   A specialized command event class for events sent by :class:`AuiToolBar`. rU  hhh	h
]rV  (h#)rW  }rX  (hX.   wx.lib.agw.aui.auibar.AuiToolBarEvent.__init__rY  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.rZ  hhh	h)]r[  (X   command_typer\  X   Noner]  X   Noner^  r_  X   win_idr`  j  X   0ra  rb  eh1X+   __init__(self, command_type=None, win_id=0)rc  h3h4h5X   15rd  h7jR  ubh#)re  }rf  (hX+   wx.lib.agw.aui.auibar.AuiToolBarEvent.Allowrg  hKh'KhX  This is the opposite of :meth:`Veto`: it explicitly allows the event to be
processed. For most events it is not necessary to call this method as the
events are allowed anyhow but some are forbidden by default (this will
be mentioned in the corresponding event description).rh  hhh	h)]ri  h1X   Allow(self)rj  h3h4h5X   10rk  h7jR  ubh#)rl  }rm  (hX4   wx.lib.agw.aui.auibar.AuiToolBarEvent.GetNotifyEventrn  hKh'KhX)   Returns the actual :class:`NotifyEvent`. ro  hhh	h)]rp  h1X   GetNotifyEvent(self)rq  h3h4h5hIh7jR  ubh#)rr  }rs  (hX/   wx.lib.agw.aui.auibar.AuiToolBarEvent.IsAllowedrt  hKh'KhX-   Returns whether the event is allowed or not. ru  hhh	h)]rv  h1X   IsAllowed(self)rw  h3h4h5hIh7jR  ubh#)rx  }ry  (hX*   wx.lib.agw.aui.auibar.AuiToolBarEvent.Vetorz  hKh'KhX  Prevents the change announced by this event from happening.

It is in general a good idea to notify the user about the reasons for
vetoing the change because otherwise the applications behaviour (which
just refuses to do what the user wants) might be quite surprising.r{  hhh	h)]r|  h1X
   Veto(self)r}  h3h4h5X   11r~  h7jR  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  X   Eventr  a]r  (]r  X   CommandEventr  a]r  (]r  X   PyCommandEventr  a]r  (]r  X   CommandToolBarEventr  a]r  ]r  X   AuiToolBarEventr  aaeeeeeeeehk]r  hm]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ah1X$   AuiToolBarEvent(CommandToolBarEvent)r  hpj  )r  }r  (j  ]r  (X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  ]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ar  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ]r  X   wx.PyCommandEventr  ar  X   wx.PyCommandEventr  ]r  X   wx.CommandEventr  ar  X   wx.CommandEventr  ]r  X   wx.Eventr  ar  X   wx.Eventr  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  aj  jR  ubh'Kh3hqhrXX   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBarEvent.txtr  h7j)  h5X   53r  j  ]r  (X   __init__r  X   Allowr  X   GetNotifyEventr  X	   IsAllowedr  X   Vetor  ej  j  ubh)r  }r  (hX$   wx.lib.agw.aui.auibar.AuiToolBarItemr  hKhX  AuiToolBarItem is a toolbar element.

It has a unique id (except for the separators which always have id = -1), the
style (telling whether it is a normal button, separator or a control), the
state (toggled or not, enabled or not) and short and long help strings. The
default implementations use the short help string for the tooltip text which
is popped up when the mouse pointer enters the tool and the long help string
for the applications status bar.r  hhh	h
]r  (h#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.__init__r  hKh'KhXW   Default class constructor.

:param `item`: another instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   itemr  X   Noner  X   Noner  r  ah1X   __init__(self, item=None)r  h3h4h5X   38r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBarItem.Assignr  hKh'KhX~   Assigns the properties of the :class:`AuiToolBarItem` `c` to `self`.

:param `c`: another instance of :class:`AuiToolBarItem`.r  hhh	h)]r  j  hhr  ah1X   Assign(self, c)r  h3h4h5X   29r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetAlignmentr  hKh'KhX$   Returns the toolbar item alignment. r  hhh	h)]r  h1X   GetAlignment(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.GetBitmapr  hKh'KhX!   Returns the toolbar item bitmap. r  hhh	h)]r  h1X   GetBitmap(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBarItem.GetDisabledBitmapr  hKh'KhX*   Returns the toolbar item disabled bitmap. r  hhh	h)]r  h1X   GetDisabledBitmap(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.GetHoverBitmapr  hKh'KhX'   Returns the toolbar item hover bitmap. r  hhh	h)]r  h1X   GetHoverBitmap(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBarItem.GetIdr  hKh'KhX%   Returns the toolbar item identifier. r  hhh	h)]r  h1X   GetId(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBarItem.GetKindr  hKh'KhXE   Returns the toolbar item kind.

See :meth:`SetKind` for more details.r  hhh	h)]r  h1X
   GetKind(self)r  h3h4h5j}  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.GetLabelr  hKh'KhX    Returns the toolbar item label. r   hhh	h)]r  h1X   GetLabel(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.GetLongHelpr  hKh'KhX>   Returns the long help string for the :class:`AuiToolBarItem`. r  hhh	h)]r  h1X   GetLongHelp(self)r  h3h4h5hIh7j  ubh#)r	  }r
  (hX/   wx.lib.agw.aui.auibar.AuiToolBarItem.GetMinSizer  hKh'KhX'   Returns the toolbar item minimum size. r  hhh	h)]r
  h1X   GetMinSize(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.GetOrientationr  hKh'KhX&   Returns the toolbar tool orientation. r  hhh	h)]r  h1X   GetOrientation(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBarItem.GetProportionr  hKh'KhX?   Returns the :class:`AuiToolBarItem` proportion in the toolbar. r  hhh	h)]r  h1X   GetProportion(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX5   wx.lib.agw.aui.auibar.AuiToolBarItem.GetRotatedBitmapr  hKh'KhX   Returns the correct bitmap depending on the tool orientation.

:param bool `disabled`: whether to return the disabled bitmap or not.r  hhh	h)]r  X   disabledr   hhr!  ah1X    GetRotatedBitmap(self, disabled)r"  h3h4h5X   25r#  h7j  ubh#)r$  }r%  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetShortHelpr&  hKh'KhX?   Returns the short help string for the :class:`AuiToolBarItem`. r'  hhh	h)]r(  h1X   GetShortHelp(self)r)  h3h4h5hIh7j  ubh#)r*  }r+  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetSizerItemr,  hKh'KhX#   Returns the associated sizer item. r-  hhh	h)]r.  h1X   GetSizerItem(self)r/  h3h4h5hIh7j  ubh#)r0  }r1  (hX4   wx.lib.agw.aui.auibar.AuiToolBarItem.GetSpacerPixelsr2  hKh'KhXP   Returns the number of pixels for a toolbar item with kind = ``ITEM_SEPARATOR``. r3  hhh	h)]r4  h1X   GetSpacerPixels(self)r5  h3h4h5hIh7j  ubh#)r6  }r7  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.GetStater8  hKh'KhXI   Returns the toolbar item state.

:see: :meth:`SetState` for more details.r9  hhh	h)]r:  h1X   GetState(self)r;  h3h4h5j}  h7j  ubh#)r<  }r=  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.GetUserDatar>  hKh'KhX"   Returns the associated user data. r?  hhh	h)]r@  h1X   GetUserData(self)rA  h3h4h5hIh7j  ubh#)rB  }rC  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.GetWindowrD  hKh'KhX/   Returns window associated to the toolbar item. rE  hhh	h)]rF  h1X   GetWindow(self)rG  h3h4h5hIh7j  ubh#)rH  }rI  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.HasDropDownrJ  hKh'KhXI   Returns whether the toolbar item has an associated dropdown menu or not. rK  hhh	h)]rL  h1X   HasDropDown(self)rM  h3h4h5hIh7j  ubh#)rN  }rO  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.IsActiverP  hKh'KhX3   Returns whether the toolbar item is active or not. rQ  hhh	h)]rR  h1X   IsActive(self)rS  h3h4h5hIh7j  ubh#)rT  }rU  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.IsStickyrV  hKh'KhX@   Returns whether the toolbar item has a sticky behaviour or not. rW  hhh	h)]rX  h1X   IsSticky(self)rY  h3h4h5hIh7j  ubh#)rZ  }r[  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetActiver\  hKh'KhXt   Activates/deactivates the toolbar item.

:param bool `b`: ``True`` to activate the item, ``False`` to deactivate it.r]  hhh	h)]r^  j  hhr_  ah1X   SetActive(self, b)r`  h3h4h5j}  h7j  ubh#)ra  }rb  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetAlignmentrc  hKh'KhX   Sets the toolbar item alignment.

:param integer `align`: the item alignment, which can be one of the available :class:`wx.Sizer`
 alignments.rd  hhh	h)]re  X   alignrf  hhrg  ah1X   SetAlignment(self, align)rh  h3h4h5X   10ri  h7j  ubh#)rj  }rk  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetBitmaprl  hKh'KhXn   Sets the toolbar item bitmap.

:param wx.Bitmap `bmp`: the image associated with this :class:`AuiToolBarItem`.rm  hhh	h)]rn  X   bmpro  hhrp  ah1X   SetBitmap(self, bmp)rq  h3h4h5j}  h7j  ubh#)rr  }rs  (hX6   wx.lib.agw.aui.auibar.AuiToolBarItem.SetDisabledBitmaprt  hKh'KhX   Sets the toolbar item disabled bitmap.

:param wx.Bitmap `bmp`: the disabled image associated with this :class:`AuiToolBarItem`.ru  hhh	h)]rv  X   bmprw  hhrx  ah1X   SetDisabledBitmap(self, bmp)ry  h3h4h5j}  h7j  ubh#)rz  }r{  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetHasDropDownr|  hKh'KhX   Sets whether the toolbar item has an associated dropdown menu.

:param bool `b`: ``True`` to set a dropdown menu, ``False`` otherwise.r}  hhh	h)]r~  j  hhr  ah1X   SetHasDropDown(self, b)r  h3h4h5j}  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetHoverBitmapr  hKh'KhXz   Sets the toolbar item hover bitmap.

:param wx.Bitmap `bmp`: the hover image associated with this :class:`AuiToolBarItem`.r  hhh	h)]r  X   bmpr  hhr  ah1X   SetHoverBitmap(self, bmp)r  h3h4h5j}  h7j  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBarItem.SetIdr  hKh'KhXL   Sets the toolbar item identifier.

:param integer `new_id`: the new tool id.r  hhh	h)]r  X   new_idr  hhr  ah1X   SetId(self, new_id)r  h3h4h5j}  h7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBarItem.SetKindr  hKh'KhXt  Sets the :class:`AuiToolBarItem` kind.

:param integer `new_kind`: can be one of the following items:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================r  hhh	h)]r  X   new_kindr  hhr  ah1X   SetKind(self, new_kind)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.SetLabelr  hKh'KhXH   Sets the toolbar item label.

:param string `s`: the toolbar item label.r  hhh	h)]r  X   sr  hhr  ah1X   SetLabel(self, s)r  h3h4h5j}  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.SetLongHelpr  hKh'KhX   Sets the long help string for the toolbar item. This string is shown in the
statusbar (if any) of the parent frame when the mouse pointer is inside the
tool.

:param string `s`: the tool long help string.r  hhh	h)]r  j  hhr  ah1X   SetLongHelp(self, s)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBarItem.SetMinSizer  hKh'KhXW   Sets the toolbar item minimum size.

:param wx.Size `s`: the toolbar item minimum size.r  hhh	h)]r  j  hhr  ah1X   SetMinSize(self, s)r  h3h4h5j}  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetOrientationr  hKh'KhX   Sets the toolbar tool orientation.

:param integer `a`: one of ``AUI_TBTOOL_HORIZONTAL``, ``AUI_TBTOOL_VERT_CLOCKWISE`` or
 ``AUI_TBTOOL_VERT_COUNTERCLOCKWISE``.r  hhh	h)]r  j  hhr  ah1X   SetOrientation(self, a)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBarItem.SetProportionr  hKh'KhXe   Sets the :class:`AuiToolBarItem` proportion in the toolbar.

:param integer `p`: the item proportion.r  hhh	h)]r  X   pr  hhr  ah1X   SetProportion(self, p)r  h3h4h5j}  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetShortHelpr  hKh'KhX   Sets the short help string for the :class:`AuiToolBarItem`, to be displayed in a
:class:`ToolTip` when the mouse hover over the toolbar item.

:param string `s`: the tool short help string.r  hhh	h)]r  j  hhr  ah1X   SetShortHelp(self, s)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetSizerItemr  hKh'KhX`   Associates a sizer item to this toolbar item.

:param `s`: an instance of :class:`wx.SizerItem`.r  hhh	h)]r  j  hhr  ah1X   SetSizerItem(self, s)r  h3h4h5j}  h7j  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiToolBarItem.SetSpacerPixelsr  hKh'KhXs   Sets the number of pixels for a toolbar item with kind = ``ITEM_SEPARATOR``.

:param integer `s`: number of pixels.r  hhh	h)]r  j  hhr  ah1X   SetSpacerPixels(self, s)r  h3h4h5j}  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.SetStater  hKh'KhX*  Sets the toolbar item state.

:param `new_state`: can be one of the following states:

 ============================================  ======================================
 Button State Constant                         Description
 ============================================  ======================================
 ``AUI_BUTTON_STATE_NORMAL``                   Normal button state
 ``AUI_BUTTON_STATE_HOVER``                    Hovered button state
 ``AUI_BUTTON_STATE_PRESSED``                  Pressed button state
 ``AUI_BUTTON_STATE_DISABLED``                 Disabled button state
 ``AUI_BUTTON_STATE_HIDDEN``                   Hidden button state
 ``AUI_BUTTON_STATE_CHECKED``                  Checked button state
 ============================================  ======================================r  hhh	h)]r  X	   new_stater  hhr  ah1X   SetState(self, new_state)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetStickyr  hKh'KhX   Sets whether the toolbar item is sticky (permanent highlight after mouse enter)
or not.

:param bool `b`: ``True`` to set the item as sticky, ``False`` otherwise.r  hhh	h)]r  j  hhr  ah1X   SetSticky(self, b)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.SetUserDatar  hKh'KhX   Associates some kind of user data to the toolbar item.

:param PyObject `data`: a Python object.

:note: The user data can be any Python object.r  hhh	h)]r  X   datar  hhr  ah1X   SetUserData(self, data)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetWindowr  hKh'KhXv   Assigns a window to the toolbar item.

:param wx.Window `w`: associate this window `w` to the :class:`AuiToolBarItem`.r  hhh	h)]r  j  hhr  ah1X   SetWindow(self, w)r  h3h4h5j}  h7j  ubehd]r  (]r  X   objectr  a]r  ]r  X   AuiToolBarItemr  aaehk]r  hm]r  h1X   AuiToolBarItem(object)r   hpj  )r  }r  (j  ]r  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr  ]r  r  aj  ]r  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr  aj  j  ubh'Kh3hqhrXW   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBarItem.txtr	  h7j)  h5X   466r
  j  ]r  (X   __init__r  X   Assignr
  X   GetAlignmentr  X	   GetBitmapr  X   GetDisabledBitmapr  X   GetHoverBitmapr  X   GetIdr  X   GetKindr  X   GetLabelr  X   GetLongHelpr  X
   GetMinSizer  X   GetOrientationr  X
   GetProportionr  X   GetRotatedBitmapr  X   GetShortHelpr  X   GetSizerItemr  X   GetSpacerPixelsr  X   GetStater  X   GetUserDatar  X	   GetWindowr  X   HasDropDownr   X   IsActiver!  X   IsStickyr"  X	   SetActiver#  X   SetAlignmentr$  X	   SetBitmapr%  X   SetDisabledBitmapr&  X   SetHasDropDownr'  X   SetHoverBitmapr(  X   SetIdr)  X   SetKindr*  X   SetLabelr+  X   SetLongHelpr,  X
   SetMinSizer-  X   SetOrientationr.  X
   SetProportionr/  X   SetShortHelpr0  X   SetSizerItemr1  X   SetSpacerPixelsr2  X   SetStater3  X	   SetStickyr4  X   SetUserDatar5  X	   SetWindowr6  ej  j  ubh)r7  }r8  (hX)   wx.lib.agw.aui.auibar.CommandToolBarEventr9  hKhXJ   A specialized command event class for events sent by :class:`AuiToolBar`. r:  hhh	h
]r;  (h#)r<  }r=  (hX2   wx.lib.agw.aui.auibar.CommandToolBarEvent.__init__r>  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.r?  hhh	h)]r@  (X   command_typerA  hhrB  X   win_idrC  hhrD  eh1X$   __init__(self, command_type, win_id)rE  h3h4h5X   18rF  h7j7  ubh#)rG  }rH  (hX7   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetClickPointrI  hKh'KhX9   Returns the point where the user clicked with the mouse. rJ  hhh	h)]rK  h1X   GetClickPoint(self)rL  h3h4h5hIh7j7  ubh#)rM  }rN  (hX5   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetItemRectrO  hKh'KhX/   Returns the :class:`AuiToolBarItem` rectangle. rP  hhh	h)]rQ  h1X   GetItemRect(self)rR  h3h4h5hIh7j7  ubh#)rS  }rT  (hX3   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetToolIdrU  hKh'KhX0   Returns the :class:`AuiToolBarItem` identifier. rV  hhh	h)]rW  h1X   GetToolId(self)rX  h3h4h5hIh7j7  ubh#)rY  }rZ  (hX;   wx.lib.agw.aui.auibar.CommandToolBarEvent.IsDropDownClickedr[  hKh'KhX5   Returns whether the drop down menu has been clicked. r\  hhh	h)]r]  h1X   IsDropDownClicked(self)r^  h3h4h5hIh7j7  ubh#)r_  }r`  (hX7   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetClickPointra  hKh'KhXO   Sets the clicking point.

:param wx.Point `p`: the location of the mouse click.rb  hhh	h)]rc  j  hhrd  ah1X   SetClickPoint(self, p)re  h3h4h5j}  h7j7  ubh#)rf  }rg  (hX<   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetDropDownClickedrh  hKh'KhX   Sets whether the drop down menu has been clicked.

:param bool `c`: ``True`` to set the drop down as clicked, ``False`` otherwise.ri  hhh	h)]rj  j  hhrk  ah1X   SetDropDownClicked(self, c)rl  h3h4h5j}  h7j7  ubh#)rm  }rn  (hX5   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetItemRectro  hKh'KhX\   Sets the :class:`AuiToolBarItem` rectangle.

:param wx.Rect `r`: the toolbar item rectangle.rp  hhh	h)]rq  X   rrr  hhrs  ah1X   SetItemRect(self, r)rt  h3h4h5j}  h7j7  ubh#)ru  }rv  (hX3   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetToolIdrw  hKh'KhX_   Sets the :class:`AuiToolBarItem` identifier.

:param integer `id`: the toolbar item identifier.rx  hhh	h)]ry  X   idrz  hhr{  ah1X   SetToolId(self, id)r|  h3h4h5j}  h7j7  ubehd]r}  (]r~  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeehk]r  X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  ahm]r  X   wx.PyCommandEventr  ah1X&   CommandToolBarEvent(wx.PyCommandEvent)r  hpj  )r  }r  (j  ]r  (X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ]r  X   wx.PyCommandEventr  ar  X   wx.PyCommandEventr  ]r  X   wx.CommandEventr  ar  X   wx.CommandEventr  ]r  X   wx.Eventr  ar  X   wx.Eventr  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  aj  j7  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.CommandToolBarEvent.txtr  h7j)  h5X   85r  j  ]r  (X   __init__r  X
   GetClickPointr  X   GetItemRectr  X	   GetToolIdr  X   IsDropDownClickedr  X
   SetClickPointr  X   SetDropDownClickedr  X   SetItemRectr  X	   SetToolIdr  ej  j  ubh)r  }r  (hX%   wx.lib.agw.aui.auibar.PyEmbeddedImager  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	h
]r  (h#)r  }r  (hX.   wx.lib.agw.aui.auibar.PyEmbeddedImage.__init__r  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r  hhh	h)]r  (X   datar  hhr  X   isBase64r  X   Truer  h/r  eh1X#   __init__(self, data, isBase64=True)r  h3h4h5h6h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetBitmapr  hKh'Khhhhh	h)]r  h1X   GetBitmap(self)r  h3h4h5h=h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetDatar  hKh'Khhhhh	h)]r  h1X
   GetData(self)r  h3h4h5hCh7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetIconr  hKh'Khhhhh	h)]r  h1X
   GetIcon(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetImager  hKh'Khhhhh	h)]r  h1X   GetImage(self)r  h3h4h5h6h7j  ubhO)r  }r  (hX,   wx.lib.agw.aui.auibar.PyEmbeddedImage.Bitmapr  hKh'Khhhhh	hShThUhhVhh3hWh7j  ubhO)r  }r  (hX*   wx.lib.agw.aui.auibar.PyEmbeddedImage.Datar  hKh'Khhhhh	hSh[hUhhVhh3hWh7j  ubhO)r  }r  (hX*   wx.lib.agw.aui.auibar.PyEmbeddedImage.Iconr  hKh'Khhhhh	hSh_hUhhVhh3hWh7j  ubhO)r  }r  (hX+   wx.lib.agw.aui.auibar.PyEmbeddedImage.Imager  hKh'Khhhhh	hShchUhhVhh3hWh7j  ubehd]r  (]r  X   objectr  a]r  ]r  hjaaehk]r  hm]r  h1X   PyEmbeddedImage(object)r  hpNh'Kh3hqhrXX   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.PyEmbeddedImage.txtr  h7j)  h5X   52r  ubh)r  }r  (hX+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer  hKhX,   A class to handle the dropdown window menu. r  hhh	h
]r  (h#)r  }r  (hX4   wx.lib.agw.aui.auibar.ToolbarCommandCapture.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  h1X   __init__(self)r  h3h4h5hCh7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.ToolbarCommandCapture.GetCommandIdr   hKh'KhX&   Returns the event command identifier. r  hhh	h)]r  h1X   GetCommandId(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.ToolbarCommandCapture.ProcessEventr  hKh'KhX  Processes an event, searching event tables and calling zero or more suitable
event handler function(s).

:param `event`: the event to process.

:note: Normally, your application would not call this function: it is called
 in the wxPython implementation to dispatch incoming user interface events
 to the framework (and application).
 However, you might need to call it if implementing new functionality (such as
 a new control) where you define new event types, as opposed to allowing the
 user to override functions.

 An instance where you might actually override the :meth:`ProcessEvent` function is where
 you want to direct event processing to event handlers not normally noticed by
 wxPython. For example, in the document/view architecture, documents and views
 are potential event handlers. When an event reaches a frame, :meth:`ProcessEvent` will
 need to be called on the associated document and view in case event handler
 functions are associated with these objects.

 The normal order of event table searching is as follows:

 1. If the object is disabled (via a call to :meth:`~EvtHandler.SetEvtHandlerEnabled`) the function
    skips to step (6).
 2. If the object is a :class:`wx.Window`, :meth:`ProcessEvent` is recursively called on the window's
    :class:`wx.Validator`. If this returns ``True``, the function exits.
 3. wxWidgets `SearchEventTable` is called for this event handler. If this fails, the
    base class table is tried, and so on until no more tables exist or an appropriate
    function was found, in which case the function exits.
 4. The search is applied down the entire chain of event handlers (usually the chain
    has a length of one). If this succeeds, the function exits.
 5. If the object is a :class:`wx.Window` and the event is a :class:`CommandEvent`, :meth:`ProcessEvent` is
    recursively applied to the parent window's event handler. If this returns ``True``,
    the function exits.
 6. Finally, :meth:`ProcessEvent` is called on the :class:`App` object.r  hhh	h)]r  X   eventr	  hhr
  ah1X   ProcessEvent(self, event)r  h3h4h5X   47r  h7j  ubehd]r
  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  j  a]r  ]r  X   ToolbarCommandCapturer  aae]r  j  a]r  (]r  j  a]r   ]r!  j  aaeeeeehk]r"  hm]r#  X
   wx.EvtHandlerr$  ah1X$   ToolbarCommandCapture(wx.EvtHandler)r%  hpj  )r&  }r'  (j  ]r(  (X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer)  ]r*  X
   wx.EvtHandlerr+  ar,  X
   wx.EvtHandlerr-  ]r.  (X	   wx.Objectr/  X   wx.Trackabler0  er1  X	   wx.Objectr2  ]r3  r4  X   wx.Trackabler5  ]r6  r7  ej  ]r8  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer9  aj  j  ubh'Kh3hqhrX^   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.ToolbarCommandCapture.txtr:  h7j)  h5X   63r;  j  ]r<  (X   __init__r=  X   GetCommandIdr>  X   ProcessEventr?  ej  j#  ubh#)r@  }rA  (hX$   wx.lib.agw.aui.auibar.BitmapFromBitsrB  hKh'KhX)  A utility function that creates a masked bitmap from raw bits (XBM format).

:param string `bits`: the raw bits of the bitmap;
:param integer `w`: the bitmap width;
:param integer `h`: the bitmap height;
:param wx.Colour `colour`: the colour which will replace all white pixels in the
 raw bitmap.rC  hhh	h)]rD  (X   bitsrE  hhrF  j  hhrG  j  hhrH  X   colourrI  hhrJ  eh1X"   BitmapFromBits(bits, w, h, colour)rK  h3h4h5X   17rL  j
  X   147rM  h7j)  ubh#)rN  }rO  (hX#   wx.lib.agw.aui.auibar.GetBaseColourrP  hKh'KhXv   Returns the face shading colour on push buttons/backgrounds,
mimicking as closely as possible the platform UI colours.rQ  hhh	h)]rR  h1X   GetBaseColour()rS  h3h4h5X   29rT  j
  X   180rU  h7j)  ubh#)rV  }rW  (hX"   wx.lib.agw.aui.auibar.GetLabelSizerX  hKh'KhX   Returns the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` item label size.

:param string `label`: the toolbar tool label;
:param bool `vertical`: whether the toolbar tool orientation is vertical or not.rY  hhh	h)]rZ  (X   dcr[  hhr\  X   labelr]  hhr^  X   verticalr_  hhr`  eh1X!   GetLabelSize(dc, label, vertical)ra  h3h4h5X   23rb  j
  X   375rc  h7j)  ubh#)rd  }re  (hX(   wx.lib.agw.aui.auibar.MakeDisabledBitmaprf  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.rg  hhh	h)]rh  X   bitmapri  hhrj  ah1X   MakeDisabledBitmap(bitmap)rk  h3h4h5j}  j
  X   210rl  h7j)  ubh#)rm  }rn  (hX    wx.lib.agw.aui.auibar.StepColourro  hKh'KhX   Darken/lighten the input colour `c`.

:param wx.Colour `c`: a colour to darken/lighten;
:param integer `ialpha`: a transparency value.rp  hhh	h)]rq  (j  hhrr  X   ialphars  hhrt  eh1X   StepColour(c, ialpha)ru  h3h4h5X   38rv  j
  X   58rw  h7j)  ubhu)rx  }ry  (hX    wx.lib.agw.aui.auibar.__author__rz  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r{  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'r|  h|X   strr}  h3h~h7j)  ubhu)r~  }r  (hX   wx.lib.agw.aui.auibar.__date__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX   '31 March 2009'r  h|X   strr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar._VERSION_STRINGr  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX   '4.1.0'r  h|X   strr  h3h~h7j)  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.actionClickButtonr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.actionClickCaptionr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.actionDragFloatingPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.actionDragMovablePaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.actionDragToolbarPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX    wx.lib.agw.aui.auibar.actionNoner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX"   wx.lib.agw.aui.auibar.actionResizer  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX!   wx.lib.agw.aui.auibar.aero_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.aero_dock_paner  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ed0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_bottomr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.aero_dock_pane_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9fd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX*   wx.lib.agw.aui.auibar.aero_dock_pane_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5050>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.aero_dock_pane_topr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX   wx.lib.agw.aui.auibar.aero_downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd50d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.aero_down_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.aero_down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.aero_down_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX   wx.lib.agw.aui.auibar.aero_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5190>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.aero_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r	  (hX,   wx.lib.agw.aui.auibar.aero_left_focus_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.aero_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5210>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX    wx.lib.agw.aui.auibar.aero_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5250>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.aero_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j)  ubhu)r   }r!  (hX-   wx.lib.agw.aui.auibar.aero_right_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r#  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r$  h|X$   wx.lib.embeddedimage.PyEmbeddedImager%  h3h~h7j)  ubhu)r&  }r'  (hX'   wx.lib.agw.aui.auibar.aero_right_singler(  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r)  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd52d0>r*  h|X$   wx.lib.embeddedimage.PyEmbeddedImager+  h3h~h7j)  ubhu)r,  }r-  (hX   wx.lib.agw.aui.auibar.aero_tabr.  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r/  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5310>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j)  ubhu)r2  }r3  (hX$   wx.lib.agw.aui.auibar.aero_tab_focusr4  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r5  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r6  h|X$   wx.lib.embeddedimage.PyEmbeddedImager7  h3h~h7j)  ubhu)r8  }r9  (hX+   wx.lib.agw.aui.auibar.aero_tab_focus_singler:  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r;  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r<  h|X$   wx.lib.embeddedimage.PyEmbeddedImager=  h3h~h7j)  ubhu)r>  }r?  (hX%   wx.lib.agw.aui.auibar.aero_tab_singler@  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rA  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5390>rB  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerC  h3h~h7j)  ubhu)rD  }rE  (hX   wx.lib.agw.aui.auibar.aero_uprF  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rG  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd53d0>rH  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerI  h3h~h7j)  ubhu)rJ  }rK  (hX#   wx.lib.agw.aui.auibar.aero_up_focusrL  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rM  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>rN  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerO  h3h~h7j)  ubhu)rP  }rQ  (hX*   wx.lib.agw.aui.auibar.aero_up_focus_singlerR  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rS  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>rT  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerU  h3h~h7j)  ubhu)rV  }rW  (hX$   wx.lib.agw.aui.auibar.aero_up_singlerX  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rY  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5450>rZ  h|X$   wx.lib.embeddedimage.PyEmbeddedImager[  h3h~h7j)  ubhu)r\  }r]  (hX$   wx.lib.agw.aui.auibar.aeroguideSizeXr^  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_  hhh	hzX   31r`  h|X   intra  h3h~h7j)  ubhu)rb  }rc  (hX$   wx.lib.agw.aui.auibar.aeroguideSizeYrd  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4re  hhh	hzX   32rf  h|X   intrg  h3h~h7j)  ubhu)rh  }ri  (hX&   wx.lib.agw.aui.auibar.AUI_BUTTON_CLOSErj  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rk  hhh	hzX   101rl  h|X   intrm  h3h~h7j)  ubhu)rn  }ro  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM1rp  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq  hhh	hzX   201rr  h|X   intrs  h3h~h7j)  ubhu)rt  }ru  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM2rv  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw  hhh	hzX   202rx  h|X   intry  h3h~h7j)  ubhu)rz  }r{  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM3r|  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}  hhh	hzX   203r~  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM4r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   204r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM5r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   205r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM6r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   206r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM7r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   207r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM8r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   208r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM9r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   209r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_BUTTON_DOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   110r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_BUTTON_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   107r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX1   wx.lib.agw.aui.auibar.AUI_BUTTON_MAXIMIZE_RESTOREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   102r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_BUTTON_MINIMIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   103r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_OPTIONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   105r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.AUI_BUTTON_PINr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   104r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.AUI_BUTTON_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   108r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_CHECKEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_NORMALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_PRESSEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX#   wx.lib.agw.aui.auibar.AUI_BUTTON_UPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   109r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_BUTTON_WINDOWLISTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   106r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_BOTTOMr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_CENTERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr	  h3h~h7j)  ubhu)r
  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_CENTREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   5r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX#   wx.lib.agw.aui.auibar.AUI_DOCK_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX#   wx.lib.agw.aui.auibar.AUI_DOCK_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_DOCK_NOTEBOOK_PAGEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r   h|X   intr!  h3h~h7j)  ubhu)r"  }r#  (hX$   wx.lib.agw.aui.auibar.AUI_DOCK_RIGHTr$  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r%  hhh	hzX   2r&  h|X   intr'  h3h~h7j)  ubhu)r(  }r)  (hX"   wx.lib.agw.aui.auibar.AUI_DOCK_TOPr*  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r+  hhh	hzX   1r,  h|X   intr-  h3h~h7j)  ubhu)r.  }r/  (hX7   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_COLOURr0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   8r2  h|X   intr3  h3h~h7j)  ubhu)r4  }r5  (hX@   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURr6  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r7  hhh	hzX   9r8  h|X   intr9  h3h~h7j)  ubhu)r:  }r;  (hX<   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURr<  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r=  hhh	hzX   12r>  h|X   intr?  h3h~h7j)  ubhu)r@  }rA  (hX3   wx.lib.agw.aui.auibar.AUI_DOCKART_BACKGROUND_COLOURrB  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rC  hhh	hzX   5rD  h|X   intrE  h3h~h7j)  ubhu)rF  }rG  (hX<   wx.lib.agw.aui.auibar.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURrH  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rI  hhh	hzX   6rJ  h|X   intrK  h3h~h7j)  ubhu)rL  }rM  (hX/   wx.lib.agw.aui.auibar.AUI_DOCKART_BORDER_COLOURrN  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rO  hhh	hzX   14rP  h|X   intrQ  h3h~h7j)  ubhu)rR  }rS  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_CAPTION_FONTrT  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rU  hhh	hzX   16rV  h|X   intrW  h3h~h7j)  ubhu)rX  }rY  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_CAPTION_SIZErZ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r[  hhh	hzX   1r\  h|X   intr]  h3h~h7j)  ubhu)r^  }r_  (hX0   wx.lib.agw.aui.auibar.AUI_DOCKART_DRAW_SASH_GRIPr`  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ra  hhh	hzX   18rb  h|X   intrc  h3h~h7j)  ubhu)rd  }re  (hX/   wx.lib.agw.aui.auibar.AUI_DOCKART_GRADIENT_TYPErf  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rg  hhh	hzX   17rh  h|X   intri  h3h~h7j)  ubhu)rj  }rk  (hX0   wx.lib.agw.aui.auibar.AUI_DOCKART_GRIPPER_COLOURrl  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm  hhh	hzX   15rn  h|X   intro  h3h~h7j)  ubhu)rp  }rq  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_GRIPPER_SIZErr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rs  hhh	hzX   2rt  h|X   intru  h3h~h7j)  ubhu)rv  }rw  (hX4   wx.lib.agw.aui.auibar.AUI_DOCKART_HINT_WINDOW_COLOURrx  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ry  hhh	hzX   19rz  h|X   intr{  h3h~h7j)  ubhu)r|  }r}  (hX9   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_COLOURr~  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hXB   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX>   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX2   wx.lib.agw.aui.auibar.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX2   wx.lib.agw.aui.auibar.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX1   wx.lib.agw.aui.auibar.AUI_MGR_AERO_DOCKING_GUIDESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_ANIMATE_FRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_MGR_AUTONB_NO_CAPTIONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_MGR_DEFAULTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_MGR_HINT_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_MGR_LIVE_RESIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX5   wx.lib.agw.aui.auibar.AUI_MGR_NO_VENETIAN_BLINDS_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7j)  ubhu)r   }r  (hX5   wx.lib.agw.aui.auibar.AUI_MGR_PREVIEW_MINIMIZED_PANESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_RECTANGLE_HINTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r	  hhh	hzX   32r
  h|X   intr  h3h~h7j)  ubhu)r  }r
  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_SMOOTH_DOCKINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_MGR_TRANSPARENT_DRAGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_MGR_TRANSPARENT_HINTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX3   wx.lib.agw.aui.auibar.AUI_MGR_USE_NATIVE_MINIFRAMESr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   16384r"  h|X   intr#  h3h~h7j)  ubhu)r$  }r%  (hX2   wx.lib.agw.aui.auibar.AUI_MGR_VENETIAN_BLINDS_HINTr&  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r'  hhh	hzX   16r(  h|X   intr)  h3h~h7j)  ubhu)r*  }r+  (hX4   wx.lib.agw.aui.auibar.AUI_MGR_WHIDBEY_DOCKING_GUIDESr,  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r-  hhh	hzX   4096r.  h|X   intr/  h3h~h7j)  ubhu)r0  }r1  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_HIDEr2  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r3  hhh	hzX   0r4  h|X   intr5  h3h~h7j)  ubhu)r6  }r7  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_HORZr8  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r9  hhh	hzX   16r:  h|X   intr;  h3h~h7j)  ubhu)r<  }r=  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_MASKr>  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r?  hhh	hzX   24r@  h|X   intrA  h3h~h7j)  ubhu)rB  }rC  (hX-   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_SMARTrD  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rE  hhh	hzX   8rF  h|X   intrG  h3h~h7j)  ubhu)rH  }rI  (hX-   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_BOTTOMrJ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rK  hhh	hzX   5rL  h|X   intrM  h3h~h7j)  ubhu)rN  }rO  (hX+   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_LEFTrP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   3rR  h|X   intrS  h3h~h7j)  ubhu)rT  }rU  (hX+   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_MASKrV  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rW  hhh	hzX   23rX  h|X   intrY  h3h~h7j)  ubhu)rZ  }r[  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_RIGHTr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   4r^  h|X   intr_  h3h~h7j)  ubhu)r`  }ra  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_SMARTrb  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rc  hhh	hzX   1rd  h|X   intre  h3h~h7j)  ubhu)rf  }rg  (hX.   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_TOOLBARrh  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ri  hhh	hzX   6rj  h|X   intrk  h3h~h7j)  ubhu)rl  }rm  (hX*   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_TOPrn  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ro  hhh	hzX   2rp  h|X   intrq  h3h~h7j)  ubhu)rr  }rs  (hX#   wx.lib.agw.aui.auibar.AUI_NB_BOTTOMrt  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ru  hhh	hzX   8rv  h|X   intrw  h3h~h7j)  ubhu)rx  }ry  (hX)   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_BUTTONrz  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r{  hhh	hzX   1024r|  h|X   intr}  h3h~h7j)  ubhu)r~  }r  (hX0   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_ACTIVE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX*   wx.lib.agw.aui.auibar.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX!   wx.lib.agw.aui.auibar.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX"   wx.lib.agw.aui.auibar.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_NB_SCROLL_BUTTONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_TAB_EXTERNAL_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   524288r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_NB_TAB_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.AUI_NB_TAB_SPLITr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX    wx.lib.agw.aui.auibar.AUI_NB_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX0   wx.lib.agw.aui.auibar.AUI_NB_USE_IMAGES_DROPDOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   131072r  h|X   intr  h3h~h7j)  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_WINDOWLIST_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r    h|X   intr   h3h~h7j)  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.AUI_TB_CLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   256r   h|X   intr   h3h~h7j)  ubhu)r   }r	   (hX-   wx.lib.agw.aui.auibar.AUI_TB_COUNTERCLOCKWISEr
   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   512r   h|X   intr
   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.AUI_TB_DEFAULT_STYLEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   0r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX$   wx.lib.agw.aui.auibar.AUI_TB_GRIPPERr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   8r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX(   wx.lib.agw.aui.auibar.AUI_TB_HORZ_LAYOUTr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   64r   h|X   intr   h3h~h7j)  ubhu)r    }r!   (hX&   wx.lib.agw.aui.auibar.AUI_TB_HORZ_TEXTr"   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#   hhh	hzX   65r$   h|X   intr%   h3h~h7j)  ubhu)r&   }r'   (hX*   wx.lib.agw.aui.auibar.AUI_TB_NO_AUTORESIZEr(   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r)   hhh	hzX   4r*   h|X   intr+   h3h~h7j)  ubhu)r,   }r-   (hX(   wx.lib.agw.aui.auibar.AUI_TB_NO_TOOLTIPSr.   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r/   hhh	hzX   2r0   h|X   intr1   h3h~h7j)  ubhu)r2   }r3   (hX%   wx.lib.agw.aui.auibar.AUI_TB_OVERFLOWr4   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r5   hhh	hzX   16r6   h|X   intr7   h3h~h7j)  ubhu)r8   }r9   (hX-   wx.lib.agw.aui.auibar.AUI_TB_PLAIN_BACKGROUNDr:   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r;   hhh	hzX   128r<   h|X   intr=   h3h~h7j)  ubhu)r>   }r?   (hX!   wx.lib.agw.aui.auibar.AUI_TB_TEXTr@   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rA   hhh	hzX   1rB   h|X   intrC   h3h~h7j)  ubhu)rD   }rE   (hX&   wx.lib.agw.aui.auibar.AUI_TB_VERT_TEXTrF   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rG   hhh	hzX   289rH   h|X   intrI   h3h~h7j)  ubhu)rJ   }rK   (hX%   wx.lib.agw.aui.auibar.AUI_TB_VERTICALrL   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rM   hhh	hzX   32rN   h|X   intrO   h3h~h7j)  ubhu)rP   }rQ   (hX,   wx.lib.agw.aui.auibar.AUI_TBART_GRIPPER_SIZErR   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rS   hhh	hzX   1rT   h|X   intrU   h3h~h7j)  ubhu)rV   }rW   (hX-   wx.lib.agw.aui.auibar.AUI_TBART_OVERFLOW_SIZErX   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rY   hhh	hzX   2rZ   h|X   intr[   h3h~h7j)  ubhu)r\   }r]   (hX.   wx.lib.agw.aui.auibar.AUI_TBART_SEPARATOR_SIZEr^   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_   hhh	hzX   0r`   h|X   intra   h3h~h7j)  ubhu)rb   }rc   (hX+   wx.lib.agw.aui.auibar.AUI_TBTOOL_HORIZONTALrd   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4re   hhh	hzX   0rf   h|X   intrg   h3h~h7j)  ubhu)rh   }ri   (hX,   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_BOTTOMrj   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rk   hhh	hzX   3rl   h|X   intrm   h3h~h7j)  ubhu)rn   }ro   (hX*   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_LEFTrp   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq   hhh	hzX   0rr   h|X   intrs   h3h~h7j)  ubhu)rt   }ru   (hX+   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_RIGHTrv   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw   hhh	hzX   1rx   h|X   intry   h3h~h7j)  ubhu)rz   }r{   (hX)   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_TOPr|   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}   hhh	hzX   2r~   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX/   wx.lib.agw.aui.auibar.AUI_TBTOOL_VERT_CLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   1r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX6   wx.lib.agw.aui.auibar.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   2r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.AuiBaseTabCtrlIdr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   5380r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX(   wx.lib.agw.aui.auibar.auiInsertRowPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.auiLayerInsertOffsetr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   5r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.auiLayerInsertPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   40r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.auiNewRowPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   40r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX)   wx.lib.agw.aui.auibar.auinotebook_previewr   hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd54d0>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7j)  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.auiToolBarLayerr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX+   wx.lib.agw.aui.auibar.BUTTON_DROPDOWN_WIDTHr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7j)  ubhu)r   }r   (hX    wx.lib.agw.aui.auibar.close_bitsr   hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr   hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r   h|X   bytesr   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.colourHintBackgroundr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(0, 64, 255, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.colourIconArrowr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(77, 79, 170, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.colourIconBackgroundr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(255, 255, 255, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.colourIconBorderr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(82, 65, 156, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.colourIconDockingPart1r   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(215, 228, 243, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.colourIconDockingPart2r   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(180, 201, 225, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.colourIconShadowr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(198, 198, 198, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.colourTargetBackgroundr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(224, 224, 224, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX(   wx.lib.agw.aui.auibar.colourTargetBorderr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(180, 180, 180, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX'   wx.lib.agw.aui.auibar.colourTargetShader   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(206, 206, 206, 255)r   h|X   wx._core.Colourr   h3h~h7j)  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.DISABLED_TEXT_COLOURr !  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(153, 153, 153, 255)r!  h|X   wx._core.Colourr!  h3h~h7j)  ubhu)r!  }r!  (hX,   wx.lib.agw.aui.auibar.DISABLED_TEXT_GREY_HUEr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   153r!  h|X   intr	!  h3h~h7j)  ubhu)r
!  }r!  (hX   wx.lib.agw.aui.auibar.downr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c50>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX    wx.lib.agw.aui.auibar.down_focusr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c90>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX'   wx.lib.agw.aui.auibar.down_focus_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd99d0>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.down_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a10>r !  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!!  h3h~h7j)  ubhu)r"!  }r#!  (hX/   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_BEGIN_DRAGr$!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r%!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f20e80bf610>r&!  h|X   wx.core.PyEventBinderr'!  h3h~h7j)  ubhu)r(!  }r)!  (hX1   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_MIDDLE_CLICKr*!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r+!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f20e80c1210>r,!  h|X   wx.core.PyEventBinderr-!  h3h~h7j)  ubhu)r.!  }r/!  (hX3   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_OVERFLOW_CLICKr0!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r1!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f20f777af90>r2!  h|X   wx.core.PyEventBinderr3!  h3h~h7j)  ubhu)r4!  }r5!  (hX0   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_RIGHT_CLICKr6!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r7!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f20e80c1510>r8!  h|X   wx.core.PyEventBinderr9!  h3h~h7j)  ubhu)r:!  }r;!  (hX2   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_TOOL_DROPDOWNr<!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r=!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f20f77761d0>r>!  h|X   wx.core.PyEventBinderr?!  h3h~h7j)  ubhu)r@!  }rA!  (hX    wx.lib.agw.aui.auibar.guideSizeXrB!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rC!  hhh	hzX   29rD!  h|X   intrE!  h3h~h7j)  ubhu)rF!  }rG!  (hX    wx.lib.agw.aui.auibar.guideSizeYrH!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rI!  hhh	hzX   32rJ!  h|X   intrK!  h3h~h7j)  ubhu)rL!  }rM!  (hX&   wx.lib.agw.aui.auibar.ID_RESTORE_FRAMErN!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rO!  hhh	hzX   15999rP!  h|X   intrQ!  h3h~h7j)  ubhu)rR!  }rS!  (hX    wx.lib.agw.aui.auibar.ITEM_CHECKrT!  hKh'Khhhhh	hzX   1rU!  h|X   wx._core.ItemKindrV!  h3h~h7j)  ubhu)rW!  }rX!  (hX"   wx.lib.agw.aui.auibar.ITEM_CONTROLrY!  hKh'Khhhhh	hzX   4rZ!  h|X   wx._core.ItemKindr[!  h3h~h7j)  ubhu)r\!  }r]!  (hX    wx.lib.agw.aui.auibar.ITEM_LABELr^!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_!  hhh	hzX   5r`!  h|X   intra!  h3h~h7j)  ubhu)rb!  }rc!  (hX!   wx.lib.agw.aui.auibar.ITEM_NORMALrd!  hKh'Khhhhh	hzX   0re!  h|X   wx._core.ItemKindrf!  h3h~h7j)  ubhu)rg!  }rh!  (hX    wx.lib.agw.aui.auibar.ITEM_RADIOri!  hKh'Khhhhh	hzX   2rj!  h|X   wx._core.ItemKindrk!  h3h~h7j)  ubhu)rl!  }rm!  (hX$   wx.lib.agw.aui.auibar.ITEM_SEPARATORrn!  hKh'Khhhhh	hzX   -1ro!  h|X   wx._core.ItemKindrp!  h3h~h7j)  ubhu)rq!  }rr!  (hX!   wx.lib.agw.aui.auibar.ITEM_SPACERrs!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rt!  hhh	hzX   6ru!  h|X   intrv!  h3h~h7j)  ubhu)rw!  }rx!  (hX   wx.lib.agw.aui.auibar.leftry!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rz!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9cd0>r{!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager|!  h3h~h7j)  ubhu)r}!  }r~!  (hX    wx.lib.agw.aui.auibar.left_focusr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d10>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX'   wx.lib.agw.aui.auibar.left_focus_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a50>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.left_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9a90>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.max_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.minimize_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.Mondrianr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9990>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.nb_close_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.nb_left_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.nb_list_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.nb_right_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.pin_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.restore_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7j)  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.restore_xpmr!  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r!  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r!  h|X   listr!  h3h~h7j)  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.rightr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d50>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.right_focusr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9d90>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX(   wx.lib.agw.aui.auibar.right_focus_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ad0>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.right_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b10>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX,   wx.lib.agw.aui.auibar.SWITCHER_TEXT_MARGIN_Xr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   4r!  h|X   intr!  h3h~h7j)  ubhu)r!  }r!  (hX,   wx.lib.agw.aui.auibar.SWITCHER_TEXT_MARGIN_Yr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   1r!  h|X   intr!  h3h~h7j)  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.tabr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9dd0>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX'   wx.lib.agw.aui.auibar.tab_active_centerr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde090>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7j)  ubhu)r!  }r!  (hX%   wx.lib.agw.aui.auibar.tab_active_leftr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde150>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager "  h3h~h7j)  ubhu)r"  }r"  (hX&   wx.lib.agw.aui.auibar.tab_active_rightr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bde190>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX   wx.lib.agw.aui.auibar.tab_closer	"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bdee90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r
"  }r"  (hX!   wx.lib.agw.aui.auibar.tab_close_hr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9850>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX!   wx.lib.agw.aui.auibar.tab_close_pr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9890>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX   wx.lib.agw.aui.auibar.tab_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e10>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r "  (hX&   wx.lib.agw.aui.auibar.tab_focus_singler!"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r""  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b50>r#"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager$"  h3h~h7j)  ubhu)r%"  }r&"  (hX)   wx.lib.agw.aui.auibar.tab_inactive_centerr'"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r("  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd98d0>r)"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager*"  h3h~h7j)  ubhu)r+"  }r,"  (hX'   wx.lib.agw.aui.auibar.tab_inactive_leftr-"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r."  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9910>r/"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0"  h3h~h7j)  ubhu)r1"  }r2"  (hX(   wx.lib.agw.aui.auibar.tab_inactive_rightr3"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r4"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9950>r5"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager6"  h3h~h7j)  ubhu)r7"  }r8"  (hX    wx.lib.agw.aui.auibar.tab_singler9"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r:"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9b90>r;"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager<"  h3h~h7j)  ubhu)r="  }r>"  (hX   wx.lib.agw.aui.auibar.upr?"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r@"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e50>rA"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerB"  h3h~h7j)  ubhu)rC"  }rD"  (hX   wx.lib.agw.aui.auibar.up_focusrE"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rF"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9e90>rG"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerH"  h3h~h7j)  ubhu)rI"  }rJ"  (hX%   wx.lib.agw.aui.auibar.up_focus_singlerK"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rL"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9bd0>rM"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerN"  h3h~h7j)  ubhu)rO"  }rP"  (hX   wx.lib.agw.aui.auibar.up_singlerQ"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rR"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9c10>rS"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerT"  h3h~h7j)  ubhu)rU"  }rV"  (hX-   wx.lib.agw.aui.auibar.vertical_border_paddingrW"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rX"  hhh	hzX   4rY"  h|X   intrZ"  h3h~h7j)  ubhu)r["  }r\"  (hX$   wx.lib.agw.aui.auibar.whidbey_deniedr]"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r^"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>r_"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager`"  h3h~h7j)  ubhu)ra"  }rb"  (hX'   wx.lib.agw.aui.auibar.whidbey_dock_panerc"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rd"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf610>re"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerf"  h3h~h7j)  ubhu)rg"  }rh"  (hX.   wx.lib.agw.aui.auibar.whidbey_dock_pane_bottomri"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rj"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf750>rk"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerl"  h3h~h7j)  ubhu)rm"  }rn"  (hX.   wx.lib.agw.aui.auibar.whidbey_dock_pane_centerro"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rp"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7baf790>rq"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerr"  h3h~h7j)  ubhu)rs"  }rt"  (hX,   wx.lib.agw.aui.auibar.whidbey_dock_pane_leftru"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rv"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c950>rw"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerx"  h3h~h7j)  ubhu)ry"  }rz"  (hX-   wx.lib.agw.aui.auibar.whidbey_dock_pane_rightr{"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r|"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c8d0>r}"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager~"  h3h~h7j)  ubhu)r"  }r"  (hX+   wx.lib.agw.aui.auibar.whidbey_dock_pane_topr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b9c9d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbey_downr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX(   wx.lib.agw.aui.auibar.whidbey_down_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX/   wx.lib.agw.aui.auibar.whidbey_down_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5550>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_down_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5510>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbey_leftr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX(   wx.lib.agw.aui.auibar.whidbey_left_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX/   wx.lib.agw.aui.auibar.whidbey_left_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_left_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96e90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX#   wx.lib.agw.aui.auibar.whidbey_rightr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_right_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX0   wx.lib.agw.aui.auibar.whidbey_right_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b964d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX*   wx.lib.agw.aui.auibar.whidbey_right_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96f10>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX    wx.lib.agw.aui.auibar.whidbey_upr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX&   wx.lib.agw.aui.auibar.whidbey_up_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX-   wx.lib.agw.aui.auibar.whidbey_up_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96810>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX'   wx.lib.agw.aui.auibar.whidbey_up_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7b96490>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7j)  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbeySizeXr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   43r"  h|X   intr"  h3h~h7j)  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbeySizeYr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   30r"  h|X   intr"  h3h~h7j)  ubhu)r"  }r"  (hX9   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_BEGIN_DRAGr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   10324r"  h|X   intr"  h3h~h7j)  ubhu)r"  }r"  (hX;   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_MIDDLE_CLICKr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   10323r"  h|X   intr"  h3h~h7j)  ubhu)r"  }r"  (hX=   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_OVERFLOW_CLICKr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r #  hhh	hzX   10321r#  h|X   intr#  h3h~h7j)  ubhu)r#  }r#  (hX:   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_RIGHT_CLICKr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   10322r#  h|X   intr#  h3h~h7j)  ubhu)r	#  }r
#  (hX<   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWNr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   10320r
#  h|X   intr#  h3h~h7j)  ubhu)r#  }r#  (hX#   wx.lib.agw.aui.auibar.wxWINDOWCLOSEr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   4001r#  h|X   intr#  h3h~h7j)  ubhu)r#  }r#  (hX&   wx.lib.agw.aui.auibar.wxWINDOWCLOSEALLr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   4002r#  h|X   intr#  h3h~h7j)  ubhu)r#  }r#  (hX"   wx.lib.agw.aui.auibar.wxWINDOWNEXTr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   4003r#  h|X   intr #  h3h~h7j)  ubhu)r!#  }r"#  (hX"   wx.lib.agw.aui.auibar.wxWINDOWPREVr##  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r$#  hhh	hzX   4004r%#  h|X   intr&#  h3h~h7j)  ubej  X;   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/auibar.pyr'#  hrXH   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.txtr(#  h'Kh3j  hpj  )r)#  }r*#  (j  ]r+#  (X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtr,#  ]r-#  r.#  X    wx.lib.agw.aui.auibar.AuiToolBarr/#  ]r0#  X
   wx.Controlr1#  ar2#  X
   wx.Controlr3#  ]r4#  X	   wx.Windowr5#  ar6#  X	   wx.Windowr7#  ]r8#  X
   wx.WindowBaser9#  ar:#  X
   wx.WindowBaser;#  ]r<#  X
   wx.EvtHandlerr=#  ar>#  X
   wx.EvtHandlerr?#  ]r@#  (X	   wx.ObjectrA#  X   wx.TrackablerB#  erC#  X	   wx.ObjectrD#  ]rE#  rF#  X   wx.TrackablerG#  ]rH#  rI#  X%   wx.lib.agw.aui.auibar.AuiToolBarEventrJ#  ]rK#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventrL#  arM#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventrN#  ]rO#  X   wx.PyCommandEventrP#  arQ#  X   wx.PyCommandEventrR#  ]rS#  X   wx.CommandEventrT#  arU#  X   wx.CommandEventrV#  ]rW#  X   wx.EventrX#  arY#  X   wx.EventrZ#  ]r[#  X	   wx.Objectr\#  ar]#  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr^#  ]r_#  r`#  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturera#  ]rb#  X
   wx.EvtHandlerrc#  ard#  ej  ]re#  (X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtrf#  X    wx.lib.agw.aui.auibar.AuiToolBarrg#  X%   wx.lib.agw.aui.auibar.AuiToolBarEventrh#  X$   wx.lib.agw.aui.auibar.AuiToolBarItemri#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventrj#  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturerk#  ej  j)  ubh7hubh)rl#  }rm#  (hX   wx.lib.agw.aui.auibookrn#  hKhX  `auibook.py` contains a notebook control which implements many features common in
applications with dockable panes. Specifically, :class:`AuiNotebook` implements functionality
which allows the user to rearrange tab order via drag-and-drop, split the tab window
into many different splitter configurations, and toggle through different themes to
customize the control's look and feel.

An effort has been made to try to maintain an API as similar to that of :class:`Notebook`.

The default theme that is used is :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`, which provides a modern, glossy
look and feel. The theme can be changed by calling :meth:`AuiNotebook.SetArtProvider() <AuiNotebook.SetArtProvider>`.ro#  hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         auibook.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
rp#  h	h
]rq#  (h)rr#  }rs#  (hX"   wx.lib.agw.aui.auibook.AuiNotebookrt#  hKhX  AuiNotebook is a notebook control which implements many features common in applications with dockable panes.
Specifically, AuiNotebook implements functionality which allows the user to rearrange tab
order via drag-and-drop, split the tab window into many different splitter configurations, and toggle
through different themes to customize the control's look and feel.

An effort has been made to try to maintain an API as similar to that of :class:`Notebook`.

The default theme that is used is :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`, which provides a modern, glossy
look and feel. The theme can be changed by calling :meth:`AuiNotebook.SetArtProvider`.ru#  hhh	h
]rv#  (h#)rw#  }rx#  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.__init__ry#  hKh'KhX~  Default class constructor.

:param wx.Window `parent`: the :class:`AuiNotebook` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the underlying :class:`Panel` window style;
:param integer `agwStyle`: the AGW-specific window style. This can be a combination of the following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet.
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet.
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

 Default value for `agwStyle` is:
 ``AUI_NB_DEFAULT_STYLE`` = ``AUI_NB_TOP`` | ``AUI_NB_TAB_SPLIT`` | ``AUI_NB_TAB_MOVE`` | ``AUI_NB_SCROLL_BUTTONS`` | ``AUI_NB_CLOSE_ON_ACTIVE_TAB`` | ``AUI_NB_MIDDLE_CLICK_CLOSE`` | ``AUI_NB_DRAW_DND_TAB``

:param string `name`: the window name.rz#  hhh	h)]r{#  (X   parentr|#  hhr}#  X   idr~#  X	   wx.ID_ANYr#  X   -1r#  r#  X   posr#  X   wx.DefaultPositionr#  X   (-1, -1)r#  r#  X   sizer#  X   wx.DefaultSizer#  X   (-1, -1)r#  r#  X   styler#  j  X   0r#  r#  X   agwStyler#  X   AUI_NB_DEFAULT_STYLEr#  X   1059121r#  r#  X   namer#  X
   "AuiNotebook"r#  X   AuiNotebookr#  r#  eh1X   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, agwStyle=AUI_NB_DEFAULT_STYLE, name="AuiNotebook")r#  h3h4h5X   67r#  h7jr#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AddControlToPager#  hKh'KhX   Adds a control inside a tab (not in the tab area).

:param integer `page_idx`: the page index;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab.r#  hhh	h)]r#  (X   page_idxr#  hhr#  X   controlr#  hhr#  eh1X)   AddControlToPage(self, page_idx, control)r#  h3h4h5X   33r#  h7jr#  ubh#)r#  }r#  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.AddPager#  hKh'KhXg  Adds a page. If the `select` parameter is ``True``, calling this will generate a
page change event.

:param wx.Window `page`: the page to be added;
:param string `caption`: specifies the text for the new page;
:param bool `select`: specifies whether the page should be selected;
:param wx.Bitmap `bitmap`: the bitmap to display in the enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap to display in the disabled tab;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab;
:param string `tooltip`: the tooltip to display when the mouse hovers over the tab.r#  hhh	h)]r#  (X   pager#  hhr#  X   captionr#  hhr#  X   selectr#  X   Falser#  j*  r#  X   bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r#  r#  X   disabled_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r#  r#  X   controlr#  X   Noner#  X   Noner#  r#  X   tooltipr#  X   ""r#  hr#  eh1Xy   AddPage(self, page, caption, select=False, bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, control=None, tooltip="")r#  h3h4h5X   17r#  h7jr#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AddTabAreaButtonr#  hKh'KhX  Adds a button in the tab area.

:param integer `id`: the button identifier. This can be one of the following:

 ==============================  =================================
 Button Identifier               Description
 ==============================  =================================
 ``AUI_BUTTON_CLOSE``            Shows a close button on the tab area
 ``AUI_BUTTON_WINDOWLIST``       Shows a window list button on the tab area
 ``AUI_BUTTON_LEFT``             Shows a left button on the tab area
 ``AUI_BUTTON_RIGHT``            Shows a right button on the tab area
 ==============================  =================================

:param integer `location`: the button location. Can be ``wx.LEFT`` or ``wx.RIGHT``;
:param wx.Bitmap `normal_bitmap`: the bitmap for an enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap for a disabled tab;
:param string `name`: the button name.r#  hhh	h)]r#  (X   idr#  hhr#  X   locationr#  hhr#  X
   normal_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r#  r#  X   disabled_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r#  r#  X   namer#  X   ""r#  hr#  eh1Xi   AddTabAreaButton(self, id, location, normal_bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, name="")r#  h3h4h5X   24r#  h7jr#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AdvanceSelectionr#  hKh'KhX   Cycles through the tabs.

:param bool `forward`: whether to advance forward or backward;
:param bool `wrap`: ``True`` to return to the first tab if we reach the last tab.

:note: The call to this function generates the page changing events.r#  hhh	h)]r#  (X   forwardr#  X   Truer#  h/r#  X   wrapr#  X   Truer#  h/r#  eh1X/   AdvanceSelection(self, forward=True, wrap=True)r#  h3h4h5X   60r#  h7jr#  ubh#)r#  }r#  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.AssignImageListr#  hKh'KhXt   Sets the image list for the :class:`AuiNotebook` control.

:param `imageList`: an instance of :class:`wx.ImageList`.r#  hhh	h)]r#  X	   imageListr#  hhr#  ah1X    AssignImageList(self, imageList)r#  h3h4h5j}  h7jr#  ubh#)r#  }r#  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.CalculateNewSplitSizer#  hKh'KhX&   Calculates the size of the new split. r#  hhh	h)]r#  h1X   CalculateNewSplitSize(self)r#  h3h4h5X   28r#  h7jr#  ubh#)r#  }r#  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.CalculateTabCtrlHeightr#  hKh'KhX(   Calculates the tab control area height. r#  hhh	h)]r#  h1X   CalculateTabCtrlHeight(self)r#  h3h4h5X   14r#  h7jr#  ubh#)r#  }r#  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.CloneTabAreaButtonsr#  hKh'KhX   Clones the tab area buttons when the :class:`AuiNotebook` is being split.

:see: :meth:`AddTabAreaButton`

:note: Standard buttons for :class:`AuiNotebook` are not cloned, only custom ones.r#  hhh	h)]r#  h1X   CloneTabAreaButtons(self)r#  h3h4h5X   14r#  h7jr#  ubh#)r#  }r $  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.DeletePager$  hKh'KhX  Deletes a page at the given index. Calling this method will generate a page
change event.

:param integer `page_idx`: the page index to be deleted.

:note:

 :meth:`DeletePage` removes a tab from the multi-notebook, and destroys the window as well.

:see: :meth:`RemovePage`r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   DeletePage(self, page_idx)r$  h3h4h5X   31r$  h7jr#  ubh#)r$  }r	$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.Destroyr
$  hKh'KhX  Destroys the window safely.

Use this function instead of the ``del`` operator, since different window
classes can be destroyed differently. Frames and dialogs are not destroyed
immediately when this function is called -- they are added to a list of
windows to be deleted on idle time, when all the window's events have been
processed. This prevents problems with events being sent to non-existent windows.

:return: ``True`` if the window has either been successfully deleted, or
 it has been added to the list of windows pending real deletion.

.. note::

   This method has been added to safely un-initialize the underlying
   :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the :class:`AuiNotebook`
   layout (i.e., tab split, re-ordering, tab floating etc...).r$  hhh	h)]r$  h1X
   Destroy(self)r
$  h3h4h5X   24r$  h7jr#  ubh#)r$  }r$  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.DoSizingr$  hKh'KhX4   Performs all sizing operations in each tab control. r$  hhh	h)]r$  h1X   DoSizing(self)r$  h3h4h5X   11r$  h7jr#  ubh#)r$  }r$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.EditTabr$  hKh'KhX   Starts the editing of an item label, sending a ``EVT_AUINOTEBOOK_BEGIN_LABEL_EDIT`` event.

:param integer `page_index`: the page index we want to edit.r$  hhh	h)]r$  X
   page_indexr$  hhr$  ah1X   EditTab(self, page_index)r$  h3h4h5X   33r$  h7jr#  ubh#)r$  }r $  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.EnableTabr!$  hKh'KhX   Enables/disables a page in the notebook.

:param integer `page_idx`: the page index;
:param bool `enable`: ``True`` to enable the page, ``False`` to disable it.r"$  hhh	h)]r#$  (X   page_idxr$$  hhr%$  X   enabler&$  X   Truer'$  h/r($  eh1X&   EnableTab(self, page_idx, enable=True)r)$  h3h4h5X   11r*$  h7jr#  ubh#)r+$  }r,$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.EnsureVisibler-$  hKh'KhXW   Ensures the input page index `indx` is visible.

:param integer `indx`: the page index.r.$  hhh	h)]r/$  X   indxr0$  hhr1$  ah1X   EnsureVisible(self, indx)r2$  h3h4h5j}  h7jr#  ubh#)r3$  }r4$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.FindNextActiveTabr5$  hKh'KhX   Finds the next active tab (used mainly when :class:`AuiNotebook` has inactive/disabled
tabs in it).

:param integer `idx`: the index of the first (most obvious) tab to check for active status;r6$  hhh	h)]r7$  X   idxr8$  hhr9$  ah1X   FindNextActiveTab(self, idx)r:$  h3h4h5X   10r;$  h7jr#  ubh#)r<$  }r=$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.FindTabr>$  hKh'KhX   Finds the tab control that currently contains the window as well
as the index of the window in the tab control. It returns ``True`` if the
window was found, otherwise ``False``.

:param `page`: an instance of :class:`AuiNotebookPage`.r?$  hhh	h)]r@$  X   pagerA$  hhrB$  ah1X   FindTab(self, page)rC$  h3h4h5X   26rD$  h7jr#  ubh#)rE$  }rF$  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.FloatPagerG$  hKh'KhX   Float the page in `page_index` by reparenting it to a floating frame.

:param integer `page_index`: the index of the page to be floated.

.. warning::

   When the notebook is more or less full screen, tabs cannot be dragged far
   enough outside of the notebook to become floating pages.rH$  hhh	h)]rI$  X
   page_indexrJ$  hhrK$  ah1X   FloatPage(self, page_index)rL$  h3h4h5X   76rM$  h7jr#  ubh#)rN$  }rO$  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetActiveTabCtrlrP$  hKh'KhXe   Returns the active tab control. It is called to determine which control
gets new windows being added.rQ$  hhh	h)]rR$  h1X   GetActiveTabCtrl(self)rS$  h3h4h5X   38rT$  h7jr#  ubh#)rU$  }rV$  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.GetAGWWindowStyleFlagrW$  hKh'KhX   Returns the AGW-specific style of the window.

:see: :meth:`SetAGWWindowStyleFlag` for a list of possible AGW-specific window styles.rX$  hhh	h)]rY$  h1X   GetAGWWindowStyleFlag(self)rZ$  h3h4h5j}  h7jr#  ubh#)r[$  }r\$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetArtProviderr]$  hKh'KhX%   Returns the associated art provider. r^$  hhh	h)]r_$  h1X   GetArtProvider(self)r`$  h3h4h5hIh7jr#  ubh#)ra$  }rb$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.GetAuiManagerrc$  hKh'KhXI   Returns the associated :class:`~wx.lib.agw.aui.framemanager.AuiManager`. rd$  hhh	h)]re$  h1X   GetAuiManager(self)rf$  h3h4h5hIh7jr#  ubh#)rg$  }rh$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetCurrentPageri$  hKh'KhXU   Returns the currently active page (not the index), or ``None`` if none was selected. rj$  hhh	h)]rk$  h1X   GetCurrentPage(self)rl$  h3h4h5jr  h7jr#  ubh#)rm$  }rn$  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetDefaultBorderro$  hKh'KhX;   Returns the default border style for :class:`AuiNotebook`. rp$  hhh	h)]rq$  h1X   GetDefaultBorder(self)rr$  h3h4h5hIh7jr#  ubh#)rs$  }rt$  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.GetEnabledru$  hKh'KhXr   Returns whether the page specified by the index `page_idx` is enabled.

:param integer `page_idx`: the page index.rv$  hhh	h)]rw$  X   page_idxrx$  hhry$  ah1X   GetEnabled(self, page_idx)rz$  h3h4h5j}  h7jr#  ubh#)r{$  }r|$  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.GetHeightForPageHeightr}$  hKh'KhXm   Gets the height of the notebook for a given page height.

:param integer `pageHeight`: the given page height.r~$  hhh	h)]r$  X
   pageHeightr$  hhr$  ah1X(   GetHeightForPageHeight(self, pageHeight)r$  h3h4h5X   13r$  h7jr#  ubh#)r$  }r$  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.GetHiddenr$  hKh'KhXq   Returns whether the page specified by the index `page_idx` is hidden.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetHidden(self, page_idx)r$  h3h4h5j}  h7jr#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetImageListr$  hKh'KhX,   Returns the associated image list (if any). r$  hhh	h)]r$  h1X   GetImageList(self)r$  h3h4h5hIh7jr#  ubh#)r$  }r$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetMinMaxTabWidthr$  hKh'KhX!  Returns the minimum and the maximum tab widths for :class:`AuiNotebook` when the
``AUI_NB_TAB_FIXED_WIDTH`` style is defined.

:note: Minimum and maximum tabs widths are used only when the ``AUI_NB_TAB_FIXED_WIDTH``
 style is present.

:see: :meth:`SetMinMaxTabWidth` for more information.r$  hhh	h)]r$  h1X   GetMinMaxTabWidth(self)r$  h3h4h5X   13r$  h7jr#  ubh#)r$  }r$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.GetPager$  hKh'KhXZ   Returns the page specified by the given index.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPage(self, page_idx)r$  h3h4h5X   12r$  h7jr#  ubh#)r$  }r$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.GetPageBitmapr$  hKh'KhXP   Returns the tab bitmap for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageBitmap(self, page_idx)r$  h3h4h5X   14r$  h7jr#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageCountr$  hKh'KhX-   Returns the number of pages in the notebook. r$  hhh	h)]r$  h1X   GetPageCount(self)r$  h3h4h5hIh7jr#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageImager$  hKh'KhXy   Returns the image index for the given page.

:param integer `page`: the given page for which to retrieve the image index.r$  hhh	h)]r$  X   pager$  hhr$  ah1X   GetPageImage(self, page)r$  h3h4h5X   21r$  h7jr#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageIndexr$  hKh'KhX   Returns the page index for the specified window. If the window is not
found in the notebook, ``wx.NOT_FOUND`` is returned.

:param wx.Window `page_wnd`: the window we are looking for.r$  hhh	h)]r$  X   page_wndr$  hhr$  ah1X   GetPageIndex(self, page_wnd)r$  h3h4h5X   10r$  h7jr#  ubh#)r$  }r$  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.GetPageInfor$  hKh'KhX}   Returns the :class:`AuiNotebookPage` info structure specified by the given index.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageInfo(self, page_idx)r$  h3h4h5X   12r$  h7jr#  ubh#)r$  }r$  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTextr$  hKh'KhXO   Returns the tab label for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageText(self, page_idx)r$  h3h4h5X   14r$  h7jr#  ubh#)r$  }r$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTextColourr$  hKh'KhXU   Returns the tab text colour for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X!   GetPageTextColour(self, page_idx)r$  h3h4h5X   14r$  h7jr#  ubh#)r$  }r$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTooltipr$  hKh'KhXQ   Returns the tab tooltip for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageTooltip(self, page_idx)r$  h3h4h5X   13r$  h7jr#  ubh#)r$  }r$  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.GetSashDClickUnsplitr$  hKh'KhXj   Returns whether a splitted :class:`AuiNotebook` can be unsplitted by double-clicking
on the splitter sash.r$  hhh	h)]r$  h1X   GetSashDClickUnsplit(self)r$  h3h4h5jr  h7jr#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetSelectionr$  hKh'KhXL   Returns the index of the currently active page, or -1 if none was selected. r$  hhh	h)]r$  h1X   GetSelection(self)r$  h3h4h5hIh7jr#  ubh#)r$  }r$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetShownPageCountr$  hKh'KhX3   Returns the number of pages shown in the notebook. r$  hhh	h)]r$  h1X   GetShownPageCount(self)r$  h3h4h5h6h7jr#  ubh#)r$  }r$  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.GetTabContainerr$  hKh'KhX2   Returns the instance of :class:`AuiTabContainer`. r$  hhh	h)]r$  h1X   GetTabContainer(self)r$  h3h4h5hIh7jr#  ubh#)r$  }r %  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.GetTabCtrlFromPointr%  hKh'KhXZ   Returns the tab control at the specified point.

:param wx.Point `pt`: the mouse location.r%  hhh	h)]r%  X   ptr%  hhr%  ah1X   GetTabCtrlFromPoint(self, pt)r%  h3h4h5X   20r%  h7jr#  ubh#)r%  }r	%  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetTabCtrlHeightr
%  hKh'KhX    Returns the tab control height. r%  hhh	h)]r%  h1X   GetTabCtrlHeight(self)r
%  h3h4h5hIh7jr#  ubh#)r%  }r%  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.GetTabFrameFromTabCtrlr%  hKh'KhXl   Returns the tab frame associated with a tab control.

:param `tab_ctrl`: an instance of :class:`AuiTabCtrl`.r%  hhh	h)]r%  X   tab_ctrlr%  hhr%  ah1X&   GetTabFrameFromTabCtrl(self, tab_ctrl)r%  h3h4h5X   20r%  h7jr#  ubh#)r%  }r%  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.GetTabFrameFromWindowr%  hKh'KhX   Returns the tab frame associated with a window.

:param wx.Window `wnd`: the window for which we want to locate the :class:`TabFrame`.r%  hhh	h)]r%  X   wndr%  hhr%  ah1X    GetTabFrameFromWindow(self, wnd)r%  h3h4h5X   19r%  h7jr#  ubh#)r %  }r!%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.HasCloseButtonr"%  hKh'KhX   Returns whether a tab displays a close button or not.

:param integer `page_idx`: the page index.

:note: This can only be called if ``AUI_NB_CLOSE_ON_ALL_TABS`` is specified.r#%  hhh	h)]r$%  X   page_idxr%%  hhr&%  ah1X   HasCloseButton(self, page_idx)r'%  h3h4h5X   15r(%  h7jr#  ubh#)r)%  }r*%  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.HasMultiplePagesr+%  hKh'KhX  This method should be overridden to return ``True`` if this window has multiple pages. All
standard class with multiple pages such as :class:`Notebook`, :class:`Listbook` and :class:`Treebook`
already override it to return ``True`` and user-defined classes with similar behaviour
should do it as well to allow the library to handle such windows appropriately.

:note: Overridden from :class:`Panel`.r,%  hhh	h)]r-%  h1X   HasMultiplePages(self)r.%  h3h4h5X   12r/%  h7jr#  ubh#)r0%  }r1%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.HideAllTabsr2%  hKh'KhXf   Hides all tabs on the :class:`AuiNotebook` control.

:param bool `hidden`: if ``True`` hides all tabs.r3%  hhh	h)]r4%  X   hiddenr5%  X   Truer6%  h/r7%  ah1X   HideAllTabs(self, hidden=True)r8%  h3h4h5j}  h7jr#  ubh#)r9%  }r:%  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.HidePager;%  hKh'KhX   Sets whether a page is hidden.

:param integer `page_idx`: the page index;
:param bool `hidden`: ``True`` to hide the page, ``False`` to show it.r<%  hhh	h)]r=%  (X   page_idxr>%  hhr?%  X   hiddenr@%  X   TruerA%  h/rB%  eh1X%   HidePage(self, page_idx, hidden=True)rC%  h3h4h5X   82rD%  h7jr#  ubh#)rE%  }rF%  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.InitNotebookrG%  hKh'KhX   Contains common initialization code called by all constructors.

:param integer `agwStyle`: the notebook style.

:see: :meth:`~AuiNotebook.__init__` for a list of available `agwStyle` bits.rH%  hhh	h)]rI%  X   agwStylerJ%  hhrK%  ah1X   InitNotebook(self, agwStyle)rL%  h3h4h5X   64rM%  h7jr#  ubh#)rN%  }rO%  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.InsertPagerP%  hKh'KhX  This is similar to :meth:`AddPage`, but allows the ability to specify the insert location.

:param integer `page_idx`: specifies the position for the new page;
:param wx.Window `page`: the page to be added;
:param string `caption`: specifies the text for the new page;
:param bool `select`: specifies whether the page should be selected;
:param wx.Bitmap `bitmap`: the bitmap to display in the enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap to display in the disabled tab;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a ;
:param string `tooltip`: the tooltip to display when the mouse hovers over the tab.rQ%  hhh	h)]rR%  (X   page_idxrS%  hhrT%  X   pagerU%  hhrV%  X   captionrW%  hhrX%  X   selectrY%  X   FalserZ%  j*  r[%  X   bitmapr\%  X
   wx.NullBitmapr]%  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r^%  r_%  X   disabled_bitmapr`%  X
   wx.NullBitmapra%  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>rb%  rc%  X   controlrd%  X   Nonere%  X   Nonerf%  rg%  X   tooltiprh%  X   ""ri%  hrj%  eh1X   InsertPage(self, page_idx, page, caption, select=False, bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, control=None, tooltip="")rk%  h3h4h5X   79rl%  h7jr#  ubh#)rm%  }rn%  (hX;   wx.lib.agw.aui.auibook.AuiNotebook.IsMouseWellOutsideWindowro%  hKh'KhXU   Returns whether the mouse is well outside the :class:`AuiNotebook` screen rectangle. rp%  hhh	h)]rq%  h1X   IsMouseWellOutsideWindow(self)rr%  h3h4h5jr  h7jr#  ubh#)rs%  }rt%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.IsRenamableru%  hKh'KhX   Returns whether a tab can be renamed or not.

:param integer `page_idx`: the page index.

:returns: ``True`` is a page can be renamed, ``False`` otherwise.rv%  hhh	h)]rw%  X   page_idxrx%  hhry%  ah1X   IsRenamable(self, page_idx)rz%  h3h4h5X   15r{%  h7jr#  ubh#)r|%  }r}%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.LoadPerspectiver~%  hKh'KhX   Loads a layout which was saved with :meth:`SavePerspective`.

:param string `layout`: a string which contains a saved :class:`AuiNotebook` layout.r%  hhh	h)]r%  X   layoutr%  hhr%  ah1X   LoadPerspective(self, layout)r%  h3h4h5X   115r%  h7jr#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.NotebookPreviewr%  hKh'KhX   Generates a preview of all the pages in the notebook (MSW and GTK only).

:param integer `thumbnail_size`: the maximum size of every page thumbnail
 (default=200 pixels).

:note: this functionality is currently unavailable on wxMAC.r%  hhh	h)]r%  X   thumbnail_sizer%  X   200r%  X   200r%  r%  ah1X)   NotebookPreview(self, thumbnail_size=200)r%  h3h4h5X   56r%  h7jr#  ubh#)r%  }r%  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.OnChildFocusNotebookr%  hKh'KhX   Handles the ``wx.EVT_CHILD_FOCUS`` event for :class:`AuiNotebook`.

:param `event`: a :class:`ChildFocusEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X!   OnChildFocusNotebook(self, event)r%  h3h4h5X   23r%  h7jr#  ubh#)r%  }r%  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.OnCloseFloatingPager%  hKh'KhX   Handles the ``wx.EVT_CLOSE`` event for a floating page in :class:`AuiNotebook`.

:param `event`: a :class:`CloseEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X    OnCloseFloatingPage(self, event)r%  h3h4h5X   32r%  h7jr#  ubh#)r%  }r%  (hX:   wx.lib.agw.aui.auibook.AuiNotebook.OnNavigationKeyNotebookr%  hKh'KhX   Handles the ``wx.EVT_NAVIGATION_KEY`` event for :class:`AuiNotebook`.

:param `event`: a :class:`NavigationKeyEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X$   OnNavigationKeyNotebook(self, event)r%  h3h4h5X   85r%  h7jr#  ubh#)r%  }r%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnRenameAcceptr%  hKh'KhX   Called by :class:`TabTextCtrl`, to accept the changes and to send the
``EVT_AUINOTEBOOK_END_LABEL_EDIT`` event.

:param integer `page_index`: the page index in the notebook;
:param string `value`: the new label for the tab.r%  hhh	h)]r%  (X
   page_indexr%  hhr%  X   valuer%  hhr%  eh1X'   OnRenameAccept(self, page_index, value)r%  h3h4h5X   17r%  h7jr#  ubh#)r%  }r%  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.OnRenameCancelledr%  hKh'KhX   Called by :class:`TabTextCtrl`, to cancel the changes and to send the
``EVT_AUINOTEBOOK_END_LABEL_EDIT`` event.

:param integer `page_index`: the page index in the notebook.r%  hhh	h)]r%  X
   page_indexr%  hhr%  ah1X#   OnRenameCancelled(self, page_index)r%  h3h4h5X   17r%  h7jr#  ubh#)r%  }r%  (hX)   wx.lib.agw.aui.auibook.AuiNotebook.OnSizer%  hKh'KhX{   Handles the ``wx.EVT_SIZE`` event for :class:`AuiNotebook`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnSize(self, event)r%  h3h4h5X   10r%  h7jr#  ubh#)r%  }r%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnTabBeginDragr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BEGIN_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabBeginDrag(self, event)r%  h3h4h5X   13r%  h7jr#  ubh#)r%  }r%  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.OnTabBgDClickr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BG_DCLICK`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabBgDClick(self, event)r%  h3h4h5X   15r%  h7jr#  ubh#)r%  }r%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.OnTabButtonr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BUTTON`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabButton(self, event)r%  h3h4h5X   86r%  h7jr#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabCancelDragr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_CANCEL_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabCancelDrag(self, event)r%  h3h4h5X   17r%  h7jr#  ubh#)r%  }r%  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabClickedr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_PAGE_CHANGING`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabClicked(self, event)r%  h3h4h5X   18r%  h7jr#  ubh#)r%  }r%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.OnTabDClickr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_DCLICK`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabDClick(self, event)r%  h3h4h5X   21r%  h7jr#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabDragMotionr &  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_DRAG_MOTION`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabDragMotion(self, event)r&  h3h4h5X   142r&  h7jr#  ubh#)r&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabEndDragr	&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_END_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r
&  hhh	h)]r&  X   eventr&  hhr
&  ah1X   OnTabEndDrag(self, event)r&  h3h4h5X   224r&  h7jr#  ubh#)r&  }r&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabMiddleDownr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_MIDDLE_DOWN`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabMiddleDown(self, event)r&  h3h4h5X   19r&  h7jr#  ubh#)r&  }r&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.OnTabMiddleUpr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_MIDDLE_UP`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabMiddleUp(self, event)r &  h3h4h5X   34r!&  h7jr#  ubh#)r"&  }r#&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnTabRightDownr$&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_RIGHT_DOWN`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%&  hhh	h)]r&&  X   eventr'&  hhr(&  ah1X   OnTabRightDown(self, event)r)&  h3h4h5X   19r*&  h7jr#  ubh#)r+&  }r,&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabRightUpr-&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_RIGHT_UP`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r.&  hhh	h)]r/&  X   eventr0&  hhr1&  ah1X   OnTabRightUp(self, event)r2&  h3h4h5X   19r3&  h7jr#  ubh#)r4&  }r5&  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.ReDockPager6&  hKh'KhX   Re-docks a floating :class:`AuiNotebook` tab in the original position, when possible.

:param `pane`: an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`.r7&  hhh	h)]r8&  X   paner9&  hhr:&  ah1X   ReDockPage(self, pane)r;&  h3h4h5X   27r<&  h7jr#  ubh#)r=&  }r>&  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.RemoveControlFromPager?&  hKh'KhXa   Removes a control from a tab (not from the tab area).

:param integer `page_idx`: the page index.r@&  hhh	h)]rA&  X   page_idxrB&  hhrC&  ah1X%   RemoveControlFromPage(self, page_idx)rD&  h3h4h5X   32rE&  h7jr#  ubh#)rF&  }rG&  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.RemoveEmptyTabFramesrH&  hKh'KhX"   Removes all the empty tab frames. rI&  hhh	h)]rJ&  h1X   RemoveEmptyTabFrames(self)rK&  h3h4h5X   40rL&  h7jr#  ubh#)rM&  }rN&  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.RemovePagerO&  hKh'KhX   Removes a page, without deleting the window pointer.

:param integer `page_idx`: the page index to be removed.

:note:

 :meth:`RemovePage` removes a tab from the multi-notebook, but does not destroy the window.

:see: :meth:`DeletePage`rP&  hhh	h)]rQ&  X   page_idxrR&  hhrS&  ah1X   RemovePage(self, page_idx)rT&  h3h4h5X   47rU&  h7jr#  ubh#)rV&  }rW&  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.RemoveTabAreaButtonrX&  hKh'KhX   Removes a button from the tab area.

:param integer `id`: the button identifier.

:see: :meth:`AddTabAreaButton` for a list of button identifiers.rY&  hhh	h)]rZ&  X   idr[&  hhr\&  ah1X   RemoveTabAreaButton(self, id)r]&  h3h4h5X   12r^&  h7jr#  ubh#)r_&  }r`&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.ReparentControlra&  hKh'KhX   Reparents a control added inside a tab.

:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab;
:param `dest_tabs`: the destination :class:`AuiTabCtrl`.rb&  hhh	h)]rc&  (X   controlrd&  hhre&  X	   dest_tabsrf&  hhrg&  eh1X)   ReparentControl(self, control, dest_tabs)rh&  h3h4h5X   12ri&  h7jr#  ubh#)rj&  }rk&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.ResetTextControlrl&  hKh'KhXB   Called by :class:`TabTextCtrl` when it marks itself for deletion. rm&  hhh	h)]rn&  h1X   ResetTextControl(self)ro&  h3h4h5X   12rp&  h7jr#  ubh#)rq&  }rr&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.SavePerspectivers&  hKh'KhX1  Saves the entire user interface layout into an encoded string, which can then
be stored by the application (probably using :class:`Config <ConfigBase>`). When a perspective
is restored using :meth:`LoadPerspective`, the entire user interface will return
to the state it was when the perspective was saved.rt&  hhh	h)]ru&  h1X   SavePerspective(self)rv&  h3h4h5X   49rw&  h7jr#  ubh#)rx&  }ry&  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.SetAGWWindowStyleFlagrz&  hKh'KhXO  Sets the AGW-specific style of the window.

:param integer `agwStyle`: the new window style. This can be a combination of the following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet.
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet.
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.

.. todo:: Implementation of flags ``AUI_NB_RIGHT`` and ``AUI_NB_LEFT``.r{&  hhh	h)]r|&  X   agwStyler}&  hhr~&  ah1X%   SetAGWWindowStyleFlag(self, agwStyle)r&  h3h4h5X   61r&  h7jr#  ubh#)r&  }r&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetArtProviderr&  hKh'KhXQ   Sets the art provider to be used by the notebook.

:param `art`: an art provider.r&  hhh	h)]r&  X   artr&  hhr&  ah1X   SetArtProvider(self, art)r&  h3h4h5X   10r&  h7jr#  ubh#)r&  }r&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetCloseButtonr&  hKh'KhX   Sets whether a tab should display a close button or not.

:param integer `page_idx`: the page index;
:param bool `hasCloseButton`: ``True`` if the page displays a close button.

:note: This can only be called if ``AUI_NB_CLOSE_ON_ALL_TABS`` is specified.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   hasCloseButtonr&  hhr&  eh1X.   SetCloseButton(self, page_idx, hasCloseButton)r&  h3h4h5X   32r&  h7jr#  ubh#)r&  }r&  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.SetFontr&  hKh'KhX   Sets the tab font.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.

:note: Overridden from :class:`Panel`.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetFont(self, font)r&  h3h4h5X   25r&  h7jr#  ubh#)r&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetImageListr&  hKh'KhX   Sets the image list for the :class:`AuiNotebook` control.

:param wx.ImageList `imageList`: the bitmap image list to associate to :class:`AuiNotebook`.r&  hhh	h)]r&  X	   imageListr&  hhr&  ah1X   SetImageList(self, imageList)r&  h3h4h5j}  h7jr#  ubh#)r&  }r&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetMeasuringFontr&  hKh'KhX   Sets the font for calculating text measurements.

:param wx.Font `font`: the new font to use to measure tab label text extents.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetMeasuringFont(self, font)r&  h3h4h5j}  h7jr#  ubh#)r&  }r&  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.SetMinMaxTabWidthr&  hKh'KhX  Sets the minimum and/or the maximum tab widths for :class:`AuiNotebook` when the
``AUI_NB_TAB_FIXED_WIDTH`` style is defined.

Pass -1 to either `minTabWidth` or `maxTabWidth` to reset to the default tab
width behaviour for :class:`AuiNotebook`.

:param integer `minTabWidth`: the minimum allowed tab width, in pixels;
:param integer `maxTabWidth`: the maximum allowed tab width, in pixels.

:note: Minimum and maximum tabs widths are used only when the ``AUI_NB_TAB_FIXED_WIDTH``
 style is present.r&  hhh	h)]r&  (X   minTabWidthr&  hhr&  X   maxTabWidthr&  hhr&  eh1X1   SetMinMaxTabWidth(self, minTabWidth, maxTabWidth)r&  h3h4h5X   21r&  h7jr#  ubh#)r&  }r&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetNavigatorIconr&  hKh'KhX   Sets the icon used by the :class:`TabNavigatorWindow`.

:param wx.Bitmap `bmp`: the new bitmap for the :class:`TabNavigatorWindow`.r&  hhh	h)]r&  X   bmpr&  hhr&  ah1X   SetNavigatorIcon(self, bmp)r&  h3h4h5X   12r&  h7jr#  ubh#)r&  }r&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.SetNormalFontr&  hKh'KhX   Sets the normal font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetNormalFont(self, font)r&  h3h4h5X   10r&  h7jr#  ubh#)r&  }r&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.SetPageBitmapr&  hKh'KhX   Sets the tab bitmap for the page.

:param integer `page_idx`: the page index;
:param wx.Bitmap `bitmap`: the bitmap to display on the page tab.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   bitmapr&  hhr&  eh1X%   SetPageBitmap(self, page_idx, bitmap)r&  h3h4h5X   36r&  h7jr#  ubh#)r&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetPageImager&  hKh'KhX   Sets the image index for the given page.

:param integer `page`: the page index;
:param integer `image`: an index into the image list which was set with :meth:`SetImageList`.r&  hhh	h)]r&  (X   pager&  hhr&  X   imager&  hhr&  eh1X   SetPageImage(self, page, image)r&  h3h4h5X   30r&  h7jr#  ubh#)r&  }r&  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTextr&  hKh'KhXu   Sets the tab label for the page.

:param integer `page_idx`: the page index;
:param string `text`: the new tab label.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   textr&  hhr&  eh1X!   SetPageText(self, page_idx, text)r&  h3h4h5X   33r&  h7jr#  ubh#)r&  }r&  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTextColourr&  hKh'KhX   Sets the tab text colour for the page.

:param integer `page_idx`: the page index;
:param wx.Colour `colour`: the new tab label text colour.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   colourr&  hhr&  eh1X)   SetPageTextColour(self, page_idx, colour)r&  h3h4h5X   31r&  h7jr#  ubh#)r&  }r&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTooltipr&  hKh'KhX   Sets the tab tooltip for the page.

:param integer `page_idx`: the page index;
:param string `tooltip`: the new tooltip.

:returns: ``True`` if the page tooltip has been set, ``False`` otherwise
 (for example when the input `page_idx` is greater than the number of
 pages in the notebook.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   tooltipr&  hhr&  eh1X'   SetPageTooltip(self, page_idx, tooltip)r '  h3h4h5X   20r'  h7jr#  ubh#)r'  }r'  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetRenamabler'  hKh'KhX   Sets whether a tab can be renamed via a left double-click or not.

:param integer `page_idx`: the page index;
:param bool `renamable`: ``True`` if the page can be renamed.r'  hhh	h)]r'  (X   page_idxr'  hhr'  X	   renamabler	'  hhr
'  eh1X'   SetRenamable(self, page_idx, renamable)r'  h3h4h5X   25r'  h7jr#  ubh#)r
'  }r'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetSashDClickUnsplitr'  hKh'KhX   Sets whether to unsplit a splitted :class:`AuiNotebook` when double-clicking on a sash.

:param bool `unsplit`: ``True`` to unsplit on sash double-clicking, ``False`` otherwise.r'  hhh	h)]r'  X   unsplitr'  X   Truer'  h/r'  ah1X(   SetSashDClickUnsplit(self, unsplit=True)r'  h3h4h5j}  h7jr#  ubh#)r'  }r'  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectedFontr'  hKh'KhX   Sets the selected tab font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their selected state.r'  hhh	h)]r'  X   fontr'  hhr'  ah1X   SetSelectedFont(self, font)r'  h3h4h5X   10r'  h7jr#  ubh#)r'  }r '  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionr!'  hKh'KhX   Sets the page selection. Calling this method will generate a page change event.

:param integer `new_page`: the index of the new selection;
:param bool `force`: whether to force the selection or not.r"'  hhh	h)]r#'  (X   new_pager$'  hhr%'  X   forcer&'  X   Falser''  j*  r('  eh1X)   SetSelection(self, new_page, force=False)r)'  h3h4h5X   74r*'  h7jr#  ubh#)r+'  }r,'  (hX5   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionToPager-'  hKh'KhXd   Sets the selection based on the input page.

:param `page`: an instance of :class:`AuiNotebookPage`.r.'  hhh	h)]r/'  X   pager0'  hhr1'  ah1X   SetSelectionToPage(self, page)r2'  h3h4h5j}  h7jr#  ubh#)r3'  }r4'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionToWindowr5'  hKh'KhXg   Sets the selection based on the input window `win`.

:param `win`: a :class:`wx.Window` derived window.r6'  hhh	h)]r7'  X   winr8'  hhr9'  ah1X   SetSelectionToWindow(self, win)r:'  h3h4h5X   28r;'  h7jr#  ubh#)r<'  }r='  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetTabCtrlHeightr>'  hKh'KhX  Sets the tab height.

By default, the tab control height is calculated by measuring the text
height and bitmap sizes on the tab captions.

Calling this method will override that calculation and set the tab control
to the specified height parameter. A call to this method will override
any call to :meth:`SetUniformBitmapSize`. Specifying -1 as the height will
return the control to its default auto-sizing behaviour.

:param integer `height`: the tab control area height.r?'  hhh	h)]r@'  X   heightrA'  hhrB'  ah1X   SetTabCtrlHeight(self, height)rC'  h3h4h5X   21rD'  h7jr#  ubh#)rE'  }rF'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetUniformBitmapSizerG'  hKh'KhX  Ensures that all tabs will have the same height, even if some tabs don't have bitmaps.
Passing ``wx.DefaultSize`` to this method will instruct the control to use dynamic tab
height, which is the default behaviour. Under the default behaviour, when a tab with a
large bitmap is added, the tab control's height will automatically increase to accommodate
the larger bitmap.

:param wx.Size `size`: the tab bitmap size.rH'  hhh	h)]rI'  X   sizerJ'  hhrK'  ah1X    SetUniformBitmapSize(self, size)rL'  h3h4h5X   17rM'  h7jr#  ubh#)rN'  }rO'  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.ShowWindowMenurP'  hKh'KhX}   Shows the window menu for the active tab control associated with this
notebook, and returns ``True`` if a selection was made.rQ'  hhh	h)]rR'  h1X   ShowWindowMenu(self)rS'  h3h4h5X   25rT'  h7jr#  ubh#)rU'  }rV'  (hX(   wx.lib.agw.aui.auibook.AuiNotebook.SplitrW'  hKh'KhXI  Performs a split operation programmatically.

:param integer `page`: indicates the page that will be split off. This page will also become
 the active page after the split.
:param integer `direction`: specifies where the pane should go, it should be one of the
 following: ``wx.TOP``, ``wx.BOTTOM``, ``wx.LEFT``, or ``wx.RIGHT``.rX'  hhh	h)]rY'  (X   pagerZ'  hhr['  X	   directionr\'  hhr]'  eh1X   Split(self, page, direction)r^'  h3h4h5X   121r_'  h7jr#  ubh#)r`'  }ra'  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.UnSplitrb'  hKh'KhX*   Restores original view after a tab split. rc'  hhh	h)]rd'  h1X
   UnSplit(self)re'  h3h4h5X   26rf'  h7jr#  ubh#)rg'  }rh'  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.UnsplitDClickri'  hKh'KhXf  Unsplit the :class:`AuiNotebook` on sash double-click.

:param `part`: an UI part representing the sash;
:param integer `sash_size`: the sash size;
:param wx.Point `pos`: the double-click mouse position.

.. warning::

   Due to a bug on MSW, for disabled pages :func:`FindWindowAtPoint`
   returns the wrong window. See http://trac.wxwidgets.org/ticket/2942rj'  hhh	h)]rk'  (X   partrl'  hhrm'  X	   sash_sizern'  hhro'  X   posrp'  hhrq'  eh1X)   UnsplitDClick(self, part, sash_size, pos)rr'  h3h4h5X   104rs'  h7jr#  ubh#)rt'  }ru'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.UpdateHintWindowSizerv'  hKh'KhXO   Updates the :class:`~wx.lib.agw.aui.framemanager.AuiManager` hint window size. rw'  hhh	h)]rx'  h1X   UpdateHintWindowSize(self)ry'  h3h4h5X   13rz'  h7jr#  ubh#)r{'  }r|'  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.UpdateTabCtrlHeightr}'  hKh'KhX   :meth:`UpdateTabCtrlHeight` does the actual tab resizing. It's meant
to be used interally.

:param bool `force`: ``True`` to force the tab art to repaint.r~'  hhh	h)]r'  X   forcer'  X   Falser'  j*  r'  ah1X&   UpdateTabCtrlHeight(self, force=False)r'  h3h4h5X   30r'  h7jr#  ubhO)r'  }r'  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.NavigatorPropsr'  hKh'Khhhhh	hSX   <lambda>r'  hUhhVhh3hWh7jr#  ubehd]r'  (]r'  X   objectr'  a]r'  (]r'  X
   simplewrapperr'  a]r'  (]r'  X   wrapperr'  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  X   Panelr'  a]r'  ]r'  j#  aaeeee]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j'  a]r'  ]r'  j#  aaeeeeeeeehk]r'  X(   wx.lib.agw.aui.tabmdi.AuiMDIClientWindowr'  ahm]r'  X   wx.Panelr'  ah1X   AuiNotebook(wx.Panel)r'  hpj  )r'  }r'  (j  ]r'  (X"   wx.lib.agw.aui.auibook.AuiNotebookr'  ]r'  X   wx.Panelr'  ar'  X   wx.Panelr'  ]r'  X	   wx.Windowr'  ar'  X	   wx.Windowr'  ]r'  X
   wx.WindowBaser'  ar'  X
   wx.WindowBaser'  ]r'  X
   wx.EvtHandlerr'  ar'  X
   wx.EvtHandlerr'  ]r'  (X	   wx.Objectr'  X   wx.Trackabler'  er'  X	   wx.Objectr'  ]r'  r'  X   wx.Trackabler'  ]r'  r'  ej  ]r'  X"   wx.lib.agw.aui.auibook.AuiNotebookr'  aj  jr#  ubh'Kh3hqhrXU   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebook.txtr'  h7jl#  h5X   3313r'  j  ]r'  (X   __init__r'  X   AddControlToPager'  X   AddPager'  X   AddTabAreaButtonr'  X   AdvanceSelectionr'  X   AssignImageListr'  X   CalculateNewSplitSizer'  X   CalculateTabCtrlHeightr'  X   CloneTabAreaButtonsr'  X
   DeletePager'  X   Destroyr'  X   DoSizingr'  X   EditTabr'  X	   EnableTabr'  X
   EnsureVisibler'  X   FindNextActiveTabr'  X   FindTabr'  X	   FloatPager'  X   GetActiveTabCtrlr'  X   GetAGWWindowStyleFlagr'  X   GetArtProviderr'  X
   GetAuiManagerr'  X   GetCurrentPager'  X   GetDefaultBorderr'  X
   GetEnabledr'  X   GetHeightForPageHeightr'  X	   GetHiddenr'  X   GetImageListr'  X   GetMinMaxTabWidthr'  X   GetPager'  X
   GetPageBitmapr'  X   GetPageCountr'  X   GetPageImager'  X   GetPageIndexr'  X   GetPageInfor'  X   GetPageTextr'  X   GetPageTextColourr'  X   GetPageTooltipr'  X   GetSashDClickUnsplitr'  X   GetSelectionr'  X   GetShownPageCountr'  X   GetTabContainerr'  X   GetTabCtrlFromPointr'  X   GetTabCtrlHeightr'  X   GetTabFrameFromTabCtrlr'  X   GetTabFrameFromWindowr'  X   HasCloseButtonr (  X   HasMultiplePagesr(  X   HideAllTabsr(  X   HidePager(  X   InitNotebookr(  X
   InsertPager(  X   IsMouseWellOutsideWindowr(  X   IsRenamabler(  X   LoadPerspectiver(  X   NotebookPreviewr	(  X   OnChildFocusNotebookr
(  X   OnCloseFloatingPager(  X   OnNavigationKeyNotebookr(  X   OnRenameAcceptr
(  X   OnRenameCancelledr(  X   OnSizer(  X   OnTabBeginDragr(  X
   OnTabBgDClickr(  X   OnTabButtonr(  X   OnTabCancelDragr(  X   OnTabClickedr(  X   OnTabDClickr(  X   OnTabDragMotionr(  X   OnTabEndDragr(  X   OnTabMiddleDownr(  X
   OnTabMiddleUpr(  X   OnTabRightDownr(  X   OnTabRightUpr(  X
   ReDockPager(  X   RemoveControlFromPager(  X   RemoveEmptyTabFramesr(  X
   RemovePager(  X   RemoveTabAreaButtonr (  X   ReparentControlr!(  X   ResetTextControlr"(  X   SavePerspectiver#(  X   SetAGWWindowStyleFlagr$(  X   SetArtProviderr%(  X   SetCloseButtonr&(  X   SetFontr'(  X   SetImageListr((  X   SetMeasuringFontr)(  X   SetMinMaxTabWidthr*(  X   SetNavigatorIconr+(  X
   SetNormalFontr,(  X
   SetPageBitmapr-(  X   SetPageImager.(  X   SetPageTextr/(  X   SetPageTextColourr0(  X   SetPageTooltipr1(  X   SetRenamabler2(  X   SetSashDClickUnsplitr3(  X   SetSelectedFontr4(  X   SetSelectionr5(  X   SetSelectionToPager6(  X   SetSelectionToWindowr7(  X   SetTabCtrlHeightr8(  X   SetUniformBitmapSizer9(  X   ShowWindowMenur:(  X   Splitr;(  X   UnSplitr<(  X
   UnsplitDClickr=(  X   UpdateHintWindowSizer>(  X   UpdateTabCtrlHeightr?(  ej  j'  ubh)r@(  }rA(  (hX'   wx.lib.agw.aui.auibook.AuiNotebookEventrB(  hKhXK   A specialized command event class for events sent by :class:`AuiNotebook`. rC(  hhh	h
]rD(  (h#)rE(  }rF(  (hX0   wx.lib.agw.aui.auibook.AuiNotebookEvent.__init__rG(  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.rH(  hhh	h)]rI(  (X   command_typerJ(  X   NonerK(  X   NonerL(  rM(  X   win_idrN(  j  X   0rO(  rP(  eh1X+   __init__(self, command_type=None, win_id=0)rQ(  h3h4h5X   15rR(  h7j@(  ubh#)rS(  }rT(  (hX-   wx.lib.agw.aui.auibook.AuiNotebookEvent.AllowrU(  hKh'KhX  This is the opposite of :meth:`Veto`: it explicitly allows the event to be
processed. For most events it is not necessary to call this method as the
events are allowed anyhow but some are forbidden by default (this will
be mentioned in the corresponding event description).rV(  hhh	h)]rW(  h1X   Allow(self)rX(  h3h4h5X   10rY(  h7j@(  ubh#)rZ(  }r[(  (hX6   wx.lib.agw.aui.auibook.AuiNotebookEvent.GetNotifyEventr\(  hKh'KhX)   Returns the actual :class:`NotifyEvent`. r](  hhh	h)]r^(  h1X   GetNotifyEvent(self)r_(  h3h4h5hIh7j@(  ubh#)r`(  }ra(  (hX1   wx.lib.agw.aui.auibook.AuiNotebookEvent.IsAllowedrb(  hKh'KhX-   Returns whether the event is allowed or not. rc(  hhh	h)]rd(  h1X   IsAllowed(self)re(  h3h4h5hIh7j@(  ubh#)rf(  }rg(  (hX,   wx.lib.agw.aui.auibook.AuiNotebookEvent.Vetorh(  hKh'KhX  Prevents the change announced by this event from happening.

It is in general a good idea to notify the user about the reasons for
vetoing the change because otherwise the applications behaviour (which
just refuses to do what the user wants) might be quite surprising.ri(  hhh	h)]rj(  h1X
   Veto(self)rk(  h3h4h5X   11rl(  h7j@(  ubehd]rm(  (]rn(  X   objectro(  a]rp(  (]rq(  X
   simplewrapperrr(  a]rs(  (]rt(  X   wrapperru(  a]rv(  (]rw(  j  a]rx(  (]ry(  j  a]rz(  (]r{(  j  a]r|(  (]r}(  j  a]r~(  (]r(  X   CommandNotebookEventr(  a]r(  ]r(  X   AuiNotebookEventr(  aaeeeeeeeehk]r(  hm]r(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ah1X&   AuiNotebookEvent(CommandNotebookEvent)r(  hpj  )r(  }r(  (j  ]r(  (X'   wx.lib.agw.aui.auibook.AuiNotebookEventr(  ]r(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ar(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ]r(  X   wx.PyCommandEventr(  ar(  X   wx.PyCommandEventr(  ]r(  X   wx.CommandEventr(  ar(  X   wx.CommandEventr(  ]r(  X   wx.Eventr(  ar(  X   wx.Eventr(  ]r(  X	   wx.Objectr(  ar(  X	   wx.Objectr(  ]r(  r(  ej  ]r(  X'   wx.lib.agw.aui.auibook.AuiNotebookEventr(  aj  j@(  ubh'Kh3hqhrXZ   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebookEvent.txtr(  h7jl#  h5X   53r(  j  ]r(  (X   __init__r(  X   Allowr(  X   GetNotifyEventr(  X	   IsAllowedr(  X   Vetor(  ej  j(  ubh)r(  }r(  (hX&   wx.lib.agw.aui.auibook.AuiNotebookPager(  hKhXO   A simple class which holds information about tab captions, bitmaps and
colours.r(  hhh	h
]r(  (h#)r(  }r(  (hX/   wx.lib.agw.aui.auibook.AuiNotebookPage.__init__r(  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r(  hhh	h)]r(  h1X   __init__(self)r(  h3h4h5X   24r(  h7j(  ubh#)r(  }r(  (hX2   wx.lib.agw.aui.auibook.AuiNotebookPage.IsMultiliner(  hKh'KhX1   Returns whether the tab contains multiline text. r(  hhh	h)]r(  h1X   IsMultiline(self)r(  h3h4h5hIh7j(  ubehd]r(  (]r(  X   objectr(  a]r(  ]r(  X   AuiNotebookPager(  aaehk]r(  hm]r(  h1X   AuiNotebookPage(object)r(  hpj  )r(  }r(  (j  ]r(  X&   wx.lib.agw.aui.auibook.AuiNotebookPager(  ]r(  r(  aj  ]r(  X&   wx.lib.agw.aui.auibook.AuiNotebookPager(  aj  j(  ubh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebookPage.txtr(  h7jl#  h5X   36r(  j  ]r(  (X   __init__r(  X   IsMultiliner(  ej  j(  ubh)r(  }r(  (hX&   wx.lib.agw.aui.auibook.AuiTabContainerr(  hKhX  AuiTabContainer is a class which contains information about each tab.
It also can render an entire tab control to a specified DC.
It's not a window class itself, because this code will be used by
the :class:`AuiNotebook`, where it is disadvantageous to have separate
windows for each tab control in the case of "docked tabs".

A derived class, :class:`AuiTabCtrl`, is an actual :class:`wx.Window` - derived window
which can be used as a tab control in the normal sense.r(  hhh	h
]r(  (h#)r(  }r(  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.__init__r(  hKh'KhX   Default class constructor.
Used internally, do not call it in your code!

:param `auiNotebook`: the parent :class:`AuiNotebook` window.r(  hhh	h)]r(  X   auiNotebookr(  hhr(  ah1X   __init__(self, auiNotebook)r(  h3h4h5X   25r(  h7j(  ubh#)r(  }r(  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.AddButtonr(  hKh'KhX  Adds a button in the tab area.

:param integer `id`: the button identifier. This can be one of the following:

 ==============================  =================================
 Button Identifier               Description
 ==============================  =================================
 ``AUI_BUTTON_CLOSE``            Shows a close button on the tab area
 ``AUI_BUTTON_WINDOWLIST``       Shows a window list button on the tab area
 ``AUI_BUTTON_LEFT``             Shows a left button on the tab area
 ``AUI_BUTTON_RIGHT``            Shows a right button on the tab area
 ==============================  =================================

:param integer `location`: the button location. Can be ``wx.LEFT`` or ``wx.RIGHT``;
:param wx.Bitmap `normal_bitmap`: the bitmap for an enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap for a disabled tab;
:param string `name`: the button name.r(  hhh	h)]r(  (X   idr(  hhr(  X   locationr(  hhr(  X
   normal_bitmapr(  X
   wx.NullBitmapr(  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r(  r(  X   disabled_bitmapr(  X
   wx.NullBitmapr(  X*   <wx._core.Bitmap object at 0x7f20f7ecc690>r(  r(  X   namer(  X   ""r(  hr(  eh1Xb   AddButton(self, id, location, normal_bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, name="")r(  h3h4h5X   31r(  h7j(  ubh#)r(  }r(  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.AddPager(  hKh'KhX   Adds a page to the tab control.

:param wx.Window `page`: the window associated with this tab;
:param `info`: an instance of :class:`AuiNotebookPage`.r(  hhh	h)]r(  (X   pager(  hhr(  X   infor(  hhr )  eh1X   AddPage(self, page, info)r)  h3h4h5X   20r)  h7j(  ubh#)r)  }r)  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.ButtonHitTestr)  hKh'KhX)  Tests if a button was hit.

:param integer `x`: the mouse `x` position;
:param integer `y`: the mouse `y` position;
:param integer `state_flags`: the current button state (hidden, disabled, etc...).

:returns: and instance of :class:`AuiTabContainerButton` if a button was hit, ``None`` otherwise.r)  hhh	h)]r)  (j  hhr)  j  hhr	)  X   state_flagsr
)  X1   AUI_BUTTON_STATE_HIDDEN|AUI_BUTTON_STATE_DISABLEDr)  X   24r)  r
)  eh1XX   ButtonHitTest(self, x, y, state_flags=AUI_BUTTON_STATE_HIDDEN|AUI_BUTTON_STATE_DISABLED)r)  h3h4h5X   26r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.CloneButtonsr)  hKh'KhX   Clones the tab area buttons when the :class:`AuiNotebook` is being split.

:see: :meth:`AddButton`

:note: Standard buttons for :class:`AuiNotebook` are not cloned, only custom ones.r)  hhh	h)]r)  h1X   CloneButtons(self)r)  h3h4h5X   23r)  h7j(  ubh#)r)  }r)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.DoShowHider)  hKh'KhX[   This function shows the active window, then hides all of the other windows
(in that order).r)  hhh	h)]r)  h1X   DoShowHide(self)r)  h3h4h5X   19r)  h7j(  ubh#)r)  }r)  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.EnableTabr )  hKh'KhX   Enables/disables a tab in the :class:`AuiTabContainer`.

:param integer `idx`: the tab index;
:param bool `enable`: ``True`` to enable a tab, ``False`` to disable it.r!)  hhh	h)]r")  (X   idxr#)  hhr$)  X   enabler%)  X   Truer&)  h/r')  eh1X!   EnableTab(self, idx, enable=True)r()  h3h4h5X   15r))  h7j(  ubh#)r*)  }r+)  (hX8   wx.lib.agw.aui.auibook.AuiTabContainer.FindNextActiveTabr,)  hKh'KhX   Finds the next active tab in the :class:`AuiTabContainer`.

:param integer `idx`: the index of the first (most obvious) tab to check for active status;r-)  hhh	h)]r.)  X   idxr/)  hhr0)  ah1X   FindNextActiveTab(self, idx)r1)  h3h4h5X   20r2)  h7j(  ubh#)r3)  }r4)  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.GetActivePager5)  hKh'KhXJ   Returns the current selected tab or ``wx.NOT_FOUND`` if none is selected. r6)  hhh	h)]r7)  h1X   GetActivePage(self)r8)  h3h4h5j}  h7j(  ubh#)r9)  }r:)  (hX2   wx.lib.agw.aui.auibook.AuiTabContainer.GetAGWFlagsr;)  hKh'KhXb   Returns the tab art flags.

.. seealso:: :meth:`SetAGWFlags` for a list of possible return values.r<)  hhh	h)]r=)  h1X   GetAGWFlags(self)r>)  h3h4h5j}  h7j(  ubh#)r?)  }r@)  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.GetArtProviderrA)  hKh'KhX-   Returns the current art provider being used. rB)  hhh	h)]rC)  h1X   GetArtProvider(self)rD)  h3h4h5hIh7j(  ubh#)rE)  }rF)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.GetEnabledrG)  hKh'KhXN   Returns whether a tab is enabled or not.

:param integer `idx`: the tab index.rH)  hhh	h)]rI)  X   idxrJ)  hhrK)  ah1X   GetEnabled(self, idx)rL)  h3h4h5X   12rM)  h7j(  ubh#)rN)  }rO)  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.GetHiddenrP)  hKh'KhXM   Returns whether a tab is hidden or not.

:param integer `idx`: the tab index.rQ)  hhh	h)]rR)  X   idxrS)  hhrT)  ah1X   GetHidden(self, idx)rU)  h3h4h5X   12rV)  h7j(  ubh#)rW)  }rX)  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.GetIdxFromWindowrY)  hKh'KhXu   Returns the tab index based on the window `wnd` associated with it.

:param `wnd`: an instance of :class:`wx.Window`.rZ)  hhh	h)]r[)  X   wndr\)  hhr])  ah1X   GetIdxFromWindow(self, wnd)r^)  h3h4h5X   13r_)  h7j(  ubh#)r`)  }ra)  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.GetPagerb)  hKh'KhXT   Returns the page specified by the given index.

:param integer `idx`: the tab index.rc)  hhh	h)]rd)  X   idxre)  hhrf)  ah1X   GetPage(self, idx)rg)  h3h4h5X   12rh)  h7j(  ubh#)ri)  }rj)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.GetPageCountrk)  hKh'KhX=   Returns the number of pages in the :class:`AuiTabContainer`. rl)  hhh	h)]rm)  h1X   GetPageCount(self)rn)  h3h4h5hIh7j(  ubh#)ro)  }rp)  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.GetPagesrq)  hKh'KhXB   Returns a list of all the pages in this :class:`AuiTabContainer`. rr)  hhh	h)]rs)  h1X   GetPages(self)rt)  h3h4h5hIh7j(  ubh#)ru)  }rv)  (hX8   wx.lib.agw.aui.auibook.AuiTabContainer.GetShownPageCountrw)  hKh'KhXC   Returns the number of pages shown in the :class:`AuiTabContainer`. rx)  hhh	h)]ry)  h1X   GetShownPageCount(self)rz)  h3h4h5jr  h7j(  ubh#)r{)  }r|)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.GetTabOffsetr})  hKh'KhX   Returns the tab offset. r~)  hhh	h)]r)  h1X   GetTabOffset(self)r)  h3h4h5hIh7j(  ubh#)r)  }r)  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.GetWindowFromIdxr)  hKh'KhXb   Returns the window associated with the tab with index `idx`.

:param integer `idx`: the tab index.r)  hhh	h)]r)  X   idxr)  hhr)  ah1X   GetWindowFromIdx(self, idx)r)  h3h4h5X   12r)  h7j(  ubh#)r)  }r)  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.HideTabr)  hKh'KhX   hides/shows a tab in the :class:`AuiTabContainer`.

:param integer `idx`: the tab index;
:param bool `hidden`: ``True`` to hide a tab, ``False`` to show it.r)  hhh	h)]r)  (X   idxr)  hhr)  X   hiddenr)  X   Truer)  h/r)  eh1X   HideTab(self, idx, hidden=True)r)  h3h4h5X   16r)  h7j(  ubh#)r)  }r)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.InsertPager)  hKh'KhX   Inserts a page in the tab control in the position specified by `idx`.

:param wx.Window `page`: the window associated with this tab;
:param `info`: an instance of :class:`AuiNotebookPage`;
:param integer `idx`: the page insertion index.r)  hhh	h)]r)  (X   pager)  hhr)  X   infor)  hhr)  X   idxr)  hhr)  eh1X!   InsertPage(self, page, info, idx)r)  h3h4h5X   24r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.IsTabVisibler)  hKh'KhX   Returns whether a tab is visible or not.

:param integer `tabPage`: the tab index;
:param integer `tabOffset`: the tab offset;
:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: an instance of :class:`wx.Window` derived window.r)  hhh	h)]r)  (X   tabPager)  hhr)  X	   tabOffsetr)  hhr)  X   dcr)  hhr)  X   wndr)  hhr)  eh1X/   IsTabVisible(self, tabPage, tabOffset, dc, wnd)r)  h3h4h5X   115r)  h7j(  ubh#)r)  }r)  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.MakeTabVisibler)  hKh'KhX   Make the tab visible if it wasn't already.

:param integer `tabPage`: the tab index;
:param `win`: an instance of :class:`wx.Window` derived window.r)  hhh	h)]r)  (X   tabPager)  hhr)  X   winr)  hhr)  eh1X"   MakeTabVisible(self, tabPage, win)r)  h3h4h5X   17r)  h7j(  ubh#)r)  }r)  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.MovePager)  hKh'KhX   Moves a page in a new position specified by `new_idx`.

:param wx.Window `page`: the window associated with this tab;
:param integer `new_idx`: the new page position.r)  hhh	h)]r)  (X   pager)  hhr)  X   new_idxr)  hhr)  eh1X   MovePage(self, page, new_idx)r)  h3h4h5X   23r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.RemoveButtonr)  hKh'KhX   Removes a button from the tab area.

:param integer `id`: the button identifier. See :meth:`AddButton` for a list of button identifiers.

:see: :meth:`AddButton`r)  hhh	h)]r)  X   idr)  hhr)  ah1X   RemoveButton(self, id)r)  h3h4h5X   14r)  h7j(  ubh#)r)  }r)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.RemovePager)  hKh'KhXy   Removes a page from the tab control.

:param `wnd`: an instance of :class:`wx.Window`, a window associated with this tab.r)  hhh	h)]r)  X   wndr)  hhr)  ah1X   RemovePage(self, wnd)r)  h3h4h5X   22r)  h7j(  ubh#)r)  }r)  (hX-   wx.lib.agw.aui.auibook.AuiTabContainer.Renderr)  hKh'KhX   Renders the tab catalog to the specified :class:`wx.DC`.

It is a virtual function and can be overridden to provide custom drawing
capabilities.

:param `raw_dc`: a :class:`wx.DC` device context;
:param `wnd`: an instance of :class:`wx.Window`.r)  hhh	h)]r)  (X   raw_dcr)  hhr)  X   wndr)  hhr)  eh1X   Render(self, raw_dc, wnd)r)  h3h4h5X   275r)  h7j(  ubh#)r)  }r)  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetActivePager)  hKh'KhX   Sets the :class:`AuiNotebook` active page.

:param `wndOrInt`: an instance of :class:`wx.Window` or an integer specifying a tab index.r)  hhh	h)]r)  X   wndOrIntr)  hhr)  ah1X   SetActivePage(self, wndOrInt)r)  h3h4h5X   31r)  h7j(  ubh#)r)  }r)  (hX2   wx.lib.agw.aui.auibook.AuiTabContainer.SetAGWFlagsr)  hKh'KhXU  Sets the tab art flags.

:param integer `agwFlags`: a combination of the following values:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

.. todo:: Implementation of flags ``AUI_NB_RIGHT`` and ``AUI_NB_LEFT``.r)  hhh	h)]r)  X   agwFlagsr)  hhr)  ah1X   SetAGWFlags(self, agwFlags)r)  h3h4h5X   60r)  h7j(  ubh#)r)  }r)  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.SetArtProviderr)  hKh'KhX  Instructs :class:`AuiTabContainer` to use art provider specified by parameter `art`
for all drawing calls. This allows plugable look-and-feel features.

:param `art`: an art provider.

:note: The previous art provider object, if any, will be deleted by :class:`AuiTabContainer`.r)  hhh	h)]r)  X   artr)  hhr)  ah1X   SetArtProvider(self, art)r)  h3h4h5X   16r)  h7j(  ubh#)r *  }r*  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.SetMeasuringFontr*  hKh'KhX   Sets the font for calculating text measurements.

:param wx.Font `font`: the new font to use to measure tab label text extents.r*  hhh	h)]r*  X   fontr*  hhr*  ah1X   SetMeasuringFont(self, font)r*  h3h4h5j}  h7j(  ubh#)r*  }r	*  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetNoneActiver
*  hKh'KhX.   Sets all the tabs as inactive (non-selected). r*  hhh	h)]r*  h1X   SetNoneActive(self)r
*  h3h4h5hCh7j(  ubh#)r*  }r*  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetNormalFontr*  hKh'KhX   Sets the normal font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.r*  hhh	h)]r*  X   fontr*  hhr*  ah1X   SetNormalFont(self, font)r*  h3h4h5j}  h7j(  ubh#)r*  }r*  (hX6   wx.lib.agw.aui.auibook.AuiTabContainer.SetSelectedFontr*  hKh'KhX   Sets the selected tab font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their selected state.r*  hhh	h)]r*  X   fontr*  hhr*  ah1X   SetSelectedFont(self, font)r*  h3h4h5j}  h7j(  ubh#)r*  }r*  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.SetTabOffsetr *  hKh'KhX>   Sets the tab offset.

:param integer `offset`: the tab offset.r!*  hhh	h)]r"*  X   offsetr#*  hhr$*  ah1X   SetTabOffset(self, offset)r%*  h3h4h5j}  h7j(  ubh#)r&*  }r'*  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.SetTabRectr(*  hKh'KhXe   Sets the tab area rectangle.

:param wx.Rect `rect`: the available area for :class:`AuiTabContainer`.r)*  hhh	h)]r**  X   rectr+*  hhr,*  ah1X   SetTabRect(self, rect)r-*  h3h4h5X   13r.*  h7j(  ubh#)r/*  }r0*  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.TabHitTestr1*  hKh'KhX   TabHitTest() tests if a tab was hit, passing the window pointer
back if that condition was fulfilled.

:param integer `x`: the mouse `x` position;
:param integer `y`: the mouse `y` position.r2*  hhh	h)]r3*  (j  hhr4*  j  hhr5*  eh1X   TabHitTest(self, x, y)r6*  h3h4h5X   28r7*  h7j(  ubehd]r8*  (]r9*  X   objectr:*  a]r;*  ]r<*  X   AuiTabContainerr=*  aaehk]r>*  X!   wx.lib.agw.aui.auibook.AuiTabCtrlr?*  ahm]r@*  h1X   AuiTabContainer(object)rA*  hpj  )rB*  }rC*  (j  ]rD*  X&   wx.lib.agw.aui.auibook.AuiTabContainerrE*  ]rF*  rG*  aj  ]rH*  X&   wx.lib.agw.aui.auibook.AuiTabContainerrI*  aj  j(  ubh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabContainer.txtrJ*  h7jl#  h5X   1025rK*  j  ]rL*  (X   __init__rM*  X	   AddButtonrN*  X   AddPagerO*  X
   ButtonHitTestrP*  X   CloneButtonsrQ*  X
   DoShowHiderR*  X	   EnableTabrS*  X   FindNextActiveTabrT*  X
   GetActivePagerU*  X   GetAGWFlagsrV*  X   GetArtProviderrW*  X
   GetEnabledrX*  X	   GetHiddenrY*  X   GetIdxFromWindowrZ*  X   GetPager[*  X   GetPageCountr\*  X   GetPagesr]*  X   GetShownPageCountr^*  X   GetTabOffsetr_*  X   GetWindowFromIdxr`*  X   HideTabra*  X
   InsertPagerb*  X   IsTabVisiblerc*  X   MakeTabVisiblerd*  X   MovePagere*  X   RemoveButtonrf*  X
   RemovePagerg*  X   Renderrh*  X
   SetActivePageri*  X   SetAGWFlagsrj*  X   SetArtProviderrk*  X   SetMeasuringFontrl*  X
   SetNoneActiverm*  X
   SetNormalFontrn*  X   SetSelectedFontro*  X   SetTabOffsetrp*  X
   SetTabRectrq*  X
   TabHitTestrr*  ej  j@*  ubh)rs*  }rt*  (hX,   wx.lib.agw.aui.auibook.AuiTabContainerButtonru*  hKhXI   A simple class which holds information about tab buttons and their state.rv*  hhh	h
]rw*  h#)rx*  }ry*  (hX5   wx.lib.agw.aui.auibook.AuiTabContainerButton.__init__rz*  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r{*  hhh	h)]r|*  h1X   __init__(self)r}*  h3h4h5X   14r~*  h7js*  ubahd]r*  (]r*  X   objectr*  a]r*  ]r*  X   AuiTabContainerButtonr*  aaehk]r*  hm]r*  h1X   AuiTabContainerButton(object)r*  hpj  )r*  }r*  (j  ]r*  X,   wx.lib.agw.aui.auibook.AuiTabContainerButtonr*  ]r*  r*  aj  ]r*  X,   wx.lib.agw.aui.auibook.AuiTabContainerButtonr*  aj  js*  ubh'Kh3hqhrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabContainerButton.txtr*  h7jl#  h5X   19r*  j  ]r*  X   __init__r*  aj  j*  ubh)r*  }r*  (hX!   wx.lib.agw.aui.auibook.AuiTabCtrlr*  hKhXm   This is an actual :class:`wx.Window` - derived window which can be used as a tab control in the normal sense.r*  hhh	h
]r*  (h#)r*  }r*  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.__init__r*  hKh'KhXO  Default class constructor.
Used internally, do not call it in your code!

:param `parent`: the :class:`AuiNotebook` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the window style.r*  hhh	h)]r*  (X   parentr*  hhr*  X   idr*  X	   wx.ID_ANYr*  X   -1r*  r*  X   posr*  X   wx.DefaultPositionr*  X   (-1, -1)r*  r*  X   sizer*  X   wx.DefaultSizer*  X   (-1, -1)r*  r*  X   styler*  X,   wx.NO_BORDER|wx.WANTS_CHARS|wx.TAB_TRAVERSALr*  X   2883584r*  r*  eh1X   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.NO_BORDER|wx.WANTS_CHARS|wx.TAB_TRAVERSAL)r*  h3h4h5X   47r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.DoGetBestSizer*  hKh'KhX   Gets the size which best suits the window: for a control, it would be the
minimal size which doesn't truncate the control, for a panel - the same
size as it would have after a call to `Fit()`.

:note: Overridden from :class:`wx.Control`.r*  hhh	h)]r*  h1X   DoGetBestSize(self)r*  h3h4h5X   11r*  h7j*  ubh#)r*  }r*  (hX2   wx.lib.agw.aui.auibook.AuiTabCtrl.GetDefaultBorderr*  hKh'KhX:   Returns the default border style for :class:`AuiTabCtrl`. r*  hhh	h)]r*  h1X   GetDefaultBorder(self)r*  h3h4h5hIh7j*  ubh#)r*  }r*  (hX1   wx.lib.agw.aui.auibook.AuiTabCtrl.GetPointedToTabr*  hKh'KhXV   Returns the page at which the mouse is pointing (if any).

:rtype: :class:`wx.Window`.r*  hhh	h)]r*  h1X   GetPointedToTab(self)r*  h3h4h5X   11r*  h7j*  ubh#)r*  }r*  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.IsDraggingr*  hKh'KhXB   Returns whether the user is dragging a tab with the mouse or not. r*  hhh	h)]r*  h1X   IsDragging(self)r*  h3h4h5hIh7j*  ubh#)r*  }r*  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnButtonr*  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BUTTON`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnButton(self, event)r*  h3h4h5X   41r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnCaptureLostr*  hKh'KhX   Handles the ``wx.EVT_MOUSE_CAPTURE_LOST`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseCaptureLostEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnCaptureLost(self, event)r*  h3h4h5X   35r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnEnterWindowr*  hKh'KhX   Handles the ``wx.EVT_ENTER_WINDOW`` event fof :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnEnterWindow(self, event)r*  h3h4h5j}  h7j*  ubh#)r*  }r*  (hX3   wx.lib.agw.aui.auibook.AuiTabCtrl.OnEraseBackgroundr*  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnEraseBackground(self, event)r*  h3h4h5X   11r*  h7j*  ubh#)r*  }r*  (hX+   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKeyDownr*  hKh'KhXz   Handles the ``wx.EVT_KEY_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnKeyDown(self, event)r*  h3h4h5X   64r*  h7j*  ubh#)r*  }r*  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKeyDown2r*  hKh'KhX   Handles the ``wx.EVT_KEY_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.

.. deprecated:: 0.6
   This implementation is now deprecated. Refer to :meth:`OnKeyDown` for the correct one.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnKeyDown2(self, event)r*  h3h4h5X   107r +  h7j*  ubh#)r+  }r+  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKillFocusr+  hKh'KhX~   Handles the ``wx.EVT_KILL_FOCUS`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnKillFocus(self, event)r+  h3h4h5j}  h7j*  ubh#)r	+  }r
+  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeaveWindowr+  hKh'KhX   Handles the ``wx.EVT_LEAVE_WINDOW`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r+  hhh	h)]r
+  X   eventr+  hhr+  ah1X   OnLeaveWindow(self, event)r+  h3h4h5X   15r+  h7j*  ubh#)r+  }r+  (hX.   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftDClickr+  hKh'KhX   Handles the ``wx.EVT_LEFT_DCLICK`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnLeftDClick(self, event)r+  h3h4h5X   21r+  h7j*  ubh#)r+  }r+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftDownr+  hKh'KhX}   Handles the ``wx.EVT_LEFT_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r+  hhh	h)]r+  X   eventr +  hhr!+  ah1X   OnLeftDown(self, event)r"+  h3h4h5X   53r#+  h7j*  ubh#)r$+  }r%+  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftUpr&+  hKh'KhX{   Handles the ``wx.EVT_LEFT_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r'+  hhh	h)]r(+  X   eventr)+  hhr*+  ah1X   OnLeftUp(self, event)r++  h3h4h5X   80r,+  h7j*  ubh#)r-+  }r.+  (hX.   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMiddleDownr/+  hKh'KhX   Handles the ``wx.EVT_MIDDLE_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r0+  hhh	h)]r1+  X   eventr2+  hhr3+  ah1X   OnMiddleDown(self, event)r4+  h3h4h5X   28r5+  h7j*  ubh#)r6+  }r7+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMiddleUpr8+  hKh'KhX}   Handles the ``wx.EVT_MIDDLE_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r9+  hhh	h)]r:+  X   eventr;+  hhr<+  ah1X   OnMiddleUp(self, event)r=+  h3h4h5X   26r>+  h7j*  ubh#)r?+  }r@+  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMotionrA+  hKh'KhXz   Handles the ``wx.EVT_MOTION`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rB+  hhh	h)]rC+  X   eventrD+  hhrE+  ah1X   OnMotion(self, event)rF+  h3h4h5X   117rG+  h7j*  ubh#)rH+  }rI+  (hX)   wx.lib.agw.aui.auibook.AuiTabCtrl.OnPaintrJ+  hKh'KhXy   Handles the ``wx.EVT_PAINT`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`PaintEvent` event to be processed.rK+  hhh	h)]rL+  X   eventrM+  hhrN+  ah1X   OnPaint(self, event)rO+  h3h4h5X   13rP+  h7j*  ubh#)rQ+  }rR+  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.OnRightDownrS+  hKh'KhX~   Handles the ``wx.EVT_RIGHT_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rT+  hhh	h)]rU+  X   eventrV+  hhrW+  ah1X   OnRightDown(self, event)rX+  h3h4h5X   23rY+  h7j*  ubh#)rZ+  }r[+  (hX+   wx.lib.agw.aui.auibook.AuiTabCtrl.OnRightUpr\+  hKh'KhX|   Handles the ``wx.EVT_RIGHT_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r]+  hhh	h)]r^+  X   eventr_+  hhr`+  ah1X   OnRightUp(self, event)ra+  h3h4h5X   21rb+  h7j*  ubh#)rc+  }rd+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnSetFocusre+  hKh'KhX}   Handles the ``wx.EVT_SET_FOCUS`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.rf+  hhh	h)]rg+  X   eventrh+  hhri+  ah1X   OnSetFocus(self, event)rj+  h3h4h5j}  h7j*  ubh#)rk+  }rl+  (hX(   wx.lib.agw.aui.auibook.AuiTabCtrl.OnSizerm+  hKh'KhXz   Handles the ``wx.EVT_SIZE`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.rn+  hhh	h)]ro+  X   eventrp+  hhrq+  ah1X   OnSize(self, event)rr+  h3h4h5X   10rs+  h7j*  ubh#)rt+  }ru+  (hX5   wx.lib.agw.aui.auibook.AuiTabCtrl.RestartTooltipTimerrv+  hKh'KhX   Starts a timer: when it fires, a tooltip will be shown on the notebook tab
the mouse is pointing at.

:param wx.Window `wnd`: the window pointed by the mouse.rw+  hhh	h)]rx+  X   wndry+  hhrz+  ah1X   RestartTooltipTimer(self, wnd)r{+  h3h4h5X   16r|+  h7j*  ubh#)r}+  }r~+  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.ShowTooltipr+  hKh'KhX   Shows the tooltip on the tab. r+  hhh	h)]r+  h1X   ShowTooltip(self)r+  h3h4h5X   24r+  h7j*  ubh#)r+  }r+  (hX2   wx.lib.agw.aui.auibook.AuiTabCtrl.StopTooltipTimerr+  hKh'KhXO   Stops the timer keeping track of tooltips and mouse movements on the tab area. r+  hhh	h)]r+  h1X   StopTooltipTimer(self)r+  h3h4h5j5  h7j*  ubehd]r+  (]r+  X   objectr+  a]r+  (]r+  X
   simplewrapperr+  a]r+  (]r+  X   wrapperr+  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  ]r+  X
   AuiTabCtrlr+  aaeeee]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  ]r+  j+  aaeeeeee]r+  j=*  a]r+  ]r+  j+  aaeehk]r+  hm]r+  (X
   wx.Controlr+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  eh1X'   AuiTabCtrl(wx.Control, AuiTabContainer)r+  hpj  )r+  }r+  (j  ]r+  (X!   wx.lib.agw.aui.auibook.AuiTabCtrlr+  ]r+  (X
   wx.Controlr+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  er+  X
   wx.Controlr+  ]r+  X	   wx.Windowr+  ar+  X	   wx.Windowr+  ]r+  X
   wx.WindowBaser+  ar+  X
   wx.WindowBaser+  ]r+  X
   wx.EvtHandlerr+  ar+  X
   wx.EvtHandlerr+  ]r+  (X	   wx.Objectr+  X   wx.Trackabler+  er+  X	   wx.Objectr+  ]r+  r+  X   wx.Trackabler+  ]r+  r+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  ]r+  r+  ej  ]r+  X!   wx.lib.agw.aui.auibook.AuiTabCtrlr+  aj  j*  ubh'Kh3hqhrXT   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabCtrl.txtr+  h7jl#  h5X   849r+  j  ]r+  (X   __init__r+  X
   DoGetBestSizer+  X   GetDefaultBorderr+  X   GetPointedToTabr+  X
   IsDraggingr+  X   OnButtonr+  X
   OnCaptureLostr+  X
   OnEnterWindowr+  X   OnEraseBackgroundr+  X	   OnKeyDownr+  X
   OnKeyDown2r+  X   OnKillFocusr+  X
   OnLeaveWindowr+  X   OnLeftDClickr+  X
   OnLeftDownr+  X   OnLeftUpr+  X   OnMiddleDownr+  X
   OnMiddleUpr+  X   OnMotionr+  X   OnPaintr+  X   OnRightDownr+  X	   OnRightUpr+  X
   OnSetFocusr+  X   OnSizer+  X   RestartTooltipTimerr+  X   ShowTooltipr+  X   StopTooltipTimerr+  ej  j+  ubh)r+  }r+  (hX+   wx.lib.agw.aui.auibook.CommandNotebookEventr+  hKhXL   A specialized command event class for events sent by :class:`AuiNotebook` . r+  hhh	h
]r+  (h#)r+  }r+  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.__init__r+  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.r+  hhh	h)]r+  (X   command_typer+  X   Noner ,  X   Noner,  r,  X   win_idr,  j  X   0r,  r,  eh1X+   __init__(self, command_type=None, win_id=0)r,  h3h4h5X   21r,  h7j+  ubh#)r,  }r	,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetDispatchedr
,  hKh'KhXU   Returns whether the event was dispatched (used for automatic :class:`AuiNotebook` ). r,  hhh	h)]r,  h1X   GetDispatched(self)r
,  h3h4h5hIh7j+  ubh#)r,  }r,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetDragSourcer,  hKh'KhX"   Returns the drag and drop source. r,  hhh	h)]r,  h1X   GetDragSource(self)r,  h3h4h5hIh7j+  ubh#)r,  }r,  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetLabelr,  hKh'KhXU   Returns the label-itemtext (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).r,  hhh	h)]r,  h1X   GetLabel(self)r,  h3h4h5hIh7j+  ubh#)r,  }r,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetOldSelectionr,  hKh'KhXQ   Returns the page that was selected before the change, or -1 if none was
selected.r,  hhh	h)]r,  h1X   GetOldSelection(self)r,  h3h4h5jr  h7j+  ubh#)r ,  }r!,  (hX8   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetSelectionr",  hKh'KhXA   Returns the currently selected page, or -1 if none was selected. r#,  hhh	h)]r$,  h1X   GetSelection(self)r%,  h3h4h5hIh7j+  ubh#)r&,  }r',  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.IsEditCancelledr(,  hKh'KhXW   Returns the edit cancel flag (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).r),  hhh	h)]r*,  h1X   IsEditCancelled(self)r+,  h3h4h5hIh7j+  ubh#)r,,  }r-,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetDispatchedr.,  hKh'KhX~   Sets the event as dispatched (used for automatic :class:`AuiNotebook` ).

:param `b`: whether the event was dispatched or not.r/,  hhh	h)]r0,  j  hhr1,  ah1X   SetDispatched(self, b)r2,  h3h4h5j}  h7j+  ubh#)r3,  }r4,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetDragSourcer5,  hKh'KhX<   Sets the drag and drop source.

:param `s`: the drag source.r6,  hhh	h)]r7,  j  hhr8,  ah1X   SetDragSource(self, s)r9,  h3h4h5j}  h7j+  ubh#)r:,  }r;,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetEditCanceledr<,  hKh'KhX   Sets the edit cancel flag (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).

:param bool `editCancelled`: whether the editing action has been cancelled or not.r=,  hhh	h)]r>,  X
   editCancelledr?,  hhr@,  ah1X$   SetEditCanceled(self, editCancelled)rA,  h3h4h5j}  h7j+  ubh#)rB,  }rC,  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetLabelrD,  hKh'KhXj   Sets the label. Useful only for ``EVT_AUINOTEBOOK_END_LABEL_EDIT``.

:param string `label`: the new label.rE,  hhh	h)]rF,  X   labelrG,  hhrH,  ah1X   SetLabel(self, label)rI,  h3h4h5j}  h7j+  ubh#)rJ,  }rK,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetOldSelectionrL,  hKh'KhX[   Sets the id of the page selected before the change.

:param integer `s`: the old selection.rM,  hhh	h)]rN,  j  hhrO,  ah1X   SetOldSelection(self, s)rP,  h3h4h5j}  h7j+  ubh#)rQ,  }rR,  (hX8   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetSelectionrS,  hKh'KhXK   Sets the selection member variable.

:param integer `s`: the new selection.rT,  hhh	h)]rU,  j  hhrV,  ah1X   SetSelection(self, s)rW,  h3h4h5X   10rX,  h7j+  ubhO)rY,  }rZ,  (hX0   wx.lib.agw.aui.auibook.CommandNotebookEvent.Pager[,  hKh'Khhhhh	hSj'  hUj'  hVhh3hWh7j+  ubhO)r\,  }r],  (hX5   wx.lib.agw.aui.auibook.CommandNotebookEvent.Selectionr^,  hKh'Khhhhh	hSj'  hUj'  hVhh3hWh7j+  ubehd]r_,  (]r`,  X   objectra,  a]rb,  (]rc,  X
   simplewrapperrd,  a]re,  (]rf,  X   wrapperrg,  a]rh,  (]ri,  j  a]rj,  (]rk,  j  a]rl,  (]rm,  j  a]rn,  (]ro,  j  a]rp,  ]rq,  j(  aaeeeeeeehk]rr,  X'   wx.lib.agw.aui.auibook.AuiNotebookEventrs,  ahm]rt,  X   wx.PyCommandEventru,  ah1X'   CommandNotebookEvent(wx.PyCommandEvent)rv,  hpj  )rw,  }rx,  (j  ]ry,  (X+   wx.lib.agw.aui.auibook.CommandNotebookEventrz,  ]r{,  X   wx.PyCommandEventr|,  ar},  X   wx.PyCommandEventr~,  ]r,  X   wx.CommandEventr,  ar,  X   wx.CommandEventr,  ]r,  X   wx.Eventr,  ar,  X   wx.Eventr,  ]r,  X	   wx.Objectr,  ar,  X	   wx.Objectr,  ]r,  r,  ej  ]r,  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr,  aj  j+  ubh'Kh3hqhrX^   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.CommandNotebookEvent.txtr,  h7jl#  h5X   129r,  j  ]r,  (X   __init__r,  X
   GetDispatchedr,  X
   GetDragSourcer,  X   GetLabelr,  X   GetOldSelectionr,  X   GetSelectionr,  X   IsEditCancelledr,  X
   SetDispatchedr,  X
   SetDragSourcer,  X   SetEditCanceledr,  X   SetLabelr,  X   SetOldSelectionr,  X   SetSelectionr,  ej  jt,  ubh)r,  }r,  (hX&   wx.lib.agw.aui.auibook.ExpandoTextCtrlr,  hKhX  The ExpandoTextCtrl is a multi-line wx.TextCtrl that will
adjust its height on the fly as needed to accomodate the number of
lines needed to display the current content of the control.  It is
assumed that the width of the control will be a fixed value and
that only the height will be adjusted automatically.  If the
control is used in a sizer then the width should be set as part of
the initial or min size of the control.

When the control resizes itself it will attempt to also make
necessary adjustments in the sizer hierarchy it is a member of (if
any) but if that is not suffiecient then the programmer can catch
the EVT_ETC_LAYOUT_NEEDED event in the container and make any
other layout adjustments that may be needed.r,  hhh	h
]r,  (h#)r,  }r,  (hX/   wx.lib.agw.aui.auibook.ExpandoTextCtrl.__init__r,  hKh'KhX  Default class constructor.

:param `parent`: parent window, must not be ``None``;
:param integer `id`: window identifier. A value of -1 indicates a default value;
:param string `value`: the control text label;
:param `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the underlying :class:`wx.Control` style;
:param wx.Validator `validator`: the window validator;
:param string `name`: the widget name.

:type parent: :class:`wx.Window`
:type pos: tuple or :class:`wx.Point`
:type size: tuple or :class:`wx.Size`r,  hhh	h)]r,  (X   parentr,  hhr,  X   idr,  X   -1r,  X   -1r,  r,  X   valuer,  X   ""r,  hr,  X   posr,  X   wx.DefaultPositionr,  X   (-1, -1)r,  r,  X   sizer,  X   wx.DefaultSizer,  X   (-1, -1)r,  r,  X   styler,  j  X   0r,  r,  X	   validatorr,  X   wx.DefaultValidatorr,  X-   <wx._core.Validator object at 0x7f20f7ecc2d0>r,  r,  X   namer,  X	   "expando"r,  X   expandor,  r,  eh1X   __init__(self, parent, id=-1, value="", pos=wx.DefaultPosition,  size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name="expando")r,  h3h4h5X   43r,  h7j,  ubh#)r,  }r,  (hX1   wx.lib.agw.aui.auibook.ExpandoTextCtrl.AppendTextr,  hKh'KhX   Appends the text to the end of the text control.

:param string `text`: text to write to the text control.

.. seealso:: :meth:`WriteText`r,  hhh	h)]r,  X   textr,  hhr,  ah1X   AppendText(self, text)r,  h3h4h5X   16r,  h7j,  ubh#)r,  }r,  (hX3   wx.lib.agw.aui.auibook.ExpandoTextCtrl.GetMaxHeightr,  hKh'KhXS   Returns the maximum height that the control will expand to on its own.

:rtype: intr,  hhh	h)]r,  h1X   GetMaxHeight(self)r,  h3h4h5j}  h7j,  ubh#)r,  }r,  (hX7   wx.lib.agw.aui.auibook.ExpandoTextCtrl.GetNumberOfLinesr,  hKh'KhXR   GetNumberOfLines() -> int

Returns the number of lines in the text control buffer.r,  hhh	h)]r,  h1X   GetNumberOfLines(self)r,  h3h4h5X   18r,  h7j,  ubh#)r,  }r,  (hX-   wx.lib.agw.aui.auibook.ExpandoTextCtrl.OnSizer,  hKh'KhX   Handles the ``wx.EVT_SIZE`` event for :class:`ExpandoTextCtrl`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r,  hhh	h)]r,  X   evtr,  hhr,  ah1X   OnSize(self, evt)r,  h3h4h5X   11r,  h7j,  ubh#)r,  }r,  (hX4   wx.lib.agw.aui.auibook.ExpandoTextCtrl.OnTextChangedr,  hKh'KhX   Handles the ``wx.EVT_TEXT`` event for :class:`ExpandoTextCtrl`.

:param `event`: a :class:`CommandEvent` event to be processed.r,  hhh	h)]r,  X   evtr,  hhr,  ah1X   OnTextChanged(self, evt)r,  h3h4h5X   11r,  h7j,  ubh#)r,  }r,  (hX.   wx.lib.agw.aui.auibook.ExpandoTextCtrl.SetFontr,  hKh'KhX0  Sets the font for the :class:`ExpandoTextCtrl`.

:param wx.Font font: font to associate with the :class:`ExpandoTextCtrl`, pass
 ``NullFont`` to reset to the default font.

:rtype: bool
:returns: ``True`` if the font was really changed, ``False`` if it was already
 set to this font and nothing was done.r,  hhh	h)]r,  X   fontr,  hhr,  ah1X   SetFont(self, font)r,  h3h4h5X   18r,  h7j,  ubh#)r,  }r,  (hX3   wx.lib.agw.aui.auibook.ExpandoTextCtrl.SetMaxHeightr,  hKh'KhX   Sets the maximum height that the control will expand to on its
own, and adjusts it down if needed.

:param integer `h`: the maximum control height, in pixels.r,  hhh	h)]r,  j  hhr,  ah1X   SetMaxHeight(self, h)r,  h3h4h5X   12r,  h7j,  ubh#)r -  }r-  (hX0   wx.lib.agw.aui.auibook.ExpandoTextCtrl.WriteTextr-  hKh'KhXd  Writes the text into the text control at the current insertion position.

:param string `text`: text to write to the text control.

.. note::

   Newlines in the text string are the only control characters allowed, and they
   will cause appropriate line breaks. See :meth:`AppendText` for more convenient
   ways of writing to the window. After the write operation, the insertion point
   will be at the end of the inserted text, so subsequent write operations will
   be appended. To append text after the user may have interacted with the control,
   call :meth:`TextCtrl.SetInsertionPointEnd` before writing.r-  hhh	h)]r-  X   textr-  hhr-  ah1X   WriteText(self, text)r-  h3h4h5X   22r-  h7j,  ubehd]r	-  (]r
-  X   objectr-  a]r-  (]r
-  X
   simplewrapperr-  a]r-  (]r-  X   wrapperr-  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  (]r-  X   TextCtrlr-  a]r-  ]r -  X   ExpandoTextCtrlr!-  aaeeeee]r"-  X	   TextEntryr#-  a]r$-  (]r%-  j-  a]r&-  ]r'-  j!-  aae]r(-  j  a]r)-  (]r*-  j  a]r+-  (]r,-  j  a]r--  (]r.-  j  a]r/-  (]r0-  j  a]r1-  (]r2-  j-  a]r3-  ]r4-  j!-  aaeeeeeeeeehk]r5-  X"   wx.lib.agw.aui.auibook.TabTextCtrlr6-  ahm]r7-  X   wx.TextCtrlr8-  ah1X   ExpandoTextCtrl(wx.TextCtrl)r9-  hpNh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.ExpandoTextCtrl.txtr:-  h7jl#  h5X   272r;-  ubh)r<-  }r=-  (hX&   wx.lib.agw.aui.auibook.PyEmbeddedImager>-  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r?-  hhh	h
]r@-  (h#)rA-  }rB-  (hX/   wx.lib.agw.aui.auibook.PyEmbeddedImage.__init__rC-  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.rD-  hhh	h)]rE-  (X   datarF-  hhrG-  X   isBase64rH-  X   TruerI-  h/rJ-  eh1X#   __init__(self, data, isBase64=True)rK-  h3h4h5h6h7j<-  ubh#)rL-  }rM-  (hX0   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetBitmaprN-  hKh'Khhhhh	h)]rO-  h1X   GetBitmap(self)rP-  h3h4h5h=h7j<-  ubh#)rQ-  }rR-  (hX.   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetDatarS-  hKh'Khhhhh	h)]rT-  h1X
   GetData(self)rU-  h3h4h5hCh7j<-  ubh#)rV-  }rW-  (hX.   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetIconrX-  hKh'Khhhhh	h)]rY-  h1X
   GetIcon(self)rZ-  h3h4h5hIh7j<-  ubh#)r[-  }r\-  (hX/   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetImager]-  hKh'Khhhhh	h)]r^-  h1X   GetImage(self)r_-  h3h4h5h6h7j<-  ubhO)r`-  }ra-  (hX-   wx.lib.agw.aui.auibook.PyEmbeddedImage.Bitmaprb-  hKh'Khhhhh	hShThUhhVhh3hWh7j<-  ubhO)rc-  }rd-  (hX+   wx.lib.agw.aui.auibook.PyEmbeddedImage.Datare-  hKh'Khhhhh	hSh[hUhhVhh3hWh7j<-  ubhO)rf-  }rg-  (hX+   wx.lib.agw.aui.auibook.PyEmbeddedImage.Iconrh-  hKh'Khhhhh	hSh_hUhhVhh3hWh7j<-  ubhO)ri-  }rj-  (hX,   wx.lib.agw.aui.auibook.PyEmbeddedImage.Imagerk-  hKh'Khhhhh	hShchUhhVhh3hWh7j<-  ubehd]rl-  (]rm-  X   objectrn-  a]ro-  ]rp-  hjaaehk]rq-  hm]rr-  h1X   PyEmbeddedImage(object)rs-  hpNh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.PyEmbeddedImage.txtrt-  h7jl#  h5X   52ru-  ubh)rv-  }rw-  (hX#   wx.lib.agw.aui.auibook.TabDragImagerx-  hKhX]   This class handles the creation of a custom image in case of drag and drop of a notebook tab.ry-  hhh	h
]rz-  (h#)r{-  }r|-  (hX,   wx.lib.agw.aui.auibook.TabDragImage.__init__r}-  hKh'KhX  Default class constructor.

For internal use: do not call it in your code!

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.r~-  hhh	h)]r-  (X   notebookr-  hhr-  X   pager-  hhr-  X   button_stater-  hhr-  X   tabArtr-  hhr-  eh1X4   __init__(self, notebook, page, button_state, tabArt)r-  h3h4h5X   16r-  h7jv-  ubh#)r-  }r-  (hX0   wx.lib.agw.aui.auibook.TabDragImage.CreateBitmapr-  hKh'KhX  Actually creates the drag and drop bitmap.

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.r-  hhh	h)]r-  (X   notebookr-  hhr-  X   pager-  hhr-  X   button_stater-  hhr-  X   tabArtr-  hhr-  eh1X8   CreateBitmap(self, notebook, page, button_state, tabArt)r-  h3h4h5X   56r-  h7jv-  ubehd]r-  (]r-  X   objectr-  a]r-  (]r-  X
   simplewrapperr-  a]r-  (]r-  X   wrapperr-  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  ]r-  j  aaeeeeehk]r-  hm]r-  X   wx.DragImager-  ah1X   TabDragImage(wx.DragImage)r-  hpNh'Kh3hqhrXV   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabDragImage.txtr-  h7jl#  h5X   78r-  ubh)r-  }r-  (hX   wx.lib.agw.aui.auibook.TabFramer-  hKhX  TabFrame is an interesting case. It's important that all child pages
of the multi-notebook control are all actually children of that control
(and not grandchildren). TabFrame facilitates this. There is one
instance of TabFrame for each tab control inside the multi-notebook.

It's important to know that TabFrame is not a real window, but it merely
used to capture the dimensions/positioning of the internal tab control and
it's managed page windows.r-  hhh	h
]r-  (h#)r-  }r-  (hX(   wx.lib.agw.aui.auibook.TabFrame.__init__r-  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r-  hhh	h)]r-  X   parentr-  hhr-  ah1X   __init__(self, parent)r-  h3h4h5X   16r-  h7j-  ubh#)r-  }r-  (hX/   wx.lib.agw.aui.auibook.TabFrame.DoGetClientSizer-  hKh'KhXL   Returns the window client size.

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  h1X   DoGetClientSize(self)r-  h3h4h5j}  h7j-  ubh#)r-  }r-  (hX)   wx.lib.agw.aui.auibook.TabFrame.DoGetSizer-  hKh'KhXE   Returns the window size.

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  h1X   DoGetSize(self)r-  h3h4h5j}  h7j-  ubh#)r-  }r-  (hX)   wx.lib.agw.aui.auibook.TabFrame.DoSetSizer-  hKh'KhX  Sets the position and size of the window in pixels. The `flags`
parameter indicates the interpretation of the other params if they are
equal to -1.

:param integer `x`: the window `x` position;
:param integer `y`: the window `y` position;
:param integer `width`: the window width;
:param integer `height`: the window height;
:param integer `flags`: may have one of this bit set:

 ===================================  ======================================
 Size Flags                           Description
 ===================================  ======================================
 ``wx.SIZE_AUTO``                     A -1 indicates that a class-specific default should be used.
 ``wx.SIZE_AUTO_WIDTH``               A -1 indicates that a class-specific default should be used for the width.
 ``wx.SIZE_AUTO_HEIGHT``              A -1 indicates that a class-specific default should be used for the height.
 ``wx.SIZE_USE_EXISTING``             Existing dimensions should be used if -1 values are supplied.
 ``wx.SIZE_ALLOW_MINUS_ONE``          Allow dimensions of -1 and less to be interpreted as real dimensions, not default values.
 ``wx.SIZE_FORCE``                    Normally, if the position and the size of the window are already the same as the
                                      parameters of this function, nothing is done. but with this flag a window resize
                                      may be forced even in this case (supported in wx 2.6.2 and later and only implemented
                                      for MSW and ignored elsewhere currently)
 ===================================  ======================================

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  (j  hhr-  j  hhr-  X   widthr-  hhr-  X   heightr-  hhr-  X   flagsr-  X   wx.SIZE_AUTOr-  X   3r-  r-  eh1X8   DoSetSize(self, x, y, width, height, flags=wx.SIZE_AUTO)r-  h3h4h5X   32r-  h7j-  ubh#)r-  }r-  (hX(   wx.lib.agw.aui.auibook.TabFrame.DoSizingr-  hKh'KhX+   Does the actual sizing of the tab control. r-  hhh	h)]r-  h1X   DoSizing(self)r-  h3h4h5X   63r-  h7j-  ubh#)r-  }r-  (hX0   wx.lib.agw.aui.auibook.TabFrame.SetTabCtrlHeightr-  hKh'KhXF   Sets the tab control height.

:param integer `h`: the tab area height.r-  hhh	h)]r-  j  hhr-  ah1X   SetTabCtrlHeight(self, h)r-  h3h4h5j}  h7j-  ubh#)r-  }r-  (hX$   wx.lib.agw.aui.auibook.TabFrame.Showr-  hKh'KhX   Shows/hides the window.

:param bool `show`: ``True`` to show the window, ``False`` otherwise.

:note:

 Overridden from :class:`wx.Control`, this method always returns ``False`` as
 :class:`TabFrame` should never be phisically shown on screen.r-  hhh	h)]r-  X   showr-  X   Truer-  h/r-  ah1X   Show(self, show=True)r-  h3h4h5X   14r-  h7j-  ubh#)r-  }r-  (hX&   wx.lib.agw.aui.auibook.TabFrame.Updater-  hKh'KhX  Calling this method immediately repaints the invalidated area of the window
and all of its children recursively while this would usually only happen when
the flow of control returns to the event loop.

:note: Notice that this function doesn't invalidate any area of the window so
 nothing happens if nothing has been invalidated (i.e. marked as requiring a redraw).
 Use `Refresh` first if you want to immediately redraw the window unconditionally.

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  h1X   Update(self)r-  h3h4h5X   16r-  h7j-  ubehd]r-  (]r-  X   objectr-  a]r-  (]r-  X
   simplewrapperr-  a]r-  (]r-  X   wrapperr .  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r	.  ]r
.  X   TabFramer.  aaeee]r.  j  a]r
.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  ]r.  j.  aaeeeeeeehk]r.  hm]r.  X	   wx.Windowr.  ah1X   TabFrame(wx.Window)r.  hpj  )r.  }r.  (j  ]r.  (X   wx.lib.agw.aui.auibook.TabFramer.  ]r.  X	   wx.Windowr.  ar.  X	   wx.Windowr .  ]r!.  X
   wx.WindowBaser".  ar#.  X
   wx.WindowBaser$.  ]r%.  X
   wx.EvtHandlerr&.  ar'.  X
   wx.EvtHandlerr(.  ]r).  (X	   wx.Objectr*.  X   wx.Trackabler+.  er,.  X	   wx.Objectr-.  ]r..  r/.  X   wx.Trackabler0.  ]r1.  r2.  ej  ]r3.  X   wx.lib.agw.aui.auibook.TabFramer4.  aj  j-  ubh'Kh3hqhrXR   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabFrame.txtr5.  h7jl#  h5X   187r6.  j  ]r7.  (X   __init__r8.  X   DoGetClientSizer9.  X	   DoGetSizer:.  X	   DoSetSizer;.  X   DoSizingr<.  X   SetTabCtrlHeightr=.  X   Showr>.  X   Updater?.  ej  j.  ubh)r@.  }rA.  (hX(   wx.lib.agw.aui.auibook.TabNavigatorPropsrB.  hKhX_   Data storage class for managing and providing access to :class:`TabNavigatorWindow` properties.rC.  hhh	h
]rD.  (h#)rE.  }rF.  (hX1   wx.lib.agw.aui.auibook.TabNavigatorProps.__init__rG.  hKh'KhX   Default class constructor. rH.  hhh	h)]rI.  h1X   __init__(self)rJ.  h3h4h5X   10rK.  h7j@.  ubhO)rL.  }rM.  (hX-   wx.lib.agw.aui.auibook.TabNavigatorProps.FontrN.  hKh'KhXR   Sets/Gets the font for the L{TabNavigatorWindow}, an instance of :class:`wx.Font`.rO.  hhh	hSj'  hUj'  hVhh3hWh7j@.  ubhO)rP.  }rQ.  (hX-   wx.lib.agw.aui.auibook.TabNavigatorProps.IconrR.  hKh'KhXT   Sets/Gets the icon for the L{TabNavigatorWindow}, an instance of :class:`wx.Bitmap`.rS.  hhh	hSj'  hUj'  hVhh3hWh7j@.  ubhO)rT.  }rU.  (hX0   wx.lib.agw.aui.auibook.TabNavigatorProps.MinSizerV.  hKh'KhXZ   Sets/Gets the minimum size for the L{TabNavigatorWindow}, an instance of :class:`wx.Size`.rW.  hhh	hSj'  hUj'  hVhh3hWh7j@.  ubehd]rX.  (]rY.  X   objectrZ.  a]r[.  ]r\.  X   TabNavigatorPropsr].  aaehk]r^.  hm]r_.  h1X   TabNavigatorProps(object)r`.  hpj  )ra.  }rb.  (j  ]rc.  X(   wx.lib.agw.aui.auibook.TabNavigatorPropsrd.  ]re.  rf.  aj  ]rg.  X(   wx.lib.agw.aui.auibook.TabNavigatorPropsrh.  aj  j@.  ubh'Kh3hqhrX[   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabNavigatorProps.txtri.  h7jl#  h5X   26rj.  j  ]rk.  X   __init__rl.  aj  j_.  ubh)rm.  }rn.  (hX)   wx.lib.agw.aui.auibook.TabNavigatorWindowro.  hKhX   This class is used to create a modal dialog that enables "Smart Tabbing",
similar to what you would get by hitting ``Alt`` + ``Tab`` on Windows.rp.  hhh	h
]rq.  (h#)rr.  }rs.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.__init__rt.  hKh'KhX   Default class constructor. Used internally.

:param `parent`: the :class:`TabNavigatorWindow` parent;
:param `props`: the :class:`TabNavigatorProps` object.
:param `centreOnMouse`: popup position of the dialog at mouse cursor. Defaults to Centre.ru.  hhh	h)]rv.  (X   parentrw.  hhrx.  X   propsry.  hhrz.  X
   centreOnMouser{.  X   Falser|.  j*  r}.  eh1X2   __init__(self, parent, props, centreOnMouse=False)r~.  h3h4h5X   87r.  h7jm.  ubh#)r.  }r.  (hX5   wx.lib.agw.aui.auibook.TabNavigatorWindow.CloseDialogr.  hKh'KhXZ   Closes the :class:`TabNavigatorWindow` dialog, setting selection in :class:`AuiNotebook`. r.  hhh	h)]r.  X   returnIdr.  X   wx.ID_OKr.  X   5100r.  r.  ah1X$   CloseDialog(self, returnId=wx.ID_OK)r.  h3h4h5jr  h7jm.  ubh#)r.  }r.  (hX9   wx.lib.agw.aui.auibook.TabNavigatorWindow.GetSelectedPager.  hKh'KhXB   Gets the page index that was selected when the dialog was closed. r.  hhh	h)]r.  h1X   GetSelectedPage(self)r.  h3h4h5hIh7jm.  ubh#)r.  }r.  (hX8   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnItemSelectedr.  hKh'KhX   Handles the ``wx.EVT_LISTBOX_DCLICK`` event for the :class:`ListBox` inside :class:`TabNavigatorWindow`.

:param `event`: a :class:`ListEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnItemSelected(self, event)r.  h3h4h5j}  h7jm.  ubh#)r.  }r.  (hX1   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnKeyUpr.  hKh'KhX~   Handles the ``wx.EVT_KEY_UP`` for the :class:`TabNavigatorWindow`.

:param `event`: a :class:`KeyEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnKeyUp(self, event)r.  h3h4h5X   12r.  h7jm.  ubh#)r.  }r.  (hX4   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnLeftDownr.  hKh'KhXu   Handles the ``wx.EVT_LEFT_DOWN`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnLeftDown(self, event)r.  h3h4h5X   17r.  h7jm.  ubh#)r.  }r.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnLeftUpr.  hKh'KhXs   Handles the ``wx.EVT_LEFT_UP`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnLeftUp(self, event)r.  h3h4h5X   12r.  h7jm.  ubh#)r.  }r.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnMotionr.  hKh'KhXr   Handles the ``wx.EVT_MOTION`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnMotion(self, event)r.  h3h4h5X   12r.  h7jm.  ubh#)r.  }r.  (hX9   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnNavigationKeyr.  hKh'KhX   Handles the ``wx.EVT_NAVIGATION_KEY`` for the :class:`TabNavigatorWindow`.

:param `event`: a :class:`NavigationKeyEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnNavigationKey(self, event)r.  h3h4h5X   29r.  h7jm.  ubh#)r.  }r.  (hX8   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnPanelEraseBgr.  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`TabNavigatorWindow` top panel.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnPanelEraseBg(self, event)r.  h3h4h5X   11r.  h7jm.  ubh#)r.  }r.  (hX6   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnPanelPaintr.  hKh'KhX   Handles the ``wx.EVT_PAINT`` event for :class:`TabNavigatorWindow` top panel.

:param `event`: a :class:`PaintEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnPanelPaint(self, event)r.  h3h4h5X   40r.  h7jm.  ubh#)r.  }r.  (hX=   wx.lib.agw.aui.auibook.TabNavigatorWindow.PopulateListControlr.  hKh'KhXw   Populates the :class:`TabNavigatorWindow` listbox with a list of tabs.

:param `book`: the actual :class:`AuiNotebook`.r.  hhh	h)]r.  X   bookr.  hhr.  ah1X   PopulateListControl(self, book)r.  h3h4h5X   36r.  h7jm.  ubehd]r.  (]r.  X   objectr.  a]r.  (]r.  X
   simplewrapperr.  a]r.  (]r.  X   wrapperr.  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r.  jz  a]r.  (]r.  j}  a]r.  (]r.  j  a]r.  ]r.  X   TabNavigatorWindowr.  aaeeeeee]r.  j  a]r.  (]r.  j  a]r.  (]r.  j  a]r.  (]r /  j  a]r/  (]r/  jz  a]r/  (]r/  j}  a]r/  (]r/  j  a]r/  ]r/  j.  aaeeeeeeeeeehk]r	/  hm]r
/  X	   wx.Dialogr/  ah1X   TabNavigatorWindow(wx.Dialog)r/  hpj  )r
/  }r/  (j  ]r/  (X)   wx.lib.agw.aui.auibook.TabNavigatorWindowr/  ]r/  X	   wx.Dialogr/  ar/  X	   wx.Dialogr/  ]r/  X   wx.TopLevelWindowr/  ar/  X   wx.TopLevelWindowr/  ]r/  X   wx.NonOwnedWindowr/  ar/  X   wx.NonOwnedWindowr/  ]r/  X	   wx.Windowr/  ar/  X	   wx.Windowr /  ]r!/  X
   wx.WindowBaser"/  ar#/  X
   wx.WindowBaser$/  ]r%/  X
   wx.EvtHandlerr&/  ar'/  X
   wx.EvtHandlerr(/  ]r)/  (X	   wx.Objectr*/  X   wx.Trackabler+/  er,/  X	   wx.Objectr-/  ]r./  r//  X   wx.Trackabler0/  ]r1/  r2/  ej  ]r3/  X)   wx.lib.agw.aui.auibook.TabNavigatorWindowr4/  aj  jm.  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabNavigatorWindow.txtr5/  h7jl#  h5X   294r6/  j  ]r7/  (X   __init__r8/  X   CloseDialogr9/  X   GetSelectedPager:/  X   OnItemSelectedr;/  X   OnKeyUpr</  X
   OnLeftDownr=/  X   OnLeftUpr>/  X   OnMotionr?/  X   OnNavigationKeyr@/  X   OnPanelEraseBgrA/  X   OnPanelPaintrB/  X   PopulateListControlrC/  ej  j
/  ubh)rD/  }rE/  (hX"   wx.lib.agw.aui.auibook.TabTextCtrlrF/  hKhX    Control used for in-place edit. rG/  hhh	h
]rH/  (h#)rI/  }rJ/  (hX+   wx.lib.agw.aui.auibook.TabTextCtrl.__init__rK/  hKh'KhX  Default class constructor.
For internal use: do not call it in your code!

:param `owner`: the :class:`AuiNotebook` owning the tab;
:param `tab`: the actual :class:`AuiTabCtrl` tab;
:param integer `page_index`: the :class:`AuiTabContainer` page index for the tab.rL/  hhh	h)]rM/  (X   ownerrN/  hhrO/  X   tabrP/  hhrQ/  X
   page_indexrR/  hhrS/  eh1X&   __init__(self, owner, tab, page_index)rT/  h3h4h5X   65rU/  h7jD/  ubh#)rV/  }rW/  (hX0   wx.lib.agw.aui.auibook.TabTextCtrl.AcceptChangesrX/  hKh'KhX.   Accepts/refuses the changes made by the user. rY/  hhh	h)]rZ/  h1X   AcceptChanges(self)r[/  h3h4h5X   24r\/  h7jD/  ubh#)r]/  }r^/  (hX)   wx.lib.agw.aui.auibook.TabTextCtrl.Finishr_/  hKh'KhX   Finish editing. r`/  hhh	h)]ra/  h1X   Finish(self)rb/  h3h4h5X   11rc/  h7jD/  ubh#)rd/  }re/  (hX'   wx.lib.agw.aui.auibook.TabTextCtrl.itemrf/  hKh'KhX#   Returns the item currently edited. rg/  hhh	h)]rh/  h1X
   item(self)ri/  h3h4h5hIh7jD/  ubh#)rj/  }rk/  (hX)   wx.lib.agw.aui.auibook.TabTextCtrl.OnCharrl/  hKh'KhXw   Handles the ``wx.EVT_CHAR`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.rm/  hhh	h)]rn/  X   eventro/  hhrp/  ah1X   OnChar(self, event)rq/  h3h4h5X   27rr/  h7jD/  ubh#)rs/  }rt/  (hX*   wx.lib.agw.aui.auibook.TabTextCtrl.OnKeyUpru/  hKh'KhXy   Handles the ``wx.EVT_KEY_UP`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.rv/  hhh	h)]rw/  X   eventrx/  hhry/  ah1X   OnKeyUp(self, event)rz/  h3h4h5X   20r{/  h7jD/  ubh#)r|/  }r}/  (hX.   wx.lib.agw.aui.auibook.TabTextCtrl.OnKillFocusr~/  hKh'KhX   Handles the ``wx.EVT_KILL_FOCUS`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.r/  hhh	h)]r/  X   eventr/  hhr/  ah1X   OnKillFocus(self, event)r/  h3h4h5X   19r/  h7jD/  ubh#)r/  }r/  (hX.   wx.lib.agw.aui.auibook.TabTextCtrl.StopEditingr/  hKh'KhX   Suddenly stops the editing. r/  hhh	h)]r/  h1X   StopEditing(self)r/  h3h4h5hCh7jD/  ubehd]r/  (]r/  X   objectr/  a]r/  (]r/  X
   simplewrapperr/  a]r/  (]r/  X   wrapperr/  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j-  a]r/  (]r/  j!-  a]r/  ]r/  X   TabTextCtrlr/  aaeeeeee]r/  j#-  a]r/  (]r/  j-  a]r/  (]r/  j!-  a]r/  ]r/  j/  aaee]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j-  a]r/  (]r/  j!-  a]r/  ]r/  j/  aaeeeeeeeeeehk]r/  hm]r/  X   wx.lib.expando.ExpandoTextCtrlr/  ah1X   TabTextCtrl(ExpandoTextCtrl)r/  hpj  )r/  }r/  (j  ]r/  (X"   wx.lib.agw.aui.auibook.TabTextCtrlr/  ]r/  X   wx.lib.expando.ExpandoTextCtrlr/  ar/  X   wx.lib.expando.ExpandoTextCtrlr/  ]r/  X   wx.TextCtrlr/  ar/  X   wx.TextCtrlr/  ]r/  (X
   wx.Controlr/  X   wx.TextEntryr/  er/  X
   wx.Controlr/  ]r/  X	   wx.Windowr/  ar/  X	   wx.Windowr/  ]r/  X
   wx.WindowBaser/  ar/  X
   wx.WindowBaser/  ]r/  X
   wx.EvtHandlerr/  ar/  X
   wx.EvtHandlerr/  ]r/  (X	   wx.Objectr/  X   wx.Trackabler/  er/  X	   wx.Objectr/  ]r/  r/  X   wx.Trackabler/  ]r/  r/  X   wx.TextEntryr/  ]r/  r/  ej  ]r/  X"   wx.lib.agw.aui.auibook.TabTextCtrlr/  aj  jD/  ubh'Kh3hqhrXU   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabTextCtrl.txtr/  h7jl#  h5X   187r/  j  ]r/  (X   __init__r/  X
   AcceptChangesr/  X   Finishr/  X   itemr/  X   OnCharr/  X   OnKeyUpr/  X   OnKillFocusr/  X   StopEditingr/  ej  j/  ubh#)r/  }r/  (hX"   wx.lib.agw.aui.auibook.LightColourr/  hKh'KhX   Brighten input `colour` by `percent`.

:param wx.Colour `colour`: the colour to be brightened;
:param integer `percent`: brightening percentage.r/  hhh	h)]r/  (X   colourr/  hhr/  X   percentr/  hhr/  eh1X   LightColour(colour, percent)r/  h3h4h5X   24r 0  j
  X   232r0  h7jl#  ubh#)r0  }r0  (hX)   wx.lib.agw.aui.auibook.MakeDisabledBitmapr0  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.r0  hhh	h)]r0  X   bitmapr0  hhr0  ah1X   MakeDisabledBitmap(bitmap)r	0  h3h4h5j}  j
  X   210r
0  h7jl#  ubh#)r0  }r0  (hX(   wx.lib.agw.aui.auibook.RescaleScreenShotr
0  hKh'KhX   Rescales a bitmap to be `thumbnail_size` pixels wide (or tall) at maximum.

:param wx.Bitmap `bmp`: the bitmap to rescale;
:param integer `thumbnail_size`: the maximum size of every page thumbnail.r0  hhh	h)]r0  (X   bmpr0  hhr0  X   thumbnail_sizer0  X   200r0  X   200r0  r0  eh1X*   RescaleScreenShot(bmp, thumbnail_size=200)r0  h3h4h5X   49r0  j
  X   561r0  h7jl#  ubh#)r0  }r0  (hX%   wx.lib.agw.aui.auibook.TakeScreenShotr0  hKh'KhX   Takes a screenshot of the screen at given position and size (`rect`).

:param wx.Rect `rect`: the screen rectangle for which we want to take a screenshot.r0  hhh	h)]r0  X   rectr0  hhr0  ah1X   TakeScreenShot(rect)r 0  h3h4h5X   39r!0  j
  X   521r"0  h7jl#  ubhu)r#0  }r$0  (hX!   wx.lib.agw.aui.auibook.__author__r%0  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r&0  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'r'0  h|X   strr(0  h3h~h7jl#  ubhu)r)0  }r*0  (hX   wx.lib.agw.aui.auibook.__date__r+0  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r,0  hhh	hzX   '31 March 2009'r-0  h|X   strr.0  h3h~h7jl#  ubhu)r/0  }r00  (hX(   wx.lib.agw.aui.auibook.actionClickButtonr10  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r20  hhh	hzX   2r30  h|X   intr40  h3h~h7jl#  ubhu)r50  }r60  (hX)   wx.lib.agw.aui.auibook.actionClickCaptionr70  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r80  hhh	hzX   3r90  h|X   intr:0  h3h~h7jl#  ubhu)r;0  }r<0  (hX-   wx.lib.agw.aui.auibook.actionDragFloatingPaner=0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r>0  hhh	hzX   5r?0  h|X   intr@0  h3h~h7jl#  ubhu)rA0  }rB0  (hX,   wx.lib.agw.aui.auibook.actionDragMovablePanerC0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rD0  hhh	hzX   6rE0  h|X   intrF0  h3h~h7jl#  ubhu)rG0  }rH0  (hX,   wx.lib.agw.aui.auibook.actionDragToolbarPanerI0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rJ0  hhh	hzX   4rK0  h|X   intrL0  h3h~h7jl#  ubhu)rM0  }rN0  (hX!   wx.lib.agw.aui.auibook.actionNonerO0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rP0  hhh	hzX   0rQ0  h|X   intrR0  h3h~h7jl#  ubhu)rS0  }rT0  (hX#   wx.lib.agw.aui.auibook.actionResizerU0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rV0  hhh	hzX   1rW0  h|X   intrX0  h3h~h7jl#  ubhu)rY0  }rZ0  (hX"   wx.lib.agw.aui.auibook.aero_deniedr[0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r\0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5490>r]0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager^0  h3h~h7jl#  ubhu)r_0  }r`0  (hX%   wx.lib.agw.aui.auibook.aero_dock_panera0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rb0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9ed0>rc0  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerd0  h3h~h7jl#  ubhu)re0  }rf0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_bottomrg0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rh0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f50>ri0  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerj0  h3h~h7jl#  ubhu)rk0  }rl0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_centerrm0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rn0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f90>ro0  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerp0  h3h~h7jl#  ubhu)rq0  }rr0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_deniedrs0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rt0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9f10>ru0  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerv0  h3h~h7jl#  ubhu)rw0  }rx0  (hX*   wx.lib.agw.aui.auibook.aero_dock_pane_leftry0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rz0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd9fd0>r{0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager|0  h3h~h7jl#  ubhu)r}0  }r~0  (hX+   wx.lib.agw.aui.auibook.aero_dock_pane_rightr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5050>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX)   wx.lib.agw.aui.auibook.aero_dock_pane_topr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5090>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX    wx.lib.agw.aui.auibook.aero_downr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd50d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX&   wx.lib.agw.aui.auibook.aero_down_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX-   wx.lib.agw.aui.auibook.aero_down_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5110>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_down_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5150>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX    wx.lib.agw.aui.auibook.aero_leftr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5190>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX&   wx.lib.agw.aui.auibook.aero_left_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX-   wx.lib.agw.aui.auibook.aero_left_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd51d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_left_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5210>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX!   wx.lib.agw.aui.auibook.aero_rightr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5250>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_right_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX.   wx.lib.agw.aui.auibook.aero_right_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5290>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX(   wx.lib.agw.aui.auibook.aero_right_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd52d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX   wx.lib.agw.aui.auibook.aero_tabr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5310>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX%   wx.lib.agw.aui.auibook.aero_tab_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX,   wx.lib.agw.aui.auibook.aero_tab_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5350>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX&   wx.lib.agw.aui.auibook.aero_tab_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5390>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX   wx.lib.agw.aui.auibook.aero_upr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd53d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX$   wx.lib.agw.aui.auibook.aero_up_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX+   wx.lib.agw.aui.auibook.aero_up_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5410>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7jl#  ubhu)r0  }r0  (hX%   wx.lib.agw.aui.auibook.aero_up_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f20f7bd5450>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager 1  h3h~h7jl#  ubhu)r1  }r1  (hX%   wx.lib.agw.aui.auibook.aeroguideSizeXr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   31r1  h|X   intr1  h3h~h7jl#  ubhu)r1  }r1  (hX%   wx.lib.agw.aui.auibook.aeroguideSizeYr	1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
1  hhh	hzX   32r1  h|X   intr1  h3h~h7jl#  ubhu)r
1  }r1  (hX'   wx.lib.agw.aui.auibook.AUI_BUTTON_CLOSEr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   101r1  h|X   intr1  h3h~h7jl#  ubhu)r1  }r1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM1r1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   201r1  h|X   intr1  h3h~h7jl#  ubhu)r1  }r1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM2r1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   202r1  h|X   intr1  h3h~h7jl#  ubhu)r1  }r 1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM3r!1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"1  hhh	hzX   203r#1  h|X   intr$1  h3h~h7jl#  ubhu)r%1  }r&1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM4r'1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r(1  hhh	hzX   204r)1  h|X   intr*1  h3h~h7jl#  ubhu)r+1  }r,1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM5r-1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r.1  hhh	hzX   205r/1  h|X   intr01  h3h~h7jl#  ubhu)r11  }r21  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM6r31  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r41  hhh	hzX   206r51  h|X   intr61  h3h~h7jl#  ubhu)r71  }r81  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM7r91  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r:1  hhh	hzX   207r;1  h|X   intr<1  h3h~h7jl#  ubhu)r=1  }r>1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM8r?1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r@1  hhh	hzX   208rA1  h|X   intrB1  h3h~h7jl#  ubhu)rC1  }rD1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM9rE1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rF1  hhh	hzX   209rG1  h|X   intrH1  h3h~h7jl#  ubhu)rI1  }rJ1  (hX&   wx.lib.agw.aui.auibook.AUI_BUTTON_DOWNrK1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rL1  hhh	hzX   110rM1  h|X   intrN1  h3h~h7jl#  ubhu)rO1  }rP1  (hX&   wx.lib.agw.aui.auibook.AUI_BUTTON_LEFTrQ1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rR1  hhh	hzX   107rS1  h|X   intrT1  h3h~h7jl#  ubhu)rU1  }rV1  (hX2   wx.lib.agw.aui.auibook.AUI_BUTTON_MAXIMIZE_RESTORErW1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rX1  hhh	hzX   102rY1  h|X   intrZ1  h3h~h7jl#  ubhu)r[1  }r\1  (hX*   wx.lib.agw.aui.auibook.AUI_BUTTON_MINIMIZEr]1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r^1  hhh	hzX   103r_1  h|X   intr`1  h3h~h7jl#  ubhu)ra1  }rb1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_OPTIONSrc1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rd1  hhh	hzX   105re1  h|X   intrf1  h3h~h7jl#  ubhu)rg1  }rh1  (hX%   wx.lib.agw.aui.auibook.AUI_BUTTON_PINri1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rj1  hhh	hzX   104rk1  h|X   intrl1  h3h~h7jl#  ubhu)rm1  }rn1  (hX'   wx.lib.agw.aui.auibook.AUI_BUTTON_RIGHTro1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rp1  hhh	hzX   108rq1  h|X   intrr1  h3h~h7jl#  ubhu)rs1  }rt1  (hX/   wx.lib.agw.aui.auibook.AUI_BUTTON_STATE_CHECKEDru1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rv1  hhh	hzX   32rw1  h|X   intrx1  h3h~h7jl#  ubhu)ry1  }rz1  (hX0   wx.lib.agw.aui.auibook.AUI_BUTTON_STATE_DISABLEDr{1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r|1  hhh	hzX   8r}1  h|X   intr~1  h3h~h7jl#  ubhu)r1  }r1  (hX.   wx.lib.agw.aui.auibook.AUI_BUTTON_STATE_HIDDENr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if n