/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/font.h>

        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxFontInfo_Family, "Family(family) -> FontInfo\n"
"\n"
"Set the font family.");

extern "C" {static PyObject *meth_wxFontInfo_Family(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Family(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFontFamily family;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_family,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFontInfo, &sipCpp, sipType_wxFontFamily, &family))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Family(family);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Family, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_FaceName, "FaceName(faceName) -> FontInfo\n"
"\n"
"Set the font face name to use.");

extern "C" {static PyObject *meth_wxFontInfo_FaceName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_FaceName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* faceName;
        int faceNameState = 0;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_faceName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFontInfo, &sipCpp, sipType_wxString,&faceName, &faceNameState))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->FaceName(*faceName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(faceName),sipType_wxString,faceNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_FaceName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Weight, "Weight(weight) -> FontInfo\n"
"\n"
"Specify the weight of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Weight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Weight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int weight;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_weight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxFontInfo, &sipCpp, &weight))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Weight(weight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Weight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Bold, "Bold(bold=True) -> FontInfo\n"
"\n"
"Use a bold version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Bold(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Bold(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool bold = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bold,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &bold))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Bold(bold);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Bold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Light, "Light(light=True) -> FontInfo\n"
"\n"
"Use a lighter version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Light(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Light(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool light = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_light,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &light))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Light(light);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Light, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Italic, "Italic(italic=True) -> FontInfo\n"
"\n"
"Use an italic version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Italic(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Italic(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool italic = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_italic,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &italic))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Italic(italic);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Italic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Slant, "Slant(slant=True) -> FontInfo\n"
"\n"
"Use a slanted version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Slant(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Slant(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool slant = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_slant,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &slant))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Slant(slant);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Slant, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Style, "Style(style) -> FontInfo\n"
"\n"
"Specify the style of the font using one of wxFontStyle constants.");

extern "C" {static PyObject *meth_wxFontInfo_Style(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Style(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFontStyle style;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFontInfo, &sipCpp, sipType_wxFontStyle, &style))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Style(style);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Style, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_AntiAliased, "AntiAliased(antiAliased=True) -> FontInfo\n"
"\n"
"Set anti-aliasing flag.");

extern "C" {static PyObject *meth_wxFontInfo_AntiAliased(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_AntiAliased(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool antiAliased = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_antiAliased,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &antiAliased))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->AntiAliased(antiAliased);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_AntiAliased, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Underlined, "Underlined(underlined=True) -> FontInfo\n"
"\n"
"Use an underlined version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Underlined(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Underlined(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool underlined = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_underlined,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &underlined))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Underlined(underlined);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Underlined, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Strikethrough, "Strikethrough(strikethrough=True) -> FontInfo\n"
"\n"
"Use a strike-through version of the font.");

extern "C" {static PyObject *meth_wxFontInfo_Strikethrough(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Strikethrough(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool strikethrough = 1;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strikethrough,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxFontInfo, &sipCpp, &strikethrough))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Strikethrough(strikethrough);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Strikethrough, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_Encoding, "Encoding(encoding) -> FontInfo\n"
"\n"
"Set the font encoding to use.");

extern "C" {static PyObject *meth_wxFontInfo_Encoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_Encoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFontEncoding encoding;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxFontInfo, &sipCpp, sipType_wxFontEncoding, &encoding))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Encoding(encoding);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_Encoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_AllFlags, "AllFlags(flags) -> FontInfo\n"
"\n"
"Set all the font attributes at once.");

extern "C" {static PyObject *meth_wxFontInfo_AllFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_AllFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxFontInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxFontInfo, &sipCpp, &flags))
        {
             ::wxFontInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->AllFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxFontInfo,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_AllFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontInfo_GetWeightClosestToNumericValue, "GetWeightClosestToNumericValue(numWeight) -> FontWeight\n"
"\n"
"Get the symbolic weight closest to the given raw weight value.");

extern "C" {static PyObject *meth_wxFontInfo_GetWeightClosestToNumericValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontInfo_GetWeightClosestToNumericValue(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int numWeight;

        static const char *sipKwdList[] = {
            sipName_numWeight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &numWeight))
        {
             ::wxFontWeight sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxFontInfo::GetWeightClosestToNumericValue(numWeight);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxFontWeight);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_FontInfo, sipName_GetWeightClosestToNumericValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFontInfo(void *, int);}
static void release_wxFontInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxFontInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxFontInfo(void *, SIP_SSIZE_T, void *);}
static void assign_wxFontInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxFontInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxFontInfo *>(sipSrc);
}


extern "C" {static void *array_wxFontInfo(SIP_SSIZE_T);}
static void *array_wxFontInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxFontInfo[sipNrElem];
}


extern "C" {static void *copy_wxFontInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxFontInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxFontInfo(reinterpret_cast<const  ::wxFontInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFontInfo(sipSimpleWrapper *);}
static void dealloc_wxFontInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFontInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFontInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFontInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxFontInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        float pointSize;

        static const char *sipKwdList[] = {
            sipName_pointSize,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "f", &pointSize))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontInfo(pointSize);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSize* pixelSize;
        int pixelSizeState = 0;

        static const char *sipKwdList[] = {
            sipName_pixelSize,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxSize, &pixelSize, &pixelSizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontInfo(*pixelSize);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(pixelSize),sipType_wxSize,pixelSizeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxFontInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxFontInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxFontInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxFontInfo[] = {
    {SIP_MLNAME_CAST(sipName_AllFlags), SIP_MLMETH_CAST(meth_wxFontInfo_AllFlags), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_AllFlags)},
    {SIP_MLNAME_CAST(sipName_AntiAliased), SIP_MLMETH_CAST(meth_wxFontInfo_AntiAliased), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_AntiAliased)},
    {SIP_MLNAME_CAST(sipName_Bold), SIP_MLMETH_CAST(meth_wxFontInfo_Bold), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Bold)},
    {SIP_MLNAME_CAST(sipName_Encoding), SIP_MLMETH_CAST(meth_wxFontInfo_Encoding), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Encoding)},
    {SIP_MLNAME_CAST(sipName_FaceName), SIP_MLMETH_CAST(meth_wxFontInfo_FaceName), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_FaceName)},
    {SIP_MLNAME_CAST(sipName_Family), SIP_MLMETH_CAST(meth_wxFontInfo_Family), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Family)},
    {SIP_MLNAME_CAST(sipName_GetWeightClosestToNumericValue), SIP_MLMETH_CAST(meth_wxFontInfo_GetWeightClosestToNumericValue), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_GetWeightClosestToNumericValue)},
    {SIP_MLNAME_CAST(sipName_Italic), SIP_MLMETH_CAST(meth_wxFontInfo_Italic), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Italic)},
    {SIP_MLNAME_CAST(sipName_Light), SIP_MLMETH_CAST(meth_wxFontInfo_Light), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Light)},
    {SIP_MLNAME_CAST(sipName_Slant), SIP_MLMETH_CAST(meth_wxFontInfo_Slant), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Slant)},
    {SIP_MLNAME_CAST(sipName_Strikethrough), SIP_MLMETH_CAST(meth_wxFontInfo_Strikethrough), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Strikethrough)},
    {SIP_MLNAME_CAST(sipName_Style), SIP_MLMETH_CAST(meth_wxFontInfo_Style), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Style)},
    {SIP_MLNAME_CAST(sipName_Underlined), SIP_MLMETH_CAST(meth_wxFontInfo_Underlined), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Underlined)},
    {SIP_MLNAME_CAST(sipName_Weight), SIP_MLMETH_CAST(meth_wxFontInfo_Weight), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxFontInfo_Weight)}
};

PyDoc_STRVAR(doc_wxFontInfo, "FontInfo()\n"
"FontInfo(pointSize)\n"
"FontInfo(pixelSize)\n"
"\n"
"This class is a helper used for wxFont creation using named parameter\n"
"idiom: it allows specifying various wxFont attributes using the\n"
"chained calls to its clearly named methods instead of passing them in\n"
"the fixed order to wxFont constructors.");


sipClassTypeDef sipTypeDef__core_wxFontInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxFontInfo,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_FontInfo,
        {0, 0, 1},
        14, methods_wxFontInfo,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxFontInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxFontInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxFontInfo,
    assign_wxFontInfo,
    array_wxFontInfo,
    copy_wxFontInfo,
    release_wxFontInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
