/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/position.h>

        #include <wx/gdicmn.h>
    PyObject* _wxPosition_Get(wxPosition* self)
    {
        wxPyThreadBlocker blocker;
        return sipBuildResult(0, "(ii)", self->GetRow(), self->GetCol());
    }


PyDoc_STRVAR(doc_wxPosition_GetCol, "GetCol() -> int\n"
"\n"
"A synonym for GetColumn().");

extern "C" {static PyObject *meth_wxPosition_GetCol(PyObject *, PyObject *);}
static PyObject *meth_wxPosition_GetCol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPosition, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCol();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_GetCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_GetColumn, "GetColumn() -> int\n"
"\n"
"Get the current row value.");

extern "C" {static PyObject *meth_wxPosition_GetColumn(PyObject *, PyObject *);}
static PyObject *meth_wxPosition_GetColumn(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPosition, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumn();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_GetColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_GetRow, "GetRow() -> int\n"
"\n"
"Get the current row value.");

extern "C" {static PyObject *meth_wxPosition_GetRow(PyObject *, PyObject *);}
static PyObject *meth_wxPosition_GetRow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPosition, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_GetRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_SetCol, "SetCol(column)\n"
"\n"
"A synonym for SetColumn().");

extern "C" {static PyObject *meth_wxPosition_SetCol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPosition_SetCol(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int column;
         ::wxPosition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPosition, &sipCpp, &column))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCol(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_SetCol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_SetColumn, "SetColumn(column)\n"
"\n"
"Set a new column value.");

extern "C" {static PyObject *meth_wxPosition_SetColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPosition_SetColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int column;
         ::wxPosition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPosition, &sipCpp, &column))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColumn(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_SetColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_SetRow, "SetRow(row)\n"
"\n"
"Set a new row value.");

extern "C" {static PyObject *meth_wxPosition_SetRow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPosition_SetRow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int row;
         ::wxPosition *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPosition, &sipCpp, &row))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRow(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_SetRow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPosition_Get, "Get() -> (row,col)\n"
"\n"
"Return the row and col properties as a tuple.");

extern "C" {static PyObject *meth_wxPosition_Get(PyObject *, PyObject *);}
static PyObject *meth_wxPosition_Get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPosition *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPosition, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxPosition_Get(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Position, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxPosition___sub__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPosition* a0;
        int a0State = 0;
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxPosition, &a0, &a0State, sipType_wxPosition, &pos, &posState))
        {
             ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPosition((*a0 - *pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxPosition,a0State);
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPosition,SIP_NULLPTR);
        }
    }

    {
         ::wxPosition* a0;
        int a0State = 0;
        const  ::wxSize* size;
        int sizeState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxPosition, &a0, &a0State, sipType_wxSize, &size, &sizeState))
        {
             ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPosition((*a0 - *size));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxPosition,a0State);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPosition,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxPosition___add__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPosition* a0;
        int a0State = 0;
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxPosition, &a0, &a0State, sipType_wxPosition, &pos, &posState))
        {
             ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPosition((*a0 + *pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxPosition,a0State);
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPosition,SIP_NULLPTR);
        }
    }

    {
         ::wxPosition* a0;
        int a0State = 0;
        const  ::wxSize* size;
        int sizeState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxPosition, &a0, &a0State, sipType_wxSize, &size, &sizeState))
        {
             ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPosition((*a0 + *size));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_wxPosition,a0State);
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPosition,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxPosition___isub__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxPosition)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxPosition *sipCpp = reinterpret_cast< ::wxPosition *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPosition));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxPosition, &pos, &posState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxPosition::operator-=(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxPosition::operator-=(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxPosition___iadd__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_wxPosition)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::wxPosition *sipCpp = reinterpret_cast< ::wxPosition *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPosition));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxPosition, &pos, &posState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxPosition::operator+=(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::wxSize* size;
        int sizeState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp-> ::wxPosition::operator+=(*size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size),sipType_wxSize,sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_wxPosition___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPosition *sipCpp = reinterpret_cast< ::wxPosition *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPosition));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPosition::operator!=(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxPosition, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxPosition___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxPosition___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPosition *sipCpp = reinterpret_cast< ::wxPosition *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPosition));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPosition* pos;
        int posState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPosition::operator==(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPosition *>(pos),sipType_wxPosition,posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxPosition, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPosition(void *, int);}
static void release_wxPosition(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPosition *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxPosition(void *, SIP_SSIZE_T, void *);}
static void assign_wxPosition(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPosition *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPosition *>(sipSrc);
}


extern "C" {static void *array_wxPosition(SIP_SSIZE_T);}
static void *array_wxPosition(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxPosition[sipNrElem];
}


extern "C" {static void *copy_wxPosition(const void *, SIP_SSIZE_T);}
static void *copy_wxPosition(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxPosition(reinterpret_cast<const  ::wxPosition *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPosition(sipSimpleWrapper *);}
static void dealloc_wxPosition(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPosition(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPosition(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPosition(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPosition *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int row;
        int col;

        static const char *sipKwdList[] = {
            sipName_row,
            sipName_col,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii", &row, &col))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPosition(row,col);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPosition* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_wxPosition, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPosition(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPosition *>(a0),sipType_wxPosition,a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_wxPosition(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxPosition(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::wxPosition **sipCppPtr = reinterpret_cast< ::wxPosition **>(sipCppPtrV);

        // is it just a typecheck?
        if (!sipIsErr) {
            // is it already an instance of wxPosition?
            if (sipCanConvertToType(sipPy, sipType_wxPosition, SIP_NO_CONVERTORS))
                return 1;
        
            if (wxPyNumberSequenceCheck(sipPy, 2)) {
                return 1;
            }
            return 0;
        }
        
         // otherwise do the conversion
         if (sipCanConvertToType(sipPy, sipType_wxPosition, SIP_NO_CONVERTORS)) {
             // Just fetch the existing instance
             *sipCppPtr = reinterpret_cast<wxPosition*>(sipConvertToType(
                     sipPy, sipType_wxPosition, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
             return 0;  // not a new instance
         }
        
         // or create a new instance
         PyObject* o1 = PySequence_ITEM(sipPy, 0);
         PyObject* o2 = PySequence_ITEM(sipPy, 1);
         *sipCppPtr = new wxPosition(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2));
         Py_DECREF(o1);
         Py_DECREF(o2);
         return SIP_TEMPORARY;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxPosition[] = {
    {(void *)slot_wxPosition___sub__, sub_slot},
    {(void *)slot_wxPosition___add__, add_slot},
    {(void *)slot_wxPosition___isub__, isub_slot},
    {(void *)slot_wxPosition___iadd__, iadd_slot},
    {(void *)slot_wxPosition___ne__, ne_slot},
    {(void *)slot_wxPosition___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxPosition[] = {
    {SIP_MLNAME_CAST(sipName_Get), meth_wxPosition_Get, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPosition_Get)},
    {SIP_MLNAME_CAST(sipName_GetCol), meth_wxPosition_GetCol, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPosition_GetCol)},
    {SIP_MLNAME_CAST(sipName_GetColumn), meth_wxPosition_GetColumn, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPosition_GetColumn)},
    {SIP_MLNAME_CAST(sipName_GetRow), meth_wxPosition_GetRow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxPosition_GetRow)},
    {SIP_MLNAME_CAST(sipName_SetCol), SIP_MLMETH_CAST(meth_wxPosition_SetCol), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPosition_SetCol)},
    {SIP_MLNAME_CAST(sipName_SetColumn), SIP_MLMETH_CAST(meth_wxPosition_SetColumn), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPosition_SetColumn)},
    {SIP_MLNAME_CAST(sipName_SetRow), SIP_MLMETH_CAST(meth_wxPosition_SetRow), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxPosition_SetRow)}
};

sipVariableDef variables_wxPosition[] = {
    {PropertyVariable, sipName_Row, &methods_wxPosition[3], &methods_wxPosition[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Column, &methods_wxPosition[2], &methods_wxPosition[5], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Col, &methods_wxPosition[1], &methods_wxPosition[4], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPosition, "Position()\n"
"Position(row, col)\n"
"\n"
"This class represents the position of an item in any kind of grid of\n"
"rows and columns such as wxGridBagSizer, or wxHVScrolledWindow.");


sipClassTypeDef sipTypeDef__core_wxPosition = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxPosition,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Position,
        {0, 0, 1},
        7, methods_wxPosition,
        0, SIP_NULLPTR,
        3, variables_wxPosition,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPosition,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxPosition,
    init_type_wxPosition,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxPosition,
    assign_wxPosition,
    array_wxPosition,
    copy_wxPosition,
    release_wxPosition,
    SIP_NULLPTR,
    convertTo_wxPosition,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
