/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_dataview.h"

        #include <wx/dataview.h>

        #include <wx/dataview.h>
        #include <wx/window.h>
        #include <wx/dataview.h>
        #include <wx/gdicmn.h>
        #include <wx/dataview.h>
        #include <wx/dataview.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxDataViewRenderer_EnableEllipsize, "EnableEllipsize(mode=wx.ELLIPSIZE_MIDDLE)\n"
"\n"
"Enable or disable replacing parts of the item text with ellipsis to\n"
"make it fit the column width.");

extern "C" {static PyObject *meth_wxDataViewRenderer_EnableEllipsize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_EnableEllipsize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxEllipsizeMode mode = wxELLIPSIZE_MIDDLE;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxEllipsizeMode, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableEllipsize(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_EnableEllipsize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_DisableEllipsize, "DisableEllipsize()\n"
"\n"
"Disable replacing parts of the item text with ellipsis.");

extern "C" {static PyObject *meth_wxDataViewRenderer_DisableEllipsize(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_DisableEllipsize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DisableEllipsize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_DisableEllipsize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetAlignment, "GetAlignment() -> int\n"
"\n"
"Returns the alignment.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetAlignment(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetAlignment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::GetAlignment() : sipCpp->GetAlignment());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetAlignment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetEllipsizeMode, "GetEllipsizeMode() -> EllipsizeMode\n"
"\n"
"Returns the ellipsize mode used by the renderer.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetEllipsizeMode(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetEllipsizeMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
             ::wxEllipsizeMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEllipsizeMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxEllipsizeMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetEllipsizeMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetMode, "GetMode() -> DataViewCellMode\n"
"\n"
"Returns the cell mode.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetMode(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
             ::wxDataViewCellMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::GetMode() : sipCpp->GetMode());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxDataViewCellMode);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetOwner, "GetOwner() -> DataViewColumn\n"
"\n"
"Returns pointer to the owning wxDataViewColumn.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetOwner(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetOwner(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
             ::wxDataViewColumn*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOwner();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxDataViewColumn,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetOwner, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetValue, "GetValue() -> value\n"
"\n"
"This methods retrieves the value from the renderer in order to\n"
"transfer the value back to the data model.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxDVCVariant* value;
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            value = new  ::wxDVCVariant();

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewRenderer, sipName_GetValue);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetValue(*value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(value,sipType_wxDVCVariant,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetVariantType, "GetVariantType() -> String\n"
"\n"
"Returns a string with the type of the wxVariant supported by this\n"
"renderer.");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetVariantType(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetVariantType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetVariantType());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetVariantType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_SetAlignment, "SetAlignment(align)\n"
"\n"
"Sets the alignment of the renderer's content.");

extern "C" {static PyObject *meth_wxDataViewRenderer_SetAlignment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_SetAlignment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int align;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_align,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, &align))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::SetAlignment(align) : sipCpp->SetAlignment(align));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_SetAlignment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_SetOwner, "SetOwner(owner)\n"
"\n"
"Sets the owning wxDataViewColumn.");

extern "C" {static PyObject *meth_wxDataViewRenderer_SetOwner(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_SetOwner(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewColumn* owner;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_owner,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxDataViewColumn, &owner))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOwner(owner);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_SetOwner, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_SetValue, "SetValue(value) -> bool\n"
"\n"
"Set the value of the renderer (and thus its cell) to value.");

extern "C" {static PyObject *meth_wxDataViewRenderer_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxDVCVariant* value;
        int valueState = 0;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxDVCVariant,&value, &valueState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_DataViewRenderer, sipName_SetValue);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetValue(*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxDVCVariant *>(value),sipType_wxDVCVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_SetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_SetValueAdjuster, "SetValueAdjuster(transformer)\n"
"\n"
"Set the transformer object to be used to customize values before they\n"
"are rendered.");

extern "C" {static PyObject *meth_wxDataViewRenderer_SetValueAdjuster(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_SetValueAdjuster(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewValueAdjuster* transformer;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_transformer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxDataViewValueAdjuster, &transformer))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValueAdjuster(transformer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_SetValueAdjuster, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_Validate, "Validate(value) -> bool\n"
"\n"
"Before data is committed to the data model, it is passed to this\n"
"method where it can be checked for validity.");

extern "C" {static PyObject *meth_wxDataViewRenderer_Validate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_Validate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDVCVariant* value;
        int valueState = 0;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxDVCVariant,&value, &valueState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::Validate(*value) : sipCpp->Validate(*value));
            Py_END_ALLOW_THREADS
            sipReleaseType(value,sipType_wxDVCVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_Validate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_HasEditorCtrl, "HasEditorCtrl() -> bool");

extern "C" {static PyObject *meth_wxDataViewRenderer_HasEditorCtrl(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_HasEditorCtrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::HasEditorCtrl() : sipCpp->HasEditorCtrl());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_HasEditorCtrl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_CreateEditorCtrl, "CreateEditorCtrl(parent, labelRect, value) -> wx.Window");

extern "C" {static PyObject *meth_wxDataViewRenderer_CreateEditorCtrl(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_CreateEditorCtrl(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindow* parent;
         ::wxRect* labelRect;
        int labelRectState = 0;
        const  ::wxDVCVariant* value;
        int valueState = 0;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_labelRect,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1J1", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxWindow, &parent, sipType_wxRect, &labelRect, &labelRectState, sipType_wxDVCVariant,&value, &valueState))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::CreateEditorCtrl(parent,*labelRect,*value) : sipCpp->CreateEditorCtrl(parent,*labelRect,*value));
            Py_END_ALLOW_THREADS
            sipReleaseType(labelRect,sipType_wxRect,labelRectState);
            sipReleaseType(const_cast< ::wxDVCVariant *>(value),sipType_wxDVCVariant,valueState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_CreateEditorCtrl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetValueFromEditorCtrl, "GetValueFromEditorCtrl(editor) -> value");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetValueFromEditorCtrl(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetValueFromEditorCtrl(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxWindow* editor;
         ::wxDVCVariant* value;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_editor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxWindow, &editor))
        {
            value = new  ::wxDVCVariant();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::GetValueFromEditorCtrl(editor,*value) : sipCpp->GetValueFromEditorCtrl(editor,*value));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(value,sipType_wxDVCVariant,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetValueFromEditorCtrl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_StartEditing, "StartEditing(item, labelRect) -> bool");

extern "C" {static PyObject *meth_wxDataViewRenderer_StartEditing(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_StartEditing(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxDataViewItem* item;
         ::wxRect* labelRect;
        int labelRectState = 0;
         ::wxDataViewRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_item,
            sipName_labelRect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxDataViewRenderer, &sipCpp, sipType_wxDataViewItem, &item, sipType_wxRect, &labelRect, &labelRectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::StartEditing(*item,*labelRect) : sipCpp->StartEditing(*item,*labelRect));
            Py_END_ALLOW_THREADS
            sipReleaseType(labelRect,sipType_wxRect,labelRectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_StartEditing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_CancelEditing, "CancelEditing()");

extern "C" {static PyObject *meth_wxDataViewRenderer_CancelEditing(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_CancelEditing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::CancelEditing() : sipCpp->CancelEditing());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_CancelEditing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_FinishEditing, "FinishEditing() -> bool");

extern "C" {static PyObject *meth_wxDataViewRenderer_FinishEditing(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_FinishEditing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxDataViewRenderer::FinishEditing() : sipCpp->FinishEditing());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_FinishEditing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDataViewRenderer_GetEditorCtrl, "GetEditorCtrl() -> wx.Window");

extern "C" {static PyObject *meth_wxDataViewRenderer_GetEditorCtrl(PyObject *, PyObject *);}
static PyObject *meth_wxDataViewRenderer_GetEditorCtrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxDataViewRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDataViewRenderer, &sipCpp))
        {
             ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEditorCtrl();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_DataViewRenderer, sipName_GetEditorCtrl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxDataViewRenderer(void *, const sipTypeDef *);}
static void *cast_wxDataViewRenderer(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxDataViewRenderer *sipCpp = reinterpret_cast< ::wxDataViewRenderer *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDataViewRenderer(void *, int);}
static void release_wxDataViewRenderer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDataViewRenderer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDataViewRenderer(sipSimpleWrapper *);}
static void dealloc_wxDataViewRenderer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDataViewRenderer(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxDataViewRenderer[] = {{25, 0, 1}};


static PyMethodDef methods_wxDataViewRenderer[] = {
    {SIP_MLNAME_CAST(sipName_CancelEditing), meth_wxDataViewRenderer_CancelEditing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_CancelEditing)},
    {SIP_MLNAME_CAST(sipName_CreateEditorCtrl), SIP_MLMETH_CAST(meth_wxDataViewRenderer_CreateEditorCtrl), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_CreateEditorCtrl)},
    {SIP_MLNAME_CAST(sipName_DisableEllipsize), meth_wxDataViewRenderer_DisableEllipsize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_DisableEllipsize)},
    {SIP_MLNAME_CAST(sipName_EnableEllipsize), SIP_MLMETH_CAST(meth_wxDataViewRenderer_EnableEllipsize), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_EnableEllipsize)},
    {SIP_MLNAME_CAST(sipName_FinishEditing), meth_wxDataViewRenderer_FinishEditing, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_FinishEditing)},
    {SIP_MLNAME_CAST(sipName_GetAlignment), meth_wxDataViewRenderer_GetAlignment, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetAlignment)},
    {SIP_MLNAME_CAST(sipName_GetEditorCtrl), meth_wxDataViewRenderer_GetEditorCtrl, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetEditorCtrl)},
    {SIP_MLNAME_CAST(sipName_GetEllipsizeMode), meth_wxDataViewRenderer_GetEllipsizeMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetEllipsizeMode)},
    {SIP_MLNAME_CAST(sipName_GetMode), meth_wxDataViewRenderer_GetMode, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetMode)},
    {SIP_MLNAME_CAST(sipName_GetOwner), meth_wxDataViewRenderer_GetOwner, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetOwner)},
    {SIP_MLNAME_CAST(sipName_GetValue), SIP_MLMETH_CAST(meth_wxDataViewRenderer_GetValue), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetValue)},
    {SIP_MLNAME_CAST(sipName_GetValueFromEditorCtrl), SIP_MLMETH_CAST(meth_wxDataViewRenderer_GetValueFromEditorCtrl), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetValueFromEditorCtrl)},
    {SIP_MLNAME_CAST(sipName_GetVariantType), meth_wxDataViewRenderer_GetVariantType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_GetVariantType)},
    {SIP_MLNAME_CAST(sipName_HasEditorCtrl), meth_wxDataViewRenderer_HasEditorCtrl, METH_VARARGS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_HasEditorCtrl)},
    {SIP_MLNAME_CAST(sipName_SetAlignment), SIP_MLMETH_CAST(meth_wxDataViewRenderer_SetAlignment), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_SetAlignment)},
    {SIP_MLNAME_CAST(sipName_SetOwner), SIP_MLMETH_CAST(meth_wxDataViewRenderer_SetOwner), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_SetOwner)},
    {SIP_MLNAME_CAST(sipName_SetValue), SIP_MLMETH_CAST(meth_wxDataViewRenderer_SetValue), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_SetValue)},
    {SIP_MLNAME_CAST(sipName_SetValueAdjuster), SIP_MLMETH_CAST(meth_wxDataViewRenderer_SetValueAdjuster), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_SetValueAdjuster)},
    {SIP_MLNAME_CAST(sipName_StartEditing), SIP_MLMETH_CAST(meth_wxDataViewRenderer_StartEditing), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_StartEditing)},
    {SIP_MLNAME_CAST(sipName_Validate), SIP_MLMETH_CAST(meth_wxDataViewRenderer_Validate), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxDataViewRenderer_Validate)}
};

sipVariableDef variables_wxDataViewRenderer[] = {
    {PropertyVariable, sipName_View, &methods_wxDataViewRenderer[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VariantType, &methods_wxDataViewRenderer[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Owner, &methods_wxDataViewRenderer[9], &methods_wxDataViewRenderer[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Mode, &methods_wxDataViewRenderer[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EllipsizeMode, &methods_wxDataViewRenderer[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EditorCtrl, &methods_wxDataViewRenderer[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Alignment, &methods_wxDataViewRenderer[5], &methods_wxDataViewRenderer[14], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDataViewRenderer, "DataViewRenderer(varianttype, mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)\n"
"\n"
"This class is used by wxDataViewCtrl to render the individual cells.");


sipClassTypeDef sipTypeDef__dataview_wxDataViewRenderer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxDataViewRenderer,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_DataViewRenderer,
        {0, 0, 1},
        20, methods_wxDataViewRenderer,
        0, SIP_NULLPTR,
        7, variables_wxDataViewRenderer,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDataViewRenderer,
    -1,
    -1,
    supers_wxDataViewRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxDataViewRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxDataViewRenderer,
    cast_wxDataViewRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
