/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmlcell.h>

        #include <wx/html/htmlcell.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxHtmlLinkInfo_GetEvent, "GetEvent() -> wx.MouseEvent\n"
"\n"
"Return pointer to event that generated OnLinkClicked() event.");

extern "C" {static PyObject *meth_wxHtmlLinkInfo_GetEvent(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlLinkInfo_GetEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxHtmlLinkInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlLinkInfo, &sipCpp))
        {
            const  ::wxMouseEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEvent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxMouseEvent *>(sipRes),sipType_wxMouseEvent,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlLinkInfo, sipName_GetEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlLinkInfo_GetHref, "GetHref() -> String\n"
"\n"
"Return HREF value of the <A> tag.");

extern "C" {static PyObject *meth_wxHtmlLinkInfo_GetHref(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlLinkInfo_GetHref(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxHtmlLinkInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlLinkInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHref());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlLinkInfo, sipName_GetHref, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlLinkInfo_GetHtmlCell, "GetHtmlCell() -> HtmlCell\n"
"\n"
"Return pointer to the cell that was clicked.");

extern "C" {static PyObject *meth_wxHtmlLinkInfo_GetHtmlCell(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlLinkInfo_GetHtmlCell(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxHtmlLinkInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlLinkInfo, &sipCpp))
        {
            const  ::wxHtmlCell*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHtmlCell();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxHtmlCell *>(sipRes),sipType_wxHtmlCell,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlLinkInfo, sipName_GetHtmlCell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlLinkInfo_GetTarget, "GetTarget() -> String\n"
"\n"
"Return TARGET value of the <A> tag (this value is used to specify in\n"
"which frame should be the page pointed by GetHref() Href opened).");

extern "C" {static PyObject *meth_wxHtmlLinkInfo_GetTarget(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlLinkInfo_GetTarget(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxHtmlLinkInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlLinkInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetTarget());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlLinkInfo, sipName_GetTarget, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlLinkInfo(void *, const sipTypeDef *);}
static void *cast_wxHtmlLinkInfo(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxHtmlLinkInfo *sipCpp = reinterpret_cast< ::wxHtmlLinkInfo *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlLinkInfo(void *, int);}
static void release_wxHtmlLinkInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlLinkInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxHtmlLinkInfo(void *, SIP_SSIZE_T, void *);}
static void assign_wxHtmlLinkInfo(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxHtmlLinkInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxHtmlLinkInfo *>(sipSrc);
}


extern "C" {static void *array_wxHtmlLinkInfo(SIP_SSIZE_T);}
static void *array_wxHtmlLinkInfo(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxHtmlLinkInfo[sipNrElem];
}


extern "C" {static void *copy_wxHtmlLinkInfo(const void *, SIP_SSIZE_T);}
static void *copy_wxHtmlLinkInfo(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxHtmlLinkInfo(reinterpret_cast<const  ::wxHtmlLinkInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxHtmlLinkInfo(sipSimpleWrapper *);}
static void dealloc_wxHtmlLinkInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlLinkInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlLinkInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlLinkInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxHtmlLinkInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlLinkInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxString* href;
        int hrefState = 0;
        const  ::wxString& targetdef = wxEmptyString;
        const  ::wxString* target = &targetdef;
        int targetState = 0;

        static const char *sipKwdList[] = {
            sipName_href,
            sipName_target,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|J1", sipType_wxString,&href, &hrefState, sipType_wxString,&target, &targetState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlLinkInfo(*href,*target);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(href),sipType_wxString,hrefState);
            sipReleaseType(const_cast< ::wxString *>(target),sipType_wxString,targetState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxHtmlLinkInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxHtmlLinkInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxHtmlLinkInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlLinkInfo[] = {{25, 0, 1}};


static PyMethodDef methods_wxHtmlLinkInfo[] = {
    {SIP_MLNAME_CAST(sipName_GetEvent), meth_wxHtmlLinkInfo_GetEvent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlLinkInfo_GetEvent)},
    {SIP_MLNAME_CAST(sipName_GetHref), meth_wxHtmlLinkInfo_GetHref, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlLinkInfo_GetHref)},
    {SIP_MLNAME_CAST(sipName_GetHtmlCell), meth_wxHtmlLinkInfo_GetHtmlCell, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlLinkInfo_GetHtmlCell)},
    {SIP_MLNAME_CAST(sipName_GetTarget), meth_wxHtmlLinkInfo_GetTarget, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlLinkInfo_GetTarget)}
};

sipVariableDef variables_wxHtmlLinkInfo[] = {
    {PropertyVariable, sipName_Target, &methods_wxHtmlLinkInfo[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HtmlCell, &methods_wxHtmlLinkInfo[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Href, &methods_wxHtmlLinkInfo[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Event, &methods_wxHtmlLinkInfo[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHtmlLinkInfo, "HtmlLinkInfo()\n"
"HtmlLinkInfo(href, target=wx.EmptyString)\n"
"\n"
"This class stores all necessary information about hypertext links (as\n"
"represented by <A> tag in HTML documents).");


sipClassTypeDef sipTypeDef__html_wxHtmlLinkInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlLinkInfo,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_HtmlLinkInfo,
        {0, 0, 1},
        4, methods_wxHtmlLinkInfo,
        0, SIP_NULLPTR,
        4, variables_wxHtmlLinkInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlLinkInfo,
    -1,
    -1,
    supers_wxHtmlLinkInfo,
    SIP_NULLPTR,
    init_type_wxHtmlLinkInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxHtmlLinkInfo,
    assign_wxHtmlLinkInfo,
    array_wxHtmlLinkInfo,
    copy_wxHtmlLinkInfo,
    release_wxHtmlLinkInfo,
    cast_wxHtmlLinkInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
