/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextctrl.h>

        #include <wx/event.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextstyles.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextEvent : public  ::wxRichTextEvent
{
public:
    sipwxRichTextEvent( ::wxEventType,int);
    sipwxRichTextEvent(const  ::wxRichTextEvent&);
    virtual ~sipwxRichTextEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEvent* Clone() const SIP_OVERRIDE;
     ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextEvent(const sipwxRichTextEvent &);
    sipwxRichTextEvent &operator = (const sipwxRichTextEvent &);

    char sipPyMethods[2];
};

sipwxRichTextEvent::sipwxRichTextEvent( ::wxEventType commandType,int winid):  ::wxRichTextEvent(commandType,winid), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextEvent::sipwxRichTextEvent(const  ::wxRichTextEvent& event):  ::wxRichTextEvent(event), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextEvent::~sipwxRichTextEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxEvent* sipwxRichTextEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,SIP_NULLPTR,sipName_Clone);

    if (!sipMeth)
        return  ::wxRichTextEvent::Clone();

    extern  ::wxEvent* sipVH__richtext_142(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_142(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEventCategory sipwxRichTextEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[1]),sipPySelf,SIP_NULLPTR,sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxRichTextEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__richtext_141(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_141(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetPosition, "GetPosition() -> long\n"
"\n"
"Returns the buffer position at which the event occurred.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetPosition, "SetPosition(pos)\n"
"\n"
"Sets the buffer position variable.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long pos;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxRichTextEvent, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns flags indicating modifier keys pressed.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets flags indicating modifier keys pressed.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextEvent, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetOldStyleSheet, "GetOldStyleSheet() -> RichTextStyleSheet\n"
"\n"
"Returns the old style sheet.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetOldStyleSheet(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetOldStyleSheet(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxRichTextStyleSheet*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOldStyleSheet();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextStyleSheet,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetOldStyleSheet, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetOldStyleSheet, "SetOldStyleSheet(sheet)\n"
"\n"
"Sets the old style sheet variable.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetOldStyleSheet(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetOldStyleSheet(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextStyleSheet* sheet;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextEvent, &sipCpp, sipType_wxRichTextStyleSheet, &sheet))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOldStyleSheet(sheet);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetOldStyleSheet, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetNewStyleSheet, "GetNewStyleSheet() -> RichTextStyleSheet\n"
"\n"
"Returns the new style sheet.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetNewStyleSheet(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetNewStyleSheet(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxRichTextStyleSheet*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNewStyleSheet();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextStyleSheet,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetNewStyleSheet, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetNewStyleSheet, "SetNewStyleSheet(sheet)\n"
"\n"
"Sets the new style sheet variable.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetNewStyleSheet(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetNewStyleSheet(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextStyleSheet* sheet;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sheet,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextEvent, &sipCpp, sipType_wxRichTextStyleSheet, &sheet))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetNewStyleSheet(sheet);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetNewStyleSheet, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetRange, "GetRange() -> RichTextRange\n"
"\n"
"Gets the range for the current operation.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetRange(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRichTextRange(sipCpp->GetRange());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRichTextRange,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetRange, "SetRange(range)\n"
"\n"
"Sets the range variable.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextRange* range;
        int rangeState = 0;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextEvent, &sipCpp, sipType_wxRichTextRange, &range, &rangeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRange(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range),sipType_wxRichTextRange,rangeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetCharacter, "GetCharacter() -> Char\n"
"\n"
"Returns the character pressed, within a wxEVT_RICHTEXT_CHARACTER\n"
"event.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetCharacter(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetCharacter(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxChar sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCharacter();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyUnicode_FromWideChar(&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetCharacter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetCharacter, "SetCharacter(ch)\n"
"\n"
"Sets the character variable.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetCharacter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetCharacter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxChar ch;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ch,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bw", &sipSelf, sipType_wxRichTextEvent, &sipCpp, &ch))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCharacter(ch);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetCharacter, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetContainer, "GetContainer() -> RichTextParagraphLayoutBox\n"
"\n"
"Returns the container for which the event is relevant.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetContainer(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxRichTextParagraphLayoutBox*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphLayoutBox,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetContainer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetContainer, "SetContainer(container)\n"
"\n"
"Sets the container for which the event is relevant.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetContainer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetContainer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextParagraphLayoutBox* container;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_container,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextEvent, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &container))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetContainer(container);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetContainer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_GetOldContainer, "GetOldContainer() -> RichTextParagraphLayoutBox\n"
"\n"
"Returns the old container, for a focus change event.");

extern "C" {static PyObject *meth_wxRichTextEvent_GetOldContainer(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_GetOldContainer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxRichTextParagraphLayoutBox*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOldContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextParagraphLayoutBox,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_GetOldContainer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_SetOldContainer, "SetOldContainer(container)\n"
"\n"
"Sets the old container, for a focus change event.");

extern "C" {static PyObject *meth_wxRichTextEvent_SetOldContainer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_SetOldContainer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextParagraphLayoutBox* container;
         ::wxRichTextEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_container,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextEvent, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &container))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOldContainer(container);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_SetOldContainer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextEvent_Clone, "Clone() -> wx.Event\n"
"\n"
"Returns a copy of the event.");

extern "C" {static PyObject *meth_wxRichTextEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxRichTextEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxRichTextEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextEvent, sipName_Clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextEvent(void *, const sipTypeDef *);}
static void *cast_wxRichTextEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextEvent *sipCpp = reinterpret_cast< ::wxRichTextEvent *>(sipCppV);

    if (targetType == sipType_wxNotifyEvent)
        return static_cast< ::wxNotifyEvent *>(sipCpp);

    if (targetType == sipType_wxCommandEvent)
        return static_cast< ::wxCommandEvent *>(sipCpp);

    if (targetType == sipType_wxEvent)
        return static_cast< ::wxEvent *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextEvent(void *, int);}
static void release_wxRichTextEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextEvent(sipSimpleWrapper *);}
static void dealloc_wxRichTextEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextEvent *sipCpp = SIP_NULLPTR;

    {
         ::wxEventType commandType = wxEVT_NULL;
        int winid = 0;

        static const char *sipKwdList[] = {
            sipName_commandType,
            sipName_winid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &commandType, &winid))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextEvent(commandType,winid);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextEvent* event;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextEvent[] = {{41, 0, 1}};


static PyMethodDef methods_wxRichTextEvent[] = {
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxRichTextEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_GetCharacter), meth_wxRichTextEvent_GetCharacter, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetCharacter)},
    {SIP_MLNAME_CAST(sipName_GetContainer), meth_wxRichTextEvent_GetContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetContainer)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxRichTextEvent_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetNewStyleSheet), meth_wxRichTextEvent_GetNewStyleSheet, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetNewStyleSheet)},
    {SIP_MLNAME_CAST(sipName_GetOldContainer), meth_wxRichTextEvent_GetOldContainer, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetOldContainer)},
    {SIP_MLNAME_CAST(sipName_GetOldStyleSheet), meth_wxRichTextEvent_GetOldStyleSheet, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetOldStyleSheet)},
    {SIP_MLNAME_CAST(sipName_GetPosition), meth_wxRichTextEvent_GetPosition, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetPosition)},
    {SIP_MLNAME_CAST(sipName_GetRange), meth_wxRichTextEvent_GetRange, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextEvent_GetRange)},
    {SIP_MLNAME_CAST(sipName_SetCharacter), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetCharacter), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetCharacter)},
    {SIP_MLNAME_CAST(sipName_SetContainer), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetContainer), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetContainer)},
    {SIP_MLNAME_CAST(sipName_SetFlags), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetFlags), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetNewStyleSheet), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetNewStyleSheet), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetNewStyleSheet)},
    {SIP_MLNAME_CAST(sipName_SetOldContainer), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetOldContainer), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetOldContainer)},
    {SIP_MLNAME_CAST(sipName_SetOldStyleSheet), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetOldStyleSheet), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetOldStyleSheet)},
    {SIP_MLNAME_CAST(sipName_SetPosition), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetPosition), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetPosition)},
    {SIP_MLNAME_CAST(sipName_SetRange), SIP_MLMETH_CAST(meth_wxRichTextEvent_SetRange), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextEvent_SetRange)}
};

sipVariableDef variables_wxRichTextEvent[] = {
    {PropertyVariable, sipName_Range, &methods_wxRichTextEvent[8], &methods_wxRichTextEvent[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxRichTextEvent[7], &methods_wxRichTextEvent[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OldStyleSheet, &methods_wxRichTextEvent[6], &methods_wxRichTextEvent[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OldContainer, &methods_wxRichTextEvent[5], &methods_wxRichTextEvent[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NewStyleSheet, &methods_wxRichTextEvent[4], &methods_wxRichTextEvent[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxRichTextEvent[3], &methods_wxRichTextEvent[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Container, &methods_wxRichTextEvent[2], &methods_wxRichTextEvent[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Character, &methods_wxRichTextEvent[1], &methods_wxRichTextEvent[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextEvent, "RichTextEvent(commandType=wx.wxEVT_NULL, winid=0)\n"
"RichTextEvent(event)\n"
"\n"
"This is the event class for wxRichTextCtrl notifications.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextEvent,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_RichTextEvent,
        {0, 0, 1},
        17, methods_wxRichTextEvent,
        0, SIP_NULLPTR,
        8, variables_wxRichTextEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextEvent,
    -1,
    -1,
    supers_wxRichTextEvent,
    SIP_NULLPTR,
    init_type_wxRichTextEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxRichTextEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxRichTextEvent,
    cast_wxRichTextEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
