/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxTextAttrShadow_Reset, "Reset()\n"
"\n"
"Resets the shadow.");

extern "C" {static PyObject *meth_wxTextAttrShadow_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_Reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_EqPartial, "EqPartial(shadow, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxTextAttrShadow_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* shadow;
        bool weakTest = 1;
        const  ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_shadow,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|b", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrShadow, &shadow, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*shadow,weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_EqPartial, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_Apply, "Apply(shadow, compareWith=None) -> bool\n"
"\n"
"Applies the border to this object, but not if the same as compareWith.");

extern "C" {static PyObject *meth_wxTextAttrShadow_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* shadow;
        const  ::wxTextAttrShadow* compareWith = 0;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_shadow,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrShadow, &shadow, sipType_wxTextAttrShadow, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*shadow,compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_Apply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_RemoveStyle, "RemoveStyle(attr) -> bool\n"
"\n"
"Removes the specified attributes from this object.");

extern "C" {static PyObject *meth_wxTextAttrShadow_RemoveStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_RemoveStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* attr;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrShadow, &attr))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveStyle(*attr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_RemoveStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr)\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxTextAttrShadow_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* attr;
         ::wxTextAttrShadow* clashingAttr;
         ::wxTextAttrShadow* absentAttr;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrShadow, &attr, sipType_wxTextAttrShadow, &clashingAttr, sipType_wxTextAttrShadow, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr,*clashingAttr,*absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_CollectCommonAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetColour, "SetColour(colour)\n"
"SetColour(colour)\n"
"\n"
"Sets the shadow colour.\n"
"");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned long colour;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, &colour))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(colour);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour),sipType_wxColour,colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetColourLong, "GetColourLong() -> unsignedlong\n"
"\n"
"Gets the colour as a long.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetColourLong(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetColourLong(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColourLong();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetColourLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetColour, "GetColour() -> wx.Colour\n"
"\n"
"Gets the colour.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_HasColour, "HasColour() -> bool\n"
"\n"
"True if the shadow has a valid colour.");

extern "C" {static PyObject *meth_wxTextAttrShadow_HasColour(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_HasColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_HasColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetOffsetX, "GetOffsetX() -> TextAttrDimension\n"
"\n"
"Gets the shadow horizontal offset.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetOffsetX(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetOffsetX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOffsetX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetOffsetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetOffsetX, "SetOffsetX(offset)\n"
"\n"
"Sets the shadow horizontal offset.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetOffsetX(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetOffsetX(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* offset;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrDimension, &offset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOffsetX(*offset);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetOffsetX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetOffsetY, "GetOffsetY() -> TextAttrDimension\n"
"\n"
"Gets the shadow vertical offset.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetOffsetY(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetOffsetY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOffsetY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetOffsetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetOffsetY, "SetOffsetY(offset)\n"
"\n"
"Sets the shadow vertical offset.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetOffsetY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetOffsetY(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* offset;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrDimension, &offset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOffsetY(*offset);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetOffsetY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetSpread, "GetSpread() -> TextAttrDimension\n"
"\n"
"Gets the shadow spread size.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetSpread(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetSpread(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetSpread();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetSpread, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetSpread, "SetSpread(spread)\n"
"\n"
"Sets the shadow spread size.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetSpread(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetSpread(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* spread;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spread,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrDimension, &spread))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSpread(*spread);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetSpread, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetBlurDistance, "GetBlurDistance() -> TextAttrDimension\n"
"\n"
"Gets the shadow blur distance.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetBlurDistance(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetBlurDistance(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetBlurDistance();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetBlurDistance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetBlurDistance, "SetBlurDistance(blur)\n"
"\n"
"Sets the shadow blur distance.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetBlurDistance(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetBlurDistance(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* blur;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_blur,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrDimension, &blur))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBlurDistance(*blur);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetBlurDistance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetOpacity, "GetOpacity() -> TextAttrDimension\n"
"\n"
"Gets the shadow opacity.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetOpacity(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetOpacity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
             ::wxTextAttrDimension*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetOpacity();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxTextAttrDimension,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetOpacity, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the dimension is valid.");

extern "C" {static PyObject *meth_wxTextAttrShadow_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetValid, "SetValid(b)\n"
"\n"
"Sets the valid flag.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetValid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetValid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValid(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns the border flags.");

extern "C" {static PyObject *meth_wxTextAttrShadow_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets the border flags.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_AddFlag, "AddFlag(flag)\n"
"\n"
"Adds a border flag.");

extern "C" {static PyObject *meth_wxTextAttrShadow_AddFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_AddFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_AddFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_RemoveFlag, "RemoveFlag(flag)\n"
"\n"
"Removes a border flag.");

extern "C" {static PyObject *meth_wxTextAttrShadow_RemoveFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_RemoveFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flag;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveFlag(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_RemoveFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_SetOpacity, "SetOpacity(opacity)\n"
"\n"
"Sets the shadow opacity.");

extern "C" {static PyObject *meth_wxTextAttrShadow_SetOpacity(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_SetOpacity(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrDimension* opacity;
         ::wxTextAttrShadow *sipCpp;

        static const char *sipKwdList[] = {
            sipName_opacity,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrShadow, &sipCpp, sipType_wxTextAttrDimension, &opacity))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOpacity(*opacity);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_SetOpacity, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrShadow_IsDefault, "IsDefault() -> bool\n"
"\n"
"True if the shadow has no attributes set.");

extern "C" {static PyObject *meth_wxTextAttrShadow_IsDefault(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrShadow_IsDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrShadow, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDefault();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_TextAttrShadow, sipName_IsDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxTextAttrShadow___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrShadow___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrShadow));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* shadow;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrShadow, &shadow))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp-> ::wxTextAttrShadow::operator==(*shadow);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextAttrShadow, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxTextAttrShadow___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxTextAttrShadow___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxTextAttrShadow));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxTextAttrShadow* shadow;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrShadow, &shadow))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxTextAttrShadow::operator==(*shadow);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextAttrShadow, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttrShadow(void *, int);}
static void release_wxTextAttrShadow(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttrShadow *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextAttrShadow(void *, SIP_SSIZE_T, void *);}
static void assign_wxTextAttrShadow(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttrShadow *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttrShadow *>(sipSrc);
}


extern "C" {static void *array_wxTextAttrShadow(SIP_SSIZE_T);}
static void *array_wxTextAttrShadow(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxTextAttrShadow[sipNrElem];
}


extern "C" {static void *copy_wxTextAttrShadow(const void *, SIP_SSIZE_T);}
static void *copy_wxTextAttrShadow(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxTextAttrShadow(reinterpret_cast<const  ::wxTextAttrShadow *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttrShadow(sipSimpleWrapper *);}
static void dealloc_wxTextAttrShadow(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttrShadow(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttrShadow(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttrShadow(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxTextAttrShadow *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrShadow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxTextAttrShadow* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTextAttrShadow, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxTextAttrShadow(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextAttrShadow[] = {
    {(void *)slot_wxTextAttrShadow___ne__, ne_slot},
    {(void *)slot_wxTextAttrShadow___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextAttrShadow[] = {
    {SIP_MLNAME_CAST(sipName_AddFlag), SIP_MLMETH_CAST(meth_wxTextAttrShadow_AddFlag), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_AddFlag)},
    {SIP_MLNAME_CAST(sipName_Apply), SIP_MLMETH_CAST(meth_wxTextAttrShadow_Apply), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_Apply)},
    {SIP_MLNAME_CAST(sipName_CollectCommonAttributes), SIP_MLMETH_CAST(meth_wxTextAttrShadow_CollectCommonAttributes), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_CollectCommonAttributes)},
    {SIP_MLNAME_CAST(sipName_EqPartial), SIP_MLMETH_CAST(meth_wxTextAttrShadow_EqPartial), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_EqPartial)},
    {SIP_MLNAME_CAST(sipName_GetBlurDistance), meth_wxTextAttrShadow_GetBlurDistance, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetBlurDistance)},
    {SIP_MLNAME_CAST(sipName_GetColour), meth_wxTextAttrShadow_GetColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetColour)},
    {SIP_MLNAME_CAST(sipName_GetColourLong), meth_wxTextAttrShadow_GetColourLong, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetColourLong)},
    {SIP_MLNAME_CAST(sipName_GetFlags), meth_wxTextAttrShadow_GetFlags, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetFlags)},
    {SIP_MLNAME_CAST(sipName_GetOffsetX), meth_wxTextAttrShadow_GetOffsetX, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetOffsetX)},
    {SIP_MLNAME_CAST(sipName_GetOffsetY), meth_wxTextAttrShadow_GetOffsetY, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetOffsetY)},
    {SIP_MLNAME_CAST(sipName_GetOpacity), meth_wxTextAttrShadow_GetOpacity, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetOpacity)},
    {SIP_MLNAME_CAST(sipName_GetSpread), meth_wxTextAttrShadow_GetSpread, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_GetSpread)},
    {SIP_MLNAME_CAST(sipName_HasColour), meth_wxTextAttrShadow_HasColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_HasColour)},
    {SIP_MLNAME_CAST(sipName_IsDefault), meth_wxTextAttrShadow_IsDefault, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_IsDefault)},
    {SIP_MLNAME_CAST(sipName_IsValid), meth_wxTextAttrShadow_IsValid, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_IsValid)},
    {SIP_MLNAME_CAST(sipName_RemoveFlag), SIP_MLMETH_CAST(meth_wxTextAttrShadow_RemoveFlag), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_RemoveFlag)},
    {SIP_MLNAME_CAST(sipName_RemoveStyle), SIP_MLMETH_CAST(meth_wxTextAttrShadow_RemoveStyle), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_RemoveStyle)},
    {SIP_MLNAME_CAST(sipName_Reset), meth_wxTextAttrShadow_Reset, METH_VARARGS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_Reset)},
    {SIP_MLNAME_CAST(sipName_SetBlurDistance), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetBlurDistance), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetBlurDistance)},
    {SIP_MLNAME_CAST(sipName_SetColour), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetColour), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetColour)},
    {SIP_MLNAME_CAST(sipName_SetFlags), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetFlags), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetFlags)},
    {SIP_MLNAME_CAST(sipName_SetOffsetX), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetOffsetX), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetOffsetX)},
    {SIP_MLNAME_CAST(sipName_SetOffsetY), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetOffsetY), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetOffsetY)},
    {SIP_MLNAME_CAST(sipName_SetOpacity), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetOpacity), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetOpacity)},
    {SIP_MLNAME_CAST(sipName_SetSpread), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetSpread), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetSpread)},
    {SIP_MLNAME_CAST(sipName_SetValid), SIP_MLMETH_CAST(meth_wxTextAttrShadow_SetValid), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxTextAttrShadow_SetValid)}
};


extern "C" {static PyObject *varget_wxTextAttrShadow_m_blurDistance(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_blurDistance(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = &sipCpp->m_blurDistance;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextAttrShadow_m_blurDistance(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_blurDistance(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_blurDistance = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_flags(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = sipCpp->m_flags;

    return SIPLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrShadow_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_offsetX(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_offsetX(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = &sipCpp->m_offsetX;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextAttrShadow_m_offsetX(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_offsetX(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_offsetX = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_offsetY(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_offsetY(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = &sipCpp->m_offsetY;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextAttrShadow_m_offsetY(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_offsetY(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_offsetY = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_opacity(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_opacity(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = &sipCpp->m_opacity;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextAttrShadow_m_opacity(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_opacity(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_opacity = *sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_shadowColour(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_shadowColour(void *sipSelf, PyObject *, PyObject *)
{
    unsigned long sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = sipCpp->m_shadowColour;

    return PyLong_FromUnsignedLong(sipVal);
}


extern "C" {static int varset_wxTextAttrShadow_m_shadowColour(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_shadowColour(void *sipSelf, PyObject *sipPy, PyObject *)
{
    unsigned long sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = sipLong_AsUnsignedLong(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_shadowColour = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrShadow_m_spread(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrShadow_m_spread(void *sipSelf, PyObject *, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    sipVal = &sipCpp->m_spread;

    return sipConvertFromType(sipVal, sipType_wxTextAttrDimension, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextAttrShadow_m_spread(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrShadow_m_spread(void *sipSelf, PyObject *sipPy, PyObject *)
{
     ::wxTextAttrDimension*sipVal;
     ::wxTextAttrShadow *sipCpp = reinterpret_cast< ::wxTextAttrShadow *>(sipSelf);

    int sipIsErr = 0;

    sipVal = reinterpret_cast< ::wxTextAttrDimension *>(sipForceConvertToType(sipPy, sipType_wxTextAttrDimension, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_spread = *sipVal;

    return 0;
}

sipVariableDef variables_wxTextAttrShadow[] = {
    {PropertyVariable, sipName_Spread, &methods_wxTextAttrShadow[11], &methods_wxTextAttrShadow[24], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Opacity, &methods_wxTextAttrShadow[10], &methods_wxTextAttrShadow[23], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OffsetY, &methods_wxTextAttrShadow[9], &methods_wxTextAttrShadow[22], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OffsetX, &methods_wxTextAttrShadow[8], &methods_wxTextAttrShadow[21], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxTextAttrShadow[7], &methods_wxTextAttrShadow[20], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ColourLong, &methods_wxTextAttrShadow[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxTextAttrShadow[5], &methods_wxTextAttrShadow[19], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BlurDistance, &methods_wxTextAttrShadow[4], &methods_wxTextAttrShadow[18], SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_blurDistance, (PyMethodDef *)varget_wxTextAttrShadow_m_blurDistance, (PyMethodDef *)varset_wxTextAttrShadow_m_blurDistance, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextAttrShadow_m_flags, (PyMethodDef *)varset_wxTextAttrShadow_m_flags, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_offsetX, (PyMethodDef *)varget_wxTextAttrShadow_m_offsetX, (PyMethodDef *)varset_wxTextAttrShadow_m_offsetX, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_offsetY, (PyMethodDef *)varget_wxTextAttrShadow_m_offsetY, (PyMethodDef *)varset_wxTextAttrShadow_m_offsetY, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_opacity, (PyMethodDef *)varget_wxTextAttrShadow_m_opacity, (PyMethodDef *)varset_wxTextAttrShadow_m_opacity, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_shadowColour, (PyMethodDef *)varget_wxTextAttrShadow_m_shadowColour, (PyMethodDef *)varset_wxTextAttrShadow_m_shadowColour, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_spread, (PyMethodDef *)varget_wxTextAttrShadow_m_spread, (PyMethodDef *)varset_wxTextAttrShadow_m_spread, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextAttrShadow, "TextAttrShadow()\n"
"\n"
"A class representing a shadow.");


sipClassTypeDef sipTypeDef__richtext_wxTextAttrShadow = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttrShadow,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_TextAttrShadow,
        {0, 0, 1},
        26, methods_wxTextAttrShadow,
        0, SIP_NULLPTR,
        15, variables_wxTextAttrShadow,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextAttrShadow,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxTextAttrShadow,
    init_type_wxTextAttrShadow,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxTextAttrShadow,
    assign_wxTextAttrShadow,
    array_wxTextAttrShadow,
    copy_wxTextAttrShadow,
    release_wxTextAttrShadow,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
