/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.19
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_xml.h"

        #include <wx/xml/xml.h>



PyDoc_STRVAR(doc_wxXmlDoctype_Clear, "Clear()\n"
"\n"
"Removes all the DOCTYPE values.");

extern "C" {static PyObject *meth_wxXmlDoctype_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetRootName, "GetRootName() -> String\n"
"\n"
"Returns the root name of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetRootName(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetRootName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetRootName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetRootName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetSystemId, "GetSystemId() -> String\n"
"\n"
"Returns the system id of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetSystemId(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetSystemId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetSystemId());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetSystemId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetPublicId, "GetPublicId() -> String\n"
"\n"
"Returns the public id of the document.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetPublicId(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetPublicId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPublicId());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetPublicId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_GetFullString, "GetFullString() -> String\n"
"\n"
"Returns the formatted DOCTYPE contents.");

extern "C" {static PyObject *meth_wxXmlDoctype_GetFullString(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_GetFullString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFullString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_GetFullString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlDoctype_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the contents can produce a valid DOCTYPE string.");

extern "C" {static PyObject *meth_wxXmlDoctype_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxXmlDoctype_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxXmlDoctype *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlDoctype, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_XmlDoctype, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxXmlDoctype(void *, int);}
static void release_wxXmlDoctype(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxXmlDoctype *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxXmlDoctype(void *, SIP_SSIZE_T, void *);}
static void assign_wxXmlDoctype(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxXmlDoctype *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxXmlDoctype *>(sipSrc);
}


extern "C" {static void *array_wxXmlDoctype(SIP_SSIZE_T);}
static void *array_wxXmlDoctype(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxXmlDoctype[sipNrElem];
}


extern "C" {static void *copy_wxXmlDoctype(const void *, SIP_SSIZE_T);}
static void *copy_wxXmlDoctype(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxXmlDoctype(reinterpret_cast<const  ::wxXmlDoctype *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxXmlDoctype(sipSimpleWrapper *);}
static void dealloc_wxXmlDoctype(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxXmlDoctype(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxXmlDoctype(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxXmlDoctype(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxXmlDoctype *sipCpp = SIP_NULLPTR;

    {
        const  ::wxString& namedef = wxString();
        const  ::wxString* name = &namedef;
        int nameState = 0;
        const  ::wxString& sysiddef = wxString();
        const  ::wxString* sysid = &sysiddef;
        int sysidState = 0;
        const  ::wxString& pubiddef = wxString();
        const  ::wxString* pubid = &pubiddef;
        int pubidState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_sysid,
            sipName_pubid,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1J1", sipType_wxString,&name, &nameState, sipType_wxString,&sysid, &sysidState, sipType_wxString,&pubid, &pubidState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxXmlDoctype(*name,*sysid,*pubid);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);
            sipReleaseType(const_cast< ::wxString *>(sysid),sipType_wxString,sysidState);
            sipReleaseType(const_cast< ::wxString *>(pubid),sipType_wxString,pubidState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxXmlDoctype* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxXmlDoctype, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxXmlDoctype(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxXmlDoctype[] = {
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxXmlDoctype_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_Clear)},
    {SIP_MLNAME_CAST(sipName_GetFullString), meth_wxXmlDoctype_GetFullString, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_GetFullString)},
    {SIP_MLNAME_CAST(sipName_GetPublicId), meth_wxXmlDoctype_GetPublicId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_GetPublicId)},
    {SIP_MLNAME_CAST(sipName_GetRootName), meth_wxXmlDoctype_GetRootName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_GetRootName)},
    {SIP_MLNAME_CAST(sipName_GetSystemId), meth_wxXmlDoctype_GetSystemId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_GetSystemId)},
    {SIP_MLNAME_CAST(sipName_IsValid), meth_wxXmlDoctype_IsValid, METH_VARARGS, SIP_MLDOC_CAST(doc_wxXmlDoctype_IsValid)}
};

sipVariableDef variables_wxXmlDoctype[] = {
    {PropertyVariable, sipName_SystemId, &methods_wxXmlDoctype[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RootName, &methods_wxXmlDoctype[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PublicId, &methods_wxXmlDoctype[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FullString, &methods_wxXmlDoctype[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxXmlDoctype, "XmlDoctype(name=\"\", sysid=\"\", pubid=\"\")\n"
"\n"
"Represents a DOCTYPE Declaration.");


sipClassTypeDef sipTypeDef__xml_wxXmlDoctype = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxXmlDoctype,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_XmlDoctype,
        {0, 0, 1},
        6, methods_wxXmlDoctype,
        0, SIP_NULLPTR,
        4, variables_wxXmlDoctype,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxXmlDoctype,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxXmlDoctype,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxXmlDoctype,
    assign_wxXmlDoctype,
    array_wxXmlDoctype,
    copy_wxXmlDoctype,
    release_wxXmlDoctype,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
