# Generated by Django 4.1.2 on 2022-10-25 01:17

from django.db import migrations, models
import django.db.models.deletion
import django_sequence.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Sequence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_complete', models.BooleanField(default=False, help_text='set to true when all stages have a state of completed')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='StageResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='human readable representation of value', max_length=64, null=True)),
                ('description', models.CharField(blank=True, help_text='description of this entry', max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StageState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='human readable representation of value', max_length=64, null=True)),
                ('description', models.CharField(blank=True, help_text='description of this entry', max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['name'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Stage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='short reference for stage', max_length=64, unique=True)),
                ('description', models.CharField(blank=True, help_text='detailed description of stage', max_length=255, null=True)),
                ('order', models.IntegerField(help_text='operational order of stage (where 1 is the first)')),
                ('details', models.CharField(blank=True, help_text='additional details, such as incomplete reason', max_length=255, null=True)),
                ('blocking', models.BooleanField(default=True, help_text='if True, do not continue to next stage if a failure or error occurs')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('result', models.ForeignKey(default=django_sequence.models.get_default_stage_result, help_text='outcome of model_sequence stage', on_delete=django.db.models.deletion.CASCADE, to='django_sequences.stageresult')),
                ('sequence', models.ForeignKey(help_text='model_sequence this stage belongs to', on_delete=django.db.models.deletion.CASCADE, to='django_sequences.sequence')),
                ('state', models.ForeignKey(default=django_sequence.models.get_default_stage_state, help_text='current activity of model_sequence stage', on_delete=django.db.models.deletion.CASCADE, to='django_sequences.stagestate')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
    ]
