"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = log4js_1.getLogger();
/**
 * Generates the python client using OpenAPI Generator
 */
class GeneratedPythonClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the python client
            logger.debug("Generating python client...");
            utils_1.invokeOpenApiGenerator({
                generator: "python",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.PYTHON,
                additionalProperties: {
                    packageName: this.project.moduleName,
                    projectName: this.project.name,
                },
                // Tell the generator where python source files live
                srcDir: this.project.moduleName,
                normalizers: {
                    KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
                },
            });
        }
    }
}
exports.GeneratedPythonClientSourceCode = GeneratedPythonClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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