# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class QueryDigitalDistrictOrgInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_dingtalk_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_dingtalk_access_token = x_acs_dingtalk_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_dingtalk_access_token is not None:
            result['x-acs-dingtalk-access-token'] = self.x_acs_dingtalk_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-dingtalk-access-token') is not None:
            self.x_acs_dingtalk_access_token = m.get('x-acs-dingtalk-access-token')
        return self


class QueryDigitalDistrictOrgInfoRequest(TeaModel):
    def __init__(
        self,
        kpi_group_id: str = None,
        stat_dates: List[str] = None,
        org_ids: List[str] = None,
    ):
        self.kpi_group_id = kpi_group_id
        self.stat_dates = stat_dates
        self.org_ids = org_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kpi_group_id is not None:
            result['kpiGroupId'] = self.kpi_group_id
        if self.stat_dates is not None:
            result['statDates'] = self.stat_dates
        if self.org_ids is not None:
            result['orgIds'] = self.org_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('kpiGroupId') is not None:
            self.kpi_group_id = m.get('kpiGroupId')
        if m.get('statDates') is not None:
            self.stat_dates = m.get('statDates')
        if m.get('orgIds') is not None:
            self.org_ids = m.get('orgIds')
        return self


class QueryDigitalDistrictOrgInfoResponseBody(TeaModel):
    def __init__(
        self,
        arguments: List[str] = None,
        result: str = None,
    ):
        # arguments
        self.arguments = arguments
        # result
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arguments is not None:
            result['arguments'] = self.arguments
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arguments') is not None:
            self.arguments = m.get('arguments')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QueryDigitalDistrictOrgInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDigitalDistrictOrgInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDigitalDistrictOrgInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


