/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.ifsupport.AsciiStreamReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class ClobOutputStream
extends OutputStream {
    private LocatorClob clob;
    private GenericTeradataConnection m_con;

    public ClobOutputStream(LocatorClob locatorClob, GenericTeradataConnection genericTeradataConnection) {
        this.clob = locatorClob;
        this.m_con = genericTeradataConnection;
    }

    public void close() {
        this.clob = null;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException(ErrorMessage.messages.getString("TJ550"));
        }
        if (byArray == null) {
            throw new IllegalArgumentException(ErrorMessage.messages.getString("TJ719"));
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ720"), n));
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ721"), n2));
        }
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(ErrorMessage.Format3(ErrorMessage.messages.getString("TJ722"), String.valueOf(n), String.valueOf(n2), String.valueOf(byArray.length)));
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            this.clob.writeStream(this.clob.length() + 1L, new AsciiStreamReader(this.m_con, -1, -1, null, byteArrayInputStream, n2), n2);
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }
}

