import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as lambda from '@aws-cdk/aws-lambda';
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 *
 */
export interface DynamoEventSourceProps extends StreamEventSourceProps {
}
/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 */
export declare class DynamoEventSource extends StreamEventSource {
    private readonly table;
    private _eventSourceMappingId?;
    /**
     *
     */
    constructor(table: dynamodb.ITable, props: DynamoEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     */
    bind(target: lambda.IFunction): void;
    /**
     * The identifier for this EventSourceMapping.
     */
    get eventSourceMappingId(): string;
}
