"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const subs = require("@aws-cdk/aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    /**
     *
     */
    constructor(topic, props) {
        this.topic = topic;
        this.props = props;
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     */
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLHVEQUF1RDs7OztBQVd2RCxNQUFhLGNBQWM7Ozs7SUFHekIsWUFBcUIsS0FBaUIsRUFBRSxLQUEyQjtRQUE5QyxVQUFLLEdBQUwsS0FBSyxDQUFZO1FBQ3BDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7Ozs7SUFFTSxJQUFJLENBQUMsTUFBd0I7UUFDbEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQzlFLENBQUM7Q0FDRjtBQVZELHdDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0ICogYXMgc3VicyBmcm9tICdAYXdzLWNkay9hd3Mtc25zLXN1YnNjcmlwdGlvbnMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBTbnNFdmVudFNvdXJjZVByb3BzIGV4dGVuZHMgc3Vicy5MYW1iZGFTdWJzY3JpcHRpb25Qcm9wcyB7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNuc0V2ZW50U291cmNlIGltcGxlbWVudHMgbGFtYmRhLklFdmVudFNvdXJjZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM/OiBTbnNFdmVudFNvdXJjZVByb3BzO1xuXG4gIGNvbnN0cnVjdG9yKHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljLCBwcm9wcz86IFNuc0V2ZW50U291cmNlUHJvcHMpIHtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICB0aGlzLnRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgc3Vicy5MYW1iZGFTdWJzY3JpcHRpb24odGFyZ2V0LCB0aGlzLnByb3BzKSk7XG4gIH1cbn1cbiJdfQ==