# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.3.0  # noqa: E501
    The version of the OpenAPI document: 0.11.1
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class ActivityBucketDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'start_height': 'str',
        'total_fees_paid': 'str',
        'beneficiary_count': 'int',
        'raw_score': 'str'
    }

    attribute_map = {
        'start_height': 'startHeight',
        'total_fees_paid': 'totalFeesPaid',
        'beneficiary_count': 'beneficiaryCount',
        'raw_score': 'rawScore'
    }

    def __init__(self, start_height=None, total_fees_paid=None, beneficiary_count=None, raw_score=None, local_vars_configuration=None):  # noqa: E501
        """ActivityBucketDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._start_height = None
        self._total_fees_paid = None
        self._beneficiary_count = None
        self._raw_score = None
        self.discriminator = None

        self.start_height = start_height
        self.total_fees_paid = total_fees_paid
        self.beneficiary_count = beneficiary_count
        self.raw_score = raw_score

    @property
    def start_height(self):
        """Gets the start_height of this ActivityBucketDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The start_height of this ActivityBucketDTO.  # noqa: E501
        :rtype: str
        """
        return self._start_height

    @start_height.setter
    def start_height(self, start_height):
        """Sets the start_height of this ActivityBucketDTO.

        Height of the blockchain.  # noqa: E501

        :param start_height: The start_height of this ActivityBucketDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and start_height is None:  # noqa: E501
            raise ValueError("Invalid value for `start_height`, must not be `None`")  # noqa: E501

        self._start_height = start_height

    @property
    def total_fees_paid(self):
        """Gets the total_fees_paid of this ActivityBucketDTO.  # noqa: E501

        Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).  # noqa: E501

        :return: The total_fees_paid of this ActivityBucketDTO.  # noqa: E501
        :rtype: str
        """
        return self._total_fees_paid

    @total_fees_paid.setter
    def total_fees_paid(self, total_fees_paid):
        """Sets the total_fees_paid of this ActivityBucketDTO.

        Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).  # noqa: E501

        :param total_fees_paid: The total_fees_paid of this ActivityBucketDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and total_fees_paid is None:  # noqa: E501
            raise ValueError("Invalid value for `total_fees_paid`, must not be `None`")  # noqa: E501

        self._total_fees_paid = total_fees_paid

    @property
    def beneficiary_count(self):
        """Gets the beneficiary_count of this ActivityBucketDTO.  # noqa: E501

        A number that allows uint 32 values.  # noqa: E501

        :return: The beneficiary_count of this ActivityBucketDTO.  # noqa: E501
        :rtype: int
        """
        return self._beneficiary_count

    @beneficiary_count.setter
    def beneficiary_count(self, beneficiary_count):
        """Sets the beneficiary_count of this ActivityBucketDTO.

        A number that allows uint 32 values.  # noqa: E501

        :param beneficiary_count: The beneficiary_count of this ActivityBucketDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and beneficiary_count is None:  # noqa: E501
            raise ValueError("Invalid value for `beneficiary_count`, must not be `None`")  # noqa: E501

        self._beneficiary_count = beneficiary_count

    @property
    def raw_score(self):
        """Gets the raw_score of this ActivityBucketDTO.  # noqa: E501

        Probability of an account to harvest the next block.  # noqa: E501

        :return: The raw_score of this ActivityBucketDTO.  # noqa: E501
        :rtype: str
        """
        return self._raw_score

    @raw_score.setter
    def raw_score(self, raw_score):
        """Sets the raw_score of this ActivityBucketDTO.

        Probability of an account to harvest the next block.  # noqa: E501

        :param raw_score: The raw_score of this ActivityBucketDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and raw_score is None:  # noqa: E501
            raise ValueError("Invalid value for `raw_score`, must not be `None`")  # noqa: E501

        self._raw_score = raw_score

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActivityBucketDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ActivityBucketDTO):
            return True

        return self.to_dict() != other.to_dict()
