"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsUiReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a AWS UI React Typescript Website Project.
 *
 * @pjid awsui-react-ts-website
 */
class AwsUiReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@awsui/global-styles", "@awsui/components-react", "@awsui/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/ui-react");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../samples/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(fs
                    .readdirSync(srcDir)
                    .filter((f) => f !== "config.json")
                    .map((name) => [
                    name,
                    fs.readFileSync(`${srcDir}/${name}`).toString(),
                ])),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../samples/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
}
exports.AwsUiReactTsWebsiteProject = AwsUiReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
AwsUiReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/awsui-react-ts-website.AwsUiReactTsWebsiteProject", version: "0.3.0" };
//# sourceMappingURL=data:application/json;base64,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